
#include  "adc.h"

BYTE adcCh04;
BYTE adcCh05;

void adcInit(void)
{
  TRISCbits.TRISC0  = 1;
  ANSELbits.ANS4    = 1;
  TRISCbits.TRISC1  = 1;
  ANSELbits.ANS5    = 1;


  ADCON0bits.CHS    = 4;
  ADCON1bits.PVCFG0 = 0;
  ADCON1bits.PVCFG1 = 0;
  ADCON1bits.NVCFG0 = 0;
  ADCON1bits.NVCFG1 = 0;
  ADCON2bits.ADFM   = 0;
  ADCON0bits.ADON   = 1;
  ADCON2bits.ACQT   = 4;  // wait until start aqusition
  ADCON2bits.ADCS   = 6;  // slow
  ADCON0bits.GO_NOT_DONE = 0;
  
  PIR1bits.ADIF     = 0;
  PIE1bits.ADIE     = 1;

  adcCh04 = 0;
  adcCh05 = 0;
}

void adcStart(void)
{
  ADCON0bits.GO_NOT_DONE = 1;
}

void adcIsr(void)
{
  if( PIR1bits.ADIF ){
    PIR1bits.ADIF = 0;
    if( ADCON0bits.CHS == 4 ){
      adcCh04 = ADRESH;
      ADCON0bits.CHS = 5;
      ADCON0bits.GO_NOT_DONE = 1;
    } else if( ADCON0bits.CHS == 5 ) {
      adcCh05 = ADRESH;
      ADCON0bits.CHS = 4;
    }
  }
}



