
#include  "button.h"
#include "HardwareProfile.h"

#define   BTN_FIRE_SW    PORTBbits.RB4
#define   BTN_FIRE_TRIS  TRISBbits.TRISB4
#define   BTN_FIRE_PULL  WPUBbits.WPUB4

#define   BTN_2_SW    	PORTBbits.RB5
#define   BTN_2_TRIS  	TRISBbits.TRISB5
#define   BTN_2_PULL  	WPUBbits.WPUB5

#define   BTN_ADMIN_SW    (!PORTBbits.RB7)
#define   BTN_ADMIN_TRIS  TRISBbits.TRISB7
#define   BTN_ADMIN_PULL  WPUBbits.WPUB7

static BOOL oldBtn;
static BOOL fireDefaultValue;
static BOOL btn2DefaultValue;


void btnInit( void ){
  ANSELHbits.ANS10 = 0;
  ANSELHbits.ANS11 = 0;
  BTN_ADMIN_TRIS   = INPUT_PIN;
  BTN_ADMIN_PULL   = 1;
  BTN_FIRE_TRIS    = INPUT_PIN;
  BTN_FIRE_PULL    = 1;
  BTN_2_TRIS       = INPUT_PIN;
  BTN_2_PULL       = 1;

  oldBtn      = btnAdmin();
}

void btnReset( void ){
  fireDefaultValue = BTN_FIRE_SW;
  btn2DefaultValue = BTN_2_SW;
}

BOOL btnGetFire( void ){
  return BTN_FIRE_SW ^ fireDefaultValue;
}

BOOL btnGet2( void ){
  return BTN_2_SW ^ btn2DefaultValue;
}

BOOL btnAdmin( void ){
  return BTN_ADMIN_SW;
}

BOOL btnAdminClicked( void ){
  BOOL newBtn  = btnAdmin();
  BOOL clicked = newBtn && !oldBtn;
  oldBtn       = newBtn;
  return clicked;
}
