
#include "speedtimer.h"

static BYTE speedTimer = 128;

BYTE speedTmrGet(){
  return speedTimer;
}

void speedTmrInit(void)
{
  TRISCbits.TRISC3  = INPUT_PIN;
  ANSELbits.ANS7    = 1;

// Voltage reference
  REFCON0bits.FVR1EN  = 1;
  REFCON0bits.FVR1S0  = 1;  // 1.024 Volt
  REFCON0bits.FVR1S1  = 0;  // 1.024 Volt

  REFCON1bits.D1EN    = 1;
  REFCON1bits.D1LPS   = 1;
  REFCON1bits.DAC1OE  = 0;
  REFCON1bits.D1PSS   = 2;  // 1.024 Volt reference 
//  REFCON1bits.D1PSS   = 0;  // VDD reference 
  REFCON1bits.D1NSS   = 0;

  REFCON2             = 8;    // 0.256 Volt

// Comparator
  CM2CON1bits.C1RSEL  = 0;  // Vref
  CM2CON1bits.C1HYS   = 1;  // hysteresis enabled
  
  CM1CON0bits.C1R     = 1;  // Vref
  CM1CON0bits.C1CH    = 3;  // RC3
  CM1CON0bits.C1ON    = 1;  // on/off
  CM1CON0bits.C1SP    = 1;  // low power, low speed
//  CM1CON0bits.C1OUT   = 0;  // read only
  CM1CON0bits.C1OE    = 0;  // external?
  CM1CON0bits.C1POL   = 0;  // inverted?
  
  CM2CON0bits.C2ON    = 0;  // on/off

// Interrupt on comparators always fires, not usable
/*  PIR2bits.C1IF     = 0;
  PIE2bits.C1IE     = 0;
  INTCONbits.PEIE   = 1;*/

  T0CONbits.T0SE    = 0;
  T0CONbits.T08BIT  = 1;    // 8 Bit
  T0CONbits.T0CS    = 0;    // internal
  T0CONbits.PSA     = 0;    // prescaler
  T0CONbits.T0PS    = 3;    // prescaler: 2^(1+T0PS)  : 16, frequency: 2929.7 Hz
  TMR0L             = 0;
  INTCONbits.TMR0IF = 0;
  T0CONbits.TMR0ON  = 1;
  INTCONbits.TMR0IE = 1;
}

// max frequency 1.45 kHz ?
void speedTmrIsr(void)
{
  static BYTE counter = 0;
  static BYTE timer   = 0;
  static BOOL last = 0;
  BOOL actual;

  if( INTCONbits.TMR0IF ){
    INTCONbits.TMR0IF   = 0;
  
    actual = CM1CON0bits.C1OUT;
    if( !last && actual ){      // positive edge
      if( counter < 127 ){
        counter++;
      }
    }
    last = actual;

    timer++;
    if( timer == 0 ){       // update frequency: 11.4 Hz; 87.381 ms
      speedTimer = 128 - (counter << 1);
      counter    = 0;
    }
  }
}
