
#include  "steering.h"

#define  adcLeft  adcCh04
#define  adcRight adcCh05

typedef struct{
  BYTE  peak;
  BYTE  center;
  BYTE  other;
} LenkSensor;

static LenkSensor calRight;
static LenkSensor calLeft;
static BYTE  oldSteering;
static BOOL  needRecalibration = TRUE;

static const BYTE ACOS[128] = {
0, 7, 10, 12, 14, 16, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32,
33, 34, 35, 36, 36, 37, 38, 39, 40, 40, 41, 42, 43, 43, 44, 45, 45, 46, 47, 47,
48, 49, 50, 50, 51, 52, 52, 53, 54, 54, 55, 55, 56, 57, 57, 58, 59, 59, 60, 61,
61, 62, 63, 63, 64, 64, 65, 66, 66, 67, 68, 68, 69, 70, 70, 71, 72, 72, 73, 73,
74, 75, 75, 76, 77, 77, 78, 79, 80, 80, 81, 82, 82, 83, 84, 84, 85, 86, 87, 87,
88, 89, 90, 91, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104,
105, 106, 108, 109, 111, 113, 115, 117, 120, 127 };


void steReset(void)
{
  calRight.peak   = 0;
  calRight.other  = 0;

  calLeft.peak    = 0;
  calLeft.other   = 0;

  oldSteering = 0x80;
}

static void steCalibEvt(void)
{
  calLeft.center  = (((WORD)calLeft.peak) + ((WORD)calRight.other)) >> 1;
  calRight.center = (((WORD)calRight.peak) + ((WORD)calLeft.other)) >> 1;
}

void steCalibCyclic(void)
{
  if( adcLeft > calLeft.peak ){
    calLeft.peak  = adcLeft;
    calLeft.other = adcRight;
    steCalibEvt();
  }
  if( adcRight > calRight.peak ){
    calRight.peak  = adcRight;
    calRight.other = adcLeft;
    steCalibEvt();
  }
}

BOOL steNeedRecalibration(void)
{
  return needRecalibration;
}

BYTE steXPos(void)
{
  BYTE  m = oldSteering;
  
  needRecalibration = (adcLeft > calLeft.center) && (adcRight > calRight.center);
  
  if( adcLeft >= calLeft.center ){
    m = adcLeft - calLeft.center;
    m = (((WORD)m) << 8) / (calLeft.peak - calLeft.center);
    m = m >> 2;
    m = ACOS[m];
    if( adcRight > calLeft.other ){
      m = 0x80 - m;
    }
  } else if( adcRight >= calRight.center ){
    m = adcRight - calRight.center;
    m = (((WORD)m) << 8) / (calRight.peak - calRight.center);
    m = m >> 2;
    m = ACOS[m];
    if( adcLeft > calRight.other ){
      m = m + 0x80;
    } else {
      m = 0xff-m;
    }
  } else {
    // out of scope
  }
  
  oldSteering = m;
  return  m;
}

