
#include  "user.h"
#include "button.h"


/** VARIABLES ******************************************************/
#pragma udata
static char buffer[8];
static USB_HANDLE lastTransmission;

#pragma udata usbram2
static INPUT_CONTROLS joystick_input;
static BYTE hid_report[8];

void UserInit(void)
{
// init variables
  lastTransmission = 0;
}

/******************************************************************************
 * Function:        void Joystick(void)
 * PreCondition:    None
 * Input:           None
 * Output:          None
 * Side Effects:    None
 * Overview:        This function will send the joystick data to the PC.  If
 *                  sw2 is pressed then it will simulate pressing a button,
 *                  moving the hat switch position, and moving two of the
 *                  analog stick postion variables.  Releasing sw2 will send
 *                  the info to the computer that indicates that nothing is
 *                  pressed on the joystick.
 * Note:            None
 *****************************************************************************/
void Joystick(BOOL isDebug)
{
  //If the last transmision is complete
  if(!HIDTxHandleBusy(lastTransmission))
  {
    if( isDebug ){
      joystick_input.analog_stick.X = adcCh05;
      joystick_input.analog_stick.Y = adcCh04;
    } else {
      joystick_input.analog_stick.X = steXPos();
      joystick_input.analog_stick.Y = speedTmrGet();
    }

    joystick_input.buttons.bt0 = btnGetFire();
    joystick_input.buttons.bt1 = btnGet2();
    joystick_input.buttons.bt2 = btnAdmin();
    joystick_input.buttons.bt3 = 0;
    joystick_input.buttons.bt4 = 0;
    joystick_input.buttons.bt5 = 0;
    joystick_input.buttons.bt6 = 0;
    joystick_input.buttons.bt7 = 0;

    //Send the packet over USB to the host.
    lastTransmission = HIDTxPacket(HID_EP, (BYTE*)&joystick_input, sizeof(joystick_input));
  }
  return;    
}

