#!/bin/sh

#flags='-Wall -Wextra -m32 -fno-inline -fno-inline-small-functions -fno-inline-functions -fno-inline-functions-called-once'
flags='-Wall -Wextra -m32 -std=c99'

#cc=g++
cc=clang

for name in *.c
do
  for optlvl in 0 1 2 s
  do
    echo "build $name:$optlvl"
    ${cc} -O${optlvl} ${flags} ${name} -o ${name}.${optlvl}d.bin
    strip -s ${name}.${optlvl}d.bin -o ${name}.${optlvl}s.bin

    objdump -d -Mintel ${name}.${optlvl}d.bin > ${name}.${optlvl}d.s
    readelf -x.data -x.got -x.rodata -x.bss -W ${name}.${optlvl}d.bin > ${name}.${optlvl}d.data
#    objdump -d -Mintel ${name}.${optlvl}s.bin > ${name}.${optlvl}s.s
#    readelf -x.data -x.got -x.rodata -x.bss -W ${name}.${optlvl}s.bin > ${name}.${optlvl}s.data

    rm ${name}.${optlvl}d.bin
  done
done

