// from http://en.wikipedia.org/wiki/Heapsort

#include  "stdio.h"
#include  "stdlib.h"

 __attribute__((noinline))
void swap( int a[], int x, int y ){
  int z = a[x];
  a[x] = a[y];
  a[y] = z;
}

 __attribute__((noinline))
void siftDown( int a[], int start, int end){
  int root = start;

  while( root * 2 + 1 <= end ){
    int child = root * 2 + 1;
    int swapi = root;
    if( a[swapi] < a[child] ){
      swapi = child;
    }
    if( (child+1 <= end) && (a[swapi] < a[child+1]) ){
      swapi = child + 1;
    }
    if( swapi != root ){
      swap( a, root, swapi );
      root = swapi;
    }else{
      return;
    }
  }
}

 __attribute__((noinline))
void heapify(int a[], int count){
  int start = (count - 2) / 2;

  while( start >= 0 ){
    siftDown(a, start, count-1);
    start = start - 1;
  }
}

 __attribute__((noinline))
void heapSort( int a[], int count ){
  heapify(a, count);

  int end = count-1; //in languages with zero-based arrays the children are 2*i+1 and 2*i+2
  while( end > 0 ){
    swap( a, end, 0 );
    end = end - 1;
    siftDown(a, 0, end);
  }
}


int main(){
  int *heap;
  int n;

  scanf( "%i", &n );
  heap = (int*)malloc( n*sizeof(*heap) );
  if( heap == NULL ){
    return -1;
  }
  
  for( int i = 0; i < n; i++ ){
    scanf( "%i", &heap[i] );
  }
  
  heapSort( heap, n );

  for( int i = 0; i < n; i++ ){
    printf( "%i\n", heap[i] );
  }
  
  return 0;
}



