
#include  <stdio.h>
#include <stdlib.h>

void printMatrix( int *m, int n ){
  for( int i = 0; i < n; i++ ){
    for( int j = 0; j < n; j++ ){
      printf( "%i ", *(m+i*n+j) );
    }
    printf( "\n" );
  }
}

void mul( int *a, int *b, int *x, int n ){
  for( int i = 0; i< n; i++ ){
    for( int j = 0; j < n; j++ ){
      *(x+i*n+j) = 0;
      for( int k = 0; k < n; k++ ){
        *(x+i*n+j) += *(a+i*n+k) * *(b+k*n+j);
      }
    }
  }
}

int main() {
  int *a, *b, *x;
  int n;
  
  printf( "please enter the dimension: \n" );
  scanf( "%i", &n ); 
  
  a = malloc( sizeof(*a) * n * n );
  b = malloc( sizeof(*b) * n * n );
  x = malloc( sizeof(*x) * n * n );
  
  printf( "please enter the %i * %i elements of a: \n", n, n );
  for( int i = 0; i < n; i++ ){
    for( int j = 0; j < n; j++ ){
      scanf( "%i", a+i*n+j );
    }
  }
  printf( "please enter the %i * %i elements of b: \n", n, n );
  for( int i = 0; i < n; i++ ){
    for( int j = 0; j < n; j++ ){
      scanf( "%i", b+i*n+j );
    }
  }
  
  mul( a, b, x, n );
  printf( "a * b is:\n" );
  printMatrix( x, n );
  
  mul( b, a, x, n );
  printf( "b * a is:\n" );
  printMatrix( x, n );
  
  free( a );
  free( b );
  free( x );
  
  return  0;
}


