#include  <stdio.h>
#include  <stdlib.h>

void quickSort(int *items, int left, int right){
  int i, j;
  int x, y;

  i = left;
  j = right;
  x = items[(left+right)/2];

  do {
    while((items[i] < x) && (i < right)){
      i++;
    }
    while((x < items[j]) && (j > left)){
      j--;
    }

    if(i <= j) {
      y = items[i];
      items[i] = items[j];
      items[j] = y;
      i++; 
      j--;
    }
  } while(i <= j);

  if(i < right){
    quickSort(items, i, right);
  }
  if(left < j){
    quickSort(items, left, j);
  }
}

int main() {
  int *data;
  int n;

  scanf( "%i", &n );
  
  if( n <= 0 ){
    return -1;
  }

  data = (int*)malloc( n * sizeof(*data) );
  
  for( int i = 0; i < n; i++ ){	
    scanf( "%i", &data[i] );
  }

  quickSort( data, 0, n-1 );
  
  for( int i = 0; i < n; i++ ){
    printf( "%i\n", data[i] );
  }

  return  0;
}

