#ifndef __CONF_H__
#define __CONF_H__

#include    "buf.h"

/*
 * Declaration of block device
 * switch. Each entry (row) is
 * the only link between the
 * main unix code and the driver.
 * The initialization of the
 * device switches is in the
 * file conf.c.
 */
struct  bdevsw
{
  int (*d_open)();
  int (*d_close)();
  int (*d_strategy)();
  struct Devtab *d_tab;
} *bdevsw;

/*
 * Nblkdev is the number of entries
 * (rows) in the block switch. It is
 * set in binit/bio.c by making
 * a pass over the switch.
 * Used in bounds checking on major
 * device numbers.
 */
int nblkdev;

/*
 * Character device switch.
 */
struct  cdevsw
{
  int (*d_open)();
  int (*d_close)();
  int (*d_read)();
  int (*d_write)();
  int (*d_sgtty)();
} *cdevsw;

/*
 * Number of character switch entries.
 * Set by cinit/tty.c
 */
int nchrdev;
#endif
