#ifndef __FILE_H__
#define __FILE_H__

#include    "inode.h"

/**
 * One file structure is allocated
 * for each open/creat/pipe call.
 * Main use is to hold the read/write
 * pointer associated with each open
 * file.
 */
struct File
{
  char  f_flag;

/// reference count
  char  f_count;

/// pointer to inode structure
  struct Inode *f_inode;

/// read/write character pointer
  char  *f_offset[2];
};

struct File    file[NFILE];

/* flags */
#define FREAD 01
#define FWRITE  02
#define FPIPE 04
#endif
