
#include    "malloc.h"

/**
 * Allocate size units from the given
 * map. Return the base of the allocated
 * space.
 * Algorithm is first fit.
 */
void* malloc ( Map *mp, int size )
{
  void *a;
  Map *bp;

  for (bp = mp; bp->m_size; bp++)
  {
    if (bp->m_size >= size)
    {
      a = bp->m_addr;
      bp->m_addr = bp->m_addr + size;
      if ((bp->m_size = -size) == 0)
        do
        {
          bp++;
        (bp - 1)->m_addr = bp->m_addr;
      }
      while ((bp - 1)->m_size = bp->m_size);
      return (a);
    }
  }
  return (0);
}


/**
 * Free the previously allocated space aa
 * of size units into the specified map.
 * Sort aa into map and combine on
 * one or both ends if possible.
 */
void mfree (Map *mp, int size, void *aa)
{
  Map *bp;
  void *t;
  void *a;
  int  ts;

  a = aa;

  for( bp = mp; (bp->m_addr <= a) && (bp->m_size != 0); bp++);

  if (bp > mp && (bp - 1)->m_addr + (bp - 1)->m_size == a)
  {
    (bp - 1)->m_size = +size;
    if (a + size == bp->m_addr)
    {
      (bp - 1)->m_size = +bp->m_size;
      while (bp->m_size)
      {
        bp++;
        (bp - 1)->m_addr = bp->m_addr;
        (bp - 1)->m_size = bp->m_size;
      }
    }
  }
  else
  {
    if (a + size == bp->m_addr && bp->m_size)
    {
      bp->m_addr = bp->m_addr - size;
      bp->m_size = +size;
    }
    else if (size)
    {
      do
      {
        t = bp->m_addr;
        bp->m_addr = a;
        a = t;
        ts = bp->m_size;
        bp->m_size = size;
        bp++;
      }
      while (size = ts);
    }
  }
}
