#ifndef MALLOC_H_
#define MALLOC_H_

/**
 * Structure of the coremap and swapmap
 * arrays. Consists of non-zero count
 * and base address of that many
 * contiguous units.
 * (The coremap unit is 64 bytes,
 * the swapmap unit is 512 bytes)
 * The addresses are increasing and
 * the list is terminated with the
 * first zero count.
 */
typedef struct
{
  int   m_size;
  void  *m_addr;
} Map;

void* malloc ( Map *mp, int size );
void mfree (Map *mp, int size, void *aa);
#endif                                            /*MALLOC_H_*/
