#include    "prf.h"

/**
 * Scaled down version of C Library printf.
 * Only %s %l %d (==%l) %o are recognized.
 * Used to print diagnostic information
 * directly on console tty.
 * Since it is not interrupt driven,
 * all system activities are pretty much
 * suspended.
 * Printf should not be used for chit-chat.
 */
//void printf( char fmt[], int x1, int x2, int x3, int x4, int x5, int x6, int x7, int x8, int x9, int xa, int xb, int xc)
void printf( char fmt[], int x1, ... )
{
  char *s;
  int *adx, c;

  adx = &x1;
  loop:
  while ((c = *fmt++) != '%')
  {
    if (c == '\0')
      return;
    putchar (c);
  }
  c = *fmt++;
  if (c == 'd' || c == 'l' || c == 'o')
    printn (*adx, c == 'o' ? 8 : 10);
  if (c == 's')
  {
    s = *adx;
    while (c = *s++)
      putchar (c);
  }
  adx++;
  goto loop;
}


/**
 * Print an unsigned integer in base b.
 */
void printn (int n, int b)
{
  int a;

  if (a = ldiv (n, b))
    printn (a, b);
  putchar (lrem (n, b) + '0');
}


/**
 * Print a character on console.
 * Attempts to save and restore device
 * status.
 * If the switches are 0, all
 * printing is inhibited.
 */
void putchar (int rc)
{
  int s;

  if (*pSW == 0)
    return;
  while ((((Kl11DevReg*)KL)->xsr & 0200) == 0)
    ;
  if (rc == 0)
    return;
  s = ((Kl11DevReg*)KL)->xsr;
  ((Kl11DevReg*)KL)->xsr = 0;
  ((Kl11DevReg*)KL)->xbr = rc;
  if (rc == '\n')
  {
    putchar ('\r');
    putchar (0177);
    putchar (0177);
  }
  putchar (0);
  ((Kl11DevReg*)KL)->xsr = s;
}


/**
 * Panic is called on unresolvable
 * fatal errors.
 * It syncs, prints "panic: mesg" and
 * then loops.
 */
void panic( char *s )
{
  panicstr = s;
  update ();
  printf ("panic: %s\n", s);
  for (;;)
    idle ();
}


/**
 * prdev prints a warning message of the
 * form "mesg on dev x/y".
 * x and y are the major and minor parts of
 * the device argument.
 */
void prdev (int str, struct Dev dev)
{
  printf ("%s on dev %l/%l\n", str, dev.d_major, dev.d_minor);
}


/**
 * deverr prints a diagnostic from
 * a device driver.
 * It prints the device, block number,
 * and an octal word (usually some error
 * status register) passed as argument.
 */
void deverror (struct Buf *rbp, int o1, int o2)
{
  prdev ("err", rbp->b_dev);
  printf ("bn%l er%o %o\n", rbp->b_blkno, o1, o2);
}
