#ifndef PRF_H_
#define PRF_H_

#include "../param.h"
#include "../seg.h"
#include "../buf.h"
#include "../conf.h"
#include "../dev.h"

/**
 * Address and structure of the
 * KL-11 console device registers.
 */
typedef struct
{
  int rsr;
  int rbr;
  int xsr;
  int xbr;
} Kl11DevReg;

/**
 * In case console is off,
 * panicstr contains argument to last
 * call to panic.
 */
char *panicstr;

void printf( char fmt[], int x1, ... );
//void printf( char fmt[], int x1, int x2, int x3, int x4, int x5, int x6, int x7, int x8, int x9, int xa, int xb, int xc);
void printn (int n, int b);
void putchar (int rc);
void panic( char *s );
void prdev (int str, struct Dev dev);
void deverror (struct Buf *rbp, int o1, int o2);
#endif                                            /*PRF_H_*/
