#ifndef SIG_H_
#define SIG_H_

#include "../param.h"
#include "../systm.h"
#include "../user.h"
#include "../proc.h"
#include "../inode.h"
#include "../reg.h"

#include    "slp.h"
#include    "sys1.h"
#include    "trap.h"
#include    "fio.h"

/*
 * Priority for tracing
 */
#define IPCPRI  (-1)

/*
 * Structure to access an array of integers.
 */
typedef int inta[];

/*
 * Tracing variables.
 * Used to pass trace command from
 * parent to child being traced.
 * This data base cannot be
 * shared and is locked
 * per user.
 */
struct
{
  int ip_lock;
  int ip_req;
  int ip_addr;
  int ip_data;
} ipc;

void signal( int tp, int sig );
void psignal( struct Proc *rp, int sig );
int issig ();
void psig ();
int core ();
int grow ( char *sp );
void ptrace ();
int procxmt ();
#endif                                            /*SIG_H_*/
