#include    "trap.h"
#include    "sys1.h"
#include    "sys2.h"
#include    "sys3.h"
#include    "sys4.h"
#include    "sig.h"
#include    "../dmr/tty.h"
#include    "pipe.h"

/**
 * This table is the switch used to transfer
 * to the appropriate routine for processing a system call.
 * Each row contains the number of arguments expected
 * and a pointer to the routine.
 */
struct Sysent sysent[64] =
{
  {                                               /*  0 = indir */
    0, &nullsys
  },
  {                                               /*  1 = exit */
    0, &rexit
  },
  {                                               /*  2 = fork */
    0, &fork
  },
  {                                               /*  3 = read */
    2, &read
  },
  {                                               /*  4 = write */
    2, &write
  },
  {                                               /*  5 = open */
    2, &open
  },
  {                                               /*  6 = close */
    0, &close
  },
  {                                               /*  7 = wait */
    0, &wait
  },
  {                                               /*  8 = creat */
    2, &creat
  },
  {                                               /*  9 = link */
    2, &link
  },
  {                                               /* 10 = unlink */
    1, &unlink
  },
  {                                               /* 11 = exec */
    2, &exec
  },
  {                                               /* 12 = chdir */
    1, &chdir
  },
  {                                               /* 13 = time */
    0, &gtime
  },
  {                                               /* 14 = mknod */
    3, &mknod
  },
  {                                               /* 15 = chmod */
    2, &chmod
  },
  {                                               /* 16 = chown */
    2, &chown
  },
  {                                               /* 17 = break */
    1, &sbreak
  },
  {                                               /* 18 = stat */
    2, &stat
  },
  {                                               /* 19 = seek */
    2, &seek
  },
  {                                               /* 20 = getpid */
    0, &getpid
  },
  {                                               /* 21 = mount */
    3, &smount
  },
  {                                               /* 22 = umount */
    1, &sumount
  },
  {                                               /* 23 = setuid */
    0, &setuid
  },
  {                                               /* 24 = getuid */
    0, &getuid
  },
  {                                               /* 25 = stime */
    0, &stime
  },
  {                                               /* 26 = ptrace */
    3, &ptrace
  },
  {                                               /* 27 = x */
    0, &nosys
  },
  {                                               /* 28 = fstat */
    1, &fstat
  },
  {                                               /* 29 = x */
    0, &nosys
  },
  {                                               /* 30 = smdate; inoperative */
    1, &nullsys
  },
  {                                               /* 31 = stty */
    1, &stty
  },
  {                                               /* 32 = gtty */
    1, &gtty
  },
  {                                               /* 33 = x */
    0, &nosys
  },
  {                                               /* 34 = nice */
    0, &nice
  },
  {                                               /* 35 = sleep */
    0, &sslep
  },
  {                                               /* 36 = sync */
    0, &sync
  },
  {                                               /* 37 = kill */
    1, &kill
  },
  {                                               /* 38 = switch */
    0, &getswit
  },
  {                                               /* 39 = x */
    0, &nosys
  },
  {                                               /* 40 = x */
    0, &nosys
  },
  {                                               /* 41 = dup */
    0, &dup
  },
  {                                               /* 42 = pipe */
    0, &pipe
  },
  {                                               /* 43 = times */
    1, &times
  },
  {                                               /* 44 = prof */
    4, &profil
  },
  {                                               /* 45 = tiu */
    0, &nosys
  },
  {                                               /* 46 = setgid */
    0, &setgid
  },
  {                                               /* 47 = getgid */
    0, &getgid
  },
  {                                               /* 48 = sig */
    2, &ssig
  },
  {                                               /* 49 = x */
    0, &nosys
  },
  {                                               /* 50 = x */
    0, &nosys
  },
  {                                               /* 51 = x */
    0, &nosys
  },
  {                                               /* 52 = x */
    0, &nosys
  },
  {                                               /* 53 = x */
    0, &nosys
  },
  {                                               /* 54 = x */
    0, &nosys
  },
  {                                               /* 55 = x */
    0, &nosys
  },
  {                                               /* 56 = x */
    0, &nosys
  },
  {                                               /* 57 = x */
    0, &nosys
  },
  {                                               /* 58 = x */
    0, &nosys
  },
  {                                               /* 59 = x */
    0, &nosys
  },
  {                                               /* 60 = x */
    0, &nosys
  },
  {                                               /* 61 = x */
    0, &nosys
  },
  {                                               /* 62 = x */
    0, &nosys
  },
  {                                               /* 63 = x */
    0, &nosys
  }
};
