#include    "text.h"

/**
 * Decrement the in-core usage count of a shared text segment.
 * When it drops to zero, free the core space.
 */
void xccdec( struct Text *rp )
{
  if( (rp != NULL) && (rp->x_ccount != 0) )
  {
    rp->x_ccount--;
    if( rp->x_ccount == 0 )
    {
      mfree (coremap, rp->x_size, rp->x_caddr);
    }
  }
}


/**
 * Swap out process p.
 *
 * panic: out of swap space
 * panic: swap error -- IO error
 *
 * @param p Process who is to be swapped out
 * @param doReleaseMainMemoryImage Flag who causes its core to be freed; it may be off when called to create an image for a child process in newproc
 * @param oldSize is the old size of the data area of the process, and is supplied during core expansion swaps
 */
void xswap ( struct Proc *rp, int doReleaseMainMemoryImage, int oldSize)
{
  void  *swpAddr;

  if (oldSize == 0)
  {
    oldSize = rp->p_size;                         // @line:4373
  }

                                                  // @line:4375
  swpAddr = malloc (swapmap, (rp->p_size + 7) / 8);
  if( swpAddr == NULL )
  {
    panic ("out of swap space");
  }

  xccdec (rp->p_textp);                           // @line:4378
  flagSet( rp->p_flag, SLOCK );                   // @line:4379

  if (swap( swpAddr, rp->p_addr, oldSize, 0 ) )
  {
    panic ("swap error");
  }
  if( doReleaseMainMemoryImage )                  // @line:4382
  {
    mfree (coremap, oldSize, rp->p_addr);
  }
  rp->p_addr = swpAddr;
  flagClear( rp->p_flag, SLOAD );
  flagClear( rp->p_flag, SLOCK );
  rp->p_time = 0;
  if (runout)
  {
    runout = 0;                                   // @line:4388
    wakeup (&runout);
  }
}


/**
 * Relinquish use of the shared text segment of a process.
 */
void xfree ()
{
  struct Text  *xp;
  struct Inode *ip;

  xp = u.u_procp->p_textp;

  if( xp != NULL )
  {
    u.u_procp->p_textp = NULL;                    // @line:4402
    xccdec (xp);                                  // @line:4403

    xp->x_count--;

    if( xp->x_count == 0 )
    {
      ip = xp->x_iptr;
      if( !flagTest( ip->i_mode, ISVTX ) )        // @line:4406
      {
        xp->x_iptr = NULL;
                                                  // @line:4408
        mfree (swapmap, (xp->x_size + 7) / 8, xp->x_daddr);
        flagClear( ip->i_flag, ITEXT );
        iput (ip);                                // @line:4411
      }
    }
  }
}


/**
 * Arrange to copy the text segment into the disk swap area. Initialise the
 * unused text entry, and get space in the disk swap area.
 *
 * @return Text segment size in ???
 */
int prepareToSwapTextOut( struct Text *xp, struct Inode *ip )
{
  int  ts;

  xp->x_count  = 1;                               // @line:4452
  xp->x_ccount = 0;
  xp->x_iptr   = ip;
  ts           = ((u.u_arg[1] + 63) >> 6) & 01777;
  xp->x_size   = ts;

  xp->x_daddr  = malloc(swapmap, (ts + 7) / 8);

  if( xp->x_daddr == NULL )
  {
    panic ("out of swap space");
  }

  return    ts;
}


void swapTextOut( struct Text *xp, struct Inode *ip, int ts )
{
  struct Proc *rp;

  expand (USIZE + ts);                            // @line:4459
  estabur (0, ts, 0, 0);                          // @line:4460
  u.u_count = (int)u.u_arg[1];                    // @line:4461
  u.u_offset[1] = 020;                            // @line:4462
  u.u_base = 0;                                   // @line:4463
  readi (ip);                                     // @line:4464
  rp = u.u_procp;

  flagSet( rp->p_flag, SLOCK );
  swap (xp->x_daddr, rp->p_addr + USIZE, ts, 0);  // @line:4467
  flagClear( rp->p_flag, SLOCK );

  rp->p_textp = xp;

  flagSet( ip->i_flag, ITEXT );
  ip->i_count++;
  expand (USIZE);                                 // @line:4473
}


/**
 * Look through the @ref text array for an entry for the text segment. If it
 * can be found, do the bookkeeping.
 *
 * @param ip Text segment which has to be found
 * @return the text segment if found or NULL otherwise
 */
struct Text* getEntryForTextSeg( struct Inode *ip )
{
  struct Text *itr;

  for( itr = &text[0]; itr < &text[NTEXT]; itr++ )// @line:4441
  {
    if( itr->x_iptr == ip )
    {
      itr->x_count++;
      u.u_procp->p_textp = itr;
      return    itr;
    }
  }

  return    NULL;
}


/**
 * Look through the @ref text array for an unused entry.
 *
 * @return the entry if found or NULL otherwise
 */
struct Text* getEmptyTextEntry()
{
  struct Text *itr;

  for (itr = &text[0]; itr < &text[NTEXT]; itr++) // @line:4441
  {
    if (itr->x_iptr == NULL)
    {
      return    itr;
    }
  }

  return    NULL;
}


/**
 * Attach to a shared text segment.
 * If there is no shared text, just return.
 * If there is, hook up to it:
 * if it is not currently being used, it has to be read
 * in from the inode (ip) and established in the swap space.
 * If it is being used, but is not currently in core,
 * a swap has to be done to get it back.
 * The full coroutine glory has to be invoked--
 * see slp.c-- because if the calling process
 * is misplaced in core the text image might not fit.
 * Quite possibly the code after "out:" could check to
 * see if the text does fit and simply swap it in.
 *
 * panic: out of swap space
 */
void xalloc ( struct Inode *ip )
{
  struct Text *xp;
  int  ts;

  if (u.u_arg[1] == 0)                            // @line:4439
  {
    return;
  }

  xp = getEntryForTextSeg( ip );
  if( xp == NULL )
  {
    xp  = getEmptyTextEntry();
    if( xp == NULL )
    {
      panic ("out of text");
    }

    ts  = prepareToSwapTextOut( xp, ip );
    swapTextOut( xp, ip, ts );
  }

  if (xp->x_ccount == 0)                          // @line:4475
  {
    savu (u.u_rsav);
    savu (u.u_ssav);
    xswap (u.u_procp, 1, 0);
    flagSet( u.u_procp->p_flag, SSWAP );
    swtch ();
// no return
  }
  xp->x_ccount++;
}
