#ifndef TRAP_H_
#define TRAP_H_

#include "../param.h"
#include "../systm.h"
#include "../user.h"
#include "../proc.h"
#include "../reg.h"
#include "../seg.h"

#define EBIT    1                                 /* user error bit in PS: C-bit */
#define UMODE   0170000                           /* user-mode bits in PS word */
#define SETD    0170011                           /* SETD instruction */
#define SYS 0104400                               /* sys (trap) instruction */
#define USER    020                               /* user-mode flag added to dev */

/*
 * structure of the system entry table (sysent.c)
 */
struct Sysent
{
  int count;                                      /* argument count */
  void (*call) ();                                /* name of handler */
};

extern struct Sysent sysent[64];
//struct Sysent sysent[64];

/*
 * Offsets of the user's registers relative to
 * the saved r0. See reg.h
 */
char regloc[9] =
{
  R0, R1, R2, R3, R4, R5, R6, R7, RPS
};

void trap (dev, sp, r1, nps, r0, pc, ps);
void trap1(int (*f) ());
void nosys ();
void nullsys ();
#endif                                            /*TRAP_H_*/
