#ifndef __PARAM_H__
#define __PARAM_H__

/*
 * tunable variables
 */

/// size of buffer cache
#define NBUF  15
/// number of in core inodes
#define NINODE  100
/// number of in core file structures
#define NFILE 100
/// number of mountable file systems
#define NMOUNT  5
/// number of simultaneous exec's
#define NEXEC 3
/// max core per process - first # is Kw
#define MAXMEM  (64*32)
/// initial stack size (*64 bytes)
#define SSIZE 20
/// increment of stack (*64 bytes)
#define SINCR 20
/// max open files per process
#define NOFILE  15
/// max size of typewriter line
#define CANBSIZ 256
/// size of core allocation area
#define CMAPSIZ 100
/// size of swap allocation area
#define SMAPSIZ 100
/// max simultaneous time callouts
#define NCALL 20
/// max number of processes
#define NPROC 50
/// max number of pure texts
#define NTEXT 40
/// max total clist size
#define NCLIST  100
/// Ticks/second of the clock
#define HZ  60

/*
 * priorities
 * probably should not be
 * altered too much
 */

#define PSWP  -100
#define PINOD -90
#define PRIBIO  -50
#define PPIPE 1
#define PWAIT 40
#define PSLEP 90
#define PUSER 100

/*
 * signals
 * dont change
 */

#define NSIG  20
/// hangup
#define   SIGHUP  1
/// interrupt (rubout)
#define   SIGINT  2
/// quit (FS)
#define   SIGQIT  3
/// illegal instruction
#define   SIGINS  4
/// trace or breakpoint
#define   SIGTRC  5
/// iot
#define   SIGIOT  6
/// emt
#define   SIGEMT  7
/// floating exception
#define   SIGFPT  8
/// kill
#define   SIGKIL  9
/// bus error
#define   SIGBUS  10
/// segmentation violation
#define   SIGSEG  11
/// sys
#define   SIGSYS  12
/// end of pipe
#define   SIGPIPE 13

/*
 * fundamental constants
 * cannot be changed
 */

/// size of user block (*64)
#define USIZE 16
#define NULL  0
static const int   NODEV = -1;
//#define NODEV (-1)
/// i number of all roots
#define ROOTINO 1
/// max characters per directory
#define DIRSIZ  14

/**
 * structure to access an
 * integer in bytes
 */
struct
{
  char  lobyte;
  char  hibyte;
};

/**
 * structure to access an integer
 */
struct
{
  int integ;
};

/*
 * Certain processor registers
 */
#define PS  0177776
#define KL  0177560
#define SW  0177570

#define pPS ((int*)PS)
#define pSW ((int*)SW)
#define pKL ((int*)KL)

#endif
