#ifndef __PROC_H__
#define __PROC_H__

#include    "text.h"

#define     flagSet( field, flag )    (field = field | flag)
#define     flagClear( field, flag )  (field = field & ~flag)
#define     flagTest( field, flag )   ((field & flag) == flag)

/**
 *  stat codes
 */
typedef enum
{
/// sleeping on high priority
  SSLEEP    = 1,

/// sleeping on low priority
  SWAIT     = 2,

/// running
  SRUN      = 3,

/// intermediate state in process creation
  SIDL      = 4,

/// intermediate state in process termination
  SZOMB     = 5,

/// process being traced
  SSTOP     = 6
} ProcState;

/**
 *  flag codes
 */
typedef enum
{
/// in core
  SLOAD     = 01,

/// scheduling process
  SSYS      = 02,

/// process cannot be swapped
  SLOCK     = 04,

/// process is being swapped out
  SSWAP     = 010,

/// process is being traced
  STRC      = 020,

/// another tracing flag
  SWTED     = 040
} ProcFlags;

/**
 * One structure allocated per active
 * process. It contains all data needed
 * about the process while the
 * process may be swapped out.
 * Other per process data (user.h)
 * is swapped with the process.
 */
struct Proc
{
  ProcState  p_stat;
  ProcFlags  p_flag;
/// priority, negative is high
  char  p_pri;
/// signal number sent to this process
  char  p_sig;
/// user id, used to direct tty signals
  char  p_uid;
/// resident time for scheduling
  char  p_time;
/// cpu usage for scheduling
  char  p_cpu;
/// nice for scheduling
  char  p_nice;

/// controlling tty
  int p_ttyp;

/// unique process id
  int p_pid;
/// process id of parent
  int p_ppid;

/// address of swappable image
  void  *p_addr;

/// size of swappable image (*64 bytes)
  int p_size;

/// event process is awaiting
  char  *p_wchan;

/// pointer to text structure
  struct Text*     p_textp;
};

struct Proc    proc[NPROC];
#endif
