#ifndef __SYSTM_H__
#define __SYSTM_H__

#include    "ken/malloc.h"
#include    "inode.h"
#include    "conf.h"
#include    "buf.h"

/**
 * Random set of variables
 * used by more than one
 * routine.
 */

/// buffer for erase and kill (#@)
char  canonb[CANBSIZ];

/// space for core allocation
//int coremap[CMAPSIZ];
Map coremap[CMAPSIZ];                             // this works because old coremap was size of int

/// space for swap allocation
//int swapmap[SMAPSIZ];
Map swapmap[SMAPSIZ];

/// pointer to inode of root directory
struct Inode *rootdir;
/// type of cpu =40, 45, or 70
int cputype;
/// number of processes in exec
int execnt;
/// time of day in 60th not in time
int lbolt;
/// time in sec from 1970
int time[2];
/// time of day of next sleep
int tout[2];

/**
 * The callout structure is for
 * a routine arranging
 * to be called by the clock interrupt
 * (clock.c) with a specified argument,
 * in a specified amount of time.
 * Used, for example, to time tab
 * delays on teletypes.
 */
struct  callo
{
/// incremental time
  int c_time;
/// argument to routine
  int c_arg;
/// routine
  int (*c_func)();
} callout[NCALL];

/**
 * Mount structure.
 * One allocated on every mount.
 * Used to find the super block.
 */
struct Mount
{
/// device mounted
  struct Dev   m_dev;

/// pointer to superblock
  struct Buf *m_bufp;
/// pointer to mounted on inode
  int *m_inodp;
};

struct Mount   mount[NMOUNT];

/// generic for unique process id's
int mpid;
/// scheduling flag
char  runin;
/// scheduling flag
char  runout;
/// scheduling flag
char  runrun;
/// more scheduling
char  curpri;
/// actual max memory per process
int maxmem;
/// pointer to clock device
int *lks;
/// dev of root see conf.c
struct Dev rootdev;

/// dev of swap see conf.c
int swapdev;
/// block number of swap space
int swplo;
/// size of swap space
int nswap;
/// lock for sync
int updlock;
/// block to be read ahead
int rablock;
/// locs. of saved user registers (trap.c)
//char  *regloc;
#endif
