#ifndef __TEXT_H__
#define __TEXT_H__

#include    "param.h"
#include    "inode.h"

/**
 * Text structure.
 * One allocated per pure
 * procedure on swap device.
 * Manipulated by text.c
 */
struct Text
{
/// disk address of segment
  void *x_daddr;

/// core address, if loaded
  void  *x_caddr;

/// size (*64)
  int x_size;
/// inode of prototype
  struct Inode *x_iptr;
/// reference count
  char  x_count;
/// number of loaded references
  char  x_ccount;
};

struct Text    text[NTEXT];
#endif
