#ifndef __USER_H__
#define __USER_H__

#include    "file.h"
#include    "proc.h"
#include    "inode.h"

/**
 * The user structure.
 * One allocated per process.
 * Contains all per process data
 * that doesn't need to be referenced
 * while the process is swapped.
 * The user block is USIZE*64 bytes
 * long; resides at virtual kernel
 * loc 140000; contains the system
 * stack per user; is cross referenced
 * with the proc structure for the
 * same process.
 */
struct User
{
/// save r5,r6 when exchanging stacks
  int u_rsav[2];
/// save fp registers
  int u_fsav[25];
/* rsav and fsav must be first in structure */

/// flag for IO; user or kernel space
  char  u_segflg;
/// return error code
  char  u_error;
/// effective user id
  char  u_uid;
/// effective group id
  char  u_gid;
/// real user id
  char  u_ruid;
/// real group id
  char  u_rgid;

/// pointer to proc structure
  struct Proc   *u_procp;

/// base address for IO
  char  *u_base;
/// bytes remaining for IO
  char  *u_count;
/// offset in file for IO
  char  *u_offset[2];

/// pointer to inode of current directory
  struct Inode     *u_cdir;

/// current pathname component
  char  u_dbuf[DIRSIZ];
/// current pointer to inode
  char  *u_dirp;
/// current directory entry
  struct
  {
    int u_ino;
    char  u_name[DIRSIZ];
  } u_dent;
/// inode of parent directory of dirp
  struct Inode *u_pdir;

/// prototype of segmentation addresses
  int u_uisa[16];

/// prototype of segmentation descriptors
  int u_uisd[16];

/// pointers to file structures of open files
  struct File*     u_ofile[NOFILE];
/// arguments to current system call
  int u_arg[5];
/// text size (*64)
  int u_tsize;
/// data size (*64)
  int u_dsize;
/// stack size (*64)
  int u_ssize;
/// flag for I and D separation
  int u_sep;
/// label variable for quits and interrupts
  int u_qsav[2];
/// label variable for swapping
  int u_ssav[2];
/// disposition of signals
  int u_signal[NSIG];
/// this process user time
  int u_utime;
/// this process system time
  int u_stime;
/// sum of childs' utimes
  int u_cutime[2];
/// sum of childs' stimes
  int u_cstime[2];
/// address of users saved R0
  int *u_ar0;
/// profile arguments
  int u_prof[4];
/// catch intr from sys
  char  u_intflg;
/* kernel stack per user
 * extends from u + USIZE*64
 * backward not to reach here
 */
};

struct User    u;

/* u_error codes */
#define EFAULT  106
#define EPERM 1
#define ENOENT  2
#define ESRCH 3
#define EINTR 4
#define EIO 5
#define ENXIO 6
#define E2BIG 7
#define ENOEXEC 8
#define EBADF 9
#define ECHILD  10
#define EAGAIN  11
#define ENOMEM  12
#define EACCES  13
#define ENOTBLK 15
#define EBUSY 16
#define EEXIST  17
#define EXDEV 18
#define ENODEV  19
#define ENOTDIR 20
#define EISDIR  21
#define EINVAL  22
#define ENFILE  23
#define EMFILE  24
#define ENOTTY  25
#define ETXTBSY 26
#define EFBIG 27
#define ENOSPC  28
#define ESPIPE  29
#define EROFS 30
#define EMLINK  31
#define EPIPE 32
#endif
