/*
insts.c

diStorm3 - Powerful disassembler for X86/AMD64
http://ragestorm.net/distorm/
distorm at gmail dot com
Copyright (C) 2011  Gil Dabah

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>
*/


#include "config.h"
#include "insts.h"
#include "instructions.h"


/*
 * GENERATED BY disOps at Thu Jun 16 00:55:44 2011
 */

/* See x86defs.c if you get an error here. */
_iflags FlagsTable[93 + 5] = {
INST_MODRM_REQUIRED,
INST_MODRM_REQUIRED | INST_PRE_REX | INST_64BITS,
INST_FLAGS_NONE,
INST_FLAGS_NONE,
INST_32BITS | INST_MODRM_REQUIRED | INST_3DNOW_FETCH,
0x80000011,
0x80000000,
0x800400,
0x80800400,
0x800080,
0x800100,
0x80800100,
0x800200,
0x80800200,
0x800000,
0x1,
0x0,
0x80800000,
0x1000000,
0x81000000,
0x808000,
0x800001,
0x1000001,
0x80020001,
0x1002000,
0x60,
0x64,
0x80000001,
0x4010000,
0x1008000,
0x80000060,
0x83000064,
0x3000064,
0x83000000,
0x3008000,
0x200,
0xc000,
0x4014000,
0x8,
0x81000009,
0x800008,
0x9,
0x80000009,
0x1000808,
0x81000808,
0x80020009,
0x1001008,
0x81001008,
0x80000019,
0x3000009,
0x83000009,
0x83000008,
0xc0000011,
0x40000001,
0xc0800011,
0x40800001,
0xc0000019,
0xc1000001,
0xc0000001,
0x40000000,
0x40000008,
0x40000009,
0x41000001,
0x43000001,
0xc0000003,
0x40000003,
0x48000000,
0x200009,
0x20020009,
0x20000009,
0x80090009,
0x200a0009,
0x80100009,
0x21100009,
0x87000009,
0x20009,
0x20000008,
0x1000009,
0x10020009,
0x160009,
0x100009,
0x40090009,
0x40100009,
0x80002009,
0xc0000009,
0x80002001,
0x410009,
0x20420009,
0x20060009,
0x120009,
0x21020009,
0xc7000019,
0x20100009,
0x40002009,
0x40002008,
0x4020009,
0x60120009,
0x60000009
};

_InstNode Table_0F = 256;
_InstNode Table_0F_0F = 1312;
_InstNode Table_0F_38 = 1768;
_InstNode Table_0F_3A = 2024;

_InstInfo InstInfos[] = {
	/*II_00*/ {0x5, 9, 15, 8, 11},
	/*II_01*/ {0x5, 11, 17, 8, 11},
	/*II_02*/ {0x5, 15, 9, 8, 11},
	/*II_03*/ {0x5, 17, 11, 8, 11},
	/*II_04*/ {0x6, 1, 33, 8, 11},
	/*II_05*/ {0x6, 3, 35, 8, 11},
	/*II_06*/ {0x7, 0, 32, 8, 16},
	/*II_07*/ {0x8, 0, 32, 8, 22},
	/*II_08*/ {0x5, 9, 15, 8, 27},
	/*II_09*/ {0x5, 11, 17, 8, 27},
	/*II_0A*/ {0x5, 15, 9, 8, 27},
	/*II_0B*/ {0x5, 17, 11, 8, 27},
	/*II_0C*/ {0x6, 1, 33, 8, 27},
	/*II_0D*/ {0x6, 3, 35, 8, 27},
	/*II_0E*/ {0x9, 0, 32, 8, 16},
	/*II_10*/ {0x5, 9, 15, 8, 31},
	/*II_11*/ {0x5, 11, 17, 8, 31},
	/*II_12*/ {0x5, 15, 9, 8, 31},
	/*II_13*/ {0x5, 17, 11, 8, 31},
	/*II_14*/ {0x6, 1, 33, 8, 31},
	/*II_15*/ {0x6, 3, 35, 8, 31},
	/*II_16*/ {0xa, 0, 32, 8, 16},
	/*II_17*/ {0xb, 0, 32, 8, 22},
	/*II_18*/ {0x5, 9, 15, 8, 36},
	/*II_19*/ {0x5, 11, 17, 8, 36},
	/*II_1A*/ {0x5, 15, 9, 8, 36},
	/*II_1B*/ {0x5, 17, 11, 8, 36},
	/*II_1C*/ {0x6, 1, 33, 8, 36},
	/*II_1D*/ {0x6, 3, 35, 8, 36},
	/*II_1E*/ {0xc, 0, 32, 8, 16},
	/*II_1F*/ {0xd, 0, 32, 8, 22},
	/*II_20*/ {0x5, 9, 15, 8, 41},
	/*II_21*/ {0x5, 11, 17, 8, 41},
	/*II_22*/ {0x5, 15, 9, 8, 41},
	/*II_23*/ {0x5, 17, 11, 8, 41},
	/*II_24*/ {0x6, 1, 33, 8, 41},
	/*II_25*/ {0x6, 3, 35, 8, 41},
	/*II_27*/ {0xe, 0, 0, 8, 46},
	/*II_28*/ {0x5, 9, 15, 8, 51},
	/*II_29*/ {0x5, 11, 17, 8, 51},
	/*II_2A*/ {0x5, 15, 9, 8, 51},
	/*II_2B*/ {0x5, 17, 11, 8, 51},
	/*II_2C*/ {0x6, 1, 33, 8, 51},
	/*II_2D*/ {0x6, 3, 35, 8, 51},
	/*II_2F*/ {0xe, 0, 0, 8, 56},
	/*II_30*/ {0x5, 9, 15, 8, 61},
	/*II_31*/ {0x5, 11, 17, 8, 61},
	/*II_32*/ {0x5, 15, 9, 8, 61},
	/*II_33*/ {0x5, 17, 11, 8, 61},
	/*II_34*/ {0x6, 1, 33, 8, 61},
	/*II_35*/ {0x6, 3, 35, 8, 61},
	/*II_37*/ {0xe, 0, 0, 8, 66},
	/*II_38*/ {0xf, 9, 15, 8, 71},
	/*II_39*/ {0xf, 11, 17, 8, 71},
	/*II_3A*/ {0xf, 15, 9, 8, 71},
	/*II_3B*/ {0xf, 17, 11, 8, 71},
	/*II_3C*/ {0x10, 1, 33, 8, 71},
	/*II_3D*/ {0x10, 3, 35, 8, 71},
	/*II_3F*/ {0xe, 0, 0, 8, 76},
	/*II_40*/ {0x11, 0, 54, 8, 81},
	/*II_40*/ {0x11, 0, 54, 8, 81},
	/*II_40*/ {0x11, 0, 54, 8, 81},
	/*II_40*/ {0x11, 0, 54, 8, 81},
	/*II_40*/ {0x11, 0, 54, 8, 81},
	/*II_40*/ {0x11, 0, 54, 8, 81},
	/*II_40*/ {0x11, 0, 54, 8, 81},
	/*II_40*/ {0x11, 0, 54, 8, 81},
	/*II_48*/ {0x11, 0, 54, 8, 86},
	/*II_48*/ {0x11, 0, 54, 8, 86},
	/*II_48*/ {0x11, 0, 54, 8, 86},
	/*II_48*/ {0x11, 0, 54, 8, 86},
	/*II_48*/ {0x11, 0, 54, 8, 86},
	/*II_48*/ {0x11, 0, 54, 8, 86},
	/*II_48*/ {0x11, 0, 54, 8, 86},
	/*II_48*/ {0x11, 0, 54, 8, 86},
	/*II_50*/ {0x12, 0, 54, 8, 16},
	/*II_50*/ {0x12, 0, 54, 8, 16},
	/*II_50*/ {0x12, 0, 54, 8, 16},
	/*II_50*/ {0x12, 0, 54, 8, 16},
	/*II_50*/ {0x12, 0, 54, 8, 16},
	/*II_50*/ {0x12, 0, 54, 8, 16},
	/*II_50*/ {0x12, 0, 54, 8, 16},
	/*II_50*/ {0x12, 0, 54, 8, 16},
	/*II_58*/ {0x13, 0, 54, 8, 22},
	/*II_58*/ {0x13, 0, 54, 8, 22},
	/*II_58*/ {0x13, 0, 54, 8, 22},
	/*II_58*/ {0x13, 0, 54, 8, 22},
	/*II_58*/ {0x13, 0, 54, 8, 22},
	/*II_58*/ {0x13, 0, 54, 8, 22},
	/*II_58*/ {0x13, 0, 54, 8, 22},
	/*II_58*/ {0x13, 0, 54, 8, 22},
	/*II_60*/ {0x14, 0, 0, 8, 91},
	/*II_61*/ {0x14, 0, 0, 8, 98},
	/*II_62*/ {0x15, 42, 11, 8, 104},
	/*II_63*/ {0x16, 10, 16, 8, 111},
	/*II_68*/ {0x12, 0, 3, 8, 16},
	/*II_6A*/ {0x18, 0, 5, 8, 16},
	/*II_6C*/ {0x19, 59, 56, 8, 123},
	/*II_6D*/ {0x1a, 59, 56, 8, 123},
	/*II_6E*/ {0x19, 55, 59, 8, 128},
	/*II_6F*/ {0x1a, 55, 59, 8, 128},
	/*II_70*/ {0x12, 0, 40, 13, 134},
	/*II_71*/ {0x12, 0, 40, 13, 138},
	/*II_72*/ {0x12, 0, 40, 13, 143},
	/*II_73*/ {0x12, 0, 40, 13, 147},
	/*II_74*/ {0x12, 0, 40, 13, 152},
	/*II_75*/ {0x12, 0, 40, 13, 156},
	/*II_76*/ {0x12, 0, 40, 13, 161},
	/*II_77*/ {0x12, 0, 40, 13, 166},
	/*II_78*/ {0x12, 0, 40, 13, 170},
	/*II_79*/ {0x12, 0, 40, 13, 174},
	/*II_7A*/ {0x12, 0, 40, 13, 179},
	/*II_7B*/ {0x12, 0, 40, 13, 183},
	/*II_7C*/ {0x12, 0, 40, 13, 188},
	/*II_7D*/ {0x12, 0, 40, 13, 192},
	/*II_7E*/ {0x12, 0, 40, 13, 197},
	/*II_7F*/ {0x12, 0, 40, 13, 202},
	/*II_84*/ {0xf, 9, 15, 8, 206},
	/*II_85*/ {0xf, 11, 17, 8, 206},
	/*II_86*/ {0x5, 9, 15, 8, 212},
	/*II_87*/ {0x5, 11, 17, 8, 212},
	/*II_88*/ {0x1b, 9, 15, 8, 218},
	/*II_89*/ {0x1b, 11, 17, 8, 218},
	/*II_8A*/ {0x1b, 15, 9, 8, 218},
	/*II_8B*/ {0x1b, 17, 11, 8, 218},
	/*II_8C*/ {0x1b, 31, 28, 8, 218},
	/*II_8D*/ {0x1b, 42, 11, 8, 223},
	/*II_8E*/ {0x1b, 16, 31, 8, 218},
	/*II_90*/ {0x6, 35, 54, 8, 212},
	/*II_91*/ {0x6, 35, 54, 8, 212},
	/*II_92*/ {0x6, 35, 54, 8, 212},
	/*II_93*/ {0x6, 35, 54, 8, 212},
	/*II_94*/ {0x6, 35, 54, 8, 212},
	/*II_95*/ {0x6, 35, 54, 8, 212},
	/*II_96*/ {0x6, 35, 54, 8, 212},
	/*II_97*/ {0x6, 35, 54, 8, 212},
	/*II_9A*/ {0xe, 0, 38, 9, 260},
	/*II_9C*/ {0x1d, 0, 0, 8, 270},
	/*II_9D*/ {0x1d, 0, 0, 8, 277},
	/*II_9E*/ {0x10, 0, 0, 8, 283},
	/*II_9F*/ {0x10, 0, 0, 8, 289},
	/*II_A0*/ {0x6, 49, 33, 8, 218},
	/*II_A1*/ {0x6, 50, 35, 8, 218},
	/*II_A2*/ {0x6, 33, 49, 8, 218},
	/*II_A3*/ {0x6, 35, 50, 8, 218},
	/*II_A4*/ {0x1e, 55, 56, 8, 295},
	/*II_A5*/ {0x1f, 55, 56, 8, 295},
	/*II_A6*/ {0x19, 56, 55, 8, 301},
	/*II_A7*/ {0x20, 56, 55, 8, 301},
	/*II_A8*/ {0x10, 1, 33, 8, 206},
	/*II_A9*/ {0x10, 3, 35, 8, 206},
	/*II_AA*/ {0x19, 33, 56, 8, 307},
	/*II_AB*/ {0x20, 35, 56, 8, 307},
	/*II_AC*/ {0x19, 55, 33, 8, 313},
	/*II_AD*/ {0x20, 55, 35, 8, 313},
	/*II_AE*/ {0x19, 33, 56, 8, 319},
	/*II_AF*/ {0x20, 35, 56, 8, 319},
	/*II_B0*/ {0x6, 1, 53, 8, 218},
	/*II_B0*/ {0x6, 1, 53, 8, 218},
	/*II_B0*/ {0x6, 1, 53, 8, 218},
	/*II_B0*/ {0x6, 1, 53, 8, 218},
	/*II_B0*/ {0x6, 1, 53, 8, 218},
	/*II_B0*/ {0x6, 1, 53, 8, 218},
	/*II_B0*/ {0x6, 1, 53, 8, 218},
	/*II_B0*/ {0x6, 1, 53, 8, 218},
	/*II_B8*/ {0x21, 3, 54, 8, 218},
	/*II_B8*/ {0x21, 3, 54, 8, 218},
	/*II_B8*/ {0x21, 3, 54, 8, 218},
	/*II_B8*/ {0x21, 3, 54, 8, 218},
	/*II_B8*/ {0x21, 3, 54, 8, 218},
	/*II_B8*/ {0x21, 3, 54, 8, 218},
	/*II_B8*/ {0x21, 3, 54, 8, 218},
	/*II_B8*/ {0x21, 3, 54, 8, 218},
	/*II_C2*/ {0x12, 0, 2, 10, 325},
	/*II_C3*/ {0x12, 0, 0, 10, 325},
	/*II_C4*/ {0x15, 37, 11, 8, 330},
	/*II_C5*/ {0x15, 37, 11, 8, 335},
	/*II_C8*/ {0x12, 8, 6, 8, 340},
	/*II_C9*/ {0x12, 0, 0, 8, 347},
	/*II_CA*/ {0x22, 0, 2, 10, 354},
	/*II_CB*/ {0x22, 0, 0, 10, 354},
	/*II_CC*/ {0x10, 0, 0, 14, 360},
	/*II_CD*/ {0x10, 0, 1, 14, 367},
	/*II_CE*/ {0xe, 0, 0, 14, 372},
	/*II_CF*/ {0x22, 0, 0, 10, 378},
	/*II_D4*/ {0xe, 0, 1, 8, 384},
	/*II_D5*/ {0xe, 0, 1, 8, 389},
	/*II_D6*/ {0xe, 0, 0, 8, 394},
	/*II_D7*/ {0x23, 0, 57, 8, 400},
	/*II_E0*/ {0x24, 0, 40, 13, 406},
	/*II_E1*/ {0x24, 0, 40, 13, 414},
	/*II_E2*/ {0x24, 0, 40, 13, 421},
	/*II_E4*/ {0x6, 1, 33, 8, 447},
	/*II_E5*/ {0x6, 1, 36, 8, 447},
	/*II_E6*/ {0x10, 33, 1, 8, 451},
	/*II_E7*/ {0x10, 36, 1, 8, 451},
	/*II_E8*/ {0x12, 0, 41, 9, 456},
	/*II_E9*/ {0x12, 0, 41, 12, 462},
	/*II_EA*/ {0xe, 0, 38, 12, 467},
	/*II_EB*/ {0x12, 0, 40, 12, 462},
	/*II_EC*/ {0x6, 59, 33, 8, 447},
	/*II_ED*/ {0x6, 59, 36, 8, 447},
	/*II_EE*/ {0x10, 33, 59, 8, 451},
	/*II_EF*/ {0x10, 36, 59, 8, 451},
	/*II_F1*/ {0x10, 0, 0, 14, 476},
	/*II_F4*/ {0x10, 0, 0, 8, 482},
	/*II_F5*/ {0x10, 0, 0, 8, 487},
	/*II_F8*/ {0x10, 0, 0, 8, 492},
	/*II_F9*/ {0x10, 0, 0, 8, 497},
	/*II_FA*/ {0x10, 0, 0, 8, 502},
	/*II_FB*/ {0x10, 0, 0, 8, 507},
	/*II_FC*/ {0x10, 0, 0, 8, 512},
	/*II_FD*/ {0x10, 0, 0, 8, 517},
	/*II_0F_02*/ {0xf, 16, 11, 8, 522},
	/*II_0F_03*/ {0xf, 16, 11, 8, 527},
	/*II_0F_05*/ {0x26, 0, 0, 27, 532},
	/*II_0F_06*/ {0x26, 0, 0, 8, 541},
	/*II_0F_07*/ {0x26, 0, 0, 27, 547},
	/*II_0F_08*/ {0x26, 0, 0, 8, 555},
	/*II_0F_09*/ {0x26, 0, 0, 8, 561},
	/*II_0F_0B*/ {0x26, 0, 0, 14, 569},
	/*II_0F_0E*/ {0x10, 0, 0, 96, 574},
	/*II_0F_1F*/ {0xf, 0, 17, 8, 581},
	/*II_0F_20*/ {0x27, 29, 14, 8, 218},
	/*II_0F_21*/ {0x27, 30, 14, 8, 218},
	/*II_0F_22*/ {0x27, 14, 29, 8, 218},
	/*II_0F_23*/ {0x27, 14, 30, 8, 218},
	/*II_0F_30*/ {0x26, 0, 0, 8, 586},
	/*II_0F_31*/ {0x26, 0, 0, 8, 593},
	/*II_0F_32*/ {0x26, 0, 0, 8, 600},
	/*II_0F_33*/ {0x26, 0, 0, 8, 607},
	/*II_0F_34*/ {0x28, 0, 0, 27, 614},
	/*II_0F_35*/ {0x28, 0, 0, 27, 624},
	/*II_0F_37*/ {0x29, 0, 0, 8, 633},
	/*II_0F_40*/ {0x2a, 17, 11, 31, 641},
	/*II_0F_41*/ {0x2a, 17, 11, 31, 648},
	/*II_0F_42*/ {0x2a, 17, 11, 31, 656},
	/*II_0F_43*/ {0x2a, 17, 11, 31, 663},
	/*II_0F_44*/ {0x2a, 17, 11, 31, 671},
	/*II_0F_45*/ {0x2a, 17, 11, 31, 678},
	/*II_0F_46*/ {0x2a, 17, 11, 31, 686},
	/*II_0F_47*/ {0x2a, 17, 11, 31, 694},
	/*II_0F_48*/ {0x2a, 17, 11, 31, 701},
	/*II_0F_49*/ {0x2a, 17, 11, 31, 708},
	/*II_0F_4A*/ {0x2a, 17, 11, 31, 716},
	/*II_0F_4B*/ {0x2a, 17, 11, 31, 723},
	/*II_0F_4C*/ {0x2a, 17, 11, 31, 731},
	/*II_0F_4D*/ {0x2a, 17, 11, 31, 738},
	/*II_0F_4E*/ {0x2a, 17, 11, 31, 746},
	/*II_0F_4F*/ {0x2a, 17, 11, 31, 754},
	/*II_0F_80*/ {0x26, 0, 41, 13, 134},
	/*II_0F_81*/ {0x26, 0, 41, 13, 138},
	/*II_0F_82*/ {0x26, 0, 41, 13, 143},
	/*II_0F_83*/ {0x26, 0, 41, 13, 147},
	/*II_0F_84*/ {0x26, 0, 41, 13, 152},
	/*II_0F_85*/ {0x26, 0, 41, 13, 156},
	/*II_0F_86*/ {0x26, 0, 41, 13, 161},
	/*II_0F_87*/ {0x26, 0, 41, 13, 166},
	/*II_0F_88*/ {0x26, 0, 41, 13, 170},
	/*II_0F_89*/ {0x26, 0, 41, 13, 174},
	/*II_0F_8A*/ {0x26, 0, 41, 13, 179},
	/*II_0F_8B*/ {0x26, 0, 41, 13, 183},
	/*II_0F_8C*/ {0x26, 0, 41, 13, 188},
	/*II_0F_8D*/ {0x26, 0, 41, 13, 192},
	/*II_0F_8E*/ {0x26, 0, 41, 13, 197},
	/*II_0F_8F*/ {0x26, 0, 41, 13, 202},
	/*II_0F_90*/ {0x2a, 0, 15, 8, 761},
	/*II_0F_91*/ {0x2a, 0, 15, 8, 767},
	/*II_0F_92*/ {0x2a, 0, 15, 8, 774},
	/*II_0F_93*/ {0x2a, 0, 15, 8, 780},
	/*II_0F_94*/ {0x2a, 0, 15, 8, 787},
	/*II_0F_95*/ {0x2a, 0, 15, 8, 793},
	/*II_0F_96*/ {0x2a, 0, 15, 8, 800},
	/*II_0F_97*/ {0x2a, 0, 15, 8, 807},
	/*II_0F_98*/ {0x2a, 0, 15, 8, 813},
	/*II_0F_99*/ {0x2a, 0, 15, 8, 819},
	/*II_0F_9A*/ {0x2a, 0, 15, 8, 826},
	/*II_0F_9B*/ {0x2a, 0, 15, 8, 832},
	/*II_0F_9C*/ {0x2a, 0, 15, 8, 839},
	/*II_0F_9D*/ {0x2a, 0, 15, 8, 845},
	/*II_0F_9E*/ {0x2a, 0, 15, 8, 852},
	/*II_0F_9F*/ {0x2a, 0, 15, 8, 859},
	/*II_0F_A0*/ {0x2b, 0, 32, 8, 16},
	/*II_0F_A1*/ {0x2c, 0, 32, 8, 22},
	/*II_0F_A2*/ {0x26, 0, 0, 8, 865},
	/*II_0F_A3*/ {0x2a, 11, 17, 8, 872},
	/*II_0F_A8*/ {0x2e, 0, 32, 8, 16},
	/*II_0F_A9*/ {0x2f, 0, 32, 8, 22},
	/*II_0F_AA*/ {0x26, 0, 0, 8, 882},
	/*II_0F_AB*/ {0x30, 11, 17, 8, 887},
	/*II_0F_AF*/ {0x2a, 17, 11, 8, 117},
	/*II_0F_B0*/ {0x30, 9, 15, 8, 898},
	/*II_0F_B1*/ {0x30, 11, 17, 8, 898},
	/*II_0F_B2*/ {0x31, 37, 11, 8, 907},
	/*II_0F_B3*/ {0x30, 11, 17, 8, 912},
	/*II_0F_B4*/ {0x31, 37, 11, 8, 917},
	/*II_0F_B5*/ {0x31, 37, 11, 8, 922},
	/*II_0F_B6*/ {0x2a, 15, 11, 8, 927},
	/*II_0F_B7*/ {0x32, 16, 11, 8, 927},
	/*II_0F_B9*/ {0x26, 0, 0, 14, 569},
	/*II_0F_BB*/ {0x30, 11, 17, 8, 934},
	/*II_0F_BC*/ {0x29, 17, 11, 8, 939},
	/*II_0F_BE*/ {0x2a, 15, 11, 8, 944},
	/*II_0F_BF*/ {0x32, 16, 11, 8, 944},
	/*II_0F_C0*/ {0x30, 9, 15, 8, 951},
	/*II_0F_C1*/ {0x30, 11, 17, 8, 951},
	/*II_0F_C3*/ {0x32, 13, 45, 48, 957},
	/*II_0F_C8*/ {0x33, 0, 54, 8, 965},
	/*II_0F_C8*/ {0x33, 0, 54, 8, 965},
	/*II_0F_C8*/ {0x33, 0, 54, 8, 965},
	/*II_0F_C8*/ {0x33, 0, 54, 8, 965},
	/*II_0F_C8*/ {0x33, 0, 54, 8, 965},
	/*II_0F_C8*/ {0x33, 0, 54, 8, 965},
	/*II_0F_C8*/ {0x33, 0, 54, 8, 965},
	/*II_0F_C8*/ {0x33, 0, 54, 8, 965},
	/*II_80_00*/ {0x34, 1, 15, 8, 11},
	/*II_80_01*/ {0x34, 1, 15, 8, 27},
	/*II_80_02*/ {0x34, 1, 15, 8, 31},
	/*II_80_03*/ {0x34, 1, 15, 8, 36},
	/*II_80_04*/ {0x34, 1, 15, 8, 41},
	/*II_80_05*/ {0x34, 1, 15, 8, 51},
	/*II_80_06*/ {0x34, 1, 15, 8, 61},
	/*II_80_07*/ {0x35, 1, 15, 8, 71},
	/*II_81_00*/ {0x34, 3, 17, 8, 11},
	/*II_81_01*/ {0x34, 3, 17, 8, 27},
	/*II_81_02*/ {0x34, 3, 17, 8, 31},
	/*II_81_03*/ {0x34, 3, 17, 8, 36},
	/*II_81_04*/ {0x34, 3, 17, 8, 41},
	/*II_81_05*/ {0x34, 3, 17, 8, 51},
	/*II_81_06*/ {0x34, 3, 17, 8, 61},
	/*II_81_07*/ {0x35, 3, 17, 8, 71},
	/*II_82_00*/ {0x36, 1, 15, 8, 11},
	/*II_82_01*/ {0x36, 1, 15, 8, 27},
	/*II_82_02*/ {0x36, 1, 15, 8, 31},
	/*II_82_03*/ {0x36, 1, 15, 8, 36},
	/*II_82_04*/ {0x36, 1, 15, 8, 41},
	/*II_82_05*/ {0x36, 1, 15, 8, 51},
	/*II_82_06*/ {0x36, 1, 15, 8, 61},
	/*II_82_07*/ {0x37, 1, 15, 8, 71},
	/*II_83_00*/ {0x34, 5, 17, 8, 11},
	/*II_83_01*/ {0x38, 5, 17, 8, 27},
	/*II_83_02*/ {0x34, 5, 17, 8, 31},
	/*II_83_03*/ {0x34, 5, 17, 8, 36},
	/*II_83_04*/ {0x38, 5, 17, 8, 41},
	/*II_83_05*/ {0x34, 5, 17, 8, 51},
	/*II_83_06*/ {0x38, 5, 17, 8, 61},
	/*II_83_07*/ {0x35, 5, 17, 8, 71},
	/*II_8F_00*/ {0x39, 0, 17, 8, 22},
	/*II_C0_00*/ {0x3a, 1, 15, 8, 972},
	/*II_C0_01*/ {0x3a, 1, 15, 8, 977},
	/*II_C0_02*/ {0x3a, 1, 15, 8, 982},
	/*II_C0_03*/ {0x3a, 1, 15, 8, 987},
	/*II_C0_04*/ {0x3a, 1, 15, 8, 992},
	/*II_C0_05*/ {0x3a, 1, 15, 8, 997},
	/*II_C0_06*/ {0x3a, 1, 15, 8, 1002},
	/*II_C0_07*/ {0x3a, 1, 15, 8, 1007},
	/*II_C1_00*/ {0x3a, 1, 17, 8, 972},
	/*II_C1_01*/ {0x3a, 1, 17, 8, 977},
	/*II_C1_02*/ {0x3a, 1, 17, 8, 982},
	/*II_C1_03*/ {0x3a, 1, 17, 8, 987},
	/*II_C1_04*/ {0x3a, 1, 17, 8, 992},
	/*II_C1_05*/ {0x3a, 1, 17, 8, 997},
	/*II_C1_06*/ {0x3a, 1, 17, 8, 1002},
	/*II_C1_07*/ {0x3a, 1, 17, 8, 1007},
	/*II_C6_00*/ {0x3a, 1, 15, 8, 218},
	/*II_C7_00*/ {0x3a, 3, 17, 8, 218},
	/*II_D0_00*/ {0x3a, 51, 15, 8, 972},
	/*II_D0_01*/ {0x3a, 51, 15, 8, 977},
	/*II_D0_02*/ {0x3a, 51, 15, 8, 982},
	/*II_D0_03*/ {0x3a, 51, 15, 8, 987},
	/*II_D0_04*/ {0x3a, 51, 15, 8, 992},
	/*II_D0_05*/ {0x3a, 51, 15, 8, 997},
	/*II_D0_06*/ {0x3a, 51, 15, 8, 1002},
	/*II_D0_07*/ {0x3a, 51, 15, 8, 1007},
	/*II_D1_00*/ {0x3a, 51, 17, 8, 972},
	/*II_D1_01*/ {0x3a, 51, 17, 8, 977},
	/*II_D1_02*/ {0x3a, 51, 17, 8, 982},
	/*II_D1_03*/ {0x3a, 51, 17, 8, 987},
	/*II_D1_04*/ {0x3a, 51, 17, 8, 992},
	/*II_D1_05*/ {0x3a, 51, 17, 8, 997},
	/*II_D1_06*/ {0x3a, 51, 17, 8, 1002},
	/*II_D1_07*/ {0x3a, 51, 17, 8, 1007},
	/*II_D2_00*/ {0x3a, 52, 15, 8, 972},
	/*II_D2_01*/ {0x3a, 52, 15, 8, 977},
	/*II_D2_02*/ {0x3a, 52, 15, 8, 982},
	/*II_D2_03*/ {0x3a, 52, 15, 8, 987},
	/*II_D2_04*/ {0x3a, 52, 15, 8, 992},
	/*II_D2_05*/ {0x3a, 52, 15, 8, 997},
	/*II_D2_06*/ {0x3a, 52, 15, 8, 1002},
	/*II_D2_07*/ {0x3a, 52, 15, 8, 1007},
	/*II_D3_00*/ {0x3a, 52, 17, 8, 972},
	/*II_D3_01*/ {0x3a, 52, 17, 8, 977},
	/*II_D3_02*/ {0x3a, 52, 17, 8, 982},
	/*II_D3_03*/ {0x3a, 52, 17, 8, 987},
	/*II_D3_04*/ {0x3a, 52, 17, 8, 992},
	/*II_D3_05*/ {0x3a, 52, 17, 8, 997},
	/*II_D3_06*/ {0x3a, 52, 17, 8, 1002},
	/*II_D3_07*/ {0x3a, 52, 17, 8, 1007},
	/*II_D8_00*/ {0x35, 0, 21, 16, 1012},
	/*II_D8_01*/ {0x35, 0, 21, 16, 1018},
	/*II_D8_02*/ {0x35, 0, 21, 16, 1024},
	/*II_D8_03*/ {0x35, 0, 21, 16, 1030},
	/*II_D8_04*/ {0x35, 0, 21, 16, 1037},
	/*II_D8_05*/ {0x35, 0, 21, 16, 1043},
	/*II_D8_06*/ {0x35, 0, 21, 16, 1050},
	/*II_D8_07*/ {0x35, 0, 21, 16, 1056},
	/*II_D8_C0*/ {0x3b, 0, 62, 16, 1012},
	/*II_D8_C0*/ {0x3b, 0, 62, 16, 1012},
	/*II_D8_C0*/ {0x3b, 0, 62, 16, 1012},
	/*II_D8_C0*/ {0x3b, 0, 62, 16, 1012},
	/*II_D8_C0*/ {0x3b, 0, 62, 16, 1012},
	/*II_D8_C0*/ {0x3b, 0, 62, 16, 1012},
	/*II_D8_C0*/ {0x3b, 0, 62, 16, 1012},
	/*II_D8_C0*/ {0x3b, 0, 62, 16, 1012},
	/*II_D8_C8*/ {0x3b, 0, 62, 16, 1018},
	/*II_D8_C8*/ {0x3b, 0, 62, 16, 1018},
	/*II_D8_C8*/ {0x3b, 0, 62, 16, 1018},
	/*II_D8_C8*/ {0x3b, 0, 62, 16, 1018},
	/*II_D8_C8*/ {0x3b, 0, 62, 16, 1018},
	/*II_D8_C8*/ {0x3b, 0, 62, 16, 1018},
	/*II_D8_C8*/ {0x3b, 0, 62, 16, 1018},
	/*II_D8_C8*/ {0x3b, 0, 62, 16, 1018},
	/*II_D8_D0*/ {0x3b, 0, 61, 16, 1024},
	/*II_D8_D0*/ {0x3b, 0, 61, 16, 1024},
	/*II_D8_D0*/ {0x3b, 0, 61, 16, 1024},
	/*II_D8_D0*/ {0x3b, 0, 61, 16, 1024},
	/*II_D8_D0*/ {0x3b, 0, 61, 16, 1024},
	/*II_D8_D0*/ {0x3b, 0, 61, 16, 1024},
	/*II_D8_D0*/ {0x3b, 0, 61, 16, 1024},
	/*II_D8_D0*/ {0x3b, 0, 61, 16, 1024},
	/*II_D8_D8*/ {0x3b, 0, 61, 16, 1030},
	/*II_D8_D9*/ {0x3b, 0, 0, 16, 1030},
	/*II_D8_D8*/ {0x3b, 0, 61, 16, 1030},
	/*II_D8_D8*/ {0x3b, 0, 61, 16, 1030},
	/*II_D8_D8*/ {0x3b, 0, 61, 16, 1030},
	/*II_D8_D8*/ {0x3b, 0, 61, 16, 1030},
	/*II_D8_D8*/ {0x3b, 0, 61, 16, 1030},
	/*II_D8_D8*/ {0x3b, 0, 61, 16, 1030},
	/*II_D8_E0*/ {0x3b, 0, 62, 16, 1037},
	/*II_D8_E0*/ {0x3b, 0, 62, 16, 1037},
	/*II_D8_E0*/ {0x3b, 0, 62, 16, 1037},
	/*II_D8_E0*/ {0x3b, 0, 62, 16, 1037},
	/*II_D8_E0*/ {0x3b, 0, 62, 16, 1037},
	/*II_D8_E0*/ {0x3b, 0, 62, 16, 1037},
	/*II_D8_E0*/ {0x3b, 0, 62, 16, 1037},
	/*II_D8_E0*/ {0x3b, 0, 62, 16, 1037},
	/*II_D8_E8*/ {0x3b, 0, 62, 16, 1043},
	/*II_D8_E8*/ {0x3b, 0, 62, 16, 1043},
	/*II_D8_E8*/ {0x3b, 0, 62, 16, 1043},
	/*II_D8_E8*/ {0x3b, 0, 62, 16, 1043},
	/*II_D8_E8*/ {0x3b, 0, 62, 16, 1043},
	/*II_D8_E8*/ {0x3b, 0, 62, 16, 1043},
	/*II_D8_E8*/ {0x3b, 0, 62, 16, 1043},
	/*II_D8_E8*/ {0x3b, 0, 62, 16, 1043},
	/*II_D8_F0*/ {0x3b, 0, 62, 16, 1050},
	/*II_D8_F0*/ {0x3b, 0, 62, 16, 1050},
	/*II_D8_F0*/ {0x3b, 0, 62, 16, 1050},
	/*II_D8_F0*/ {0x3b, 0, 62, 16, 1050},
	/*II_D8_F0*/ {0x3b, 0, 62, 16, 1050},
	/*II_D8_F0*/ {0x3b, 0, 62, 16, 1050},
	/*II_D8_F0*/ {0x3b, 0, 62, 16, 1050},
	/*II_D8_F0*/ {0x3b, 0, 62, 16, 1050},
	/*II_D8_F8*/ {0x3b, 0, 62, 16, 1056},
	/*II_D8_F8*/ {0x3b, 0, 62, 16, 1056},
	/*II_D8_F8*/ {0x3b, 0, 62, 16, 1056},
	/*II_D8_F8*/ {0x3b, 0, 62, 16, 1056},
	/*II_D8_F8*/ {0x3b, 0, 62, 16, 1056},
	/*II_D8_F8*/ {0x3b, 0, 62, 16, 1056},
	/*II_D8_F8*/ {0x3b, 0, 62, 16, 1056},
	/*II_D8_F8*/ {0x3b, 0, 62, 16, 1056},
	/*II_D9_00*/ {0x35, 0, 21, 16, 1063},
	/*II_D9_02*/ {0x35, 0, 21, 16, 1068},
	/*II_D9_03*/ {0x35, 0, 21, 16, 1073},
	/*II_D9_04*/ {0x35, 0, 42, 16, 1079},
	/*II_D9_05*/ {0x35, 0, 42, 16, 1087},
	/*II_D9_C0*/ {0x3b, 0, 61, 16, 1063},
	/*II_D9_C0*/ {0x3b, 0, 61, 16, 1063},
	/*II_D9_C0*/ {0x3b, 0, 61, 16, 1063},
	/*II_D9_C0*/ {0x3b, 0, 61, 16, 1063},
	/*II_D9_C0*/ {0x3b, 0, 61, 16, 1063},
	/*II_D9_C0*/ {0x3b, 0, 61, 16, 1063},
	/*II_D9_C0*/ {0x3b, 0, 61, 16, 1063},
	/*II_D9_C0*/ {0x3b, 0, 61, 16, 1063},
	/*II_D9_C8*/ {0x3b, 0, 61, 16, 1094},
	/*II_D9_C9*/ {0x3b, 0, 0, 16, 1094},
	/*II_D9_C8*/ {0x3b, 0, 61, 16, 1094},
	/*II_D9_C8*/ {0x3b, 0, 61, 16, 1094},
	/*II_D9_C8*/ {0x3b, 0, 61, 16, 1094},
	/*II_D9_C8*/ {0x3b, 0, 61, 16, 1094},
	/*II_D9_C8*/ {0x3b, 0, 61, 16, 1094},
	/*II_D9_C8*/ {0x3b, 0, 61, 16, 1094},
	/*II_D9_D0*/ {0x3b, 0, 0, 16, 1100},
	/*II_D9_E0*/ {0x3b, 0, 0, 16, 1106},
	/*II_D9_E1*/ {0x3b, 0, 0, 16, 1112},
	/*II_D9_E4*/ {0x3b, 0, 0, 16, 1118},
	/*II_D9_E5*/ {0x3b, 0, 0, 16, 1124},
	/*II_D9_E8*/ {0x3b, 0, 0, 16, 1130},
	/*II_D9_E9*/ {0x3b, 0, 0, 16, 1136},
	/*II_D9_EA*/ {0x3b, 0, 0, 16, 1144},
	/*II_D9_EB*/ {0x3b, 0, 0, 16, 1152},
	/*II_D9_EC*/ {0x3b, 0, 0, 16, 1159},
	/*II_D9_ED*/ {0x3b, 0, 0, 16, 1167},
	/*II_D9_EE*/ {0x3b, 0, 0, 16, 1175},
	/*II_D9_F0*/ {0x3b, 0, 0, 16, 1181},
	/*II_D9_F1*/ {0x3b, 0, 0, 16, 1188},
	/*II_D9_F2*/ {0x3b, 0, 0, 16, 1195},
	/*II_D9_F3*/ {0x3b, 0, 0, 16, 1202},
	/*II_D9_F4*/ {0x3b, 0, 0, 16, 1210},
	/*II_D9_F5*/ {0x3b, 0, 0, 16, 1219},
	/*II_D9_F6*/ {0x3b, 0, 0, 16, 1227},
	/*II_D9_F7*/ {0x3b, 0, 0, 16, 1236},
	/*II_D9_F8*/ {0x3b, 0, 0, 16, 1245},
	/*II_D9_F9*/ {0x3b, 0, 0, 16, 1252},
	/*II_D9_FA*/ {0x3b, 0, 0, 16, 1261},
	/*II_D9_FB*/ {0x3b, 0, 0, 16, 1268},
	/*II_D9_FC*/ {0x3b, 0, 0, 16, 1277},
	/*II_D9_FD*/ {0x3b, 0, 0, 16, 1286},
	/*II_D9_FE*/ {0x3b, 0, 0, 16, 1294},
	/*II_D9_FF*/ {0x3b, 0, 0, 16, 1300},
	/*II_DA_00*/ {0x35, 0, 21, 16, 1306},
	/*II_DA_01*/ {0x35, 0, 21, 16, 1313},
	/*II_DA_02*/ {0x35, 0, 21, 16, 1320},
	/*II_DA_03*/ {0x35, 0, 21, 16, 1327},
	/*II_DA_04*/ {0x35, 0, 21, 16, 1335},
	/*II_DA_05*/ {0x35, 0, 21, 16, 1342},
	/*II_DA_06*/ {0x35, 0, 21, 16, 1350},
	/*II_DA_07*/ {0x35, 0, 21, 16, 1357},
	/*II_DA_C0*/ {0x3c, 0, 62, 24, 1365},
	/*II_DA_C0*/ {0x3c, 0, 62, 24, 1365},
	/*II_DA_C0*/ {0x3c, 0, 62, 24, 1365},
	/*II_DA_C0*/ {0x3c, 0, 62, 24, 1365},
	/*II_DA_C0*/ {0x3c, 0, 62, 24, 1365},
	/*II_DA_C0*/ {0x3c, 0, 62, 24, 1365},
	/*II_DA_C0*/ {0x3c, 0, 62, 24, 1365},
	/*II_DA_C0*/ {0x3c, 0, 62, 24, 1365},
	/*II_DA_C8*/ {0x3c, 0, 62, 24, 1373},
	/*II_DA_C8*/ {0x3c, 0, 62, 24, 1373},
	/*II_DA_C8*/ {0x3c, 0, 62, 24, 1373},
	/*II_DA_C8*/ {0x3c, 0, 62, 24, 1373},
	/*II_DA_C8*/ {0x3c, 0, 62, 24, 1373},
	/*II_DA_C8*/ {0x3c, 0, 62, 24, 1373},
	/*II_DA_C8*/ {0x3c, 0, 62, 24, 1373},
	/*II_DA_C8*/ {0x3c, 0, 62, 24, 1373},
	/*II_DA_D0*/ {0x3c, 0, 62, 24, 1381},
	/*II_DA_D0*/ {0x3c, 0, 62, 24, 1381},
	/*II_DA_D0*/ {0x3c, 0, 62, 24, 1381},
	/*II_DA_D0*/ {0x3c, 0, 62, 24, 1381},
	/*II_DA_D0*/ {0x3c, 0, 62, 24, 1381},
	/*II_DA_D0*/ {0x3c, 0, 62, 24, 1381},
	/*II_DA_D0*/ {0x3c, 0, 62, 24, 1381},
	/*II_DA_D0*/ {0x3c, 0, 62, 24, 1381},
	/*II_DA_D8*/ {0x3c, 0, 62, 24, 1390},
	/*II_DA_D8*/ {0x3c, 0, 62, 24, 1390},
	/*II_DA_D8*/ {0x3c, 0, 62, 24, 1390},
	/*II_DA_D8*/ {0x3c, 0, 62, 24, 1390},
	/*II_DA_D8*/ {0x3c, 0, 62, 24, 1390},
	/*II_DA_D8*/ {0x3c, 0, 62, 24, 1390},
	/*II_DA_D8*/ {0x3c, 0, 62, 24, 1390},
	/*II_DA_D8*/ {0x3c, 0, 62, 24, 1390},
	/*II_DA_E9*/ {0x3b, 0, 0, 16, 1398},
	/*II_DB_00*/ {0x35, 0, 21, 16, 1407},
	/*II_DB_01*/ {0x3d, 0, 21, 56, 1413},
	/*II_DB_02*/ {0x35, 0, 21, 16, 1421},
	/*II_DB_03*/ {0x35, 0, 21, 16, 1427},
	/*II_DB_05*/ {0x35, 0, 23, 16, 1063},
	/*II_DB_07*/ {0x35, 0, 23, 16, 1073},
	/*II_DB_C0*/ {0x3c, 0, 62, 24, 1434},
	/*II_DB_C0*/ {0x3c, 0, 62, 24, 1434},
	/*II_DB_C0*/ {0x3c, 0, 62, 24, 1434},
	/*II_DB_C0*/ {0x3c, 0, 62, 24, 1434},
	/*II_DB_C0*/ {0x3c, 0, 62, 24, 1434},
	/*II_DB_C0*/ {0x3c, 0, 62, 24, 1434},
	/*II_DB_C0*/ {0x3c, 0, 62, 24, 1434},
	/*II_DB_C0*/ {0x3c, 0, 62, 24, 1434},
	/*II_DB_C8*/ {0x3c, 0, 62, 24, 1443},
	/*II_DB_C8*/ {0x3c, 0, 62, 24, 1443},
	/*II_DB_C8*/ {0x3c, 0, 62, 24, 1443},
	/*II_DB_C8*/ {0x3c, 0, 62, 24, 1443},
	/*II_DB_C8*/ {0x3c, 0, 62, 24, 1443},
	/*II_DB_C8*/ {0x3c, 0, 62, 24, 1443},
	/*II_DB_C8*/ {0x3c, 0, 62, 24, 1443},
	/*II_DB_C8*/ {0x3c, 0, 62, 24, 1443},
	/*II_DB_D0*/ {0x3c, 0, 62, 24, 1452},
	/*II_DB_D0*/ {0x3c, 0, 62, 24, 1452},
	/*II_DB_D0*/ {0x3c, 0, 62, 24, 1452},
	/*II_DB_D0*/ {0x3c, 0, 62, 24, 1452},
	/*II_DB_D0*/ {0x3c, 0, 62, 24, 1452},
	/*II_DB_D0*/ {0x3c, 0, 62, 24, 1452},
	/*II_DB_D0*/ {0x3c, 0, 62, 24, 1452},
	/*II_DB_D0*/ {0x3c, 0, 62, 24, 1452},
	/*II_DB_D8*/ {0x3c, 0, 62, 24, 1462},
	/*II_DB_D8*/ {0x3c, 0, 62, 24, 1462},
	/*II_DB_D8*/ {0x3c, 0, 62, 24, 1462},
	/*II_DB_D8*/ {0x3c, 0, 62, 24, 1462},
	/*II_DB_D8*/ {0x3c, 0, 62, 24, 1462},
	/*II_DB_D8*/ {0x3c, 0, 62, 24, 1462},
	/*II_DB_D8*/ {0x3c, 0, 62, 24, 1462},
	/*II_DB_D8*/ {0x3c, 0, 62, 24, 1462},
	/*II_DB_E0*/ {0x3b, 0, 0, 16, 1471},
	/*II_DB_E1*/ {0x3b, 0, 0, 16, 1477},
	/*II_DB_E4*/ {0x3b, 0, 0, 16, 1485},
	/*II_DB_E8*/ {0x3c, 0, 62, 16, 1493},
	/*II_DB_E8*/ {0x3c, 0, 62, 16, 1493},
	/*II_DB_E8*/ {0x3c, 0, 62, 16, 1493},
	/*II_DB_E8*/ {0x3c, 0, 62, 16, 1493},
	/*II_DB_E8*/ {0x3c, 0, 62, 16, 1493},
	/*II_DB_E8*/ {0x3c, 0, 62, 16, 1493},
	/*II_DB_E8*/ {0x3c, 0, 62, 16, 1493},
	/*II_DB_E8*/ {0x3c, 0, 62, 16, 1493},
	/*II_DB_F0*/ {0x3c, 0, 62, 24, 1501},
	/*II_DB_F0*/ {0x3c, 0, 62, 24, 1501},
	/*II_DB_F0*/ {0x3c, 0, 62, 24, 1501},
	/*II_DB_F0*/ {0x3c, 0, 62, 24, 1501},
	/*II_DB_F0*/ {0x3c, 0, 62, 24, 1501},
	/*II_DB_F0*/ {0x3c, 0, 62, 24, 1501},
	/*II_DB_F0*/ {0x3c, 0, 62, 24, 1501},
	/*II_DB_F0*/ {0x3c, 0, 62, 24, 1501},
	/*II_DC_00*/ {0x35, 0, 22, 16, 1012},
	/*II_DC_01*/ {0x35, 0, 22, 16, 1018},
	/*II_DC_02*/ {0x35, 0, 22, 16, 1024},
	/*II_DC_03*/ {0x35, 0, 22, 16, 1030},
	/*II_DC_04*/ {0x35, 0, 22, 16, 1037},
	/*II_DC_05*/ {0x35, 0, 22, 16, 1043},
	/*II_DC_06*/ {0x35, 0, 22, 16, 1050},
	/*II_DC_07*/ {0x35, 0, 22, 16, 1056},
	/*II_DC_C0*/ {0x3b, 0, 63, 16, 1012},
	/*II_DC_C0*/ {0x3b, 0, 63, 16, 1012},
	/*II_DC_C0*/ {0x3b, 0, 63, 16, 1012},
	/*II_DC_C0*/ {0x3b, 0, 63, 16, 1012},
	/*II_DC_C0*/ {0x3b, 0, 63, 16, 1012},
	/*II_DC_C0*/ {0x3b, 0, 63, 16, 1012},
	/*II_DC_C0*/ {0x3b, 0, 63, 16, 1012},
	/*II_DC_C0*/ {0x3b, 0, 63, 16, 1012},
	/*II_DC_C8*/ {0x3b, 0, 63, 16, 1018},
	/*II_DC_C8*/ {0x3b, 0, 63, 16, 1018},
	/*II_DC_C8*/ {0x3b, 0, 63, 16, 1018},
	/*II_DC_C8*/ {0x3b, 0, 63, 16, 1018},
	/*II_DC_C8*/ {0x3b, 0, 63, 16, 1018},
	/*II_DC_C8*/ {0x3b, 0, 63, 16, 1018},
	/*II_DC_C8*/ {0x3b, 0, 63, 16, 1018},
	/*II_DC_C8*/ {0x3b, 0, 63, 16, 1018},
	/*II_DC_E0*/ {0x3b, 0, 63, 16, 1043},
	/*II_DC_E0*/ {0x3b, 0, 63, 16, 1043},
	/*II_DC_E0*/ {0x3b, 0, 63, 16, 1043},
	/*II_DC_E0*/ {0x3b, 0, 63, 16, 1043},
	/*II_DC_E0*/ {0x3b, 0, 63, 16, 1043},
	/*II_DC_E0*/ {0x3b, 0, 63, 16, 1043},
	/*II_DC_E0*/ {0x3b, 0, 63, 16, 1043},
	/*II_DC_E0*/ {0x3b, 0, 63, 16, 1043},
	/*II_DC_E8*/ {0x3b, 0, 63, 16, 1037},
	/*II_DC_E8*/ {0x3b, 0, 63, 16, 1037},
	/*II_DC_E8*/ {0x3b, 0, 63, 16, 1037},
	/*II_DC_E8*/ {0x3b, 0, 63, 16, 1037},
	/*II_DC_E8*/ {0x3b, 0, 63, 16, 1037},
	/*II_DC_E8*/ {0x3b, 0, 63, 16, 1037},
	/*II_DC_E8*/ {0x3b, 0, 63, 16, 1037},
	/*II_DC_E8*/ {0x3b, 0, 63, 16, 1037},
	/*II_DC_F0*/ {0x3b, 0, 63, 16, 1056},
	/*II_DC_F0*/ {0x3b, 0, 63, 16, 1056},
	/*II_DC_F0*/ {0x3b, 0, 63, 16, 1056},
	/*II_DC_F0*/ {0x3b, 0, 63, 16, 1056},
	/*II_DC_F0*/ {0x3b, 0, 63, 16, 1056},
	/*II_DC_F0*/ {0x3b, 0, 63, 16, 1056},
	/*II_DC_F0*/ {0x3b, 0, 63, 16, 1056},
	/*II_DC_F0*/ {0x3b, 0, 63, 16, 1056},
	/*II_DC_F8*/ {0x3b, 0, 63, 16, 1050},
	/*II_DC_F8*/ {0x3b, 0, 63, 16, 1050},
	/*II_DC_F8*/ {0x3b, 0, 63, 16, 1050},
	/*II_DC_F8*/ {0x3b, 0, 63, 16, 1050},
	/*II_DC_F8*/ {0x3b, 0, 63, 16, 1050},
	/*II_DC_F8*/ {0x3b, 0, 63, 16, 1050},
	/*II_DC_F8*/ {0x3b, 0, 63, 16, 1050},
	/*II_DC_F8*/ {0x3b, 0, 63, 16, 1050},
	/*II_DD_00*/ {0x35, 0, 22, 16, 1063},
	/*II_DD_01*/ {0x3d, 0, 22, 56, 1413},
	/*II_DD_02*/ {0x35, 0, 22, 16, 1068},
	/*II_DD_03*/ {0x35, 0, 22, 16, 1073},
	/*II_DD_04*/ {0x35, 0, 42, 16, 1508},
	/*II_DD_C0*/ {0x3b, 0, 61, 16, 1516},
	/*II_DD_C0*/ {0x3b, 0, 61, 16, 1516},
	/*II_DD_C0*/ {0x3b, 0, 61, 16, 1516},
	/*II_DD_C0*/ {0x3b, 0, 61, 16, 1516},
	/*II_DD_C0*/ {0x3b, 0, 61, 16, 1516},
	/*II_DD_C0*/ {0x3b, 0, 61, 16, 1516},
	/*II_DD_C0*/ {0x3b, 0, 61, 16, 1516},
	/*II_DD_C0*/ {0x3b, 0, 61, 16, 1516},
	/*II_DD_D0*/ {0x3b, 0, 61, 16, 1068},
	/*II_DD_D0*/ {0x3b, 0, 61, 16, 1068},
	/*II_DD_D0*/ {0x3b, 0, 61, 16, 1068},
	/*II_DD_D0*/ {0x3b, 0, 61, 16, 1068},
	/*II_DD_D0*/ {0x3b, 0, 61, 16, 1068},
	/*II_DD_D0*/ {0x3b, 0, 61, 16, 1068},
	/*II_DD_D0*/ {0x3b, 0, 61, 16, 1068},
	/*II_DD_D0*/ {0x3b, 0, 61, 16, 1068},
	/*II_DD_D8*/ {0x3b, 0, 61, 16, 1073},
	/*II_DD_D8*/ {0x3b, 0, 61, 16, 1073},
	/*II_DD_D8*/ {0x3b, 0, 61, 16, 1073},
	/*II_DD_D8*/ {0x3b, 0, 61, 16, 1073},
	/*II_DD_D8*/ {0x3b, 0, 61, 16, 1073},
	/*II_DD_D8*/ {0x3b, 0, 61, 16, 1073},
	/*II_DD_D8*/ {0x3b, 0, 61, 16, 1073},
	/*II_DD_D8*/ {0x3b, 0, 61, 16, 1073},
	/*II_DD_E0*/ {0x3b, 0, 63, 16, 1523},
	/*II_DD_E1*/ {0x3b, 0, 0, 16, 1523},
	/*II_DD_E0*/ {0x3b, 0, 63, 16, 1523},
	/*II_DD_E0*/ {0x3b, 0, 63, 16, 1523},
	/*II_DD_E0*/ {0x3b, 0, 63, 16, 1523},
	/*II_DD_E0*/ {0x3b, 0, 63, 16, 1523},
	/*II_DD_E0*/ {0x3b, 0, 63, 16, 1523},
	/*II_DD_E0*/ {0x3b, 0, 63, 16, 1523},
	/*II_DD_E8*/ {0x3b, 0, 61, 16, 1530},
	/*II_DD_E9*/ {0x3b, 0, 0, 16, 1530},
	/*II_DD_E8*/ {0x3b, 0, 61, 16, 1530},
	/*II_DD_E8*/ {0x3b, 0, 61, 16, 1530},
	/*II_DD_E8*/ {0x3b, 0, 61, 16, 1530},
	/*II_DD_E8*/ {0x3b, 0, 61, 16, 1530},
	/*II_DD_E8*/ {0x3b, 0, 61, 16, 1530},
	/*II_DD_E8*/ {0x3b, 0, 61, 16, 1530},
	/*II_DE_00*/ {0x35, 0, 20, 16, 1306},
	/*II_DE_01*/ {0x35, 0, 20, 16, 1313},
	/*II_DE_02*/ {0x35, 0, 20, 16, 1320},
	/*II_DE_03*/ {0x35, 0, 20, 16, 1327},
	/*II_DE_04*/ {0x35, 0, 20, 16, 1335},
	/*II_DE_05*/ {0x35, 0, 20, 16, 1342},
	/*II_DE_06*/ {0x35, 0, 20, 16, 1350},
	/*II_DE_07*/ {0x35, 0, 20, 16, 1357},
	/*II_DE_C0*/ {0x3b, 0, 63, 16, 1538},
	/*II_DE_C1*/ {0x3b, 0, 0, 16, 1538},
	/*II_DE_C0*/ {0x3b, 0, 63, 16, 1538},
	/*II_DE_C0*/ {0x3b, 0, 63, 16, 1538},
	/*II_DE_C0*/ {0x3b, 0, 63, 16, 1538},
	/*II_DE_C0*/ {0x3b, 0, 63, 16, 1538},
	/*II_DE_C0*/ {0x3b, 0, 63, 16, 1538},
	/*II_DE_C0*/ {0x3b, 0, 63, 16, 1538},
	/*II_DE_C8*/ {0x3b, 0, 63, 16, 1545},
	/*II_DE_C9*/ {0x3b, 0, 0, 16, 1545},
	/*II_DE_C8*/ {0x3b, 0, 63, 16, 1545},
	/*II_DE_C8*/ {0x3b, 0, 63, 16, 1545},
	/*II_DE_C8*/ {0x3b, 0, 63, 16, 1545},
	/*II_DE_C8*/ {0x3b, 0, 63, 16, 1545},
	/*II_DE_C8*/ {0x3b, 0, 63, 16, 1545},
	/*II_DE_C8*/ {0x3b, 0, 63, 16, 1545},
	/*II_DE_D9*/ {0x3b, 0, 0, 16, 1552},
	/*II_DE_E0*/ {0x3b, 0, 63, 16, 1560},
	/*II_DE_E1*/ {0x3b, 0, 0, 16, 1560},
	/*II_DE_E0*/ {0x3b, 0, 63, 16, 1560},
	/*II_DE_E0*/ {0x3b, 0, 63, 16, 1560},
	/*II_DE_E0*/ {0x3b, 0, 63, 16, 1560},
	/*II_DE_E0*/ {0x3b, 0, 63, 16, 1560},
	/*II_DE_E0*/ {0x3b, 0, 63, 16, 1560},
	/*II_DE_E0*/ {0x3b, 0, 63, 16, 1560},
	/*II_DE_E8*/ {0x3b, 0, 63, 16, 1568},
	/*II_DE_E9*/ {0x3b, 0, 0, 16, 1568},
	/*II_DE_E8*/ {0x3b, 0, 63, 16, 1568},
	/*II_DE_E8*/ {0x3b, 0, 63, 16, 1568},
	/*II_DE_E8*/ {0x3b, 0, 63, 16, 1568},
	/*II_DE_E8*/ {0x3b, 0, 63, 16, 1568},
	/*II_DE_E8*/ {0x3b, 0, 63, 16, 1568},
	/*II_DE_E8*/ {0x3b, 0, 63, 16, 1568},
	/*II_DE_F0*/ {0x3b, 0, 63, 16, 1575},
	/*II_DE_F1*/ {0x3b, 0, 0, 16, 1575},
	/*II_DE_F0*/ {0x3b, 0, 63, 16, 1575},
	/*II_DE_F0*/ {0x3b, 0, 63, 16, 1575},
	/*II_DE_F0*/ {0x3b, 0, 63, 16, 1575},
	/*II_DE_F0*/ {0x3b, 0, 63, 16, 1575},
	/*II_DE_F0*/ {0x3b, 0, 63, 16, 1575},
	/*II_DE_F0*/ {0x3b, 0, 63, 16, 1575},
	/*II_DE_F8*/ {0x3b, 0, 63, 16, 1583},
	/*II_DE_F9*/ {0x3b, 0, 0, 16, 1583},
	/*II_DE_F8*/ {0x3b, 0, 63, 16, 1583},
	/*II_DE_F8*/ {0x3b, 0, 63, 16, 1583},
	/*II_DE_F8*/ {0x3b, 0, 63, 16, 1583},
	/*II_DE_F8*/ {0x3b, 0, 63, 16, 1583},
	/*II_DE_F8*/ {0x3b, 0, 63, 16, 1583},
	/*II_DE_F8*/ {0x3b, 0, 63, 16, 1583},
	/*II_DF_00*/ {0x35, 0, 20, 16, 1407},
	/*II_DF_01*/ {0x3d, 0, 20, 56, 1413},
	/*II_DF_02*/ {0x35, 0, 20, 16, 1421},
	/*II_DF_03*/ {0x35, 0, 20, 16, 1427},
	/*II_DF_04*/ {0x35, 0, 23, 16, 1590},
	/*II_DF_05*/ {0x35, 0, 22, 16, 1407},
	/*II_DF_06*/ {0x35, 0, 23, 16, 1596},
	/*II_DF_07*/ {0x35, 0, 22, 16, 1427},
	/*II_DF_E8*/ {0x3c, 0, 62, 16, 1603},
	/*II_DF_E8*/ {0x3c, 0, 62, 16, 1603},
	/*II_DF_E8*/ {0x3c, 0, 62, 16, 1603},
	/*II_DF_E8*/ {0x3c, 0, 62, 16, 1603},
	/*II_DF_E8*/ {0x3c, 0, 62, 16, 1603},
	/*II_DF_E8*/ {0x3c, 0, 62, 16, 1603},
	/*II_DF_E8*/ {0x3c, 0, 62, 16, 1603},
	/*II_DF_E8*/ {0x3c, 0, 62, 16, 1603},
	/*II_DF_F0*/ {0x3c, 0, 62, 16, 1612},
	/*II_DF_F0*/ {0x3c, 0, 62, 16, 1612},
	/*II_DF_F0*/ {0x3c, 0, 62, 16, 1612},
	/*II_DF_F0*/ {0x3c, 0, 62, 16, 1612},
	/*II_DF_F0*/ {0x3c, 0, 62, 16, 1612},
	/*II_DF_F0*/ {0x3c, 0, 62, 16, 1612},
	/*II_DF_F0*/ {0x3c, 0, 62, 16, 1612},
	/*II_DF_F0*/ {0x3c, 0, 62, 16, 1612},
	/*II_F6_00*/ {0x35, 1, 15, 8, 206},
	/*II_F6_02*/ {0x34, 0, 15, 8, 1620},
	/*II_F6_03*/ {0x34, 0, 15, 8, 1625},
	/*II_F6_04*/ {0x3a, 0, 15, 8, 1630},
	/*II_F6_05*/ {0x3a, 0, 15, 8, 117},
	/*II_F6_06*/ {0x3a, 0, 15, 8, 1635},
	/*II_F6_07*/ {0x3a, 0, 15, 8, 1640},
	/*II_F7_00*/ {0x35, 3, 17, 8, 206},
	/*II_F7_02*/ {0x34, 0, 17, 8, 1620},
	/*II_F7_03*/ {0x34, 0, 17, 8, 1625},
	/*II_F7_04*/ {0x3a, 0, 17, 8, 1630},
	/*II_F7_05*/ {0x3a, 0, 17, 8, 117},
	/*II_F7_06*/ {0x3a, 0, 17, 8, 1635},
	/*II_F7_07*/ {0x3a, 0, 17, 8, 1640},
	/*II_FE_00*/ {0x34, 0, 15, 8, 81},
	/*II_FE_01*/ {0x34, 0, 15, 8, 86},
	/*II_FF_00*/ {0x34, 0, 17, 8, 81},
	/*II_FF_01*/ {0x34, 0, 17, 8, 86},
	/*II_FF_02*/ {0x3e, 0, 17, 9, 456},
	/*II_FF_03*/ {0x3f, 0, 37, 9, 260},
	/*II_FF_04*/ {0x3e, 0, 17, 12, 462},
	/*II_FF_05*/ {0x3f, 0, 37, 12, 467},
	/*II_FF_06*/ {0x3e, 0, 17, 8, 16},
	/*II_0F_00_00*/ {0x35, 0, 17, 8, 1646},
	/*II_0F_00_01*/ {0x35, 0, 16, 8, 1652},
	/*II_0F_00_02*/ {0x35, 0, 16, 8, 1657},
	/*II_0F_00_03*/ {0x3d, 0, 16, 8, 1663},
	/*II_0F_00_04*/ {0x35, 0, 16, 8, 1668},
	/*II_0F_00_05*/ {0x35, 0, 16, 8, 1674},
	/*II_0F_01_00*/ {0x3e, 0, 39, 8, 1680},
	/*II_0F_01_01*/ {0x3e, 0, 39, 8, 1686},
	/*II_0F_01_02*/ {0x3e, 0, 39, 8, 1692},
	/*II_0F_01_03*/ {0x3e, 0, 39, 8, 1698},
	/*II_0F_01_04*/ {0x40, 0, 28, 8, 1704},
	/*II_0F_01_06*/ {0x41, 0, 16, 8, 1710},
	/*II_0F_01_07*/ {0x3d, 0, 42, 8, 1716},
	/*II_0F_01_C1*/ {0x3c, 0, 0, 112, 1724},
	/*II_0F_01_C2*/ {0x3c, 0, 0, 112, 1732},
	/*II_0F_01_C3*/ {0x3c, 0, 0, 112, 1742},
	/*II_0F_01_C4*/ {0x3c, 0, 0, 112, 1752},
	/*II_0F_01_C8*/ {0x3c, 0, 0, 8, 1760},
	/*II_0F_01_C9*/ {0x3c, 0, 0, 8, 1769},
	/*II_0F_01_D0*/ {0x26, 0, 0, 8, 1776},
	/*II_0F_01_D1*/ {0x26, 0, 0, 8, 1784},
	/*II_0F_01_D8*/ {0x3d, 0, 58, 120, 1792},
	/*II_0F_01_D9*/ {0x3c, 0, 0, 120, 1799},
	/*II_0F_01_DA*/ {0x3c, 0, 58, 120, 1808},
	/*II_0F_01_DB*/ {0x3c, 0, 58, 120, 1816},
	/*II_0F_01_DC*/ {0x3c, 0, 0, 120, 1824},
	/*II_0F_01_DD*/ {0x3c, 0, 0, 120, 1830},
	/*II_0F_01_DE*/ {0x3c, 0, 58, 120, 1836},
	/*II_0F_01_DF*/ {0x3c, 60, 58, 120, 1844},
	/*II_0F_01_F8*/ {0x42, 0, 0, 8, 1853},
	/*II_0F_01_F9*/ {0x42, 0, 0, 8, 1861},
	/*II_0F_0D_00*/ {0x3d, 0, 42, 96, 1869},
	/*II_0F_0D_01*/ {0x3d, 0, 42, 96, 1879},
	/*II_0F_0F_0C*/ {0x43, 67, 64, 104, 1890},
	/*II_0F_0F_0D*/ {0x43, 67, 64, 96, 1897},
	/*II_0F_0F_1C*/ {0x43, 67, 64, 104, 1904},
	/*II_0F_0F_1D*/ {0x43, 67, 64, 96, 1911},
	/*II_0F_0F_8A*/ {0x43, 67, 64, 104, 1918},
	/*II_0F_0F_8E*/ {0x43, 67, 64, 104, 1926},
	/*II_0F_0F_90*/ {0x43, 67, 64, 96, 1935},
	/*II_0F_0F_94*/ {0x43, 67, 64, 96, 1944},
	/*II_0F_0F_96*/ {0x43, 67, 64, 96, 1951},
	/*II_0F_0F_97*/ {0x43, 67, 64, 96, 1958},
	/*II_0F_0F_9A*/ {0x43, 67, 64, 96, 1967},
	/*II_0F_0F_9E*/ {0x43, 67, 64, 96, 1974},
	/*II_0F_0F_A0*/ {0x43, 67, 64, 96, 1981},
	/*II_0F_0F_A4*/ {0x43, 67, 64, 96, 1990},
	/*II_0F_0F_A6*/ {0x43, 67, 64, 96, 1997},
	/*II_0F_0F_A7*/ {0x43, 67, 64, 96, 2007},
	/*II_0F_0F_AA*/ {0x43, 67, 64, 96, 2017},
	/*II_0F_0F_AE*/ {0x43, 67, 64, 96, 2025},
	/*II_0F_0F_B0*/ {0x43, 67, 64, 96, 2032},
	/*II_0F_0F_B4*/ {0x43, 67, 64, 96, 2041},
	/*II_0F_0F_B6*/ {0x43, 67, 64, 96, 2048},
	/*II_0F_0F_B7*/ {0x43, 67, 64, 96, 2058},
	/*II_0F_0F_BB*/ {0x43, 67, 64, 104, 2067},
	/*II_0F_0F_BF*/ {0x43, 67, 64, 96, 2075},
	/*II_0F_10*/ {0x2a, 73, 68, 40, 2084},
	/*II_66_0F_10*/ {0x2a, 73, 68, 48, 2092},
	/*II_F3_0F_10*/ {0x2a, 71, 68, 40, 2100},
	/*II_F2_0F_10*/ {0x2a, 72, 68, 48, 2107},
	/*II_0F_11*/ {0x2a, 68, 73, 40, 2084},
	/*II_66_0F_11*/ {0x2a, 68, 73, 48, 2092},
	/*II_F3_0F_11*/ {0x2a, 68, 71, 40, 2100},
	/*II_F2_0F_11*/ {0x2a, 68, 72, 48, 2107},
	/*II_66_0F_12*/ {0x2a, 46, 68, 48, 2165},
	/*II_F3_0F_12*/ {0x2a, 72, 68, 56, 2173},
	/*II_F2_0F_12*/ {0x2a, 72, 68, 56, 2183},
	/*II_0F_13*/ {0x2a, 68, 46, 40, 2157},
	/*II_66_0F_13*/ {0x2a, 68, 46, 48, 2165},
	/*II_0F_14*/ {0x29, 73, 68, 40, 2241},
	/*II_66_0F_14*/ {0x29, 73, 68, 48, 2251},
	/*II_0F_15*/ {0x29, 73, 68, 40, 2283},
	/*II_66_0F_15*/ {0x29, 73, 68, 48, 2293},
	/*II_66_0F_16*/ {0x2a, 46, 68, 48, 2342},
	/*II_F3_0F_16*/ {0x2a, 73, 68, 56, 2350},
	/*II_0F_17*/ {0x2a, 68, 46, 40, 2334},
	/*II_66_0F_17*/ {0x2a, 68, 46, 48, 2342},
	/*II_0F_18_00*/ {0x3d, 0, 42, 40, 2399},
	/*II_0F_18_01*/ {0x3d, 0, 42, 40, 2412},
	/*II_0F_18_02*/ {0x3d, 0, 42, 40, 2424},
	/*II_0F_18_03*/ {0x3d, 0, 42, 40, 2436},
	/*II_0F_28*/ {0x2a, 73, 68, 40, 2448},
	/*II_66_0F_28*/ {0x2a, 73, 68, 48, 2456},
	/*II_0F_29*/ {0x2a, 68, 73, 40, 2448},
	/*II_66_0F_29*/ {0x2a, 68, 73, 48, 2456},
	/*II_0F_2A*/ {0x29, 67, 68, 40, 2482},
	/*II_66_0F_2A*/ {0x29, 67, 68, 48, 2492},
	/*II_F3_0F_2A*/ {0x31, 18, 68, 40, 2502},
	/*II_F2_0F_2A*/ {0x31, 18, 68, 48, 2512},
	/*II_0F_2B*/ {0x2a, 68, 47, 40, 2544},
	/*II_66_0F_2B*/ {0x2a, 68, 47, 48, 2553},
	/*II_F3_0F_2B*/ {0x2a, 68, 44, 88, 2562},
	/*II_F2_0F_2B*/ {0x2a, 68, 46, 88, 2571},
	/*II_0F_2C*/ {0x29, 72, 64, 40, 2600},
	/*II_66_0F_2C*/ {0x29, 73, 64, 48, 2611},
	/*II_F3_0F_2C*/ {0x31, 71, 13, 40, 2622},
	/*II_F2_0F_2C*/ {0x31, 72, 13, 48, 2633},
	/*II_0F_2D*/ {0x29, 72, 64, 40, 2668},
	/*II_66_0F_2D*/ {0x29, 73, 68, 48, 2678},
	/*II_F3_0F_2D*/ {0x31, 71, 13, 40, 2688},
	/*II_F2_0F_2D*/ {0x31, 72, 13, 48, 2698},
	/*II_0F_2E*/ {0x29, 71, 68, 40, 2730},
	/*II_66_0F_2E*/ {0x29, 72, 68, 48, 2739},
	/*II_0F_2F*/ {0x29, 71, 68, 40, 2768},
	/*II_66_0F_2F*/ {0x29, 72, 68, 48, 2776},
	/*II_0F_50*/ {0x48, 69, 12, 40, 2802},
	/*II_66_0F_50*/ {0x48, 69, 12, 48, 2812},
	/*II_0F_51*/ {0x29, 73, 68, 40, 2844},
	/*II_66_0F_51*/ {0x29, 73, 68, 48, 2852},
	/*II_F3_0F_51*/ {0x29, 71, 68, 40, 2860},
	/*II_F2_0F_51*/ {0x29, 72, 68, 48, 2868},
	/*II_0F_52*/ {0x29, 73, 68, 40, 2912},
	/*II_F3_0F_52*/ {0x29, 71, 68, 40, 2921},
	/*II_0F_53*/ {0x29, 73, 68, 40, 2950},
	/*II_F3_0F_53*/ {0x29, 71, 68, 40, 2957},
	/*II_0F_54*/ {0x29, 73, 68, 40, 2980},
	/*II_66_0F_54*/ {0x29, 73, 68, 48, 2987},
	/*II_0F_55*/ {0x29, 73, 68, 40, 3010},
	/*II_66_0F_55*/ {0x29, 73, 68, 48, 3018},
	/*II_0F_56*/ {0x29, 73, 68, 40, 3044},
	/*II_66_0F_56*/ {0x29, 73, 68, 48, 3050},
	/*II_0F_57*/ {0x29, 73, 68, 40, 3070},
	/*II_66_0F_57*/ {0x29, 73, 68, 48, 3077},
	/*II_0F_58*/ {0x29, 73, 68, 40, 3100},
	/*II_66_0F_58*/ {0x29, 73, 68, 48, 3107},
	/*II_F3_0F_58*/ {0x29, 71, 68, 40, 3114},
	/*II_F2_0F_58*/ {0x29, 72, 68, 48, 3121},
	/*II_0F_59*/ {0x29, 73, 68, 40, 3160},
	/*II_66_0F_59*/ {0x29, 73, 68, 48, 3167},
	/*II_F3_0F_59*/ {0x29, 71, 68, 40, 3174},
	/*II_F2_0F_59*/ {0x29, 72, 68, 48, 3181},
	/*II_0F_5A*/ {0x29, 72, 68, 48, 3220},
	/*II_66_0F_5A*/ {0x29, 73, 68, 48, 3230},
	/*II_F3_0F_5A*/ {0x29, 71, 68, 48, 3240},
	/*II_F2_0F_5A*/ {0x29, 72, 68, 48, 3250},
	/*II_0F_5B*/ {0x29, 73, 68, 48, 3304},
	/*II_66_0F_5B*/ {0x29, 73, 68, 48, 3314},
	/*II_F3_0F_5B*/ {0x29, 73, 68, 48, 3324},
	/*II_0F_5C*/ {0x29, 73, 68, 40, 3369},
	/*II_66_0F_5C*/ {0x29, 73, 68, 48, 3376},
	/*II_F3_0F_5C*/ {0x29, 71, 68, 40, 3383},
	/*II_F2_0F_5C*/ {0x29, 72, 68, 48, 3390},
	/*II_0F_5D*/ {0x29, 73, 68, 40, 3429},
	/*II_66_0F_5D*/ {0x29, 73, 68, 48, 3436},
	/*II_F3_0F_5D*/ {0x29, 71, 68, 40, 3443},
	/*II_F2_0F_5D*/ {0x29, 72, 68, 48, 3450},
	/*II_0F_5E*/ {0x29, 73, 68, 40, 3489},
	/*II_66_0F_5E*/ {0x29, 73, 68, 48, 3496},
	/*II_F3_0F_5E*/ {0x29, 71, 68, 40, 3503},
	/*II_F2_0F_5E*/ {0x29, 72, 68, 48, 3510},
	/*II_0F_5F*/ {0x29, 73, 68, 40, 3549},
	/*II_66_0F_5F*/ {0x29, 73, 68, 48, 3556},
	/*II_F3_0F_5F*/ {0x29, 71, 68, 40, 3563},
	/*II_F2_0F_5F*/ {0x29, 72, 68, 48, 3570},
	/*II_0F_60*/ {0x29, 66, 64, 32, 3609},
	/*II_66_0F_60*/ {0x29, 73, 68, 48, 3609},
	/*II_0F_61*/ {0x29, 66, 64, 32, 3632},
	/*II_66_0F_61*/ {0x29, 73, 68, 48, 3632},
	/*II_0F_62*/ {0x29, 66, 64, 32, 3655},
	/*II_66_0F_62*/ {0x29, 73, 68, 48, 3655},
	/*II_0F_63*/ {0x29, 67, 64, 32, 3678},
	/*II_66_0F_63*/ {0x29, 73, 68, 48, 3678},
	/*II_0F_64*/ {0x29, 67, 64, 32, 3699},
	/*II_66_0F_64*/ {0x29, 73, 68, 48, 3699},
	/*II_0F_65*/ {0x29, 67, 64, 32, 3718},
	/*II_66_0F_65*/ {0x29, 73, 68, 48, 3718},
	/*II_0F_66*/ {0x29, 67, 64, 32, 3737},
	/*II_66_0F_66*/ {0x29, 73, 68, 48, 3737},
	/*II_0F_67*/ {0x29, 67, 64, 32, 3756},
	/*II_66_0F_67*/ {0x29, 73, 68, 48, 3756},
	/*II_0F_68*/ {0x29, 67, 64, 32, 3777},
	/*II_66_0F_68*/ {0x29, 73, 68, 48, 3777},
	/*II_0F_69*/ {0x29, 67, 64, 32, 3800},
	/*II_66_0F_69*/ {0x29, 73, 68, 48, 3800},
	/*II_0F_6A*/ {0x29, 67, 64, 32, 3823},
	/*II_66_0F_6A*/ {0x29, 73, 68, 48, 3823},
	/*II_0F_6B*/ {0x29, 67, 64, 32, 3846},
	/*II_66_0F_6B*/ {0x29, 73, 68, 48, 3846},
	/*II_66_0F_6C*/ {0x29, 73, 68, 48, 3867},
	/*II_66_0F_6D*/ {0x29, 73, 68, 48, 3892},
	/*II_0F_6F*/ {0x2a, 67, 64, 32, 3923},
	/*II_66_0F_6F*/ {0x2a, 73, 68, 48, 3943},
	/*II_F3_0F_6F*/ {0x2a, 73, 68, 48, 3951},
	/*II_0F_74*/ {0x29, 67, 64, 32, 4040},
	/*II_66_0F_74*/ {0x29, 73, 68, 48, 4040},
	/*II_0F_75*/ {0x29, 67, 64, 32, 4059},
	/*II_66_0F_75*/ {0x29, 73, 68, 48, 4059},
	/*II_0F_76*/ {0x29, 67, 64, 32, 4078},
	/*II_66_0F_76*/ {0x29, 73, 68, 48, 4078},
	/*II_0F_77*/ {0x26, 0, 0, 32, 4097},
	/*II_0F_78*/ {0x4d, 13, 18, 112, 4125},
	/*II_0F_79*/ {0x4d, 18, 13, 112, 4149},
	/*II_66_0F_79*/ {0x29, 69, 68, 88, 4133},
	/*II_F2_0F_79*/ {0x50, 69, 68, 88, 4140},
	/*II_66_0F_7C*/ {0x29, 73, 68, 56, 4158},
	/*II_F2_0F_7C*/ {0x29, 73, 68, 56, 4166},
	/*II_66_0F_7D*/ {0x29, 73, 68, 56, 4192},
	/*II_F2_0F_7D*/ {0x29, 73, 68, 56, 4200},
	/*II_F3_0F_7E*/ {0x2a, 72, 68, 48, 3923},
	/*II_0F_7F*/ {0x2a, 64, 67, 32, 3923},
	/*II_66_0F_7F*/ {0x2a, 68, 73, 48, 3943},
	/*II_F3_0F_7F*/ {0x2a, 68, 73, 48, 3951},
	/*II_0F_AE_00*/ {0x3d, 0, 42, 8, 4226},
	/*II_0F_AE_01*/ {0x3d, 0, 42, 8, 4234},
	/*II_0F_AE_04*/ {0x3d, 0, 42, 8, 4243},
	/*II_0F_AE_06*/ {0x52, 0, 0, 8, 4265},
	/*II_F3_0F_B8*/ {0x53, 17, 11, 80, 4290},
	/*II_0F_BA_04*/ {0x54, 1, 17, 8, 872},
	/*II_0F_BA_05*/ {0x38, 1, 17, 8, 887},
	/*II_0F_BA_06*/ {0x38, 1, 17, 8, 912},
	/*II_0F_BA_07*/ {0x38, 1, 17, 8, 934},
	/*II_0F_BD*/ {0x29, 17, 11, 8, 4298},
	/*II_F3_0F_BD*/ {0x55, 17, 11, 8, 4303},
	/*II_0F_C7_07*/ {0x3d, 0, 46, 112, 5065},
	/*II_66_0F_D0*/ {0x29, 73, 68, 56, 5074},
	/*II_F2_0F_D0*/ {0x29, 73, 68, 56, 5084},
	/*II_0F_D1*/ {0x29, 67, 64, 32, 5116},
	/*II_66_0F_D1*/ {0x29, 73, 68, 48, 5116},
	/*II_0F_D2*/ {0x29, 67, 64, 32, 5131},
	/*II_66_0F_D2*/ {0x29, 73, 68, 48, 5131},
	/*II_0F_D3*/ {0x29, 67, 64, 32, 5146},
	/*II_66_0F_D3*/ {0x29, 73, 68, 48, 5146},
	/*II_0F_D4*/ {0x29, 72, 68, 48, 5161},
	/*II_66_0F_D4*/ {0x29, 73, 68, 48, 5161},
	/*II_0F_D5*/ {0x29, 67, 64, 32, 5176},
	/*II_66_0F_D5*/ {0x29, 73, 68, 48, 5176},
	/*II_66_0F_D6*/ {0x2a, 68, 72, 48, 3923},
	/*II_F3_0F_D6*/ {0x48, 65, 68, 48, 5193},
	/*II_F2_0F_D6*/ {0x48, 69, 64, 48, 5202},
	/*II_0F_D7*/ {0x50, 65, 12, 40, 5211},
	/*II_66_0F_D7*/ {0x50, 69, 12, 48, 5211},
	/*II_0F_D8*/ {0x29, 67, 64, 32, 5232},
	/*II_66_0F_D8*/ {0x29, 73, 68, 48, 5232},
	/*II_0F_D9*/ {0x29, 67, 64, 32, 5251},
	/*II_66_0F_D9*/ {0x29, 73, 68, 48, 5251},
	/*II_0F_DA*/ {0x29, 67, 64, 40, 5270},
	/*II_66_0F_DA*/ {0x29, 73, 68, 48, 5270},
	/*II_0F_DB*/ {0x29, 67, 64, 32, 5287},
	/*II_66_0F_DB*/ {0x29, 73, 68, 48, 5287},
	/*II_0F_DC*/ {0x29, 67, 64, 32, 5300},
	/*II_66_0F_DC*/ {0x29, 73, 68, 48, 5300},
	/*II_0F_DD*/ {0x29, 67, 64, 32, 5319},
	/*II_66_0F_DD*/ {0x29, 73, 68, 48, 5319},
	/*II_0F_DE*/ {0x29, 67, 64, 40, 5328},
	/*II_66_0F_DE*/ {0x29, 73, 68, 48, 5328},
	/*II_0F_DF*/ {0x29, 67, 64, 32, 5345},
	/*II_66_0F_DF*/ {0x29, 73, 68, 48, 5345},
	/*II_0F_E0*/ {0x29, 67, 64, 40, 5360},
	/*II_66_0F_E0*/ {0x29, 73, 68, 48, 5360},
	/*II_0F_E1*/ {0x29, 67, 64, 32, 5375},
	/*II_66_0F_E1*/ {0x29, 73, 68, 48, 5375},
	/*II_0F_E2*/ {0x29, 67, 64, 32, 5390},
	/*II_66_0F_E2*/ {0x29, 73, 68, 48, 5390},
	/*II_0F_E3*/ {0x29, 67, 64, 40, 5405},
	/*II_66_0F_E3*/ {0x29, 73, 68, 48, 5405},
	/*II_0F_E4*/ {0x29, 67, 64, 40, 5420},
	/*II_66_0F_E4*/ {0x29, 73, 68, 48, 5420},
	/*II_0F_E5*/ {0x29, 67, 64, 32, 5439},
	/*II_66_0F_E5*/ {0x29, 73, 68, 48, 5439},
	/*II_66_0F_E6*/ {0x29, 73, 68, 48, 5456},
	/*II_F3_0F_E6*/ {0x29, 72, 68, 48, 5467},
	/*II_F2_0F_E6*/ {0x29, 73, 68, 48, 5477},
	/*II_0F_E7*/ {0x2a, 64, 46, 40, 5521},
	/*II_66_0F_E7*/ {0x2a, 68, 47, 48, 5529},
	/*II_0F_E8*/ {0x29, 67, 64, 32, 5548},
	/*II_66_0F_E8*/ {0x29, 73, 68, 48, 5548},
	/*II_0F_E9*/ {0x29, 67, 64, 32, 5565},
	/*II_66_0F_E9*/ {0x29, 73, 68, 48, 5565},
	/*II_0F_EA*/ {0x29, 67, 64, 40, 5582},
	/*II_66_0F_EA*/ {0x29, 73, 68, 48, 5582},
	/*II_0F_EB*/ {0x29, 67, 64, 32, 5599},
	/*II_66_0F_EB*/ {0x29, 73, 68, 48, 5599},
	/*II_0F_EC*/ {0x29, 67, 64, 32, 5610},
	/*II_66_0F_EC*/ {0x29, 73, 68, 48, 5610},
	/*II_0F_ED*/ {0x29, 67, 64, 32, 5627},
	/*II_66_0F_ED*/ {0x29, 73, 68, 48, 5627},
	/*II_0F_EE*/ {0x29, 67, 64, 40, 5644},
	/*II_66_0F_EE*/ {0x29, 73, 68, 48, 5644},
	/*II_0F_EF*/ {0x29, 67, 64, 32, 5661},
	/*II_66_0F_EF*/ {0x29, 73, 68, 48, 5661},
	/*II_F2_0F_F0*/ {0x29, 42, 68, 56, 5674},
	/*II_0F_F1*/ {0x29, 67, 64, 32, 5689},
	/*II_66_0F_F1*/ {0x29, 73, 68, 48, 5689},
	/*II_0F_F2*/ {0x29, 67, 64, 32, 5704},
	/*II_66_0F_F2*/ {0x29, 73, 68, 48, 5704},
	/*II_0F_F3*/ {0x29, 67, 64, 32, 5719},
	/*II_66_0F_F3*/ {0x29, 73, 68, 48, 5719},
	/*II_0F_F4*/ {0x29, 67, 64, 48, 5734},
	/*II_66_0F_F4*/ {0x29, 73, 68, 48, 5734},
	/*II_0F_F5*/ {0x29, 67, 64, 32, 5753},
	/*II_66_0F_F5*/ {0x29, 73, 68, 48, 5753},
	/*II_0F_F6*/ {0x29, 67, 64, 40, 5772},
	/*II_66_0F_F6*/ {0x29, 73, 68, 48, 5772},
	/*II_0F_F7*/ {0x50, 65, 64, 40, 5789},
	/*II_66_0F_F7*/ {0x50, 69, 68, 48, 5799},
	/*II_0F_F8*/ {0x29, 67, 64, 32, 5824},
	/*II_66_0F_F8*/ {0x29, 73, 68, 48, 5824},
	/*II_0F_F9*/ {0x29, 67, 64, 32, 5839},
	/*II_66_0F_F9*/ {0x29, 73, 68, 48, 5839},
	/*II_0F_FA*/ {0x29, 67, 64, 32, 5854},
	/*II_66_0F_FA*/ {0x29, 73, 68, 48, 5854},
	/*II_0F_FB*/ {0x29, 67, 64, 48, 5869},
	/*II_66_0F_FB*/ {0x29, 73, 68, 48, 5869},
	/*II_0F_FC*/ {0x29, 67, 64, 32, 5884},
	/*II_66_0F_FC*/ {0x29, 73, 68, 48, 5884},
	/*II_0F_FD*/ {0x29, 67, 64, 32, 5899},
	/*II_66_0F_FD*/ {0x29, 73, 68, 48, 5899},
	/*II_0F_FE*/ {0x29, 67, 64, 32, 5914},
	/*II_66_0F_FE*/ {0x29, 73, 68, 48, 5914},
	/*II_D9_06*/ {0x35, 0, 42, 16, 5929},
	/*II_9B_D9_06*/ {0x5d, 0, 42, 16, 5938},
	/*II_D9_07*/ {0x35, 0, 42, 16, 5946},
	/*II_9B_D9_07*/ {0x5d, 0, 42, 16, 5954},
	/*II_DB_E2*/ {0x3b, 0, 0, 16, 5961},
	/*II_9B_DB_E2*/ {0x5e, 0, 0, 16, 5969},
	/*II_DB_E3*/ {0x3b, 0, 0, 16, 5976},
	/*II_9B_DB_E3*/ {0x5e, 0, 0, 16, 5984},
	/*II_DD_06*/ {0x35, 0, 42, 16, 5991},
	/*II_9B_DD_06*/ {0x5d, 0, 42, 16, 5999},
	/*II_DD_07*/ {0x35, 0, 42, 16, 6006},
	/*II_9B_DD_07*/ {0x5d, 0, 42, 16, 6014},
	/*II_DF_E0*/ {0x3b, 0, 34, 16, 6006},
	/*II_9B_DF_E0*/ {0x5e, 0, 34, 16, 6014},
	/*II_0F_38_00*/ {0x29, 67, 64, 64, 6021},
	/*II_66_0F_38_00*/ {0x29, 73, 68, 64, 6021},
	/*II_0F_38_01*/ {0x29, 67, 64, 64, 6038},
	/*II_66_0F_38_01*/ {0x29, 73, 68, 64, 6038},
	/*II_0F_38_02*/ {0x29, 67, 64, 64, 6055},
	/*II_66_0F_38_02*/ {0x29, 73, 68, 64, 6055},
	/*II_0F_38_03*/ {0x29, 67, 64, 64, 6072},
	/*II_66_0F_38_03*/ {0x29, 73, 68, 64, 6072},
	/*II_0F_38_04*/ {0x29, 67, 64, 64, 6091},
	/*II_66_0F_38_04*/ {0x29, 73, 68, 64, 6091},
	/*II_0F_38_05*/ {0x29, 67, 64, 64, 6114},
	/*II_66_0F_38_05*/ {0x29, 73, 68, 64, 6114},
	/*II_0F_38_06*/ {0x29, 67, 64, 64, 6131},
	/*II_66_0F_38_06*/ {0x29, 73, 68, 64, 6131},
	/*II_0F_38_07*/ {0x29, 67, 64, 64, 6148},
	/*II_66_0F_38_07*/ {0x29, 73, 68, 64, 6148},
	/*II_0F_38_08*/ {0x29, 67, 64, 64, 6167},
	/*II_66_0F_38_08*/ {0x29, 73, 68, 64, 6167},
	/*II_0F_38_09*/ {0x29, 67, 64, 64, 6184},
	/*II_66_0F_38_09*/ {0x29, 73, 68, 64, 6184},
	/*II_0F_38_0A*/ {0x29, 67, 64, 64, 6201},
	/*II_66_0F_38_0A*/ {0x29, 73, 68, 64, 6201},
	/*II_0F_38_0B*/ {0x29, 67, 64, 64, 6218},
	/*II_66_0F_38_0B*/ {0x29, 73, 68, 64, 6218},
	/*II_66_0F_38_17*/ {0x29, 73, 68, 80, 6311},
	/*II_0F_38_1C*/ {0x29, 67, 64, 64, 6370},
	/*II_66_0F_38_1C*/ {0x29, 73, 68, 64, 6370},
	/*II_0F_38_1D*/ {0x29, 67, 64, 64, 6385},
	/*II_66_0F_38_1D*/ {0x29, 73, 68, 64, 6385},
	/*II_0F_38_1E*/ {0x29, 67, 64, 64, 6400},
	/*II_66_0F_38_1E*/ {0x29, 73, 68, 64, 6400},
	/*II_66_0F_38_20*/ {0x29, 72, 68, 72, 6415},
	/*II_66_0F_38_21*/ {0x29, 71, 68, 72, 6436},
	/*II_66_0F_38_22*/ {0x29, 70, 68, 72, 6457},
	/*II_66_0F_38_23*/ {0x29, 72, 68, 72, 6478},
	/*II_66_0F_38_24*/ {0x29, 71, 68, 72, 6499},
	/*II_66_0F_38_25*/ {0x29, 72, 68, 72, 6520},
	/*II_66_0F_38_28*/ {0x29, 73, 68, 72, 6541},
	/*II_66_0F_38_29*/ {0x29, 73, 68, 72, 6558},
	/*II_66_0F_38_2A*/ {0x2a, 47, 68, 72, 6577},
	/*II_66_0F_38_2B*/ {0x29, 73, 68, 72, 6598},
	/*II_66_0F_38_30*/ {0x29, 72, 68, 72, 6643},
	/*II_66_0F_38_31*/ {0x29, 71, 68, 72, 6664},
	/*II_66_0F_38_32*/ {0x29, 70, 68, 72, 6685},
	/*II_66_0F_38_33*/ {0x29, 72, 68, 72, 6706},
	/*II_66_0F_38_34*/ {0x29, 71, 68, 72, 6727},
	/*II_66_0F_38_35*/ {0x29, 72, 68, 72, 6748},
	/*II_66_0F_38_37*/ {0x29, 73, 68, 80, 6769},
	/*II_66_0F_38_38*/ {0x29, 73, 68, 72, 6788},
	/*II_66_0F_38_39*/ {0x29, 73, 68, 72, 6805},
	/*II_66_0F_38_3A*/ {0x29, 73, 68, 72, 6822},
	/*II_66_0F_38_3B*/ {0x29, 73, 68, 72, 6839},
	/*II_66_0F_38_3C*/ {0x29, 73, 68, 72, 6856},
	/*II_66_0F_38_3D*/ {0x29, 73, 68, 72, 6873},
	/*II_66_0F_38_3E*/ {0x29, 73, 68, 72, 6890},
	/*II_66_0F_38_3F*/ {0x29, 73, 68, 72, 6907},
	/*II_66_0F_38_40*/ {0x29, 73, 68, 72, 6924},
	/*II_66_0F_38_41*/ {0x29, 73, 68, 72, 6941},
	/*II_66_0F_38_80*/ {0x4d, 47, 13, 112, 6966},
	/*II_66_0F_38_81*/ {0x4d, 47, 13, 112, 6974},
	/*II_66_0F_38_DB*/ {0x29, 73, 68, 152, 7823},
	/*II_66_0F_38_DC*/ {0x29, 73, 68, 152, 7840},
	/*II_66_0F_38_DD*/ {0x29, 73, 68, 152, 7857},
	/*II_66_0F_38_DE*/ {0x29, 73, 68, 152, 7882},
	/*II_66_0F_38_DF*/ {0x29, 73, 68, 152, 7899},
	/*II_0F_38_F0*/ {0x2a, 17, 11, 8, 7924},
	/*II_F2_0F_38_F0*/ {0x2a, 15, 13, 80, 7931},
	/*II_0F_38_F1*/ {0x2a, 11, 17, 8, 7924},
	/*II_F2_0F_38_F1*/ {0x2a, 17, 13, 80, 7931},
	/*II_0F_71_02*/ {0x52, 1, 65, 32, 5116},
	/*II_66_0F_71_02*/ {0x3d, 1, 69, 48, 5116},
	/*II_0F_71_04*/ {0x52, 1, 65, 32, 5375},
	/*II_66_0F_71_04*/ {0x3d, 1, 69, 48, 5375},
	/*II_0F_71_06*/ {0x52, 1, 65, 32, 5689},
	/*II_66_0F_71_06*/ {0x3d, 1, 69, 48, 5689},
	/*II_0F_72_02*/ {0x52, 1, 65, 32, 5131},
	/*II_66_0F_72_02*/ {0x3d, 1, 69, 48, 5131},
	/*II_0F_72_04*/ {0x52, 1, 65, 32, 5390},
	/*II_66_0F_72_04*/ {0x3d, 1, 69, 48, 5390},
	/*II_0F_72_06*/ {0x52, 1, 65, 32, 5704},
	/*II_66_0F_72_06*/ {0x3d, 1, 69, 48, 5704},
	/*II_0F_73_02*/ {0x52, 1, 65, 32, 5146},
	/*II_66_0F_73_02*/ {0x3d, 1, 69, 48, 5146},
	/*II_66_0F_73_03*/ {0x3d, 1, 69, 48, 8494},
	/*II_0F_73_06*/ {0x52, 1, 65, 32, 5719},
	/*II_66_0F_73_06*/ {0x3d, 1, 69, 48, 5719},
	/*II_66_0F_73_07*/ {0x3d, 1, 69, 48, 8511},
	/*II_0F_AE_02*/ {0x3d, 0, 42, 8, 8528},
	/*II_0F_AE_03*/ {0x3d, 0, 42, 8, 8547},
	/*II_0F_C7_06*/ {0x3d, 0, 46, 112, 8566},
	/*II_66_0F_C7_06*/ {0x3d, 0, 46, 112, 8575},
	/*II_F3_0F_C7_06*/ {0x3d, 0, 46, 112, 8584}
};

_InstInfoEx InstInfosEx[] = {
	/*II_69*/ {0x17, 17, 11, 8, 117, 0x0, 3, 0, 0, 0},
	/*II_6B*/ {0x17, 17, 11, 8, 117, 0x0, 5, 0, 0, 0},
	/*II_98*/ {0x1c, 0, 0, 8, 228, 0x0, 0, 0, 233, 239},
	/*II_99*/ {0x1c, 0, 0, 8, 245, 0x0, 0, 0, 250, 255},
	/*II_E3*/ {0x25, 0, 40, 13, 427, 0x0, 0, 0, 433, 440},
	/*II_0F_A4*/ {0x2d, 11, 17, 8, 876, 0x0, 1, 0, 0, 0},
	/*II_0F_A5*/ {0x2d, 11, 17, 8, 876, 0x0, 52, 0, 0, 0},
	/*II_0F_AC*/ {0x2d, 11, 17, 8, 892, 0x0, 1, 0, 0, 0},
	/*II_0F_AD*/ {0x2d, 11, 17, 8, 892, 0x0, 52, 0, 0, 0},
	/*II_V_F3_0F_10*/ {0x44, 81, 68, 128, 2114, 0x0, 69, 0, 0, 0},
	/*II_V_F2_0F_10*/ {0x44, 81, 68, 128, 2122, 0x0, 69, 0, 0, 0},
	/*II_NV_0F_10*/ {0x45, 90, 83, 128, 2130, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_10*/ {0x45, 90, 83, 128, 2139, 0x1, 0, 0, 0, 0},
	/*II_NV_F3_0F_10*/ {0x45, 44, 68, 128, 2114, 0x0, 0, 0, 0, 0},
	/*II_NV_F2_0F_10*/ {0x45, 46, 68, 128, 2122, 0x0, 0, 0, 0, 0},
	/*II_V_F3_0F_11*/ {0x44, 81, 68, 128, 2114, 0x0, 69, 0, 0, 0},
	/*II_V_F2_0F_11*/ {0x44, 81, 68, 128, 2122, 0x0, 69, 0, 0, 0},
	/*II_NV_0F_11*/ {0x45, 83, 90, 128, 2130, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_11*/ {0x45, 83, 90, 128, 2139, 0x1, 0, 0, 0, 0},
	/*II_NV_F3_0F_11*/ {0x45, 68, 44, 128, 2114, 0x0, 0, 0, 0, 0},
	/*II_NV_F2_0F_11*/ {0x45, 68, 46, 128, 2122, 0x0, 0, 0, 0, 0},
	/*II_0F_12*/ {0x46, 72, 68, 40, 2148, 0x0, 0, 0, 2157, 0},
	/*II_V_0F_12*/ {0x47, 81, 68, 128, 2192, 0x0, 72, 0, 2202, 0},
	/*II_V_66_0F_12*/ {0x44, 81, 68, 128, 2211, 0x0, 46, 0, 0, 0},
	/*II_NV_F3_0F_12*/ {0x45, 90, 83, 128, 2220, 0x1, 0, 0, 0, 0},
	/*II_NV_F2_0F_12*/ {0x45, 89, 83, 128, 2231, 0x1, 0, 0, 0, 0},
	/*II_NV_0F_13*/ {0x45, 68, 46, 128, 2202, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_13*/ {0x45, 68, 46, 128, 2211, 0x0, 0, 0, 0, 0},
	/*II_V_0F_14*/ {0x44, 88, 83, 128, 2261, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_14*/ {0x44, 88, 83, 128, 2272, 0x1, 90, 0, 0, 0},
	/*II_V_0F_15*/ {0x44, 88, 83, 128, 2303, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_15*/ {0x44, 88, 83, 128, 2314, 0x1, 90, 0, 0, 0},
	/*II_0F_16*/ {0x46, 72, 68, 40, 2325, 0x0, 0, 0, 2334, 0},
	/*II_V_0F_16*/ {0x47, 81, 68, 128, 2360, 0x0, 72, 0, 2370, 0},
	/*II_V_66_0F_16*/ {0x44, 81, 68, 128, 2379, 0x0, 46, 0, 0, 0},
	/*II_NV_F3_0F_16*/ {0x45, 90, 83, 128, 2388, 0x1, 0, 0, 0, 0},
	/*II_NV_0F_17*/ {0x45, 68, 46, 128, 2370, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_17*/ {0x45, 68, 46, 128, 2379, 0x0, 0, 0, 0, 0},
	/*II_NV_0F_28*/ {0x45, 90, 83, 128, 2464, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_28*/ {0x45, 90, 83, 128, 2473, 0x1, 0, 0, 0, 0},
	/*II_NV_0F_29*/ {0x45, 83, 90, 128, 2464, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_29*/ {0x45, 83, 90, 128, 2473, 0x1, 0, 0, 0, 0},
	/*II_V_F3_0F_2A*/ {0x44, 81, 68, 128, 2522, 0x2, 79, 0, 0, 0},
	/*II_V_F2_0F_2A*/ {0x44, 81, 68, 128, 2533, 0x2, 79, 0, 0, 0},
	/*II_NV_0F_2B*/ {0x45, 83, 92, 128, 2580, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_2B*/ {0x45, 83, 92, 128, 2590, 0x1, 0, 0, 0, 0},
	/*II_NV_F3_0F_2C*/ {0x45, 80, 78, 128, 2644, 0x2, 0, 0, 0, 0},
	/*II_NV_F2_0F_2C*/ {0x45, 80, 78, 128, 2656, 0x2, 0, 0, 0, 0},
	/*II_NV_F3_0F_2D*/ {0x45, 80, 78, 128, 2708, 0x2, 0, 0, 0, 0},
	/*II_NV_F2_0F_2D*/ {0x45, 80, 78, 128, 2719, 0x2, 0, 0, 0, 0},
	/*II_NV_0F_2E*/ {0x45, 71, 68, 128, 2748, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_2E*/ {0x45, 72, 68, 128, 2758, 0x0, 0, 0, 0, 0},
	/*II_NV_0F_2F*/ {0x45, 71, 68, 128, 2784, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_2F*/ {0x45, 72, 68, 128, 2793, 0x0, 0, 0, 0, 0},
	/*II_NV_0F_50*/ {0x49, 83, 13, 128, 2822, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_50*/ {0x49, 83, 13, 128, 2833, 0x1, 0, 0, 0, 0},
	/*II_V_F3_0F_51*/ {0x44, 81, 68, 128, 2876, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_51*/ {0x44, 81, 68, 128, 2885, 0x0, 72, 0, 0, 0},
	/*II_NV_0F_51*/ {0x45, 90, 83, 128, 2894, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_51*/ {0x45, 90, 83, 128, 2903, 0x1, 0, 0, 0, 0},
	/*II_V_F3_0F_52*/ {0x44, 81, 68, 128, 2930, 0x0, 71, 0, 0, 0},
	/*II_NV_0F_52*/ {0x45, 90, 83, 128, 2940, 0x1, 0, 0, 0, 0},
	/*II_V_F3_0F_53*/ {0x44, 81, 68, 128, 2964, 0x0, 71, 0, 0, 0},
	/*II_NV_0F_53*/ {0x45, 90, 83, 128, 2972, 0x1, 0, 0, 0, 0},
	/*II_V_0F_54*/ {0x44, 88, 83, 128, 2994, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_54*/ {0x44, 88, 83, 128, 3002, 0x1, 90, 0, 0, 0},
	/*II_V_0F_55*/ {0x44, 88, 83, 128, 3026, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_55*/ {0x44, 88, 83, 128, 3035, 0x1, 90, 0, 0, 0},
	/*II_V_0F_56*/ {0x44, 88, 83, 128, 3056, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_56*/ {0x44, 88, 83, 128, 3063, 0x1, 90, 0, 0, 0},
	/*II_V_0F_57*/ {0x44, 88, 83, 128, 3084, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_57*/ {0x44, 88, 83, 128, 3092, 0x1, 90, 0, 0, 0},
	/*II_V_0F_58*/ {0x44, 88, 83, 128, 3128, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_58*/ {0x44, 88, 83, 128, 3136, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_58*/ {0x44, 81, 68, 128, 3144, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_58*/ {0x44, 81, 68, 128, 3152, 0x0, 72, 0, 0, 0},
	/*II_V_0F_59*/ {0x44, 88, 83, 128, 3188, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_59*/ {0x44, 88, 83, 128, 3196, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_59*/ {0x44, 81, 68, 128, 3204, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_59*/ {0x44, 81, 68, 128, 3212, 0x0, 72, 0, 0, 0},
	/*II_V_F3_0F_5A*/ {0x44, 81, 68, 128, 3260, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_5A*/ {0x44, 81, 68, 128, 3271, 0x0, 72, 0, 0, 0},
	/*II_NV_0F_5A*/ {0x45, 91, 83, 128, 3282, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_5A*/ {0x45, 90, 68, 128, 3293, 0x1, 0, 0, 0, 0},
	/*II_NV_0F_5B*/ {0x45, 90, 83, 128, 3335, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_5B*/ {0x45, 90, 83, 128, 3346, 0x1, 0, 0, 0, 0},
	/*II_NV_F3_0F_5B*/ {0x45, 90, 83, 128, 3357, 0x1, 0, 0, 0, 0},
	/*II_V_0F_5C*/ {0x44, 88, 83, 128, 3397, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_5C*/ {0x44, 88, 83, 128, 3405, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_5C*/ {0x44, 81, 68, 128, 3413, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_5C*/ {0x44, 81, 68, 128, 3421, 0x0, 72, 0, 0, 0},
	/*II_V_0F_5D*/ {0x44, 88, 83, 128, 3457, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_5D*/ {0x44, 88, 83, 128, 3465, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_5D*/ {0x44, 81, 68, 128, 3473, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_5D*/ {0x44, 81, 68, 128, 3481, 0x0, 72, 0, 0, 0},
	/*II_V_0F_5E*/ {0x44, 88, 83, 128, 3517, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_5E*/ {0x44, 88, 83, 128, 3525, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_5E*/ {0x44, 81, 68, 128, 3533, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_5E*/ {0x44, 81, 68, 128, 3541, 0x0, 72, 0, 0, 0},
	/*II_V_0F_5F*/ {0x44, 88, 83, 128, 3577, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_5F*/ {0x44, 88, 83, 128, 3585, 0x1, 90, 0, 0, 0},
	/*II_V_F3_0F_5F*/ {0x44, 81, 68, 128, 3593, 0x0, 71, 0, 0, 0},
	/*II_V_F2_0F_5F*/ {0x44, 81, 68, 128, 3601, 0x0, 72, 0, 0, 0},
	/*II_V_66_0F_60*/ {0x44, 81, 68, 128, 3620, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_61*/ {0x44, 81, 68, 128, 3643, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_62*/ {0x44, 81, 68, 128, 3666, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_63*/ {0x44, 81, 68, 128, 3688, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_64*/ {0x44, 81, 68, 128, 3708, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_65*/ {0x44, 81, 68, 128, 3727, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_66*/ {0x44, 81, 68, 128, 3746, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_67*/ {0x44, 81, 68, 128, 3766, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_68*/ {0x44, 81, 68, 128, 3788, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_69*/ {0x44, 81, 68, 128, 3811, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_6A*/ {0x44, 81, 68, 128, 3834, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_6B*/ {0x44, 81, 68, 128, 3856, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_6C*/ {0x44, 81, 68, 128, 3879, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_6D*/ {0x44, 81, 68, 128, 3904, 0x0, 73, 0, 0, 0},
	/*II_0F_6E*/ {0x4a, 18, 64, 32, 3917, 0x0, 0, 0, 3923, 0},
	/*II_66_0F_6E*/ {0x4a, 18, 68, 48, 3917, 0x0, 0, 0, 3923, 0},
	/*II_NV_66_0F_6E*/ {0x45, 79, 68, 128, 3929, 0x6, 0, 0, 3936, 0},
	/*II_NV_66_0F_6F*/ {0x45, 90, 83, 128, 3959, 0x1, 0, 0, 0, 0},
	/*II_NV_F3_0F_6F*/ {0x45, 90, 83, 128, 3968, 0x1, 0, 0, 0, 0},
	/*II_0F_70*/ {0x4b, 67, 64, 40, 3977, 0x0, 1, 0, 0, 0},
	/*II_66_0F_70*/ {0x4b, 73, 68, 48, 3985, 0x0, 1, 0, 0, 0},
	/*II_F3_0F_70*/ {0x4b, 73, 68, 48, 3993, 0x0, 1, 0, 0, 0},
	/*II_F2_0F_70*/ {0x4b, 73, 68, 48, 4002, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_70*/ {0x44, 73, 68, 128, 4011, 0x0, 1, 0, 0, 0},
	/*II_NV_F3_0F_70*/ {0x44, 73, 68, 128, 4020, 0x0, 1, 0, 0, 0},
	/*II_NV_F2_0F_70*/ {0x44, 73, 68, 128, 4030, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_74*/ {0x44, 81, 68, 128, 4049, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_75*/ {0x44, 81, 68, 128, 4068, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_76*/ {0x44, 81, 68, 128, 4087, 0x0, 73, 0, 0, 0},
	/*II_NV_0F_77*/ {0x4c, 0, 0, 128, 4103, 0x9, 0, 0, 4115, 0},
	/*II_66_0F_78*/ {0x4e, 7, 69, 88, 4133, 0x0, 8, 0, 0, 0},
	/*II_F2_0F_78*/ {0x4f, 69, 68, 88, 4140, 0x0, 7, 8, 0, 0},
	/*II_V_66_0F_7C*/ {0x44, 88, 83, 128, 4174, 0x1, 90, 0, 0, 0},
	/*II_V_F2_0F_7C*/ {0x44, 88, 83, 128, 4183, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_7D*/ {0x44, 88, 83, 128, 4208, 0x1, 90, 0, 0, 0},
	/*II_V_F2_0F_7D*/ {0x44, 88, 83, 128, 4217, 0x1, 90, 0, 0, 0},
	/*II_0F_7E*/ {0x4a, 64, 18, 32, 3917, 0x0, 0, 0, 3923, 0},
	/*II_66_0F_7E*/ {0x4a, 68, 18, 48, 3917, 0x0, 0, 0, 3923, 0},
	/*II_NV_66_0F_7E*/ {0x45, 68, 79, 128, 3929, 0x6, 0, 0, 3936, 0},
	/*II_NV_F3_0F_7E*/ {0x45, 72, 68, 128, 3936, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_7F*/ {0x45, 83, 90, 128, 3959, 0x1, 0, 0, 0, 0},
	/*II_NV_F3_0F_7F*/ {0x45, 83, 90, 128, 3968, 0x1, 0, 0, 0, 0},
	/*II_0F_AE_05*/ {0x51, 0, 43, 8, 4249, 0x0, 0, 0, 4257, 0},
	/*II_0F_AE_07*/ {0x51, 0, 43, 8, 4273, 0x0, 0, 0, 4281, 0},
	/*II_0F_C2*/ {0x56, 73, 68, 40, 4310, 0x0, 0, 0, 4319, 4328},
	/*II_66_0F_C2*/ {0x56, 73, 68, 48, 4389, 0x0, 0, 0, 4398, 4407},
	/*II_F3_0F_C2*/ {0x56, 71, 68, 40, 4468, 0x0, 0, 0, 4477, 4486},
	/*II_F2_0F_C2*/ {0x56, 72, 68, 48, 4547, 0x0, 0, 0, 4556, 4565},
	/*II_V_0F_C2*/ {0x57, 88, 83, 128, 4626, 0x1, 90, 0, 4636, 4646},
	/*II_V_66_0F_C2*/ {0x57, 88, 83, 128, 4713, 0x1, 90, 0, 4723, 4733},
	/*II_V_F3_0F_C2*/ {0x57, 81, 68, 128, 4800, 0x0, 71, 0, 4810, 4820},
	/*II_V_F2_0F_C2*/ {0x57, 81, 68, 128, 4887, 0x0, 72, 0, 4897, 4907},
	/*II_0F_C4*/ {0x4b, 25, 64, 40, 4974, 0x0, 1, 0, 0, 0},
	/*II_66_0F_C4*/ {0x4b, 25, 68, 48, 4974, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_C4*/ {0x58, 81, 68, 128, 4982, 0x0, 25, 1, 0, 0},
	/*II_0F_C5*/ {0x59, 65, 12, 40, 4991, 0x0, 1, 0, 0, 0},
	/*II_66_0F_C5*/ {0x4b, 69, 12, 48, 4991, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_C5*/ {0x5a, 68, 13, 128, 4999, 0x0, 1, 0, 0, 0},
	/*II_0F_C6*/ {0x4b, 73, 68, 40, 5008, 0x0, 1, 0, 0, 0},
	/*II_66_0F_C6*/ {0x4b, 73, 68, 48, 5016, 0x0, 1, 0, 0, 0},
	/*II_V_0F_C6*/ {0x58, 88, 83, 128, 5024, 0x1, 90, 1, 0, 0},
	/*II_V_66_0F_C6*/ {0x58, 88, 83, 128, 5033, 0x1, 90, 1, 0, 0},
	/*II_0F_C7_01*/ {0x5b, 0, 48, 8, 5042, 0x0, 0, 0, 5053, 0},
	/*II_V_66_0F_D0*/ {0x44, 88, 83, 128, 5094, 0x1, 90, 0, 0, 0},
	/*II_V_F2_0F_D0*/ {0x44, 88, 83, 128, 5105, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_D1*/ {0x44, 81, 68, 128, 5123, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_D2*/ {0x44, 81, 68, 128, 5138, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_D3*/ {0x44, 81, 68, 128, 5153, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_D4*/ {0x44, 81, 68, 128, 5168, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_D5*/ {0x44, 81, 68, 128, 5184, 0x0, 73, 0, 0, 0},
	/*II_NV_66_0F_D6*/ {0x45, 68, 72, 128, 3936, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_D7*/ {0x49, 68, 13, 128, 5221, 0x0, 0, 0, 0, 0},
	/*II_V_66_0F_D8*/ {0x44, 81, 68, 128, 5241, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_D9*/ {0x44, 81, 68, 128, 5260, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DA*/ {0x44, 81, 68, 128, 5278, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DB*/ {0x44, 81, 68, 128, 5293, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DC*/ {0x44, 81, 68, 128, 5309, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DD*/ {0x44, 81, 68, 128, 5309, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DE*/ {0x44, 81, 68, 128, 5336, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_DF*/ {0x44, 81, 68, 128, 5352, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E0*/ {0x44, 81, 68, 128, 5367, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E1*/ {0x44, 81, 68, 128, 5382, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E2*/ {0x44, 81, 68, 128, 5397, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E3*/ {0x44, 81, 68, 128, 5412, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E4*/ {0x44, 81, 68, 128, 5429, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E5*/ {0x44, 81, 68, 128, 5447, 0x0, 73, 0, 0, 0},
	/*II_NV_66_0F_E6*/ {0x45, 90, 68, 128, 5487, 0x1, 0, 0, 0, 0},
	/*II_NV_F3_0F_E6*/ {0x45, 91, 83, 128, 5499, 0x1, 0, 0, 0, 0},
	/*II_NV_F2_0F_E6*/ {0x45, 90, 68, 128, 5510, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_E7*/ {0x45, 83, 92, 128, 5538, 0x1, 0, 0, 0, 0},
	/*II_V_66_0F_E8*/ {0x44, 81, 68, 128, 5556, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_E9*/ {0x44, 81, 68, 128, 5573, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_EA*/ {0x44, 81, 68, 128, 5590, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_EB*/ {0x44, 81, 68, 128, 5604, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_EC*/ {0x44, 81, 68, 128, 5618, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_ED*/ {0x44, 81, 68, 128, 5635, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_EE*/ {0x44, 81, 68, 128, 5652, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_EF*/ {0x44, 81, 68, 128, 5667, 0x0, 73, 0, 0, 0},
	/*II_NV_F2_0F_F0*/ {0x45, 92, 83, 128, 5681, 0x1, 0, 0, 0, 0},
	/*II_V_66_0F_F1*/ {0x44, 81, 68, 128, 5696, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F2*/ {0x44, 81, 68, 128, 5711, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F3*/ {0x44, 81, 68, 128, 5726, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F4*/ {0x44, 81, 68, 128, 5743, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F5*/ {0x44, 81, 68, 128, 5762, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F6*/ {0x44, 81, 68, 128, 5780, 0x0, 73, 0, 0, 0},
	/*II_NV_66_0F_F7*/ {0x5c, 69, 68, 128, 5811, 0x0, 0, 0, 0, 0},
	/*II_V_66_0F_F8*/ {0x44, 81, 68, 128, 5831, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_F9*/ {0x44, 81, 68, 128, 5846, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_FA*/ {0x44, 81, 68, 128, 5861, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_FB*/ {0x44, 81, 68, 128, 5876, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_FC*/ {0x44, 81, 68, 128, 5891, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_FD*/ {0x44, 81, 68, 128, 5906, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_FE*/ {0x44, 81, 68, 128, 5921, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_00*/ {0x44, 81, 68, 128, 6029, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_01*/ {0x44, 81, 68, 128, 6046, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_02*/ {0x44, 81, 68, 128, 6063, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_03*/ {0x44, 81, 68, 128, 6081, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_04*/ {0x44, 81, 68, 128, 6102, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_05*/ {0x44, 81, 68, 128, 6122, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_06*/ {0x44, 81, 68, 128, 6139, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_07*/ {0x44, 81, 68, 128, 6157, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_08*/ {0x44, 81, 68, 128, 6175, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_09*/ {0x44, 81, 68, 128, 6192, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_0A*/ {0x44, 81, 68, 128, 6209, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_0B*/ {0x44, 81, 68, 128, 6228, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_0C*/ {0x44, 88, 83, 128, 6239, 0x1, 90, 0, 0, 0},
	/*II_V_66_0F_38_0D*/ {0x44, 88, 83, 128, 6250, 0x1, 90, 0, 0, 0},
	/*II_NV_66_0F_38_0E*/ {0x45, 90, 83, 128, 6261, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_38_0F*/ {0x45, 90, 83, 128, 6271, 0x1, 0, 0, 0, 0},
	/*II_66_0F_38_10*/ {0x4b, 73, 68, 72, 6281, 0x0, 74, 0, 0, 0},
	/*II_66_0F_38_14*/ {0x4b, 73, 68, 72, 6291, 0x0, 74, 0, 0, 0},
	/*II_66_0F_38_15*/ {0x4b, 73, 68, 72, 6301, 0x0, 74, 0, 0, 0},
	/*II_NV_66_0F_38_17*/ {0x45, 90, 83, 128, 6318, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_38_18*/ {0x45, 44, 83, 128, 6326, 0x1, 0, 0, 0, 0},
	/*II_NV_66_0F_38_19*/ {0x45, 46, 85, 128, 6340, 0x10, 0, 0, 0, 0},
	/*II_NV_66_0F_38_1A*/ {0x45, 47, 85, 128, 6354, 0x10, 0, 0, 0, 0},
	/*II_NV_66_0F_38_1C*/ {0x45, 73, 68, 128, 6377, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_1D*/ {0x45, 73, 68, 128, 6392, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_1E*/ {0x45, 73, 68, 128, 6407, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_20*/ {0x45, 72, 68, 128, 6425, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_21*/ {0x45, 71, 68, 128, 6446, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_22*/ {0x45, 70, 68, 128, 6467, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_23*/ {0x45, 72, 68, 128, 6488, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_24*/ {0x45, 71, 68, 128, 6509, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_25*/ {0x45, 72, 68, 128, 6530, 0x0, 0, 0, 0, 0},
	/*II_V_66_0F_38_28*/ {0x44, 81, 68, 128, 6549, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_29*/ {0x44, 81, 68, 128, 6567, 0x0, 73, 0, 0, 0},
	/*II_NV_66_0F_38_2A*/ {0x45, 47, 68, 128, 6587, 0x0, 0, 0, 0, 0},
	/*II_V_66_0F_38_2B*/ {0x44, 81, 68, 128, 6608, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_2C*/ {0x44, 88, 83, 128, 6619, 0x1, 92, 0, 0, 0},
	/*II_V_66_0F_38_2D*/ {0x44, 88, 83, 128, 6631, 0x1, 92, 0, 0, 0},
	/*II_V_66_0F_38_2E*/ {0x44, 88, 92, 128, 6619, 0x1, 83, 0, 0, 0},
	/*II_V_66_0F_38_2F*/ {0x44, 88, 92, 128, 6631, 0x1, 83, 0, 0, 0},
	/*II_NV_66_0F_38_30*/ {0x45, 72, 68, 128, 6653, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_31*/ {0x45, 71, 68, 128, 6674, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_32*/ {0x45, 70, 68, 128, 6695, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_33*/ {0x45, 72, 68, 128, 6716, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_34*/ {0x45, 71, 68, 128, 6737, 0x0, 0, 0, 0, 0},
	/*II_NV_66_0F_38_35*/ {0x45, 72, 68, 128, 6758, 0x0, 0, 0, 0, 0},
	/*II_V_66_0F_38_37*/ {0x44, 81, 68, 128, 6778, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_38*/ {0x44, 81, 68, 128, 6796, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_39*/ {0x44, 81, 68, 128, 6813, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3A*/ {0x44, 81, 68, 128, 6830, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3B*/ {0x44, 81, 68, 128, 6847, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3C*/ {0x44, 81, 68, 128, 6864, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3D*/ {0x44, 81, 68, 128, 6881, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3E*/ {0x44, 81, 68, 128, 6898, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_3F*/ {0x44, 81, 68, 128, 6915, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_40*/ {0x44, 81, 68, 128, 6932, 0x0, 73, 0, 0, 0},
	/*II_NV_66_0F_38_41*/ {0x45, 73, 68, 128, 6953, 0x0, 0, 0, 0, 0},
	/*II_V_66_0F_38_96*/ {0x44, 88, 83, 136, 6983, 0x7, 90, 0, 6999, 0},
	/*II_V_66_0F_38_97*/ {0x44, 88, 83, 136, 7015, 0x7, 90, 0, 7031, 0},
	/*II_V_66_0F_38_98*/ {0x44, 88, 83, 136, 7047, 0x7, 90, 0, 7060, 0},
	/*II_V_66_0F_38_99*/ {0x44, 81, 68, 136, 7073, 0x6, 80, 0, 7086, 0},
	/*II_V_66_0F_38_9A*/ {0x44, 88, 83, 136, 7099, 0x7, 90, 0, 7112, 0},
	/*II_V_66_0F_38_9B*/ {0x44, 81, 68, 136, 7125, 0x6, 80, 0, 7138, 0},
	/*II_V_66_0F_38_9C*/ {0x44, 88, 83, 136, 7151, 0x7, 90, 0, 7165, 0},
	/*II_V_66_0F_38_9D*/ {0x44, 81, 68, 136, 7179, 0x6, 80, 0, 7193, 0},
	/*II_V_66_0F_38_9E*/ {0x44, 88, 83, 136, 7207, 0x7, 90, 0, 7221, 0},
	/*II_V_66_0F_38_9F*/ {0x44, 81, 68, 136, 7235, 0x6, 80, 0, 7249, 0},
	/*II_V_66_0F_38_A6*/ {0x44, 88, 83, 136, 7263, 0x7, 90, 0, 7279, 0},
	/*II_V_66_0F_38_A7*/ {0x44, 88, 83, 136, 7295, 0x7, 90, 0, 7311, 0},
	/*II_V_66_0F_38_A8*/ {0x44, 88, 83, 136, 7327, 0x7, 90, 0, 7340, 0},
	/*II_V_66_0F_38_A9*/ {0x44, 81, 68, 136, 7353, 0x6, 80, 0, 7366, 0},
	/*II_V_66_0F_38_AA*/ {0x44, 88, 83, 136, 7379, 0x7, 90, 0, 7392, 0},
	/*II_V_66_0F_38_AB*/ {0x44, 81, 68, 136, 7405, 0x6, 80, 0, 7418, 0},
	/*II_V_66_0F_38_AC*/ {0x44, 88, 83, 136, 7431, 0x7, 90, 0, 7445, 0},
	/*II_V_66_0F_38_AD*/ {0x44, 81, 68, 136, 7459, 0x6, 80, 0, 7473, 0},
	/*II_V_66_0F_38_AE*/ {0x44, 88, 83, 136, 7487, 0x7, 90, 0, 7501, 0},
	/*II_V_66_0F_38_AF*/ {0x44, 81, 68, 136, 7515, 0x6, 80, 0, 7529, 0},
	/*II_V_66_0F_38_B6*/ {0x44, 88, 83, 136, 7543, 0x7, 90, 0, 7559, 0},
	/*II_V_66_0F_38_B7*/ {0x44, 88, 83, 136, 7575, 0x7, 90, 0, 7591, 0},
	/*II_V_66_0F_38_B8*/ {0x44, 88, 83, 136, 7607, 0x7, 90, 0, 7620, 0},
	/*II_V_66_0F_38_B9*/ {0x44, 81, 68, 136, 7633, 0x6, 80, 0, 7646, 0},
	/*II_V_66_0F_38_BA*/ {0x44, 88, 83, 136, 7659, 0x7, 90, 0, 7672, 0},
	/*II_V_66_0F_38_BB*/ {0x44, 81, 68, 136, 7685, 0x6, 80, 0, 7698, 0},
	/*II_V_66_0F_38_BC*/ {0x44, 88, 83, 136, 7711, 0x7, 90, 0, 7725, 0},
	/*II_V_66_0F_38_BD*/ {0x44, 81, 68, 136, 7739, 0x6, 80, 0, 7753, 0},
	/*II_V_66_0F_38_BE*/ {0x44, 88, 83, 136, 7767, 0x7, 90, 0, 7781, 0},
	/*II_V_66_0F_38_BF*/ {0x44, 81, 68, 136, 7795, 0x6, 80, 0, 7809, 0},
	/*II_NV_66_0F_38_DB*/ {0x45, 73, 68, 152, 7831, 0x0, 0, 0, 0, 0},
	/*II_V_66_0F_38_DC*/ {0x44, 81, 68, 152, 7848, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_DD*/ {0x44, 81, 68, 152, 7869, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_DE*/ {0x44, 81, 68, 152, 7890, 0x0, 73, 0, 0, 0},
	/*II_V_66_0F_38_DF*/ {0x44, 81, 68, 152, 7911, 0x0, 73, 0, 0, 0},
	/*II_NV_66_0F_3A_04*/ {0x44, 90, 83, 128, 6239, 0x1, 1, 0, 0, 0},
	/*II_NV_66_0F_3A_05*/ {0x44, 90, 83, 128, 6250, 0x1, 1, 0, 0, 0},
	/*II_V_66_0F_3A_06*/ {0x58, 87, 85, 128, 7938, 0x10, 86, 1, 0, 0},
	/*II_66_0F_3A_08*/ {0x4b, 73, 68, 72, 7950, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_3A_08*/ {0x44, 90, 83, 128, 7959, 0x1, 1, 0, 0, 0},
	/*II_66_0F_3A_09*/ {0x4b, 73, 68, 72, 7969, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_3A_09*/ {0x44, 90, 83, 128, 7978, 0x1, 1, 0, 0, 0},
	/*II_66_0F_3A_0A*/ {0x4b, 71, 68, 72, 7988, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0A*/ {0x58, 81, 68, 128, 7997, 0x0, 71, 1, 0, 0},
	/*II_66_0F_3A_0B*/ {0x4b, 72, 68, 72, 8007, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0B*/ {0x58, 81, 68, 128, 8016, 0x0, 72, 1, 0, 0},
	/*II_66_0F_3A_0C*/ {0x4b, 73, 68, 72, 8026, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0C*/ {0x58, 88, 83, 128, 8035, 0x1, 90, 1, 0, 0},
	/*II_66_0F_3A_0D*/ {0x4b, 73, 68, 72, 8045, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0D*/ {0x58, 88, 83, 128, 8054, 0x1, 90, 1, 0, 0},
	/*II_66_0F_3A_0E*/ {0x4b, 73, 68, 72, 8064, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0E*/ {0x58, 81, 68, 128, 8073, 0x0, 73, 1, 0, 0},
	/*II_0F_3A_0F*/ {0x4b, 67, 64, 64, 8084, 0x0, 1, 0, 0, 0},
	/*II_66_0F_3A_0F*/ {0x4b, 73, 68, 64, 8084, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_0F*/ {0x58, 81, 68, 128, 8093, 0x0, 73, 1, 0, 0},
	/*II_66_0F_3A_14*/ {0x4b, 68, 26, 72, 8103, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_3A_14*/ {0x5a, 68, 76, 128, 8111, 0x0, 1, 0, 0, 0},
	/*II_66_0F_3A_15*/ {0x4b, 68, 27, 72, 4991, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_3A_15*/ {0x5a, 68, 77, 128, 4999, 0x0, 1, 0, 0, 0},
	/*II_66_0F_3A_16*/ {0x5f, 68, 18, 72, 8120, 0x0, 1, 0, 8128, 0},
	/*II_NV_66_0F_3A_16*/ {0x44, 68, 79, 128, 8136, 0x2, 1, 0, 0, 0},
	/*II_66_0F_3A_17*/ {0x4b, 68, 18, 72, 8145, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_3A_17*/ {0x44, 68, 75, 128, 8156, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_18*/ {0x58, 87, 85, 128, 8168, 0x10, 73, 1, 0, 0},
	/*II_NV_66_0F_3A_19*/ {0x44, 85, 73, 128, 8181, 0x10, 1, 0, 0, 0},
	/*II_66_0F_3A_20*/ {0x4b, 24, 68, 72, 8195, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_20*/ {0x58, 81, 68, 128, 8203, 0x0, 76, 1, 0, 0},
	/*II_66_0F_3A_21*/ {0x4b, 71, 68, 72, 8212, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_21*/ {0x58, 81, 68, 128, 8222, 0x0, 71, 1, 0, 0},
	/*II_66_0F_3A_22*/ {0x5f, 18, 68, 72, 8233, 0x0, 1, 0, 8241, 0},
	/*II_V_66_0F_3A_22*/ {0x58, 81, 68, 128, 8249, 0x6, 79, 1, 8258, 0},
	/*II_66_0F_3A_40*/ {0x4b, 73, 68, 72, 8267, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_40*/ {0x58, 88, 83, 128, 8273, 0x1, 90, 1, 0, 0},
	/*II_66_0F_3A_41*/ {0x4b, 73, 68, 72, 8280, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_41*/ {0x58, 81, 68, 128, 8286, 0x0, 73, 1, 0, 0},
	/*II_66_0F_3A_42*/ {0x4b, 73, 68, 72, 8293, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_42*/ {0x58, 81, 68, 128, 8302, 0x0, 73, 1, 0, 0},
	/*II_66_0F_3A_44*/ {0x4b, 73, 68, 144, 8312, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_3A_44*/ {0x58, 81, 68, 144, 8323, 0x0, 73, 1, 0, 0},
	/*II_V_66_0F_3A_4A*/ {0x58, 88, 83, 128, 8335, 0x1, 90, 84, 0, 0},
	/*II_V_66_0F_3A_4B*/ {0x58, 88, 83, 128, 8346, 0x1, 90, 84, 0, 0},
	/*II_V_66_0F_3A_4C*/ {0x58, 81, 68, 128, 8357, 0x0, 73, 82, 0, 0},
	/*II_66_0F_3A_60*/ {0x4b, 73, 68, 80, 8368, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_3A_60*/ {0x44, 73, 68, 128, 8379, 0x0, 1, 0, 0, 0},
	/*II_66_0F_3A_61*/ {0x4b, 73, 68, 80, 8391, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_3A_61*/ {0x44, 73, 68, 128, 8402, 0x0, 1, 0, 0, 0},
	/*II_66_0F_3A_62*/ {0x4b, 73, 68, 80, 8413, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_3A_62*/ {0x44, 73, 68, 128, 8424, 0x0, 1, 0, 0, 0},
	/*II_66_0F_3A_63*/ {0x4b, 73, 68, 80, 8436, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_3A_63*/ {0x44, 73, 68, 128, 8447, 0x0, 1, 0, 0, 0},
	/*II_66_0F_3A_DF*/ {0x4b, 73, 68, 152, 8459, 0x0, 1, 0, 0, 0},
	/*II_NV_66_0F_3A_DF*/ {0x44, 73, 68, 152, 8476, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_71_02*/ {0x60, 69, 81, 128, 5123, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_71_04*/ {0x60, 69, 81, 128, 5382, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_71_06*/ {0x60, 69, 81, 128, 5696, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_72_02*/ {0x60, 69, 81, 128, 5138, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_72_04*/ {0x60, 69, 81, 128, 5397, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_72_06*/ {0x60, 69, 81, 128, 5711, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_02*/ {0x60, 69, 81, 128, 5153, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_03*/ {0x60, 69, 81, 128, 8502, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_06*/ {0x60, 69, 81, 128, 5726, 0x0, 1, 0, 0, 0},
	/*II_V_66_0F_73_07*/ {0x60, 69, 81, 128, 8519, 0x0, 1, 0, 0, 0},
	/*II_NV_0F_AE_02*/ {0x61, 0, 44, 128, 8537, 0x0, 0, 0, 0, 0},
	/*II_NV_0F_AE_03*/ {0x61, 0, 44, 128, 8556, 0x0, 0, 0, 0, 0}
};

_InstNode InstructionsTree[] = {
/* 0 - _00 */  0x2000,
/* 1 - _01 */  0x2001,
/* 2 - _02 */  0x2002,
/* 3 - _03 */  0x2003,
/* 4 - _04 */  0x2004,
/* 5 - _05 */  0x2005,
/* 6 - _06 */  0x2006,
/* 7 - _07 */  0x2007,
/* 8 - _08 */  0x2008,
/* 9 - _09 */  0x2009,
/* a - _0A */  0x200a,
/* b - _0B */  0x200b,
/* c - _0C */  0x200c,
/* d - _0D */  0x200d,
/* e - _0E */  0x200e,
/* f - _0F */  0x8100,
/* 10 - _10 */  0x200f,
/* 11 - _11 */  0x2010,
/* 12 - _12 */  0x2011,
/* 13 - _13 */  0x2012,
/* 14 - _14 */  0x2013,
/* 15 - _15 */  0x2014,
/* 16 - _16 */  0x2015,
/* 17 - _17 */  0x2016,
/* 18 - _18 */  0x2017,
/* 19 - _19 */  0x2018,
/* 1a - _1A */  0x2019,
/* 1b - _1B */  0x201a,
/* 1c - _1C */  0x201b,
/* 1d - _1D */  0x201c,
/* 1e - _1E */  0x201d,
/* 1f - _1F */  0x201e,
/* 20 - _20 */  0x201f,
/* 21 - _21 */  0x2020,
/* 22 - _22 */  0x2021,
/* 23 - _23 */  0x2022,
/* 24 - _24 */  0x2023,
/* 25 - _25 */  0x2024,
/* 26 -  */  0,
/* 27 - _27 */  0x2025,
/* 28 - _28 */  0x2026,
/* 29 - _29 */  0x2027,
/* 2a - _2A */  0x2028,
/* 2b - _2B */  0x2029,
/* 2c - _2C */  0x202a,
/* 2d - _2D */  0x202b,
/* 2e -  */  0,
/* 2f - _2F */  0x202c,
/* 30 - _30 */  0x202d,
/* 31 - _31 */  0x202e,
/* 32 - _32 */  0x202f,
/* 33 - _33 */  0x2030,
/* 34 - _34 */  0x2031,
/* 35 - _35 */  0x2032,
/* 36 -  */  0,
/* 37 - _37 */  0x2033,
/* 38 - _38 */  0x2034,
/* 39 - _39 */  0x2035,
/* 3a - _3A */  0x2036,
/* 3b - _3B */  0x2037,
/* 3c - _3C */  0x2038,
/* 3d - _3D */  0x2039,
/* 3e -  */  0,
/* 3f - _3F */  0x203a,
/* 40 - _40 */  0x203b,
/* 41 - _40 */  0x203c,
/* 42 - _40 */  0x203d,
/* 43 - _40 */  0x203e,
/* 44 - _40 */  0x203f,
/* 45 - _40 */  0x2040,
/* 46 - _40 */  0x2041,
/* 47 - _40 */  0x2042,
/* 48 - _48 */  0x2043,
/* 49 - _48 */  0x2044,
/* 4a - _48 */  0x2045,
/* 4b - _48 */  0x2046,
/* 4c - _48 */  0x2047,
/* 4d - _48 */  0x2048,
/* 4e - _48 */  0x2049,
/* 4f - _48 */  0x204a,
/* 50 - _50 */  0x204b,
/* 51 - _50 */  0x204c,
/* 52 - _50 */  0x204d,
/* 53 - _50 */  0x204e,
/* 54 - _50 */  0x204f,
/* 55 - _50 */  0x2050,
/* 56 - _50 */  0x2051,
/* 57 - _50 */  0x2052,
/* 58 - _58 */  0x2053,
/* 59 - _58 */  0x2054,
/* 5a - _58 */  0x2055,
/* 5b - _58 */  0x2056,
/* 5c - _58 */  0x2057,
/* 5d - _58 */  0x2058,
/* 5e - _58 */  0x2059,
/* 5f - _58 */  0x205a,
/* 60 - _60 */  0x205b,
/* 61 - _61 */  0x205c,
/* 62 - _62 */  0x205d,
/* 63 - _63 */  0x205e,
/* 64 -  */  0,
/* 65 -  */  0,
/* 66 -  */  0,
/* 67 -  */  0,
/* 68 - _68 */  0x205f,
/* 69 - _69 */  0x4000,
/* 6a - _6A */  0x2060,
/* 6b - _6B */  0x4001,
/* 6c - _6C */  0x2061,
/* 6d - _6D */  0x2062,
/* 6e - _6E */  0x2063,
/* 6f - _6F */  0x2064,
/* 70 - _70 */  0x2065,
/* 71 - _71 */  0x2066,
/* 72 - _72 */  0x2067,
/* 73 - _73 */  0x2068,
/* 74 - _74 */  0x2069,
/* 75 - _75 */  0x206a,
/* 76 - _76 */  0x206b,
/* 77 - _77 */  0x206c,
/* 78 - _78 */  0x206d,
/* 79 - _79 */  0x206e,
/* 7a - _7A */  0x206f,
/* 7b - _7B */  0x2070,
/* 7c - _7C */  0x2071,
/* 7d - _7D */  0x2072,
/* 7e - _7E */  0x2073,
/* 7f - _7F */  0x2074,
/* 80 - _80 */  0x6200,
/* 81 - _81 */  0x6208,
/* 82 - _82 */  0x6210,
/* 83 - _83 */  0x6218,
/* 84 - _84 */  0x2075,
/* 85 - _85 */  0x2076,
/* 86 - _86 */  0x2077,
/* 87 - _87 */  0x2078,
/* 88 - _88 */  0x2079,
/* 89 - _89 */  0x207a,
/* 8a - _8A */  0x207b,
/* 8b - _8B */  0x207c,
/* 8c - _8C */  0x207d,
/* 8d - _8D */  0x207e,
/* 8e - _8E */  0x207f,
/* 8f - _8F */  0x6220,
/* 90 - _90 */  0x2080,
/* 91 - _91 */  0x2081,
/* 92 - _92 */  0x2082,
/* 93 - _93 */  0x2083,
/* 94 - _94 */  0x2084,
/* 95 - _95 */  0x2085,
/* 96 - _96 */  0x2086,
/* 97 - _97 */  0x2087,
/* 98 - _98 */  0x4002,
/* 99 - _99 */  0x4003,
/* 9a - _9A */  0x2088,
/* 9b -  */  0,
/* 9c - _9C */  0x2089,
/* 9d - _9D */  0x208a,
/* 9e - _9E */  0x208b,
/* 9f - _9F */  0x208c,
/* a0 - _A0 */  0x208d,
/* a1 - _A1 */  0x208e,
/* a2 - _A2 */  0x208f,
/* a3 - _A3 */  0x2090,
/* a4 - _A4 */  0x2091,
/* a5 - _A5 */  0x2092,
/* a6 - _A6 */  0x2093,
/* a7 - _A7 */  0x2094,
/* a8 - _A8 */  0x2095,
/* a9 - _A9 */  0x2096,
/* aa - _AA */  0x2097,
/* ab - _AB */  0x2098,
/* ac - _AC */  0x2099,
/* ad - _AD */  0x209a,
/* ae - _AE */  0x209b,
/* af - _AF */  0x209c,
/* b0 - _B0 */  0x209d,
/* b1 - _B0 */  0x209e,
/* b2 - _B0 */  0x209f,
/* b3 - _B0 */  0x20a0,
/* b4 - _B0 */  0x20a1,
/* b5 - _B0 */  0x20a2,
/* b6 - _B0 */  0x20a3,
/* b7 - _B0 */  0x20a4,
/* b8 - _B8 */  0x20a5,
/* b9 - _B8 */  0x20a6,
/* ba - _B8 */  0x20a7,
/* bb - _B8 */  0x20a8,
/* bc - _B8 */  0x20a9,
/* bd - _B8 */  0x20aa,
/* be - _B8 */  0x20ab,
/* bf - _B8 */  0x20ac,
/* c0 - _C0 */  0x6228,
/* c1 - _C1 */  0x6230,
/* c2 - _C2 */  0x20ad,
/* c3 - _C3 */  0x20ae,
/* c4 - _C4 */  0x20af,
/* c5 - _C5 */  0x20b0,
/* c6 - _C6 */  0x6238,
/* c7 - _C7 */  0x6240,
/* c8 - _C8 */  0x20b1,
/* c9 - _C9 */  0x20b2,
/* ca - _CA */  0x20b3,
/* cb - _CB */  0x20b4,
/* cc - _CC */  0x20b5,
/* cd - _CD */  0x20b6,
/* ce - _CE */  0x20b7,
/* cf - _CF */  0x20b8,
/* d0 - _D0 */  0x6248,
/* d1 - _D1 */  0x6250,
/* d2 - _D2 */  0x6258,
/* d3 - _D3 */  0x6260,
/* d4 - _D4 */  0x20b9,
/* d5 - _D5 */  0x20ba,
/* d6 - _D6 */  0x20bb,
/* d7 - _D7 */  0x20bc,
/* d8 - _D8 */  0xa268,
/* d9 - _D9 */  0xa2b0,
/* da - _DA */  0xa2f8,
/* db - _DB */  0xa340,
/* dc - _DC */  0xa388,
/* dd - _DD */  0xa3d0,
/* de - _DE */  0xa418,
/* df - _DF */  0xa460,
/* e0 - _E0 */  0x20bd,
/* e1 - _E1 */  0x20be,
/* e2 - _E2 */  0x20bf,
/* e3 - _E3 */  0x4004,
/* e4 - _E4 */  0x20c0,
/* e5 - _E5 */  0x20c1,
/* e6 - _E6 */  0x20c2,
/* e7 - _E7 */  0x20c3,
/* e8 - _E8 */  0x20c4,
/* e9 - _E9 */  0x20c5,
/* ea - _EA */  0x20c6,
/* eb - _EB */  0x20c7,
/* ec - _EC */  0x20c8,
/* ed - _ED */  0x20c9,
/* ee - _EE */  0x20ca,
/* ef - _EF */  0x20cb,
/* f0 -  */  0,
/* f1 - _F1 */  0x20cc,
/* f2 -  */  0,
/* f3 -  */  0,
/* f4 - _F4 */  0x20cd,
/* f5 - _F5 */  0x20ce,
/* f6 - _F6 */  0x64a8,
/* f7 - _F7 */  0x64b0,
/* f8 - _F8 */  0x20cf,
/* f9 - _F9 */  0x20d0,
/* fa - _FA */  0x20d1,
/* fb - _FB */  0x20d2,
/* fc - _FC */  0x20d3,
/* fd - _FD */  0x20d4,
/* fe - _FE */  0x64b8,
/* ff - _FF */  0x64c0,
/* 100 - _0F_00 */  0x64c8,
/* 101 - _0F_01 */  0xa4d0,
/* 102 - _0F_02 */  0x20d5,
/* 103 - _0F_03 */  0x20d6,
/* 104 -  */  0,
/* 105 - _0F_05 */  0x20d7,
/* 106 - _0F_06 */  0x20d8,
/* 107 - _0F_07 */  0x20d9,
/* 108 - _0F_08 */  0x20da,
/* 109 - _0F_09 */  0x20db,
/* 10a -  */  0,
/* 10b - _0F_0B */  0x20dc,
/* 10c -  */  0,
/* 10d - _0F_0D */  0x6518,
/* 10e - _0F_0E */  0x20dd,
/* 10f - _0F_0F */  0x8520,
/* 110 - _0F_10 */  0xc620,
/* 111 - _0F_11 */  0xc62c,
/* 112 - _0F_12 */  0xc638,
/* 113 - _0F_13 */  0xc644,
/* 114 - _0F_14 */  0xc650,
/* 115 - _0F_15 */  0xc65c,
/* 116 - _0F_16 */  0xc668,
/* 117 - _0F_17 */  0xc674,
/* 118 - _0F_18 */  0x6680,
/* 119 -  */  0,
/* 11a -  */  0,
/* 11b -  */  0,
/* 11c -  */  0,
/* 11d -  */  0,
/* 11e -  */  0,
/* 11f - _0F_1F */  0x20de,
/* 120 - _0F_20 */  0x20df,
/* 121 - _0F_21 */  0x20e0,
/* 122 - _0F_22 */  0x20e1,
/* 123 - _0F_23 */  0x20e2,
/* 124 -  */  0,
/* 125 -  */  0,
/* 126 -  */  0,
/* 127 -  */  0,
/* 128 - _0F_28 */  0xc688,
/* 129 - _0F_29 */  0xc694,
/* 12a - _0F_2A */  0xc6a0,
/* 12b - _0F_2B */  0xc6ac,
/* 12c - _0F_2C */  0xc6b8,
/* 12d - _0F_2D */  0xc6c4,
/* 12e - _0F_2E */  0xc6d0,
/* 12f - _0F_2F */  0xc6dc,
/* 130 - _0F_30 */  0x20e3,
/* 131 - _0F_31 */  0x20e4,
/* 132 - _0F_32 */  0x20e5,
/* 133 - _0F_33 */  0x20e6,
/* 134 - _0F_34 */  0x20e7,
/* 135 - _0F_35 */  0x20e8,
/* 136 -  */  0,
/* 137 - _0F_37 */  0x20e9,
/* 138 - _0F_38 */  0x86e8,
/* 139 -  */  0,
/* 13a - _0F_3A */  0x87e8,
/* 13b -  */  0,
/* 13c -  */  0,
/* 13d -  */  0,
/* 13e -  */  0,
/* 13f -  */  0,
/* 140 - _0F_40 */  0x20ea,
/* 141 - _0F_41 */  0x20eb,
/* 142 - _0F_42 */  0x20ec,
/* 143 - _0F_43 */  0x20ed,
/* 144 - _0F_44 */  0x20ee,
/* 145 - _0F_45 */  0x20ef,
/* 146 - _0F_46 */  0x20f0,
/* 147 - _0F_47 */  0x20f1,
/* 148 - _0F_48 */  0x20f2,
/* 149 - _0F_49 */  0x20f3,
/* 14a - _0F_4A */  0x20f4,
/* 14b - _0F_4B */  0x20f5,
/* 14c - _0F_4C */  0x20f6,
/* 14d - _0F_4D */  0x20f7,
/* 14e - _0F_4E */  0x20f8,
/* 14f - _0F_4F */  0x20f9,
/* 150 - _0F_50 */  0xc8e8,
/* 151 - _0F_51 */  0xc8f4,
/* 152 - _0F_52 */  0xc900,
/* 153 - _0F_53 */  0xc90c,
/* 154 - _0F_54 */  0xc918,
/* 155 - _0F_55 */  0xc924,
/* 156 - _0F_56 */  0xc930,
/* 157 - _0F_57 */  0xc93c,
/* 158 - _0F_58 */  0xc948,
/* 159 - _0F_59 */  0xc954,
/* 15a - _0F_5A */  0xc960,
/* 15b - _0F_5B */  0xc96c,
/* 15c - _0F_5C */  0xc978,
/* 15d - _0F_5D */  0xc984,
/* 15e - _0F_5E */  0xc990,
/* 15f - _0F_5F */  0xc99c,
/* 160 - _0F_60 */  0xc9a8,
/* 161 - _0F_61 */  0xc9b4,
/* 162 - _0F_62 */  0xc9c0,
/* 163 - _0F_63 */  0xc9cc,
/* 164 - _0F_64 */  0xc9d8,
/* 165 - _0F_65 */  0xc9e4,
/* 166 - _0F_66 */  0xc9f0,
/* 167 - _0F_67 */  0xc9fc,
/* 168 - _0F_68 */  0xca08,
/* 169 - _0F_69 */  0xca14,
/* 16a - _0F_6A */  0xca20,
/* 16b - _0F_6B */  0xca2c,
/* 16c - _0F_6C */  0xca38,
/* 16d - _0F_6D */  0xca44,
/* 16e - _0F_6E */  0xca50,
/* 16f - _0F_6F */  0xca5c,
/* 170 - _0F_70 */  0xca68,
/* 171 - _0F_71 */  0x6a74,
/* 172 - _0F_72 */  0x6a7c,
/* 173 - _0F_73 */  0x6a84,
/* 174 - _0F_74 */  0xca8c,
/* 175 - _0F_75 */  0xca98,
/* 176 - _0F_76 */  0xcaa4,
/* 177 - _0F_77 */  0xcab0,
/* 178 - _0F_78 */  0xcabc,
/* 179 - _0F_79 */  0xcac8,
/* 17a -  */  0,
/* 17b -  */  0,
/* 17c - _0F_7C */  0xcad4,
/* 17d - _0F_7D */  0xcae0,
/* 17e - _0F_7E */  0xcaec,
/* 17f - _0F_7F */  0xcaf8,
/* 180 - _0F_80 */  0x20fa,
/* 181 - _0F_81 */  0x20fb,
/* 182 - _0F_82 */  0x20fc,
/* 183 - _0F_83 */  0x20fd,
/* 184 - _0F_84 */  0x20fe,
/* 185 - _0F_85 */  0x20ff,
/* 186 - _0F_86 */  0x2100,
/* 187 - _0F_87 */  0x2101,
/* 188 - _0F_88 */  0x2102,
/* 189 - _0F_89 */  0x2103,
/* 18a - _0F_8A */  0x2104,
/* 18b - _0F_8B */  0x2105,
/* 18c - _0F_8C */  0x2106,
/* 18d - _0F_8D */  0x2107,
/* 18e - _0F_8E */  0x2108,
/* 18f - _0F_8F */  0x2109,
/* 190 - _0F_90 */  0x210a,
/* 191 - _0F_91 */  0x210b,
/* 192 - _0F_92 */  0x210c,
/* 193 - _0F_93 */  0x210d,
/* 194 - _0F_94 */  0x210e,
/* 195 - _0F_95 */  0x210f,
/* 196 - _0F_96 */  0x2110,
/* 197 - _0F_97 */  0x2111,
/* 198 - _0F_98 */  0x2112,
/* 199 - _0F_99 */  0x2113,
/* 19a - _0F_9A */  0x2114,
/* 19b - _0F_9B */  0x2115,
/* 19c - _0F_9C */  0x2116,
/* 19d - _0F_9D */  0x2117,
/* 19e - _0F_9E */  0x2118,
/* 19f - _0F_9F */  0x2119,
/* 1a0 - _0F_A0 */  0x211a,
/* 1a1 - _0F_A1 */  0x211b,
/* 1a2 - _0F_A2 */  0x211c,
/* 1a3 - _0F_A3 */  0x211d,
/* 1a4 - _0F_A4 */  0x4005,
/* 1a5 - _0F_A5 */  0x4006,
/* 1a6 -  */  0,
/* 1a7 -  */  0,
/* 1a8 - _0F_A8 */  0x211e,
/* 1a9 - _0F_A9 */  0x211f,
/* 1aa - _0F_AA */  0x2120,
/* 1ab - _0F_AB */  0x2121,
/* 1ac - _0F_AC */  0x4007,
/* 1ad - _0F_AD */  0x4008,
/* 1ae - _0F_AE */  0x6b04,
/* 1af - _0F_AF */  0x2122,
/* 1b0 - _0F_B0 */  0x2123,
/* 1b1 - _0F_B1 */  0x2124,
/* 1b2 - _0F_B2 */  0x2125,
/* 1b3 - _0F_B3 */  0x2126,
/* 1b4 - _0F_B4 */  0x2127,
/* 1b5 - _0F_B5 */  0x2128,
/* 1b6 - _0F_B6 */  0x2129,
/* 1b7 - _0F_B7 */  0x212a,
/* 1b8 - _0F_B8 */  0xcb0c,
/* 1b9 - _0F_B9 */  0x212b,
/* 1ba - _0F_BA */  0x6b18,
/* 1bb - _0F_BB */  0x212c,
/* 1bc - _0F_BC */  0x212d,
/* 1bd - _0F_BD */  0xcb20,
/* 1be - _0F_BE */  0x212e,
/* 1bf - _0F_BF */  0x212f,
/* 1c0 - _0F_C0 */  0x2130,
/* 1c1 - _0F_C1 */  0x2131,
/* 1c2 - _0F_C2 */  0xcb2c,
/* 1c3 - _0F_C3 */  0x2132,
/* 1c4 - _0F_C4 */  0xcb38,
/* 1c5 - _0F_C5 */  0xcb44,
/* 1c6 - _0F_C6 */  0xcb50,
/* 1c7 - _0F_C7 */  0x6b5c,
/* 1c8 - _0F_C8 */  0x2133,
/* 1c9 - _0F_C8 */  0x2134,
/* 1ca - _0F_C8 */  0x2135,
/* 1cb - _0F_C8 */  0x2136,
/* 1cc - _0F_C8 */  0x2137,
/* 1cd - _0F_C8 */  0x2138,
/* 1ce - _0F_C8 */  0x2139,
/* 1cf - _0F_C8 */  0x213a,
/* 1d0 - _0F_D0 */  0xcb64,
/* 1d1 - _0F_D1 */  0xcb70,
/* 1d2 - _0F_D2 */  0xcb7c,
/* 1d3 - _0F_D3 */  0xcb88,
/* 1d4 - _0F_D4 */  0xcb94,
/* 1d5 - _0F_D5 */  0xcba0,
/* 1d6 - _0F_D6 */  0xcbac,
/* 1d7 - _0F_D7 */  0xcbb8,
/* 1d8 - _0F_D8 */  0xcbc4,
/* 1d9 - _0F_D9 */  0xcbd0,
/* 1da - _0F_DA */  0xcbdc,
/* 1db - _0F_DB */  0xcbe8,
/* 1dc - _0F_DC */  0xcbf4,
/* 1dd - _0F_DD */  0xcc00,
/* 1de - _0F_DE */  0xcc0c,
/* 1df - _0F_DF */  0xcc18,
/* 1e0 - _0F_E0 */  0xcc24,
/* 1e1 - _0F_E1 */  0xcc30,
/* 1e2 - _0F_E2 */  0xcc3c,
/* 1e3 - _0F_E3 */  0xcc48,
/* 1e4 - _0F_E4 */  0xcc54,
/* 1e5 - _0F_E5 */  0xcc60,
/* 1e6 - _0F_E6 */  0xcc6c,
/* 1e7 - _0F_E7 */  0xcc78,
/* 1e8 - _0F_E8 */  0xcc84,
/* 1e9 - _0F_E9 */  0xcc90,
/* 1ea - _0F_EA */  0xcc9c,
/* 1eb - _0F_EB */  0xcca8,
/* 1ec - _0F_EC */  0xccb4,
/* 1ed - _0F_ED */  0xccc0,
/* 1ee - _0F_EE */  0xcccc,
/* 1ef - _0F_EF */  0xccd8,
/* 1f0 - _0F_F0 */  0xcce4,
/* 1f1 - _0F_F1 */  0xccf0,
/* 1f2 - _0F_F2 */  0xccfc,
/* 1f3 - _0F_F3 */  0xcd08,
/* 1f4 - _0F_F4 */  0xcd14,
/* 1f5 - _0F_F5 */  0xcd20,
/* 1f6 - _0F_F6 */  0xcd2c,
/* 1f7 - _0F_F7 */  0xcd38,
/* 1f8 - _0F_F8 */  0xcd44,
/* 1f9 - _0F_F9 */  0xcd50,
/* 1fa - _0F_FA */  0xcd5c,
/* 1fb - _0F_FB */  0xcd68,
/* 1fc - _0F_FC */  0xcd74,
/* 1fd - _0F_FD */  0xcd80,
/* 1fe - _0F_FE */  0xcd8c,
/* 1ff -  */  0,
/* 200 - _80_00 */  0x213b,
/* 201 - _80_01 */  0x213c,
/* 202 - _80_02 */  0x213d,
/* 203 - _80_03 */  0x213e,
/* 204 - _80_04 */  0x213f,
/* 205 - _80_05 */  0x2140,
/* 206 - _80_06 */  0x2141,
/* 207 - _80_07 */  0x2142,
/* 208 - _81_00 */  0x2143,
/* 209 - _81_01 */  0x2144,
/* 20a - _81_02 */  0x2145,
/* 20b - _81_03 */  0x2146,
/* 20c - _81_04 */  0x2147,
/* 20d - _81_05 */  0x2148,
/* 20e - _81_06 */  0x2149,
/* 20f - _81_07 */  0x214a,
/* 210 - _82_00 */  0x214b,
/* 211 - _82_01 */  0x214c,
/* 212 - _82_02 */  0x214d,
/* 213 - _82_03 */  0x214e,
/* 214 - _82_04 */  0x214f,
/* 215 - _82_05 */  0x2150,
/* 216 - _82_06 */  0x2151,
/* 217 - _82_07 */  0x2152,
/* 218 - _83_00 */  0x2153,
/* 219 - _83_01 */  0x2154,
/* 21a - _83_02 */  0x2155,
/* 21b - _83_03 */  0x2156,
/* 21c - _83_04 */  0x2157,
/* 21d - _83_05 */  0x2158,
/* 21e - _83_06 */  0x2159,
/* 21f - _83_07 */  0x215a,
/* 220 - _8F_00 */  0x215b,
/* 221 -  */  0,
/* 222 -  */  0,
/* 223 -  */  0,
/* 224 -  */  0,
/* 225 -  */  0,
/* 226 -  */  0,
/* 227 -  */  0,
/* 228 - _C0_00 */  0x215c,
/* 229 - _C0_01 */  0x215d,
/* 22a - _C0_02 */  0x215e,
/* 22b - _C0_03 */  0x215f,
/* 22c - _C0_04 */  0x2160,
/* 22d - _C0_05 */  0x2161,
/* 22e - _C0_06 */  0x2162,
/* 22f - _C0_07 */  0x2163,
/* 230 - _C1_00 */  0x2164,
/* 231 - _C1_01 */  0x2165,
/* 232 - _C1_02 */  0x2166,
/* 233 - _C1_03 */  0x2167,
/* 234 - _C1_04 */  0x2168,
/* 235 - _C1_05 */  0x2169,
/* 236 - _C1_06 */  0x216a,
/* 237 - _C1_07 */  0x216b,
/* 238 - _C6_00 */  0x216c,
/* 239 -  */  0,
/* 23a -  */  0,
/* 23b -  */  0,
/* 23c -  */  0,
/* 23d -  */  0,
/* 23e -  */  0,
/* 23f -  */  0,
/* 240 - _C7_00 */  0x216d,
/* 241 -  */  0,
/* 242 -  */  0,
/* 243 -  */  0,
/* 244 -  */  0,
/* 245 -  */  0,
/* 246 -  */  0,
/* 247 -  */  0,
/* 248 - _D0_00 */  0x216e,
/* 249 - _D0_01 */  0x216f,
/* 24a - _D0_02 */  0x2170,
/* 24b - _D0_03 */  0x2171,
/* 24c - _D0_04 */  0x2172,
/* 24d - _D0_05 */  0x2173,
/* 24e - _D0_06 */  0x2174,
/* 24f - _D0_07 */  0x2175,
/* 250 - _D1_00 */  0x2176,
/* 251 - _D1_01 */  0x2177,
/* 252 - _D1_02 */  0x2178,
/* 253 - _D1_03 */  0x2179,
/* 254 - _D1_04 */  0x217a,
/* 255 - _D1_05 */  0x217b,
/* 256 - _D1_06 */  0x217c,
/* 257 - _D1_07 */  0x217d,
/* 258 - _D2_00 */  0x217e,
/* 259 - _D2_01 */  0x217f,
/* 25a - _D2_02 */  0x2180,
/* 25b - _D2_03 */  0x2181,
/* 25c - _D2_04 */  0x2182,
/* 25d - _D2_05 */  0x2183,
/* 25e - _D2_06 */  0x2184,
/* 25f - _D2_07 */  0x2185,
/* 260 - _D3_00 */  0x2186,
/* 261 - _D3_01 */  0x2187,
/* 262 - _D3_02 */  0x2188,
/* 263 - _D3_03 */  0x2189,
/* 264 - _D3_04 */  0x218a,
/* 265 - _D3_05 */  0x218b,
/* 266 - _D3_06 */  0x218c,
/* 267 - _D3_07 */  0x218d,
/* 268 - _D8_00 */  0x218e,
/* 269 - _D8_01 */  0x218f,
/* 26a - _D8_02 */  0x2190,
/* 26b - _D8_03 */  0x2191,
/* 26c - _D8_04 */  0x2192,
/* 26d - _D8_05 */  0x2193,
/* 26e - _D8_06 */  0x2194,
/* 26f - _D8_07 */  0x2195,
/* 270 - _D8_C0 */  0x2196,
/* 271 - _D8_C0 */  0x2197,
/* 272 - _D8_C0 */  0x2198,
/* 273 - _D8_C0 */  0x2199,
/* 274 - _D8_C0 */  0x219a,
/* 275 - _D8_C0 */  0x219b,
/* 276 - _D8_C0 */  0x219c,
/* 277 - _D8_C0 */  0x219d,
/* 278 - _D8_C8 */  0x219e,
/* 279 - _D8_C8 */  0x219f,
/* 27a - _D8_C8 */  0x21a0,
/* 27b - _D8_C8 */  0x21a1,
/* 27c - _D8_C8 */  0x21a2,
/* 27d - _D8_C8 */  0x21a3,
/* 27e - _D8_C8 */  0x21a4,
/* 27f - _D8_C8 */  0x21a5,
/* 280 - _D8_D0 */  0x21a6,
/* 281 - _D8_D0 */  0x21a7,
/* 282 - _D8_D0 */  0x21a8,
/* 283 - _D8_D0 */  0x21a9,
/* 284 - _D8_D0 */  0x21aa,
/* 285 - _D8_D0 */  0x21ab,
/* 286 - _D8_D0 */  0x21ac,
/* 287 - _D8_D0 */  0x21ad,
/* 288 - _D8_D8 */  0x21ae,
/* 289 - _D8_D9 */  0x21af,
/* 28a - _D8_D8 */  0x21b0,
/* 28b - _D8_D8 */  0x21b1,
/* 28c - _D8_D8 */  0x21b2,
/* 28d - _D8_D8 */  0x21b3,
/* 28e - _D8_D8 */  0x21b4,
/* 28f - _D8_D8 */  0x21b5,
/* 290 - _D8_E0 */  0x21b6,
/* 291 - _D8_E0 */  0x21b7,
/* 292 - _D8_E0 */  0x21b8,
/* 293 - _D8_E0 */  0x21b9,
/* 294 - _D8_E0 */  0x21ba,
/* 295 - _D8_E0 */  0x21bb,
/* 296 - _D8_E0 */  0x21bc,
/* 297 - _D8_E0 */  0x21bd,
/* 298 - _D8_E8 */  0x21be,
/* 299 - _D8_E8 */  0x21bf,
/* 29a - _D8_E8 */  0x21c0,
/* 29b - _D8_E8 */  0x21c1,
/* 29c - _D8_E8 */  0x21c2,
/* 29d - _D8_E8 */  0x21c3,
/* 29e - _D8_E8 */  0x21c4,
/* 29f - _D8_E8 */  0x21c5,
/* 2a0 - _D8_F0 */  0x21c6,
/* 2a1 - _D8_F0 */  0x21c7,
/* 2a2 - _D8_F0 */  0x21c8,
/* 2a3 - _D8_F0 */  0x21c9,
/* 2a4 - _D8_F0 */  0x21ca,
/* 2a5 - _D8_F0 */  0x21cb,
/* 2a6 - _D8_F0 */  0x21cc,
/* 2a7 - _D8_F0 */  0x21cd,
/* 2a8 - _D8_F8 */  0x21ce,
/* 2a9 - _D8_F8 */  0x21cf,
/* 2aa - _D8_F8 */  0x21d0,
/* 2ab - _D8_F8 */  0x21d1,
/* 2ac - _D8_F8 */  0x21d2,
/* 2ad - _D8_F8 */  0x21d3,
/* 2ae - _D8_F8 */  0x21d4,
/* 2af - _D8_F8 */  0x21d5,
/* 2b0 - _D9_00 */  0x21d6,
/* 2b1 -  */  0,
/* 2b2 - _D9_02 */  0x21d7,
/* 2b3 - _D9_03 */  0x21d8,
/* 2b4 - _D9_04 */  0x21d9,
/* 2b5 - _D9_05 */  0x21da,
/* 2b6 - _D9_06 */  0xcd98,
/* 2b7 - _D9_07 */  0xcda4,
/* 2b8 - _D9_C0 */  0x21db,
/* 2b9 - _D9_C0 */  0x21dc,
/* 2ba - _D9_C0 */  0x21dd,
/* 2bb - _D9_C0 */  0x21de,
/* 2bc - _D9_C0 */  0x21df,
/* 2bd - _D9_C0 */  0x21e0,
/* 2be - _D9_C0 */  0x21e1,
/* 2bf - _D9_C0 */  0x21e2,
/* 2c0 - _D9_C8 */  0x21e3,
/* 2c1 - _D9_C9 */  0x21e4,
/* 2c2 - _D9_C8 */  0x21e5,
/* 2c3 - _D9_C8 */  0x21e6,
/* 2c4 - _D9_C8 */  0x21e7,
/* 2c5 - _D9_C8 */  0x21e8,
/* 2c6 - _D9_C8 */  0x21e9,
/* 2c7 - _D9_C8 */  0x21ea,
/* 2c8 - _D9_D0 */  0x21eb,
/* 2c9 -  */  0,
/* 2ca -  */  0,
/* 2cb -  */  0,
/* 2cc -  */  0,
/* 2cd -  */  0,
/* 2ce -  */  0,
/* 2cf -  */  0,
/* 2d0 -  */  0,
/* 2d1 -  */  0,
/* 2d2 -  */  0,
/* 2d3 -  */  0,
/* 2d4 -  */  0,
/* 2d5 -  */  0,
/* 2d6 -  */  0,
/* 2d7 -  */  0,
/* 2d8 - _D9_E0 */  0x21ec,
/* 2d9 - _D9_E1 */  0x21ed,
/* 2da -  */  0,
/* 2db -  */  0,
/* 2dc - _D9_E4 */  0x21ee,
/* 2dd - _D9_E5 */  0x21ef,
/* 2de -  */  0,
/* 2df -  */  0,
/* 2e0 - _D9_E8 */  0x21f0,
/* 2e1 - _D9_E9 */  0x21f1,
/* 2e2 - _D9_EA */  0x21f2,
/* 2e3 - _D9_EB */  0x21f3,
/* 2e4 - _D9_EC */  0x21f4,
/* 2e5 - _D9_ED */  0x21f5,
/* 2e6 - _D9_EE */  0x21f6,
/* 2e7 -  */  0,
/* 2e8 - _D9_F0 */  0x21f7,
/* 2e9 - _D9_F1 */  0x21f8,
/* 2ea - _D9_F2 */  0x21f9,
/* 2eb - _D9_F3 */  0x21fa,
/* 2ec - _D9_F4 */  0x21fb,
/* 2ed - _D9_F5 */  0x21fc,
/* 2ee - _D9_F6 */  0x21fd,
/* 2ef - _D9_F7 */  0x21fe,
/* 2f0 - _D9_F8 */  0x21ff,
/* 2f1 - _D9_F9 */  0x2200,
/* 2f2 - _D9_FA */  0x2201,
/* 2f3 - _D9_FB */  0x2202,
/* 2f4 - _D9_FC */  0x2203,
/* 2f5 - _D9_FD */  0x2204,
/* 2f6 - _D9_FE */  0x2205,
/* 2f7 - _D9_FF */  0x2206,
/* 2f8 - _DA_00 */  0x2207,
/* 2f9 - _DA_01 */  0x2208,
/* 2fa - _DA_02 */  0x2209,
/* 2fb - _DA_03 */  0x220a,
/* 2fc - _DA_04 */  0x220b,
/* 2fd - _DA_05 */  0x220c,
/* 2fe - _DA_06 */  0x220d,
/* 2ff - _DA_07 */  0x220e,
/* 300 - _DA_C0 */  0x220f,
/* 301 - _DA_C0 */  0x2210,
/* 302 - _DA_C0 */  0x2211,
/* 303 - _DA_C0 */  0x2212,
/* 304 - _DA_C0 */  0x2213,
/* 305 - _DA_C0 */  0x2214,
/* 306 - _DA_C0 */  0x2215,
/* 307 - _DA_C0 */  0x2216,
/* 308 - _DA_C8 */  0x2217,
/* 309 - _DA_C8 */  0x2218,
/* 30a - _DA_C8 */  0x2219,
/* 30b - _DA_C8 */  0x221a,
/* 30c - _DA_C8 */  0x221b,
/* 30d - _DA_C8 */  0x221c,
/* 30e - _DA_C8 */  0x221d,
/* 30f - _DA_C8 */  0x221e,
/* 310 - _DA_D0 */  0x221f,
/* 311 - _DA_D0 */  0x2220,
/* 312 - _DA_D0 */  0x2221,
/* 313 - _DA_D0 */  0x2222,
/* 314 - _DA_D0 */  0x2223,
/* 315 - _DA_D0 */  0x2224,
/* 316 - _DA_D0 */  0x2225,
/* 317 - _DA_D0 */  0x2226,
/* 318 - _DA_D8 */  0x2227,
/* 319 - _DA_D8 */  0x2228,
/* 31a - _DA_D8 */  0x2229,
/* 31b - _DA_D8 */  0x222a,
/* 31c - _DA_D8 */  0x222b,
/* 31d - _DA_D8 */  0x222c,
/* 31e - _DA_D8 */  0x222d,
/* 31f - _DA_D8 */  0x222e,
/* 320 -  */  0,
/* 321 -  */  0,
/* 322 -  */  0,
/* 323 -  */  0,
/* 324 -  */  0,
/* 325 -  */  0,
/* 326 -  */  0,
/* 327 -  */  0,
/* 328 -  */  0,
/* 329 - _DA_E9 */  0x222f,
/* 32a -  */  0,
/* 32b -  */  0,
/* 32c -  */  0,
/* 32d -  */  0,
/* 32e -  */  0,
/* 32f -  */  0,
/* 330 -  */  0,
/* 331 -  */  0,
/* 332 -  */  0,
/* 333 -  */  0,
/* 334 -  */  0,
/* 335 -  */  0,
/* 336 -  */  0,
/* 337 -  */  0,
/* 338 -  */  0,
/* 339 -  */  0,
/* 33a -  */  0,
/* 33b -  */  0,
/* 33c -  */  0,
/* 33d -  */  0,
/* 33e -  */  0,
/* 33f -  */  0,
/* 340 - _DB_00 */  0x2230,
/* 341 - _DB_01 */  0x2231,
/* 342 - _DB_02 */  0x2232,
/* 343 - _DB_03 */  0x2233,
/* 344 -  */  0,
/* 345 - _DB_05 */  0x2234,
/* 346 -  */  0,
/* 347 - _DB_07 */  0x2235,
/* 348 - _DB_C0 */  0x2236,
/* 349 - _DB_C0 */  0x2237,
/* 34a - _DB_C0 */  0x2238,
/* 34b - _DB_C0 */  0x2239,
/* 34c - _DB_C0 */  0x223a,
/* 34d - _DB_C0 */  0x223b,
/* 34e - _DB_C0 */  0x223c,
/* 34f - _DB_C0 */  0x223d,
/* 350 - _DB_C8 */  0x223e,
/* 351 - _DB_C8 */  0x223f,
/* 352 - _DB_C8 */  0x2240,
/* 353 - _DB_C8 */  0x2241,
/* 354 - _DB_C8 */  0x2242,
/* 355 - _DB_C8 */  0x2243,
/* 356 - _DB_C8 */  0x2244,
/* 357 - _DB_C8 */  0x2245,
/* 358 - _DB_D0 */  0x2246,
/* 359 - _DB_D0 */  0x2247,
/* 35a - _DB_D0 */  0x2248,
/* 35b - _DB_D0 */  0x2249,
/* 35c - _DB_D0 */  0x224a,
/* 35d - _DB_D0 */  0x224b,
/* 35e - _DB_D0 */  0x224c,
/* 35f - _DB_D0 */  0x224d,
/* 360 - _DB_D8 */  0x224e,
/* 361 - _DB_D8 */  0x224f,
/* 362 - _DB_D8 */  0x2250,
/* 363 - _DB_D8 */  0x2251,
/* 364 - _DB_D8 */  0x2252,
/* 365 - _DB_D8 */  0x2253,
/* 366 - _DB_D8 */  0x2254,
/* 367 - _DB_D8 */  0x2255,
/* 368 - _DB_E0 */  0x2256,
/* 369 - _DB_E1 */  0x2257,
/* 36a - _DB_E2 */  0xcdb0,
/* 36b - _DB_E3 */  0xcdbc,
/* 36c - _DB_E4 */  0x2258,
/* 36d -  */  0,
/* 36e -  */  0,
/* 36f -  */  0,
/* 370 - _DB_E8 */  0x2259,
/* 371 - _DB_E8 */  0x225a,
/* 372 - _DB_E8 */  0x225b,
/* 373 - _DB_E8 */  0x225c,
/* 374 - _DB_E8 */  0x225d,
/* 375 - _DB_E8 */  0x225e,
/* 376 - _DB_E8 */  0x225f,
/* 377 - _DB_E8 */  0x2260,
/* 378 - _DB_F0 */  0x2261,
/* 379 - _DB_F0 */  0x2262,
/* 37a - _DB_F0 */  0x2263,
/* 37b - _DB_F0 */  0x2264,
/* 37c - _DB_F0 */  0x2265,
/* 37d - _DB_F0 */  0x2266,
/* 37e - _DB_F0 */  0x2267,
/* 37f - _DB_F0 */  0x2268,
/* 380 -  */  0,
/* 381 -  */  0,
/* 382 -  */  0,
/* 383 -  */  0,
/* 384 -  */  0,
/* 385 -  */  0,
/* 386 -  */  0,
/* 387 -  */  0,
/* 388 - _DC_00 */  0x2269,
/* 389 - _DC_01 */  0x226a,
/* 38a - _DC_02 */  0x226b,
/* 38b - _DC_03 */  0x226c,
/* 38c - _DC_04 */  0x226d,
/* 38d - _DC_05 */  0x226e,
/* 38e - _DC_06 */  0x226f,
/* 38f - _DC_07 */  0x2270,
/* 390 - _DC_C0 */  0x2271,
/* 391 - _DC_C0 */  0x2272,
/* 392 - _DC_C0 */  0x2273,
/* 393 - _DC_C0 */  0x2274,
/* 394 - _DC_C0 */  0x2275,
/* 395 - _DC_C0 */  0x2276,
/* 396 - _DC_C0 */  0x2277,
/* 397 - _DC_C0 */  0x2278,
/* 398 - _DC_C8 */  0x2279,
/* 399 - _DC_C8 */  0x227a,
/* 39a - _DC_C8 */  0x227b,
/* 39b - _DC_C8 */  0x227c,
/* 39c - _DC_C8 */  0x227d,
/* 39d - _DC_C8 */  0x227e,
/* 39e - _DC_C8 */  0x227f,
/* 39f - _DC_C8 */  0x2280,
/* 3a0 -  */  0,
/* 3a1 -  */  0,
/* 3a2 -  */  0,
/* 3a3 -  */  0,
/* 3a4 -  */  0,
/* 3a5 -  */  0,
/* 3a6 -  */  0,
/* 3a7 -  */  0,
/* 3a8 -  */  0,
/* 3a9 -  */  0,
/* 3aa -  */  0,
/* 3ab -  */  0,
/* 3ac -  */  0,
/* 3ad -  */  0,
/* 3ae -  */  0,
/* 3af -  */  0,
/* 3b0 - _DC_E0 */  0x2281,
/* 3b1 - _DC_E0 */  0x2282,
/* 3b2 - _DC_E0 */  0x2283,
/* 3b3 - _DC_E0 */  0x2284,
/* 3b4 - _DC_E0 */  0x2285,
/* 3b5 - _DC_E0 */  0x2286,
/* 3b6 - _DC_E0 */  0x2287,
/* 3b7 - _DC_E0 */  0x2288,
/* 3b8 - _DC_E8 */  0x2289,
/* 3b9 - _DC_E8 */  0x228a,
/* 3ba - _DC_E8 */  0x228b,
/* 3bb - _DC_E8 */  0x228c,
/* 3bc - _DC_E8 */  0x228d,
/* 3bd - _DC_E8 */  0x228e,
/* 3be - _DC_E8 */  0x228f,
/* 3bf - _DC_E8 */  0x2290,
/* 3c0 - _DC_F0 */  0x2291,
/* 3c1 - _DC_F0 */  0x2292,
/* 3c2 - _DC_F0 */  0x2293,
/* 3c3 - _DC_F0 */  0x2294,
/* 3c4 - _DC_F0 */  0x2295,
/* 3c5 - _DC_F0 */  0x2296,
/* 3c6 - _DC_F0 */  0x2297,
/* 3c7 - _DC_F0 */  0x2298,
/* 3c8 - _DC_F8 */  0x2299,
/* 3c9 - _DC_F8 */  0x229a,
/* 3ca - _DC_F8 */  0x229b,
/* 3cb - _DC_F8 */  0x229c,
/* 3cc - _DC_F8 */  0x229d,
/* 3cd - _DC_F8 */  0x229e,
/* 3ce - _DC_F8 */  0x229f,
/* 3cf - _DC_F8 */  0x22a0,
/* 3d0 - _DD_00 */  0x22a1,
/* 3d1 - _DD_01 */  0x22a2,
/* 3d2 - _DD_02 */  0x22a3,
/* 3d3 - _DD_03 */  0x22a4,
/* 3d4 - _DD_04 */  0x22a5,
/* 3d5 -  */  0,
/* 3d6 - _DD_06 */  0xcdc8,
/* 3d7 - _DD_07 */  0xcdd4,
/* 3d8 - _DD_C0 */  0x22a6,
/* 3d9 - _DD_C0 */  0x22a7,
/* 3da - _DD_C0 */  0x22a8,
/* 3db - _DD_C0 */  0x22a9,
/* 3dc - _DD_C0 */  0x22aa,
/* 3dd - _DD_C0 */  0x22ab,
/* 3de - _DD_C0 */  0x22ac,
/* 3df - _DD_C0 */  0x22ad,
/* 3e0 -  */  0,
/* 3e1 -  */  0,
/* 3e2 -  */  0,
/* 3e3 -  */  0,
/* 3e4 -  */  0,
/* 3e5 -  */  0,
/* 3e6 -  */  0,
/* 3e7 -  */  0,
/* 3e8 - _DD_D0 */  0x22ae,
/* 3e9 - _DD_D0 */  0x22af,
/* 3ea - _DD_D0 */  0x22b0,
/* 3eb - _DD_D0 */  0x22b1,
/* 3ec - _DD_D0 */  0x22b2,
/* 3ed - _DD_D0 */  0x22b3,
/* 3ee - _DD_D0 */  0x22b4,
/* 3ef - _DD_D0 */  0x22b5,
/* 3f0 - _DD_D8 */  0x22b6,
/* 3f1 - _DD_D8 */  0x22b7,
/* 3f2 - _DD_D8 */  0x22b8,
/* 3f3 - _DD_D8 */  0x22b9,
/* 3f4 - _DD_D8 */  0x22ba,
/* 3f5 - _DD_D8 */  0x22bb,
/* 3f6 - _DD_D8 */  0x22bc,
/* 3f7 - _DD_D8 */  0x22bd,
/* 3f8 - _DD_E0 */  0x22be,
/* 3f9 - _DD_E1 */  0x22bf,
/* 3fa - _DD_E0 */  0x22c0,
/* 3fb - _DD_E0 */  0x22c1,
/* 3fc - _DD_E0 */  0x22c2,
/* 3fd - _DD_E0 */  0x22c3,
/* 3fe - _DD_E0 */  0x22c4,
/* 3ff - _DD_E0 */  0x22c5,
/* 400 - _DD_E8 */  0x22c6,
/* 401 - _DD_E9 */  0x22c7,
/* 402 - _DD_E8 */  0x22c8,
/* 403 - _DD_E8 */  0x22c9,
/* 404 - _DD_E8 */  0x22ca,
/* 405 - _DD_E8 */  0x22cb,
/* 406 - _DD_E8 */  0x22cc,
/* 407 - _DD_E8 */  0x22cd,
/* 408 -  */  0,
/* 409 -  */  0,
/* 40a -  */  0,
/* 40b -  */  0,
/* 40c -  */  0,
/* 40d -  */  0,
/* 40e -  */  0,
/* 40f -  */  0,
/* 410 -  */  0,
/* 411 -  */  0,
/* 412 -  */  0,
/* 413 -  */  0,
/* 414 -  */  0,
/* 415 -  */  0,
/* 416 -  */  0,
/* 417 -  */  0,
/* 418 - _DE_00 */  0x22ce,
/* 419 - _DE_01 */  0x22cf,
/* 41a - _DE_02 */  0x22d0,
/* 41b - _DE_03 */  0x22d1,
/* 41c - _DE_04 */  0x22d2,
/* 41d - _DE_05 */  0x22d3,
/* 41e - _DE_06 */  0x22d4,
/* 41f - _DE_07 */  0x22d5,
/* 420 - _DE_C0 */  0x22d6,
/* 421 - _DE_C1 */  0x22d7,
/* 422 - _DE_C0 */  0x22d8,
/* 423 - _DE_C0 */  0x22d9,
/* 424 - _DE_C0 */  0x22da,
/* 425 - _DE_C0 */  0x22db,
/* 426 - _DE_C0 */  0x22dc,
/* 427 - _DE_C0 */  0x22dd,
/* 428 - _DE_C8 */  0x22de,
/* 429 - _DE_C9 */  0x22df,
/* 42a - _DE_C8 */  0x22e0,
/* 42b - _DE_C8 */  0x22e1,
/* 42c - _DE_C8 */  0x22e2,
/* 42d - _DE_C8 */  0x22e3,
/* 42e - _DE_C8 */  0x22e4,
/* 42f - _DE_C8 */  0x22e5,
/* 430 -  */  0,
/* 431 -  */  0,
/* 432 -  */  0,
/* 433 -  */  0,
/* 434 -  */  0,
/* 435 -  */  0,
/* 436 -  */  0,
/* 437 -  */  0,
/* 438 -  */  0,
/* 439 - _DE_D9 */  0x22e6,
/* 43a -  */  0,
/* 43b -  */  0,
/* 43c -  */  0,
/* 43d -  */  0,
/* 43e -  */  0,
/* 43f -  */  0,
/* 440 - _DE_E0 */  0x22e7,
/* 441 - _DE_E1 */  0x22e8,
/* 442 - _DE_E0 */  0x22e9,
/* 443 - _DE_E0 */  0x22ea,
/* 444 - _DE_E0 */  0x22eb,
/* 445 - _DE_E0 */  0x22ec,
/* 446 - _DE_E0 */  0x22ed,
/* 447 - _DE_E0 */  0x22ee,
/* 448 - _DE_E8 */  0x22ef,
/* 449 - _DE_E9 */  0x22f0,
/* 44a - _DE_E8 */  0x22f1,
/* 44b - _DE_E8 */  0x22f2,
/* 44c - _DE_E8 */  0x22f3,
/* 44d - _DE_E8 */  0x22f4,
/* 44e - _DE_E8 */  0x22f5,
/* 44f - _DE_E8 */  0x22f6,
/* 450 - _DE_F0 */  0x22f7,
/* 451 - _DE_F1 */  0x22f8,
/* 452 - _DE_F0 */  0x22f9,
/* 453 - _DE_F0 */  0x22fa,
/* 454 - _DE_F0 */  0x22fb,
/* 455 - _DE_F0 */  0x22fc,
/* 456 - _DE_F0 */  0x22fd,
/* 457 - _DE_F0 */  0x22fe,
/* 458 - _DE_F8 */  0x22ff,
/* 459 - _DE_F9 */  0x2300,
/* 45a - _DE_F8 */  0x2301,
/* 45b - _DE_F8 */  0x2302,
/* 45c - _DE_F8 */  0x2303,
/* 45d - _DE_F8 */  0x2304,
/* 45e - _DE_F8 */  0x2305,
/* 45f - _DE_F8 */  0x2306,
/* 460 - _DF_00 */  0x2307,
/* 461 - _DF_01 */  0x2308,
/* 462 - _DF_02 */  0x2309,
/* 463 - _DF_03 */  0x230a,
/* 464 - _DF_04 */  0x230b,
/* 465 - _DF_05 */  0x230c,
/* 466 - _DF_06 */  0x230d,
/* 467 - _DF_07 */  0x230e,
/* 468 -  */  0,
/* 469 -  */  0,
/* 46a -  */  0,
/* 46b -  */  0,
/* 46c -  */  0,
/* 46d -  */  0,
/* 46e -  */  0,
/* 46f -  */  0,
/* 470 -  */  0,
/* 471 -  */  0,
/* 472 -  */  0,
/* 473 -  */  0,
/* 474 -  */  0,
/* 475 -  */  0,
/* 476 -  */  0,
/* 477 -  */  0,
/* 478 -  */  0,
/* 479 -  */  0,
/* 47a -  */  0,
/* 47b -  */  0,
/* 47c -  */  0,
/* 47d -  */  0,
/* 47e -  */  0,
/* 47f -  */  0,
/* 480 -  */  0,
/* 481 -  */  0,
/* 482 -  */  0,
/* 483 -  */  0,
/* 484 -  */  0,
/* 485 -  */  0,
/* 486 -  */  0,
/* 487 -  */  0,
/* 488 - _DF_E0 */  0xcde0,
/* 489 -  */  0,
/* 48a -  */  0,
/* 48b -  */  0,
/* 48c -  */  0,
/* 48d -  */  0,
/* 48e -  */  0,
/* 48f -  */  0,
/* 490 - _DF_E8 */  0x230f,
/* 491 - _DF_E8 */  0x2310,
/* 492 - _DF_E8 */  0x2311,
/* 493 - _DF_E8 */  0x2312,
/* 494 - _DF_E8 */  0x2313,
/* 495 - _DF_E8 */  0x2314,
/* 496 - _DF_E8 */  0x2315,
/* 497 - _DF_E8 */  0x2316,
/* 498 - _DF_F0 */  0x2317,
/* 499 - _DF_F0 */  0x2318,
/* 49a - _DF_F0 */  0x2319,
/* 49b - _DF_F0 */  0x231a,
/* 49c - _DF_F0 */  0x231b,
/* 49d - _DF_F0 */  0x231c,
/* 49e - _DF_F0 */  0x231d,
/* 49f - _DF_F0 */  0x231e,
/* 4a0 -  */  0,
/* 4a1 -  */  0,
/* 4a2 -  */  0,
/* 4a3 -  */  0,
/* 4a4 -  */  0,
/* 4a5 -  */  0,
/* 4a6 -  */  0,
/* 4a7 -  */  0,
/* 4a8 - _F6_00 */  0x231f,
/* 4a9 -  */  0,
/* 4aa - _F6_02 */  0x2320,
/* 4ab - _F6_03 */  0x2321,
/* 4ac - _F6_04 */  0x2322,
/* 4ad - _F6_05 */  0x2323,
/* 4ae - _F6_06 */  0x2324,
/* 4af - _F6_07 */  0x2325,
/* 4b0 - _F7_00 */  0x2326,
/* 4b1 -  */  0,
/* 4b2 - _F7_02 */  0x2327,
/* 4b3 - _F7_03 */  0x2328,
/* 4b4 - _F7_04 */  0x2329,
/* 4b5 - _F7_05 */  0x232a,
/* 4b6 - _F7_06 */  0x232b,
/* 4b7 - _F7_07 */  0x232c,
/* 4b8 - _FE_00 */  0x232d,
/* 4b9 - _FE_01 */  0x232e,
/* 4ba -  */  0,
/* 4bb -  */  0,
/* 4bc -  */  0,
/* 4bd -  */  0,
/* 4be -  */  0,
/* 4bf -  */  0,
/* 4c0 - _FF_00 */  0x232f,
/* 4c1 - _FF_01 */  0x2330,
/* 4c2 - _FF_02 */  0x2331,
/* 4c3 - _FF_03 */  0x2332,
/* 4c4 - _FF_04 */  0x2333,
/* 4c5 - _FF_05 */  0x2334,
/* 4c6 - _FF_06 */  0x2335,
/* 4c7 -  */  0,
/* 4c8 - _0F_00_00 */  0x2336,
/* 4c9 - _0F_00_01 */  0x2337,
/* 4ca - _0F_00_02 */  0x2338,
/* 4cb - _0F_00_03 */  0x2339,
/* 4cc - _0F_00_04 */  0x233a,
/* 4cd - _0F_00_05 */  0x233b,
/* 4ce -  */  0,
/* 4cf -  */  0,
/* 4d0 - _0F_01_00 */  0x233c,
/* 4d1 - _0F_01_01 */  0x233d,
/* 4d2 - _0F_01_02 */  0x233e,
/* 4d3 - _0F_01_03 */  0x233f,
/* 4d4 - _0F_01_04 */  0x2340,
/* 4d5 -  */  0,
/* 4d6 - _0F_01_06 */  0x2341,
/* 4d7 - _0F_01_07 */  0x2342,
/* 4d8 -  */  0,
/* 4d9 - _0F_01_C1 */  0x2343,
/* 4da - _0F_01_C2 */  0x2344,
/* 4db - _0F_01_C3 */  0x2345,
/* 4dc - _0F_01_C4 */  0x2346,
/* 4dd -  */  0,
/* 4de -  */  0,
/* 4df -  */  0,
/* 4e0 - _0F_01_C8 */  0x2347,
/* 4e1 - _0F_01_C9 */  0x2348,
/* 4e2 -  */  0,
/* 4e3 -  */  0,
/* 4e4 -  */  0,
/* 4e5 -  */  0,
/* 4e6 -  */  0,
/* 4e7 -  */  0,
/* 4e8 - _0F_01_D0 */  0x2349,
/* 4e9 - _0F_01_D1 */  0x234a,
/* 4ea -  */  0,
/* 4eb -  */  0,
/* 4ec -  */  0,
/* 4ed -  */  0,
/* 4ee -  */  0,
/* 4ef -  */  0,
/* 4f0 - _0F_01_D8 */  0x234b,
/* 4f1 - _0F_01_D9 */  0x234c,
/* 4f2 - _0F_01_DA */  0x234d,
/* 4f3 - _0F_01_DB */  0x234e,
/* 4f4 - _0F_01_DC */  0x234f,
/* 4f5 - _0F_01_DD */  0x2350,
/* 4f6 - _0F_01_DE */  0x2351,
/* 4f7 - _0F_01_DF */  0x2352,
/* 4f8 -  */  0,
/* 4f9 -  */  0,
/* 4fa -  */  0,
/* 4fb -  */  0,
/* 4fc -  */  0,
/* 4fd -  */  0,
/* 4fe -  */  0,
/* 4ff -  */  0,
/* 500 -  */  0,
/* 501 -  */  0,
/* 502 -  */  0,
/* 503 -  */  0,
/* 504 -  */  0,
/* 505 -  */  0,
/* 506 -  */  0,
/* 507 -  */  0,
/* 508 -  */  0,
/* 509 -  */  0,
/* 50a -  */  0,
/* 50b -  */  0,
/* 50c -  */  0,
/* 50d -  */  0,
/* 50e -  */  0,
/* 50f -  */  0,
/* 510 - _0F_01_F8 */  0x2353,
/* 511 - _0F_01_F9 */  0x2354,
/* 512 -  */  0,
/* 513 -  */  0,
/* 514 -  */  0,
/* 515 -  */  0,
/* 516 -  */  0,
/* 517 -  */  0,
/* 518 - _0F_0D_00 */  0x2355,
/* 519 - _0F_0D_01 */  0x2356,
/* 51a -  */  0,
/* 51b -  */  0,
/* 51c -  */  0,
/* 51d -  */  0,
/* 51e -  */  0,
/* 51f -  */  0,
/* 520 -  */  0,
/* 521 -  */  0,
/* 522 -  */  0,
/* 523 -  */  0,
/* 524 -  */  0,
/* 525 -  */  0,
/* 526 -  */  0,
/* 527 -  */  0,
/* 528 -  */  0,
/* 529 -  */  0,
/* 52a -  */  0,
/* 52b -  */  0,
/* 52c - _0F_0F_0C */  0x2357,
/* 52d - _0F_0F_0D */  0x2358,
/* 52e -  */  0,
/* 52f -  */  0,
/* 530 -  */  0,
/* 531 -  */  0,
/* 532 -  */  0,
/* 533 -  */  0,
/* 534 -  */  0,
/* 535 -  */  0,
/* 536 -  */  0,
/* 537 -  */  0,
/* 538 -  */  0,
/* 539 -  */  0,
/* 53a -  */  0,
/* 53b -  */  0,
/* 53c - _0F_0F_1C */  0x2359,
/* 53d - _0F_0F_1D */  0x235a,
/* 53e -  */  0,
/* 53f -  */  0,
/* 540 -  */  0,
/* 541 -  */  0,
/* 542 -  */  0,
/* 543 -  */  0,
/* 544 -  */  0,
/* 545 -  */  0,
/* 546 -  */  0,
/* 547 -  */  0,
/* 548 -  */  0,
/* 549 -  */  0,
/* 54a -  */  0,
/* 54b -  */  0,
/* 54c -  */  0,
/* 54d -  */  0,
/* 54e -  */  0,
/* 54f -  */  0,
/* 550 -  */  0,
/* 551 -  */  0,
/* 552 -  */  0,
/* 553 -  */  0,
/* 554 -  */  0,
/* 555 -  */  0,
/* 556 -  */  0,
/* 557 -  */  0,
/* 558 -  */  0,
/* 559 -  */  0,
/* 55a -  */  0,
/* 55b -  */  0,
/* 55c -  */  0,
/* 55d -  */  0,
/* 55e -  */  0,
/* 55f -  */  0,
/* 560 -  */  0,
/* 561 -  */  0,
/* 562 -  */  0,
/* 563 -  */  0,
/* 564 -  */  0,
/* 565 -  */  0,
/* 566 -  */  0,
/* 567 -  */  0,
/* 568 -  */  0,
/* 569 -  */  0,
/* 56a -  */  0,
/* 56b -  */  0,
/* 56c -  */  0,
/* 56d -  */  0,
/* 56e -  */  0,
/* 56f -  */  0,
/* 570 -  */  0,
/* 571 -  */  0,
/* 572 -  */  0,
/* 573 -  */  0,
/* 574 -  */  0,
/* 575 -  */  0,
/* 576 -  */  0,
/* 577 -  */  0,
/* 578 -  */  0,
/* 579 -  */  0,
/* 57a -  */  0,
/* 57b -  */  0,
/* 57c -  */  0,
/* 57d -  */  0,
/* 57e -  */  0,
/* 57f -  */  0,
/* 580 -  */  0,
/* 581 -  */  0,
/* 582 -  */  0,
/* 583 -  */  0,
/* 584 -  */  0,
/* 585 -  */  0,
/* 586 -  */  0,
/* 587 -  */  0,
/* 588 -  */  0,
/* 589 -  */  0,
/* 58a -  */  0,
/* 58b -  */  0,
/* 58c -  */  0,
/* 58d -  */  0,
/* 58e -  */  0,
/* 58f -  */  0,
/* 590 -  */  0,
/* 591 -  */  0,
/* 592 -  */  0,
/* 593 -  */  0,
/* 594 -  */  0,
/* 595 -  */  0,
/* 596 -  */  0,
/* 597 -  */  0,
/* 598 -  */  0,
/* 599 -  */  0,
/* 59a -  */  0,
/* 59b -  */  0,
/* 59c -  */  0,
/* 59d -  */  0,
/* 59e -  */  0,
/* 59f -  */  0,
/* 5a0 -  */  0,
/* 5a1 -  */  0,
/* 5a2 -  */  0,
/* 5a3 -  */  0,
/* 5a4 -  */  0,
/* 5a5 -  */  0,
/* 5a6 -  */  0,
/* 5a7 -  */  0,
/* 5a8 -  */  0,
/* 5a9 -  */  0,
/* 5aa - _0F_0F_8A */  0x235b,
/* 5ab -  */  0,
/* 5ac -  */  0,
/* 5ad -  */  0,
/* 5ae - _0F_0F_8E */  0x235c,
/* 5af -  */  0,
/* 5b0 - _0F_0F_90 */  0x235d,
/* 5b1 -  */  0,
/* 5b2 -  */  0,
/* 5b3 -  */  0,
/* 5b4 - _0F_0F_94 */  0x235e,
/* 5b5 -  */  0,
/* 5b6 - _0F_0F_96 */  0x235f,
/* 5b7 - _0F_0F_97 */  0x2360,
/* 5b8 -  */  0,
/* 5b9 -  */  0,
/* 5ba - _0F_0F_9A */  0x2361,
/* 5bb -  */  0,
/* 5bc -  */  0,
/* 5bd -  */  0,
/* 5be - _0F_0F_9E */  0x2362,
/* 5bf -  */  0,
/* 5c0 - _0F_0F_A0 */  0x2363,
/* 5c1 -  */  0,
/* 5c2 -  */  0,
/* 5c3 -  */  0,
/* 5c4 - _0F_0F_A4 */  0x2364,
/* 5c5 -  */  0,
/* 5c6 - _0F_0F_A6 */  0x2365,
/* 5c7 - _0F_0F_A7 */  0x2366,
/* 5c8 -  */  0,
/* 5c9 -  */  0,
/* 5ca - _0F_0F_AA */  0x2367,
/* 5cb -  */  0,
/* 5cc -  */  0,
/* 5cd -  */  0,
/* 5ce - _0F_0F_AE */  0x2368,
/* 5cf -  */  0,
/* 5d0 - _0F_0F_B0 */  0x2369,
/* 5d1 -  */  0,
/* 5d2 -  */  0,
/* 5d3 -  */  0,
/* 5d4 - _0F_0F_B4 */  0x236a,
/* 5d5 -  */  0,
/* 5d6 - _0F_0F_B6 */  0x236b,
/* 5d7 - _0F_0F_B7 */  0x236c,
/* 5d8 -  */  0,
/* 5d9 -  */  0,
/* 5da -  */  0,
/* 5db - _0F_0F_BB */  0x236d,
/* 5dc -  */  0,
/* 5dd -  */  0,
/* 5de -  */  0,
/* 5df - _0F_0F_BF */  0x236e,
/* 5e0 -  */  0,
/* 5e1 -  */  0,
/* 5e2 -  */  0,
/* 5e3 -  */  0,
/* 5e4 -  */  0,
/* 5e5 -  */  0,
/* 5e6 -  */  0,
/* 5e7 -  */  0,
/* 5e8 -  */  0,
/* 5e9 -  */  0,
/* 5ea -  */  0,
/* 5eb -  */  0,
/* 5ec -  */  0,
/* 5ed -  */  0,
/* 5ee -  */  0,
/* 5ef -  */  0,
/* 5f0 -  */  0,
/* 5f1 -  */  0,
/* 5f2 -  */  0,
/* 5f3 -  */  0,
/* 5f4 -  */  0,
/* 5f5 -  */  0,
/* 5f6 -  */  0,
/* 5f7 -  */  0,
/* 5f8 -  */  0,
/* 5f9 -  */  0,
/* 5fa -  */  0,
/* 5fb -  */  0,
/* 5fc -  */  0,
/* 5fd -  */  0,
/* 5fe -  */  0,
/* 5ff -  */  0,
/* 600 -  */  0,
/* 601 -  */  0,
/* 602 -  */  0,
/* 603 -  */  0,
/* 604 -  */  0,
/* 605 -  */  0,
/* 606 -  */  0,
/* 607 -  */  0,
/* 608 -  */  0,
/* 609 -  */  0,
/* 60a -  */  0,
/* 60b -  */  0,
/* 60c -  */  0,
/* 60d -  */  0,
/* 60e -  */  0,
/* 60f -  */  0,
/* 610 -  */  0,
/* 611 -  */  0,
/* 612 -  */  0,
/* 613 -  */  0,
/* 614 -  */  0,
/* 615 -  */  0,
/* 616 -  */  0,
/* 617 -  */  0,
/* 618 -  */  0,
/* 619 -  */  0,
/* 61a -  */  0,
/* 61b -  */  0,
/* 61c -  */  0,
/* 61d -  */  0,
/* 61e -  */  0,
/* 61f -  */  0,
/* 620 - _0F_10 */  0x236f,
/* 621 - _66_0F_10 */  0x2370,
/* 622 - _F3_0F_10 */  0x2371,
/* 623 - _F2_0F_10 */  0x2372,
/* 624 -  */  0,
/* 625 -  */  0,
/* 626 - _V_F3_0F_10 */  0x4009,
/* 627 - _V_F2_0F_10 */  0x400a,
/* 628 - _NV_0F_10 */  0x400b,
/* 629 - _NV_66_0F_10 */  0x400c,
/* 62a - _NV_F3_0F_10 */  0x400d,
/* 62b - _NV_F2_0F_10 */  0x400e,
/* 62c - _0F_11 */  0x2373,
/* 62d - _66_0F_11 */  0x2374,
/* 62e - _F3_0F_11 */  0x2375,
/* 62f - _F2_0F_11 */  0x2376,
/* 630 -  */  0,
/* 631 -  */  0,
/* 632 - _V_F3_0F_11 */  0x400f,
/* 633 - _V_F2_0F_11 */  0x4010,
/* 634 - _NV_0F_11 */  0x4011,
/* 635 - _NV_66_0F_11 */  0x4012,
/* 636 - _NV_F3_0F_11 */  0x4013,
/* 637 - _NV_F2_0F_11 */  0x4014,
/* 638 - _0F_12 */  0x4015,
/* 639 - _66_0F_12 */  0x2377,
/* 63a - _F3_0F_12 */  0x2378,
/* 63b - _F2_0F_12 */  0x2379,
/* 63c - _V_0F_12 */  0x4016,
/* 63d - _V_66_0F_12 */  0x4017,
/* 63e -  */  0,
/* 63f -  */  0,
/* 640 -  */  0,
/* 641 -  */  0,
/* 642 - _NV_F3_0F_12 */  0x4018,
/* 643 - _NV_F2_0F_12 */  0x4019,
/* 644 - _0F_13 */  0x237a,
/* 645 - _66_0F_13 */  0x237b,
/* 646 -  */  0,
/* 647 -  */  0,
/* 648 -  */  0,
/* 649 -  */  0,
/* 64a -  */  0,
/* 64b -  */  0,
/* 64c - _NV_0F_13 */  0x401a,
/* 64d - _NV_66_0F_13 */  0x401b,
/* 64e -  */  0,
/* 64f -  */  0,
/* 650 - _0F_14 */  0x237c,
/* 651 - _66_0F_14 */  0x237d,
/* 652 -  */  0,
/* 653 -  */  0,
/* 654 - _V_0F_14 */  0x401c,
/* 655 - _V_66_0F_14 */  0x401d,
/* 656 -  */  0,
/* 657 -  */  0,
/* 658 -  */  0,
/* 659 -  */  0,
/* 65a -  */  0,
/* 65b -  */  0,
/* 65c - _0F_15 */  0x237e,
/* 65d - _66_0F_15 */  0x237f,
/* 65e -  */  0,
/* 65f -  */  0,
/* 660 - _V_0F_15 */  0x401e,
/* 661 - _V_66_0F_15 */  0x401f,
/* 662 -  */  0,
/* 663 -  */  0,
/* 664 -  */  0,
/* 665 -  */  0,
/* 666 -  */  0,
/* 667 -  */  0,
/* 668 - _0F_16 */  0x4020,
/* 669 - _66_0F_16 */  0x2380,
/* 66a - _F3_0F_16 */  0x2381,
/* 66b -  */  0,
/* 66c - _V_0F_16 */  0x4021,
/* 66d - _V_66_0F_16 */  0x4022,
/* 66e -  */  0,
/* 66f -  */  0,
/* 670 -  */  0,
/* 671 -  */  0,
/* 672 - _NV_F3_0F_16 */  0x4023,
/* 673 -  */  0,
/* 674 - _0F_17 */  0x2382,
/* 675 - _66_0F_17 */  0x2383,
/* 676 -  */  0,
/* 677 -  */  0,
/* 678 -  */  0,
/* 679 -  */  0,
/* 67a -  */  0,
/* 67b -  */  0,
/* 67c - _NV_0F_17 */  0x4024,
/* 67d - _NV_66_0F_17 */  0x4025,
/* 67e -  */  0,
/* 67f -  */  0,
/* 680 - _0F_18_00 */  0x2384,
/* 681 - _0F_18_01 */  0x2385,
/* 682 - _0F_18_02 */  0x2386,
/* 683 - _0F_18_03 */  0x2387,
/* 684 -  */  0,
/* 685 -  */  0,
/* 686 -  */  0,
/* 687 -  */  0,
/* 688 - _0F_28 */  0x2388,
/* 689 - _66_0F_28 */  0x2389,
/* 68a -  */  0,
/* 68b -  */  0,
/* 68c -  */  0,
/* 68d -  */  0,
/* 68e -  */  0,
/* 68f -  */  0,
/* 690 - _NV_0F_28 */  0x4026,
/* 691 - _NV_66_0F_28 */  0x4027,
/* 692 -  */  0,
/* 693 -  */  0,
/* 694 - _0F_29 */  0x238a,
/* 695 - _66_0F_29 */  0x238b,
/* 696 -  */  0,
/* 697 -  */  0,
/* 698 -  */  0,
/* 699 -  */  0,
/* 69a -  */  0,
/* 69b -  */  0,
/* 69c - _NV_0F_29 */  0x4028,
/* 69d - _NV_66_0F_29 */  0x4029,
/* 69e -  */  0,
/* 69f -  */  0,
/* 6a0 - _0F_2A */  0x238c,
/* 6a1 - _66_0F_2A */  0x238d,
/* 6a2 - _F3_0F_2A */  0x238e,
/* 6a3 - _F2_0F_2A */  0x238f,
/* 6a4 -  */  0,
/* 6a5 -  */  0,
/* 6a6 - _V_F3_0F_2A */  0x402a,
/* 6a7 - _V_F2_0F_2A */  0x402b,
/* 6a8 -  */  0,
/* 6a9 -  */  0,
/* 6aa -  */  0,
/* 6ab -  */  0,
/* 6ac - _0F_2B */  0x2390,
/* 6ad - _66_0F_2B */  0x2391,
/* 6ae - _F3_0F_2B */  0x2392,
/* 6af - _F2_0F_2B */  0x2393,
/* 6b0 -  */  0,
/* 6b1 -  */  0,
/* 6b2 -  */  0,
/* 6b3 -  */  0,
/* 6b4 - _NV_0F_2B */  0x402c,
/* 6b5 - _NV_66_0F_2B */  0x402d,
/* 6b6 -  */  0,
/* 6b7 -  */  0,
/* 6b8 - _0F_2C */  0x2394,
/* 6b9 - _66_0F_2C */  0x2395,
/* 6ba - _F3_0F_2C */  0x2396,
/* 6bb - _F2_0F_2C */  0x2397,
/* 6bc -  */  0,
/* 6bd -  */  0,
/* 6be -  */  0,
/* 6bf -  */  0,
/* 6c0 -  */  0,
/* 6c1 -  */  0,
/* 6c2 - _NV_F3_0F_2C */  0x402e,
/* 6c3 - _NV_F2_0F_2C */  0x402f,
/* 6c4 - _0F_2D */  0x2398,
/* 6c5 - _66_0F_2D */  0x2399,
/* 6c6 - _F3_0F_2D */  0x239a,
/* 6c7 - _F2_0F_2D */  0x239b,
/* 6c8 -  */  0,
/* 6c9 -  */  0,
/* 6ca -  */  0,
/* 6cb -  */  0,
/* 6cc -  */  0,
/* 6cd -  */  0,
/* 6ce - _NV_F3_0F_2D */  0x4030,
/* 6cf - _NV_F2_0F_2D */  0x4031,
/* 6d0 - _0F_2E */  0x239c,
/* 6d1 - _66_0F_2E */  0x239d,
/* 6d2 -  */  0,
/* 6d3 -  */  0,
/* 6d4 -  */  0,
/* 6d5 -  */  0,
/* 6d6 -  */  0,
/* 6d7 -  */  0,
/* 6d8 - _NV_0F_2E */  0x4032,
/* 6d9 - _NV_66_0F_2E */  0x4033,
/* 6da -  */  0,
/* 6db -  */  0,
/* 6dc - _0F_2F */  0x239e,
/* 6dd - _66_0F_2F */  0x239f,
/* 6de -  */  0,
/* 6df -  */  0,
/* 6e0 -  */  0,
/* 6e1 -  */  0,
/* 6e2 -  */  0,
/* 6e3 -  */  0,
/* 6e4 - _NV_0F_2F */  0x4034,
/* 6e5 - _NV_66_0F_2F */  0x4035,
/* 6e6 -  */  0,
/* 6e7 -  */  0,
/* 6e8 - _0F_38_00 */  0xcdec,
/* 6e9 - _0F_38_01 */  0xcdf8,
/* 6ea - _0F_38_02 */  0xce04,
/* 6eb - _0F_38_03 */  0xce10,
/* 6ec - _0F_38_04 */  0xce1c,
/* 6ed - _0F_38_05 */  0xce28,
/* 6ee - _0F_38_06 */  0xce34,
/* 6ef - _0F_38_07 */  0xce40,
/* 6f0 - _0F_38_08 */  0xce4c,
/* 6f1 - _0F_38_09 */  0xce58,
/* 6f2 - _0F_38_0A */  0xce64,
/* 6f3 - _0F_38_0B */  0xce70,
/* 6f4 - _0F_38_0C */  0xce7c,
/* 6f5 - _0F_38_0D */  0xce88,
/* 6f6 - _0F_38_0E */  0xce94,
/* 6f7 - _0F_38_0F */  0xcea0,
/* 6f8 - _0F_38_10 */  0xceac,
/* 6f9 -  */  0,
/* 6fa -  */  0,
/* 6fb -  */  0,
/* 6fc - _0F_38_14 */  0xceb8,
/* 6fd - _0F_38_15 */  0xcec4,
/* 6fe -  */  0,
/* 6ff - _0F_38_17 */  0xced0,
/* 700 - _0F_38_18 */  0xcedc,
/* 701 - _0F_38_19 */  0xcee8,
/* 702 - _0F_38_1A */  0xcef4,
/* 703 -  */  0,
/* 704 - _0F_38_1C */  0xcf00,
/* 705 - _0F_38_1D */  0xcf0c,
/* 706 - _0F_38_1E */  0xcf18,
/* 707 -  */  0,
/* 708 - _0F_38_20 */  0xcf24,
/* 709 - _0F_38_21 */  0xcf30,
/* 70a - _0F_38_22 */  0xcf3c,
/* 70b - _0F_38_23 */  0xcf48,
/* 70c - _0F_38_24 */  0xcf54,
/* 70d - _0F_38_25 */  0xcf60,
/* 70e -  */  0,
/* 70f -  */  0,
/* 710 - _0F_38_28 */  0xcf6c,
/* 711 - _0F_38_29 */  0xcf78,
/* 712 - _0F_38_2A */  0xcf84,
/* 713 - _0F_38_2B */  0xcf90,
/* 714 - _0F_38_2C */  0xcf9c,
/* 715 - _0F_38_2D */  0xcfa8,
/* 716 - _0F_38_2E */  0xcfb4,
/* 717 - _0F_38_2F */  0xcfc0,
/* 718 - _0F_38_30 */  0xcfcc,
/* 719 - _0F_38_31 */  0xcfd8,
/* 71a - _0F_38_32 */  0xcfe4,
/* 71b - _0F_38_33 */  0xcff0,
/* 71c - _0F_38_34 */  0xcffc,
/* 71d - _0F_38_35 */  0xd008,
/* 71e -  */  0,
/* 71f - _0F_38_37 */  0xd014,
/* 720 - _0F_38_38 */  0xd020,
/* 721 - _0F_38_39 */  0xd02c,
/* 722 - _0F_38_3A */  0xd038,
/* 723 - _0F_38_3B */  0xd044,
/* 724 - _0F_38_3C */  0xd050,
/* 725 - _0F_38_3D */  0xd05c,
/* 726 - _0F_38_3E */  0xd068,
/* 727 - _0F_38_3F */  0xd074,
/* 728 - _0F_38_40 */  0xd080,
/* 729 - _0F_38_41 */  0xd08c,
/* 72a -  */  0,
/* 72b -  */  0,
/* 72c -  */  0,
/* 72d -  */  0,
/* 72e -  */  0,
/* 72f -  */  0,
/* 730 -  */  0,
/* 731 -  */  0,
/* 732 -  */  0,
/* 733 -  */  0,
/* 734 -  */  0,
/* 735 -  */  0,
/* 736 -  */  0,
/* 737 -  */  0,
/* 738 -  */  0,
/* 739 -  */  0,
/* 73a -  */  0,
/* 73b -  */  0,
/* 73c -  */  0,
/* 73d -  */  0,
/* 73e -  */  0,
/* 73f -  */  0,
/* 740 -  */  0,
/* 741 -  */  0,
/* 742 -  */  0,
/* 743 -  */  0,
/* 744 -  */  0,
/* 745 -  */  0,
/* 746 -  */  0,
/* 747 -  */  0,
/* 748 -  */  0,
/* 749 -  */  0,
/* 74a -  */  0,
/* 74b -  */  0,
/* 74c -  */  0,
/* 74d -  */  0,
/* 74e -  */  0,
/* 74f -  */  0,
/* 750 -  */  0,
/* 751 -  */  0,
/* 752 -  */  0,
/* 753 -  */  0,
/* 754 -  */  0,
/* 755 -  */  0,
/* 756 -  */  0,
/* 757 -  */  0,
/* 758 -  */  0,
/* 759 -  */  0,
/* 75a -  */  0,
/* 75b -  */  0,
/* 75c -  */  0,
/* 75d -  */  0,
/* 75e -  */  0,
/* 75f -  */  0,
/* 760 -  */  0,
/* 761 -  */  0,
/* 762 -  */  0,
/* 763 -  */  0,
/* 764 -  */  0,
/* 765 -  */  0,
/* 766 -  */  0,
/* 767 -  */  0,
/* 768 - _0F_38_80 */  0xd098,
/* 769 - _0F_38_81 */  0xd0a4,
/* 76a -  */  0,
/* 76b -  */  0,
/* 76c -  */  0,
/* 76d -  */  0,
/* 76e -  */  0,
/* 76f -  */  0,
/* 770 -  */  0,
/* 771 -  */  0,
/* 772 -  */  0,
/* 773 -  */  0,
/* 774 -  */  0,
/* 775 -  */  0,
/* 776 -  */  0,
/* 777 -  */  0,
/* 778 -  */  0,
/* 779 -  */  0,
/* 77a -  */  0,
/* 77b -  */  0,
/* 77c -  */  0,
/* 77d -  */  0,
/* 77e - _0F_38_96 */  0xd0b0,
/* 77f - _0F_38_97 */  0xd0bc,
/* 780 - _0F_38_98 */  0xd0c8,
/* 781 - _0F_38_99 */  0xd0d4,
/* 782 - _0F_38_9A */  0xd0e0,
/* 783 - _0F_38_9B */  0xd0ec,
/* 784 - _0F_38_9C */  0xd0f8,
/* 785 - _0F_38_9D */  0xd104,
/* 786 - _0F_38_9E */  0xd110,
/* 787 - _0F_38_9F */  0xd11c,
/* 788 -  */  0,
/* 789 -  */  0,
/* 78a -  */  0,
/* 78b -  */  0,
/* 78c -  */  0,
/* 78d -  */  0,
/* 78e - _0F_38_A6 */  0xd128,
/* 78f - _0F_38_A7 */  0xd134,
/* 790 - _0F_38_A8 */  0xd140,
/* 791 - _0F_38_A9 */  0xd14c,
/* 792 - _0F_38_AA */  0xd158,
/* 793 - _0F_38_AB */  0xd164,
/* 794 - _0F_38_AC */  0xd170,
/* 795 - _0F_38_AD */  0xd17c,
/* 796 - _0F_38_AE */  0xd188,
/* 797 - _0F_38_AF */  0xd194,
/* 798 -  */  0,
/* 799 -  */  0,
/* 79a -  */  0,
/* 79b -  */  0,
/* 79c -  */  0,
/* 79d -  */  0,
/* 79e - _0F_38_B6 */  0xd1a0,
/* 79f - _0F_38_B7 */  0xd1ac,
/* 7a0 - _0F_38_B8 */  0xd1b8,
/* 7a1 - _0F_38_B9 */  0xd1c4,
/* 7a2 - _0F_38_BA */  0xd1d0,
/* 7a3 - _0F_38_BB */  0xd1dc,
/* 7a4 - _0F_38_BC */  0xd1e8,
/* 7a5 - _0F_38_BD */  0xd1f4,
/* 7a6 - _0F_38_BE */  0xd200,
/* 7a7 - _0F_38_BF */  0xd20c,
/* 7a8 -  */  0,
/* 7a9 -  */  0,
/* 7aa -  */  0,
/* 7ab -  */  0,
/* 7ac -  */  0,
/* 7ad -  */  0,
/* 7ae -  */  0,
/* 7af -  */  0,
/* 7b0 -  */  0,
/* 7b1 -  */  0,
/* 7b2 -  */  0,
/* 7b3 -  */  0,
/* 7b4 -  */  0,
/* 7b5 -  */  0,
/* 7b6 -  */  0,
/* 7b7 -  */  0,
/* 7b8 -  */  0,
/* 7b9 -  */  0,
/* 7ba -  */  0,
/* 7bb -  */  0,
/* 7bc -  */  0,
/* 7bd -  */  0,
/* 7be -  */  0,
/* 7bf -  */  0,
/* 7c0 -  */  0,
/* 7c1 -  */  0,
/* 7c2 -  */  0,
/* 7c3 - _0F_38_DB */  0xd218,
/* 7c4 - _0F_38_DC */  0xd224,
/* 7c5 - _0F_38_DD */  0xd230,
/* 7c6 - _0F_38_DE */  0xd23c,
/* 7c7 - _0F_38_DF */  0xd248,
/* 7c8 -  */  0,
/* 7c9 -  */  0,
/* 7ca -  */  0,
/* 7cb -  */  0,
/* 7cc -  */  0,
/* 7cd -  */  0,
/* 7ce -  */  0,
/* 7cf -  */  0,
/* 7d0 -  */  0,
/* 7d1 -  */  0,
/* 7d2 -  */  0,
/* 7d3 -  */  0,
/* 7d4 -  */  0,
/* 7d5 -  */  0,
/* 7d6 -  */  0,
/* 7d7 -  */  0,
/* 7d8 - _0F_38_F0 */  0xd254,
/* 7d9 - _0F_38_F1 */  0xd260,
/* 7da -  */  0,
/* 7db -  */  0,
/* 7dc -  */  0,
/* 7dd -  */  0,
/* 7de -  */  0,
/* 7df -  */  0,
/* 7e0 -  */  0,
/* 7e1 -  */  0,
/* 7e2 -  */  0,
/* 7e3 -  */  0,
/* 7e4 -  */  0,
/* 7e5 -  */  0,
/* 7e6 -  */  0,
/* 7e7 -  */  0,
/* 7e8 -  */  0,
/* 7e9 -  */  0,
/* 7ea -  */  0,
/* 7eb -  */  0,
/* 7ec - _0F_3A_04 */  0xd26c,
/* 7ed - _0F_3A_05 */  0xd278,
/* 7ee - _0F_3A_06 */  0xd284,
/* 7ef -  */  0,
/* 7f0 - _0F_3A_08 */  0xd290,
/* 7f1 - _0F_3A_09 */  0xd29c,
/* 7f2 - _0F_3A_0A */  0xd2a8,
/* 7f3 - _0F_3A_0B */  0xd2b4,
/* 7f4 - _0F_3A_0C */  0xd2c0,
/* 7f5 - _0F_3A_0D */  0xd2cc,
/* 7f6 - _0F_3A_0E */  0xd2d8,
/* 7f7 - _0F_3A_0F */  0xd2e4,
/* 7f8 -  */  0,
/* 7f9 -  */  0,
/* 7fa -  */  0,
/* 7fb -  */  0,
/* 7fc - _0F_3A_14 */  0xd2f0,
/* 7fd - _0F_3A_15 */  0xd2fc,
/* 7fe - _0F_3A_16 */  0xd308,
/* 7ff - _0F_3A_17 */  0xd314,
/* 800 - _0F_3A_18 */  0xd320,
/* 801 - _0F_3A_19 */  0xd32c,
/* 802 -  */  0,
/* 803 -  */  0,
/* 804 -  */  0,
/* 805 -  */  0,
/* 806 -  */  0,
/* 807 -  */  0,
/* 808 - _0F_3A_20 */  0xd338,
/* 809 - _0F_3A_21 */  0xd344,
/* 80a - _0F_3A_22 */  0xd350,
/* 80b -  */  0,
/* 80c -  */  0,
/* 80d -  */  0,
/* 80e -  */  0,
/* 80f -  */  0,
/* 810 -  */  0,
/* 811 -  */  0,
/* 812 -  */  0,
/* 813 -  */  0,
/* 814 -  */  0,
/* 815 -  */  0,
/* 816 -  */  0,
/* 817 -  */  0,
/* 818 -  */  0,
/* 819 -  */  0,
/* 81a -  */  0,
/* 81b -  */  0,
/* 81c -  */  0,
/* 81d -  */  0,
/* 81e -  */  0,
/* 81f -  */  0,
/* 820 -  */  0,
/* 821 -  */  0,
/* 822 -  */  0,
/* 823 -  */  0,
/* 824 -  */  0,
/* 825 -  */  0,
/* 826 -  */  0,
/* 827 -  */  0,
/* 828 - _0F_3A_40 */  0xd35c,
/* 829 - _0F_3A_41 */  0xd368,
/* 82a - _0F_3A_42 */  0xd374,
/* 82b -  */  0,
/* 82c - _0F_3A_44 */  0xd380,
/* 82d -  */  0,
/* 82e -  */  0,
/* 82f -  */  0,
/* 830 -  */  0,
/* 831 -  */  0,
/* 832 - _0F_3A_4A */  0xd38c,
/* 833 - _0F_3A_4B */  0xd398,
/* 834 - _0F_3A_4C */  0xd3a4,
/* 835 -  */  0,
/* 836 -  */  0,
/* 837 -  */  0,
/* 838 -  */  0,
/* 839 -  */  0,
/* 83a -  */  0,
/* 83b -  */  0,
/* 83c -  */  0,
/* 83d -  */  0,
/* 83e -  */  0,
/* 83f -  */  0,
/* 840 -  */  0,
/* 841 -  */  0,
/* 842 -  */  0,
/* 843 -  */  0,
/* 844 -  */  0,
/* 845 -  */  0,
/* 846 -  */  0,
/* 847 -  */  0,
/* 848 - _0F_3A_60 */  0xd3b0,
/* 849 - _0F_3A_61 */  0xd3bc,
/* 84a - _0F_3A_62 */  0xd3c8,
/* 84b - _0F_3A_63 */  0xd3d4,
/* 84c -  */  0,
/* 84d -  */  0,
/* 84e -  */  0,
/* 84f -  */  0,
/* 850 -  */  0,
/* 851 -  */  0,
/* 852 -  */  0,
/* 853 -  */  0,
/* 854 -  */  0,
/* 855 -  */  0,
/* 856 -  */  0,
/* 857 -  */  0,
/* 858 -  */  0,
/* 859 -  */  0,
/* 85a -  */  0,
/* 85b -  */  0,
/* 85c -  */  0,
/* 85d -  */  0,
/* 85e -  */  0,
/* 85f -  */  0,
/* 860 -  */  0,
/* 861 -  */  0,
/* 862 -  */  0,
/* 863 -  */  0,
/* 864 -  */  0,
/* 865 -  */  0,
/* 866 -  */  0,
/* 867 -  */  0,
/* 868 -  */  0,
/* 869 -  */  0,
/* 86a -  */  0,
/* 86b -  */  0,
/* 86c -  */  0,
/* 86d -  */  0,
/* 86e -  */  0,
/* 86f -  */  0,
/* 870 -  */  0,
/* 871 -  */  0,
/* 872 -  */  0,
/* 873 -  */  0,
/* 874 -  */  0,
/* 875 -  */  0,
/* 876 -  */  0,
/* 877 -  */  0,
/* 878 -  */  0,
/* 879 -  */  0,
/* 87a -  */  0,
/* 87b -  */  0,
/* 87c -  */  0,
/* 87d -  */  0,
/* 87e -  */  0,
/* 87f -  */  0,
/* 880 -  */  0,
/* 881 -  */  0,
/* 882 -  */  0,
/* 883 -  */  0,
/* 884 -  */  0,
/* 885 -  */  0,
/* 886 -  */  0,
/* 887 -  */  0,
/* 888 -  */  0,
/* 889 -  */  0,
/* 88a -  */  0,
/* 88b -  */  0,
/* 88c -  */  0,
/* 88d -  */  0,
/* 88e -  */  0,
/* 88f -  */  0,
/* 890 -  */  0,
/* 891 -  */  0,
/* 892 -  */  0,
/* 893 -  */  0,
/* 894 -  */  0,
/* 895 -  */  0,
/* 896 -  */  0,
/* 897 -  */  0,
/* 898 -  */  0,
/* 899 -  */  0,
/* 89a -  */  0,
/* 89b -  */  0,
/* 89c -  */  0,
/* 89d -  */  0,
/* 89e -  */  0,
/* 89f -  */  0,
/* 8a0 -  */  0,
/* 8a1 -  */  0,
/* 8a2 -  */  0,
/* 8a3 -  */  0,
/* 8a4 -  */  0,
/* 8a5 -  */  0,
/* 8a6 -  */  0,
/* 8a7 -  */  0,
/* 8a8 -  */  0,
/* 8a9 -  */  0,
/* 8aa -  */  0,
/* 8ab -  */  0,
/* 8ac -  */  0,
/* 8ad -  */  0,
/* 8ae -  */  0,
/* 8af -  */  0,
/* 8b0 -  */  0,
/* 8b1 -  */  0,
/* 8b2 -  */  0,
/* 8b3 -  */  0,
/* 8b4 -  */  0,
/* 8b5 -  */  0,
/* 8b6 -  */  0,
/* 8b7 -  */  0,
/* 8b8 -  */  0,
/* 8b9 -  */  0,
/* 8ba -  */  0,
/* 8bb -  */  0,
/* 8bc -  */  0,
/* 8bd -  */  0,
/* 8be -  */  0,
/* 8bf -  */  0,
/* 8c0 -  */  0,
/* 8c1 -  */  0,
/* 8c2 -  */  0,
/* 8c3 -  */  0,
/* 8c4 -  */  0,
/* 8c5 -  */  0,
/* 8c6 -  */  0,
/* 8c7 - _0F_3A_DF */  0xd3e0,
/* 8c8 -  */  0,
/* 8c9 -  */  0,
/* 8ca -  */  0,
/* 8cb -  */  0,
/* 8cc -  */  0,
/* 8cd -  */  0,
/* 8ce -  */  0,
/* 8cf -  */  0,
/* 8d0 -  */  0,
/* 8d1 -  */  0,
/* 8d2 -  */  0,
/* 8d3 -  */  0,
/* 8d4 -  */  0,
/* 8d5 -  */  0,
/* 8d6 -  */  0,
/* 8d7 -  */  0,
/* 8d8 -  */  0,
/* 8d9 -  */  0,
/* 8da -  */  0,
/* 8db -  */  0,
/* 8dc -  */  0,
/* 8dd -  */  0,
/* 8de -  */  0,
/* 8df -  */  0,
/* 8e0 -  */  0,
/* 8e1 -  */  0,
/* 8e2 -  */  0,
/* 8e3 -  */  0,
/* 8e4 -  */  0,
/* 8e5 -  */  0,
/* 8e6 -  */  0,
/* 8e7 -  */  0,
/* 8e8 - _0F_50 */  0x23a0,
/* 8e9 - _66_0F_50 */  0x23a1,
/* 8ea -  */  0,
/* 8eb -  */  0,
/* 8ec -  */  0,
/* 8ed -  */  0,
/* 8ee -  */  0,
/* 8ef -  */  0,
/* 8f0 - _NV_0F_50 */  0x4036,
/* 8f1 - _NV_66_0F_50 */  0x4037,
/* 8f2 -  */  0,
/* 8f3 -  */  0,
/* 8f4 - _0F_51 */  0x23a2,
/* 8f5 - _66_0F_51 */  0x23a3,
/* 8f6 - _F3_0F_51 */  0x23a4,
/* 8f7 - _F2_0F_51 */  0x23a5,
/* 8f8 -  */  0,
/* 8f9 -  */  0,
/* 8fa - _V_F3_0F_51 */  0x4038,
/* 8fb - _V_F2_0F_51 */  0x4039,
/* 8fc - _NV_0F_51 */  0x403a,
/* 8fd - _NV_66_0F_51 */  0x403b,
/* 8fe -  */  0,
/* 8ff -  */  0,
/* 900 - _0F_52 */  0x23a6,
/* 901 -  */  0,
/* 902 - _F3_0F_52 */  0x23a7,
/* 903 -  */  0,
/* 904 -  */  0,
/* 905 -  */  0,
/* 906 - _V_F3_0F_52 */  0x403c,
/* 907 -  */  0,
/* 908 - _NV_0F_52 */  0x403d,
/* 909 -  */  0,
/* 90a -  */  0,
/* 90b -  */  0,
/* 90c - _0F_53 */  0x23a8,
/* 90d -  */  0,
/* 90e - _F3_0F_53 */  0x23a9,
/* 90f -  */  0,
/* 910 -  */  0,
/* 911 -  */  0,
/* 912 - _V_F3_0F_53 */  0x403e,
/* 913 -  */  0,
/* 914 - _NV_0F_53 */  0x403f,
/* 915 -  */  0,
/* 916 -  */  0,
/* 917 -  */  0,
/* 918 - _0F_54 */  0x23aa,
/* 919 - _66_0F_54 */  0x23ab,
/* 91a -  */  0,
/* 91b -  */  0,
/* 91c - _V_0F_54 */  0x4040,
/* 91d - _V_66_0F_54 */  0x4041,
/* 91e -  */  0,
/* 91f -  */  0,
/* 920 -  */  0,
/* 921 -  */  0,
/* 922 -  */  0,
/* 923 -  */  0,
/* 924 - _0F_55 */  0x23ac,
/* 925 - _66_0F_55 */  0x23ad,
/* 926 -  */  0,
/* 927 -  */  0,
/* 928 - _V_0F_55 */  0x4042,
/* 929 - _V_66_0F_55 */  0x4043,
/* 92a -  */  0,
/* 92b -  */  0,
/* 92c -  */  0,
/* 92d -  */  0,
/* 92e -  */  0,
/* 92f -  */  0,
/* 930 - _0F_56 */  0x23ae,
/* 931 - _66_0F_56 */  0x23af,
/* 932 -  */  0,
/* 933 -  */  0,
/* 934 - _V_0F_56 */  0x4044,
/* 935 - _V_66_0F_56 */  0x4045,
/* 936 -  */  0,
/* 937 -  */  0,
/* 938 -  */  0,
/* 939 -  */  0,
/* 93a -  */  0,
/* 93b -  */  0,
/* 93c - _0F_57 */  0x23b0,
/* 93d - _66_0F_57 */  0x23b1,
/* 93e -  */  0,
/* 93f -  */  0,
/* 940 - _V_0F_57 */  0x4046,
/* 941 - _V_66_0F_57 */  0x4047,
/* 942 -  */  0,
/* 943 -  */  0,
/* 944 -  */  0,
/* 945 -  */  0,
/* 946 -  */  0,
/* 947 -  */  0,
/* 948 - _0F_58 */  0x23b2,
/* 949 - _66_0F_58 */  0x23b3,
/* 94a - _F3_0F_58 */  0x23b4,
/* 94b - _F2_0F_58 */  0x23b5,
/* 94c - _V_0F_58 */  0x4048,
/* 94d - _V_66_0F_58 */  0x4049,
/* 94e - _V_F3_0F_58 */  0x404a,
/* 94f - _V_F2_0F_58 */  0x404b,
/* 950 -  */  0,
/* 951 -  */  0,
/* 952 -  */  0,
/* 953 -  */  0,
/* 954 - _0F_59 */  0x23b6,
/* 955 - _66_0F_59 */  0x23b7,
/* 956 - _F3_0F_59 */  0x23b8,
/* 957 - _F2_0F_59 */  0x23b9,
/* 958 - _V_0F_59 */  0x404c,
/* 959 - _V_66_0F_59 */  0x404d,
/* 95a - _V_F3_0F_59 */  0x404e,
/* 95b - _V_F2_0F_59 */  0x404f,
/* 95c -  */  0,
/* 95d -  */  0,
/* 95e -  */  0,
/* 95f -  */  0,
/* 960 - _0F_5A */  0x23ba,
/* 961 - _66_0F_5A */  0x23bb,
/* 962 - _F3_0F_5A */  0x23bc,
/* 963 - _F2_0F_5A */  0x23bd,
/* 964 -  */  0,
/* 965 -  */  0,
/* 966 - _V_F3_0F_5A */  0x4050,
/* 967 - _V_F2_0F_5A */  0x4051,
/* 968 - _NV_0F_5A */  0x4052,
/* 969 - _NV_66_0F_5A */  0x4053,
/* 96a -  */  0,
/* 96b -  */  0,
/* 96c - _0F_5B */  0x23be,
/* 96d - _66_0F_5B */  0x23bf,
/* 96e - _F3_0F_5B */  0x23c0,
/* 96f -  */  0,
/* 970 -  */  0,
/* 971 -  */  0,
/* 972 -  */  0,
/* 973 -  */  0,
/* 974 - _NV_0F_5B */  0x4054,
/* 975 - _NV_66_0F_5B */  0x4055,
/* 976 - _NV_F3_0F_5B */  0x4056,
/* 977 -  */  0,
/* 978 - _0F_5C */  0x23c1,
/* 979 - _66_0F_5C */  0x23c2,
/* 97a - _F3_0F_5C */  0x23c3,
/* 97b - _F2_0F_5C */  0x23c4,
/* 97c - _V_0F_5C */  0x4057,
/* 97d - _V_66_0F_5C */  0x4058,
/* 97e - _V_F3_0F_5C */  0x4059,
/* 97f - _V_F2_0F_5C */  0x405a,
/* 980 -  */  0,
/* 981 -  */  0,
/* 982 -  */  0,
/* 983 -  */  0,
/* 984 - _0F_5D */  0x23c5,
/* 985 - _66_0F_5D */  0x23c6,
/* 986 - _F3_0F_5D */  0x23c7,
/* 987 - _F2_0F_5D */  0x23c8,
/* 988 - _V_0F_5D */  0x405b,
/* 989 - _V_66_0F_5D */  0x405c,
/* 98a - _V_F3_0F_5D */  0x405d,
/* 98b - _V_F2_0F_5D */  0x405e,
/* 98c -  */  0,
/* 98d -  */  0,
/* 98e -  */  0,
/* 98f -  */  0,
/* 990 - _0F_5E */  0x23c9,
/* 991 - _66_0F_5E */  0x23ca,
/* 992 - _F3_0F_5E */  0x23cb,
/* 993 - _F2_0F_5E */  0x23cc,
/* 994 - _V_0F_5E */  0x405f,
/* 995 - _V_66_0F_5E */  0x4060,
/* 996 - _V_F3_0F_5E */  0x4061,
/* 997 - _V_F2_0F_5E */  0x4062,
/* 998 -  */  0,
/* 999 -  */  0,
/* 99a -  */  0,
/* 99b -  */  0,
/* 99c - _0F_5F */  0x23cd,
/* 99d - _66_0F_5F */  0x23ce,
/* 99e - _F3_0F_5F */  0x23cf,
/* 99f - _F2_0F_5F */  0x23d0,
/* 9a0 - _V_0F_5F */  0x4063,
/* 9a1 - _V_66_0F_5F */  0x4064,
/* 9a2 - _V_F3_0F_5F */  0x4065,
/* 9a3 - _V_F2_0F_5F */  0x4066,
/* 9a4 -  */  0,
/* 9a5 -  */  0,
/* 9a6 -  */  0,
/* 9a7 -  */  0,
/* 9a8 - _0F_60 */  0x23d1,
/* 9a9 - _66_0F_60 */  0x23d2,
/* 9aa -  */  0,
/* 9ab -  */  0,
/* 9ac -  */  0,
/* 9ad - _V_66_0F_60 */  0x4067,
/* 9ae -  */  0,
/* 9af -  */  0,
/* 9b0 -  */  0,
/* 9b1 -  */  0,
/* 9b2 -  */  0,
/* 9b3 -  */  0,
/* 9b4 - _0F_61 */  0x23d3,
/* 9b5 - _66_0F_61 */  0x23d4,
/* 9b6 -  */  0,
/* 9b7 -  */  0,
/* 9b8 -  */  0,
/* 9b9 - _V_66_0F_61 */  0x4068,
/* 9ba -  */  0,
/* 9bb -  */  0,
/* 9bc -  */  0,
/* 9bd -  */  0,
/* 9be -  */  0,
/* 9bf -  */  0,
/* 9c0 - _0F_62 */  0x23d5,
/* 9c1 - _66_0F_62 */  0x23d6,
/* 9c2 -  */  0,
/* 9c3 -  */  0,
/* 9c4 -  */  0,
/* 9c5 - _V_66_0F_62 */  0x4069,
/* 9c6 -  */  0,
/* 9c7 -  */  0,
/* 9c8 -  */  0,
/* 9c9 -  */  0,
/* 9ca -  */  0,
/* 9cb -  */  0,
/* 9cc - _0F_63 */  0x23d7,
/* 9cd - _66_0F_63 */  0x23d8,
/* 9ce -  */  0,
/* 9cf -  */  0,
/* 9d0 -  */  0,
/* 9d1 - _V_66_0F_63 */  0x406a,
/* 9d2 -  */  0,
/* 9d3 -  */  0,
/* 9d4 -  */  0,
/* 9d5 -  */  0,
/* 9d6 -  */  0,
/* 9d7 -  */  0,
/* 9d8 - _0F_64 */  0x23d9,
/* 9d9 - _66_0F_64 */  0x23da,
/* 9da -  */  0,
/* 9db -  */  0,
/* 9dc -  */  0,
/* 9dd - _V_66_0F_64 */  0x406b,
/* 9de -  */  0,
/* 9df -  */  0,
/* 9e0 -  */  0,
/* 9e1 -  */  0,
/* 9e2 -  */  0,
/* 9e3 -  */  0,
/* 9e4 - _0F_65 */  0x23db,
/* 9e5 - _66_0F_65 */  0x23dc,
/* 9e6 -  */  0,
/* 9e7 -  */  0,
/* 9e8 -  */  0,
/* 9e9 - _V_66_0F_65 */  0x406c,
/* 9ea -  */  0,
/* 9eb -  */  0,
/* 9ec -  */  0,
/* 9ed -  */  0,
/* 9ee -  */  0,
/* 9ef -  */  0,
/* 9f0 - _0F_66 */  0x23dd,
/* 9f1 - _66_0F_66 */  0x23de,
/* 9f2 -  */  0,
/* 9f3 -  */  0,
/* 9f4 -  */  0,
/* 9f5 - _V_66_0F_66 */  0x406d,
/* 9f6 -  */  0,
/* 9f7 -  */  0,
/* 9f8 -  */  0,
/* 9f9 -  */  0,
/* 9fa -  */  0,
/* 9fb -  */  0,
/* 9fc - _0F_67 */  0x23df,
/* 9fd - _66_0F_67 */  0x23e0,
/* 9fe -  */  0,
/* 9ff -  */  0,
/* a00 -  */  0,
/* a01 - _V_66_0F_67 */  0x406e,
/* a02 -  */  0,
/* a03 -  */  0,
/* a04 -  */  0,
/* a05 -  */  0,
/* a06 -  */  0,
/* a07 -  */  0,
/* a08 - _0F_68 */  0x23e1,
/* a09 - _66_0F_68 */  0x23e2,
/* a0a -  */  0,
/* a0b -  */  0,
/* a0c -  */  0,
/* a0d - _V_66_0F_68 */  0x406f,
/* a0e -  */  0,
/* a0f -  */  0,
/* a10 -  */  0,
/* a11 -  */  0,
/* a12 -  */  0,
/* a13 -  */  0,
/* a14 - _0F_69 */  0x23e3,
/* a15 - _66_0F_69 */  0x23e4,
/* a16 -  */  0,
/* a17 -  */  0,
/* a18 -  */  0,
/* a19 - _V_66_0F_69 */  0x4070,
/* a1a -  */  0,
/* a1b -  */  0,
/* a1c -  */  0,
/* a1d -  */  0,
/* a1e -  */  0,
/* a1f -  */  0,
/* a20 - _0F_6A */  0x23e5,
/* a21 - _66_0F_6A */  0x23e6,
/* a22 -  */  0,
/* a23 -  */  0,
/* a24 -  */  0,
/* a25 - _V_66_0F_6A */  0x4071,
/* a26 -  */  0,
/* a27 -  */  0,
/* a28 -  */  0,
/* a29 -  */  0,
/* a2a -  */  0,
/* a2b -  */  0,
/* a2c - _0F_6B */  0x23e7,
/* a2d - _66_0F_6B */  0x23e8,
/* a2e -  */  0,
/* a2f -  */  0,
/* a30 -  */  0,
/* a31 - _V_66_0F_6B */  0x4072,
/* a32 -  */  0,
/* a33 -  */  0,
/* a34 -  */  0,
/* a35 -  */  0,
/* a36 -  */  0,
/* a37 -  */  0,
/* a38 -  */  0,
/* a39 - _66_0F_6C */  0x23e9,
/* a3a -  */  0,
/* a3b -  */  0,
/* a3c -  */  0,
/* a3d - _V_66_0F_6C */  0x4073,
/* a3e -  */  0,
/* a3f -  */  0,
/* a40 -  */  0,
/* a41 -  */  0,
/* a42 -  */  0,
/* a43 -  */  0,
/* a44 -  */  0,
/* a45 - _66_0F_6D */  0x23ea,
/* a46 -  */  0,
/* a47 -  */  0,
/* a48 -  */  0,
/* a49 - _V_66_0F_6D */  0x4074,
/* a4a -  */  0,
/* a4b -  */  0,
/* a4c -  */  0,
/* a4d -  */  0,
/* a4e -  */  0,
/* a4f -  */  0,
/* a50 - _0F_6E */  0x4075,
/* a51 - _66_0F_6E */  0x4076,
/* a52 -  */  0,
/* a53 -  */  0,
/* a54 -  */  0,
/* a55 -  */  0,
/* a56 -  */  0,
/* a57 -  */  0,
/* a58 -  */  0,
/* a59 - _NV_66_0F_6E */  0x4077,
/* a5a -  */  0,
/* a5b -  */  0,
/* a5c - _0F_6F */  0x23eb,
/* a5d - _66_0F_6F */  0x23ec,
/* a5e - _F3_0F_6F */  0x23ed,
/* a5f -  */  0,
/* a60 -  */  0,
/* a61 -  */  0,
/* a62 -  */  0,
/* a63 -  */  0,
/* a64 -  */  0,
/* a65 - _NV_66_0F_6F */  0x4078,
/* a66 - _NV_F3_0F_6F */  0x4079,
/* a67 -  */  0,
/* a68 - _0F_70 */  0x407a,
/* a69 - _66_0F_70 */  0x407b,
/* a6a - _F3_0F_70 */  0x407c,
/* a6b - _F2_0F_70 */  0x407d,
/* a6c -  */  0,
/* a6d -  */  0,
/* a6e -  */  0,
/* a6f -  */  0,
/* a70 -  */  0,
/* a71 - _NV_66_0F_70 */  0x407e,
/* a72 - _NV_F3_0F_70 */  0x407f,
/* a73 - _NV_F2_0F_70 */  0x4080,
/* a74 -  */  0,
/* a75 -  */  0,
/* a76 - _0F_71_02 */  0xd3ec,
/* a77 -  */  0,
/* a78 - _0F_71_04 */  0xd3f8,
/* a79 -  */  0,
/* a7a - _0F_71_06 */  0xd404,
/* a7b -  */  0,
/* a7c -  */  0,
/* a7d -  */  0,
/* a7e - _0F_72_02 */  0xd410,
/* a7f -  */  0,
/* a80 - _0F_72_04 */  0xd41c,
/* a81 -  */  0,
/* a82 - _0F_72_06 */  0xd428,
/* a83 -  */  0,
/* a84 -  */  0,
/* a85 -  */  0,
/* a86 - _0F_73_02 */  0xd434,
/* a87 - _0F_73_03 */  0xd440,
/* a88 -  */  0,
/* a89 -  */  0,
/* a8a - _0F_73_06 */  0xd44c,
/* a8b - _0F_73_07 */  0xd458,
/* a8c - _0F_74 */  0x23ee,
/* a8d - _66_0F_74 */  0x23ef,
/* a8e -  */  0,
/* a8f -  */  0,
/* a90 -  */  0,
/* a91 - _V_66_0F_74 */  0x4081,
/* a92 -  */  0,
/* a93 -  */  0,
/* a94 -  */  0,
/* a95 -  */  0,
/* a96 -  */  0,
/* a97 -  */  0,
/* a98 - _0F_75 */  0x23f0,
/* a99 - _66_0F_75 */  0x23f1,
/* a9a -  */  0,
/* a9b -  */  0,
/* a9c -  */  0,
/* a9d - _V_66_0F_75 */  0x4082,
/* a9e -  */  0,
/* a9f -  */  0,
/* aa0 -  */  0,
/* aa1 -  */  0,
/* aa2 -  */  0,
/* aa3 -  */  0,
/* aa4 - _0F_76 */  0x23f2,
/* aa5 - _66_0F_76 */  0x23f3,
/* aa6 -  */  0,
/* aa7 -  */  0,
/* aa8 -  */  0,
/* aa9 - _V_66_0F_76 */  0x4083,
/* aaa -  */  0,
/* aab -  */  0,
/* aac -  */  0,
/* aad -  */  0,
/* aae -  */  0,
/* aaf -  */  0,
/* ab0 - _0F_77 */  0x23f4,
/* ab1 -  */  0,
/* ab2 -  */  0,
/* ab3 -  */  0,
/* ab4 -  */  0,
/* ab5 -  */  0,
/* ab6 -  */  0,
/* ab7 -  */  0,
/* ab8 - _NV_0F_77 */  0x4084,
/* ab9 -  */  0,
/* aba -  */  0,
/* abb -  */  0,
/* abc - _0F_78 */  0x23f5,
/* abd - _66_0F_78 */  0x4085,
/* abe -  */  0,
/* abf - _F2_0F_78 */  0x4086,
/* ac0 -  */  0,
/* ac1 -  */  0,
/* ac2 -  */  0,
/* ac3 -  */  0,
/* ac4 -  */  0,
/* ac5 -  */  0,
/* ac6 -  */  0,
/* ac7 -  */  0,
/* ac8 - _0F_79 */  0x23f6,
/* ac9 - _66_0F_79 */  0x23f7,
/* aca -  */  0,
/* acb - _F2_0F_79 */  0x23f8,
/* acc -  */  0,
/* acd -  */  0,
/* ace -  */  0,
/* acf -  */  0,
/* ad0 -  */  0,
/* ad1 -  */  0,
/* ad2 -  */  0,
/* ad3 -  */  0,
/* ad4 -  */  0,
/* ad5 - _66_0F_7C */  0x23f9,
/* ad6 -  */  0,
/* ad7 - _F2_0F_7C */  0x23fa,
/* ad8 -  */  0,
/* ad9 - _V_66_0F_7C */  0x4087,
/* ada -  */  0,
/* adb - _V_F2_0F_7C */  0x4088,
/* adc -  */  0,
/* add -  */  0,
/* ade -  */  0,
/* adf -  */  0,
/* ae0 -  */  0,
/* ae1 - _66_0F_7D */  0x23fb,
/* ae2 -  */  0,
/* ae3 - _F2_0F_7D */  0x23fc,
/* ae4 -  */  0,
/* ae5 - _V_66_0F_7D */  0x4089,
/* ae6 -  */  0,
/* ae7 - _V_F2_0F_7D */  0x408a,
/* ae8 -  */  0,
/* ae9 -  */  0,
/* aea -  */  0,
/* aeb -  */  0,
/* aec - _0F_7E */  0x408b,
/* aed - _66_0F_7E */  0x408c,
/* aee - _F3_0F_7E */  0x23fd,
/* aef -  */  0,
/* af0 -  */  0,
/* af1 -  */  0,
/* af2 -  */  0,
/* af3 -  */  0,
/* af4 -  */  0,
/* af5 - _NV_66_0F_7E */  0x408d,
/* af6 - _NV_F3_0F_7E */  0x408e,
/* af7 -  */  0,
/* af8 - _0F_7F */  0x23fe,
/* af9 - _66_0F_7F */  0x23ff,
/* afa - _F3_0F_7F */  0x2400,
/* afb -  */  0,
/* afc -  */  0,
/* afd -  */  0,
/* afe -  */  0,
/* aff -  */  0,
/* b00 -  */  0,
/* b01 - _NV_66_0F_7F */  0x408f,
/* b02 - _NV_F3_0F_7F */  0x4090,
/* b03 -  */  0,
/* b04 - _0F_AE_00 */  0x2401,
/* b05 - _0F_AE_01 */  0x2402,
/* b06 - _0F_AE_02 */  0xd464,
/* b07 - _0F_AE_03 */  0xd470,
/* b08 - _0F_AE_04 */  0x2403,
/* b09 - _0F_AE_05 */  0x4091,
/* b0a - _0F_AE_06 */  0x2404,
/* b0b - _0F_AE_07 */  0x4092,
/* b0c -  */  0,
/* b0d -  */  0,
/* b0e - _F3_0F_B8 */  0x2405,
/* b0f -  */  0,
/* b10 -  */  0,
/* b11 -  */  0,
/* b12 -  */  0,
/* b13 -  */  0,
/* b14 -  */  0,
/* b15 -  */  0,
/* b16 -  */  0,
/* b17 -  */  0,
/* b18 -  */  0,
/* b19 -  */  0,
/* b1a -  */  0,
/* b1b -  */  0,
/* b1c - _0F_BA_04 */  0x2406,
/* b1d - _0F_BA_05 */  0x2407,
/* b1e - _0F_BA_06 */  0x2408,
/* b1f - _0F_BA_07 */  0x2409,
/* b20 - _0F_BD */  0x240a,
/* b21 -  */  0,
/* b22 - _F3_0F_BD */  0x240b,
/* b23 -  */  0,
/* b24 -  */  0,
/* b25 -  */  0,
/* b26 -  */  0,
/* b27 -  */  0,
/* b28 -  */  0,
/* b29 -  */  0,
/* b2a -  */  0,
/* b2b -  */  0,
/* b2c - _0F_C2 */  0x4093,
/* b2d - _66_0F_C2 */  0x4094,
/* b2e - _F3_0F_C2 */  0x4095,
/* b2f - _F2_0F_C2 */  0x4096,
/* b30 - _V_0F_C2 */  0x4097,
/* b31 - _V_66_0F_C2 */  0x4098,
/* b32 - _V_F3_0F_C2 */  0x4099,
/* b33 - _V_F2_0F_C2 */  0x409a,
/* b34 -  */  0,
/* b35 -  */  0,
/* b36 -  */  0,
/* b37 -  */  0,
/* b38 - _0F_C4 */  0x409b,
/* b39 - _66_0F_C4 */  0x409c,
/* b3a -  */  0,
/* b3b -  */  0,
/* b3c -  */  0,
/* b3d - _V_66_0F_C4 */  0x409d,
/* b3e -  */  0,
/* b3f -  */  0,
/* b40 -  */  0,
/* b41 -  */  0,
/* b42 -  */  0,
/* b43 -  */  0,
/* b44 - _0F_C5 */  0x409e,
/* b45 - _66_0F_C5 */  0x409f,
/* b46 -  */  0,
/* b47 -  */  0,
/* b48 -  */  0,
/* b49 -  */  0,
/* b4a -  */  0,
/* b4b -  */  0,
/* b4c -  */  0,
/* b4d - _NV_66_0F_C5 */  0x40a0,
/* b4e -  */  0,
/* b4f -  */  0,
/* b50 - _0F_C6 */  0x40a1,
/* b51 - _66_0F_C6 */  0x40a2,
/* b52 -  */  0,
/* b53 -  */  0,
/* b54 - _V_0F_C6 */  0x40a3,
/* b55 - _V_66_0F_C6 */  0x40a4,
/* b56 -  */  0,
/* b57 -  */  0,
/* b58 -  */  0,
/* b59 -  */  0,
/* b5a -  */  0,
/* b5b -  */  0,
/* b5c -  */  0,
/* b5d - _0F_C7_01 */  0x40a5,
/* b5e -  */  0,
/* b5f -  */  0,
/* b60 -  */  0,
/* b61 -  */  0,
/* b62 - _0F_C7_06 */  0xd47c,
/* b63 - _0F_C7_07 */  0x240c,
/* b64 -  */  0,
/* b65 - _66_0F_D0 */  0x240d,
/* b66 -  */  0,
/* b67 - _F2_0F_D0 */  0x240e,
/* b68 -  */  0,
/* b69 - _V_66_0F_D0 */  0x40a6,
/* b6a -  */  0,
/* b6b - _V_F2_0F_D0 */  0x40a7,
/* b6c -  */  0,
/* b6d -  */  0,
/* b6e -  */  0,
/* b6f -  */  0,
/* b70 - _0F_D1 */  0x240f,
/* b71 - _66_0F_D1 */  0x2410,
/* b72 -  */  0,
/* b73 -  */  0,
/* b74 -  */  0,
/* b75 - _V_66_0F_D1 */  0x40a8,
/* b76 -  */  0,
/* b77 -  */  0,
/* b78 -  */  0,
/* b79 -  */  0,
/* b7a -  */  0,
/* b7b -  */  0,
/* b7c - _0F_D2 */  0x2411,
/* b7d - _66_0F_D2 */  0x2412,
/* b7e -  */  0,
/* b7f -  */  0,
/* b80 -  */  0,
/* b81 - _V_66_0F_D2 */  0x40a9,
/* b82 -  */  0,
/* b83 -  */  0,
/* b84 -  */  0,
/* b85 -  */  0,
/* b86 -  */  0,
/* b87 -  */  0,
/* b88 - _0F_D3 */  0x2413,
/* b89 - _66_0F_D3 */  0x2414,
/* b8a -  */  0,
/* b8b -  */  0,
/* b8c -  */  0,
/* b8d - _V_66_0F_D3 */  0x40aa,
/* b8e -  */  0,
/* b8f -  */  0,
/* b90 -  */  0,
/* b91 -  */  0,
/* b92 -  */  0,
/* b93 -  */  0,
/* b94 - _0F_D4 */  0x2415,
/* b95 - _66_0F_D4 */  0x2416,
/* b96 -  */  0,
/* b97 -  */  0,
/* b98 -  */  0,
/* b99 - _V_66_0F_D4 */  0x40ab,
/* b9a -  */  0,
/* b9b -  */  0,
/* b9c -  */  0,
/* b9d -  */  0,
/* b9e -  */  0,
/* b9f -  */  0,
/* ba0 - _0F_D5 */  0x2417,
/* ba1 - _66_0F_D5 */  0x2418,
/* ba2 -  */  0,
/* ba3 -  */  0,
/* ba4 -  */  0,
/* ba5 - _V_66_0F_D5 */  0x40ac,
/* ba6 -  */  0,
/* ba7 -  */  0,
/* ba8 -  */  0,
/* ba9 -  */  0,
/* baa -  */  0,
/* bab -  */  0,
/* bac -  */  0,
/* bad - _66_0F_D6 */  0x2419,
/* bae - _F3_0F_D6 */  0x241a,
/* baf - _F2_0F_D6 */  0x241b,
/* bb0 -  */  0,
/* bb1 -  */  0,
/* bb2 -  */  0,
/* bb3 -  */  0,
/* bb4 -  */  0,
/* bb5 - _NV_66_0F_D6 */  0x40ad,
/* bb6 -  */  0,
/* bb7 -  */  0,
/* bb8 - _0F_D7 */  0x241c,
/* bb9 - _66_0F_D7 */  0x241d,
/* bba -  */  0,
/* bbb -  */  0,
/* bbc -  */  0,
/* bbd -  */  0,
/* bbe -  */  0,
/* bbf -  */  0,
/* bc0 -  */  0,
/* bc1 - _NV_66_0F_D7 */  0x40ae,
/* bc2 -  */  0,
/* bc3 -  */  0,
/* bc4 - _0F_D8 */  0x241e,
/* bc5 - _66_0F_D8 */  0x241f,
/* bc6 -  */  0,
/* bc7 -  */  0,
/* bc8 -  */  0,
/* bc9 - _V_66_0F_D8 */  0x40af,
/* bca -  */  0,
/* bcb -  */  0,
/* bcc -  */  0,
/* bcd -  */  0,
/* bce -  */  0,
/* bcf -  */  0,
/* bd0 - _0F_D9 */  0x2420,
/* bd1 - _66_0F_D9 */  0x2421,
/* bd2 -  */  0,
/* bd3 -  */  0,
/* bd4 -  */  0,
/* bd5 - _V_66_0F_D9 */  0x40b0,
/* bd6 -  */  0,
/* bd7 -  */  0,
/* bd8 -  */  0,
/* bd9 -  */  0,
/* bda -  */  0,
/* bdb -  */  0,
/* bdc - _0F_DA */  0x2422,
/* bdd - _66_0F_DA */  0x2423,
/* bde -  */  0,
/* bdf -  */  0,
/* be0 -  */  0,
/* be1 - _V_66_0F_DA */  0x40b1,
/* be2 -  */  0,
/* be3 -  */  0,
/* be4 -  */  0,
/* be5 -  */  0,
/* be6 -  */  0,
/* be7 -  */  0,
/* be8 - _0F_DB */  0x2424,
/* be9 - _66_0F_DB */  0x2425,
/* bea -  */  0,
/* beb -  */  0,
/* bec -  */  0,
/* bed - _V_66_0F_DB */  0x40b2,
/* bee -  */  0,
/* bef -  */  0,
/* bf0 -  */  0,
/* bf1 -  */  0,
/* bf2 -  */  0,
/* bf3 -  */  0,
/* bf4 - _0F_DC */  0x2426,
/* bf5 - _66_0F_DC */  0x2427,
/* bf6 -  */  0,
/* bf7 -  */  0,
/* bf8 -  */  0,
/* bf9 - _V_66_0F_DC */  0x40b3,
/* bfa -  */  0,
/* bfb -  */  0,
/* bfc -  */  0,
/* bfd -  */  0,
/* bfe -  */  0,
/* bff -  */  0,
/* c00 - _0F_DD */  0x2428,
/* c01 - _66_0F_DD */  0x2429,
/* c02 -  */  0,
/* c03 -  */  0,
/* c04 -  */  0,
/* c05 - _V_66_0F_DD */  0x40b4,
/* c06 -  */  0,
/* c07 -  */  0,
/* c08 -  */  0,
/* c09 -  */  0,
/* c0a -  */  0,
/* c0b -  */  0,
/* c0c - _0F_DE */  0x242a,
/* c0d - _66_0F_DE */  0x242b,
/* c0e -  */  0,
/* c0f -  */  0,
/* c10 -  */  0,
/* c11 - _V_66_0F_DE */  0x40b5,
/* c12 -  */  0,
/* c13 -  */  0,
/* c14 -  */  0,
/* c15 -  */  0,
/* c16 -  */  0,
/* c17 -  */  0,
/* c18 - _0F_DF */  0x242c,
/* c19 - _66_0F_DF */  0x242d,
/* c1a -  */  0,
/* c1b -  */  0,
/* c1c -  */  0,
/* c1d - _V_66_0F_DF */  0x40b6,
/* c1e -  */  0,
/* c1f -  */  0,
/* c20 -  */  0,
/* c21 -  */  0,
/* c22 -  */  0,
/* c23 -  */  0,
/* c24 - _0F_E0 */  0x242e,
/* c25 - _66_0F_E0 */  0x242f,
/* c26 -  */  0,
/* c27 -  */  0,
/* c28 -  */  0,
/* c29 - _V_66_0F_E0 */  0x40b7,
/* c2a -  */  0,
/* c2b -  */  0,
/* c2c -  */  0,
/* c2d -  */  0,
/* c2e -  */  0,
/* c2f -  */  0,
/* c30 - _0F_E1 */  0x2430,
/* c31 - _66_0F_E1 */  0x2431,
/* c32 -  */  0,
/* c33 -  */  0,
/* c34 -  */  0,
/* c35 - _V_66_0F_E1 */  0x40b8,
/* c36 -  */  0,
/* c37 -  */  0,
/* c38 -  */  0,
/* c39 -  */  0,
/* c3a -  */  0,
/* c3b -  */  0,
/* c3c - _0F_E2 */  0x2432,
/* c3d - _66_0F_E2 */  0x2433,
/* c3e -  */  0,
/* c3f -  */  0,
/* c40 -  */  0,
/* c41 - _V_66_0F_E2 */  0x40b9,
/* c42 -  */  0,
/* c43 -  */  0,
/* c44 -  */  0,
/* c45 -  */  0,
/* c46 -  */  0,
/* c47 -  */  0,
/* c48 - _0F_E3 */  0x2434,
/* c49 - _66_0F_E3 */  0x2435,
/* c4a -  */  0,
/* c4b -  */  0,
/* c4c -  */  0,
/* c4d - _V_66_0F_E3 */  0x40ba,
/* c4e -  */  0,
/* c4f -  */  0,
/* c50 -  */  0,
/* c51 -  */  0,
/* c52 -  */  0,
/* c53 -  */  0,
/* c54 - _0F_E4 */  0x2436,
/* c55 - _66_0F_E4 */  0x2437,
/* c56 -  */  0,
/* c57 -  */  0,
/* c58 -  */  0,
/* c59 - _V_66_0F_E4 */  0x40bb,
/* c5a -  */  0,
/* c5b -  */  0,
/* c5c -  */  0,
/* c5d -  */  0,
/* c5e -  */  0,
/* c5f -  */  0,
/* c60 - _0F_E5 */  0x2438,
/* c61 - _66_0F_E5 */  0x2439,
/* c62 -  */  0,
/* c63 -  */  0,
/* c64 -  */  0,
/* c65 - _V_66_0F_E5 */  0x40bc,
/* c66 -  */  0,
/* c67 -  */  0,
/* c68 -  */  0,
/* c69 -  */  0,
/* c6a -  */  0,
/* c6b -  */  0,
/* c6c -  */  0,
/* c6d - _66_0F_E6 */  0x243a,
/* c6e - _F3_0F_E6 */  0x243b,
/* c6f - _F2_0F_E6 */  0x243c,
/* c70 -  */  0,
/* c71 -  */  0,
/* c72 -  */  0,
/* c73 -  */  0,
/* c74 -  */  0,
/* c75 - _NV_66_0F_E6 */  0x40bd,
/* c76 - _NV_F3_0F_E6 */  0x40be,
/* c77 - _NV_F2_0F_E6 */  0x40bf,
/* c78 - _0F_E7 */  0x243d,
/* c79 - _66_0F_E7 */  0x243e,
/* c7a -  */  0,
/* c7b -  */  0,
/* c7c -  */  0,
/* c7d -  */  0,
/* c7e -  */  0,
/* c7f -  */  0,
/* c80 -  */  0,
/* c81 - _NV_66_0F_E7 */  0x40c0,
/* c82 -  */  0,
/* c83 -  */  0,
/* c84 - _0F_E8 */  0x243f,
/* c85 - _66_0F_E8 */  0x2440,
/* c86 -  */  0,
/* c87 -  */  0,
/* c88 -  */  0,
/* c89 - _V_66_0F_E8 */  0x40c1,
/* c8a -  */  0,
/* c8b -  */  0,
/* c8c -  */  0,
/* c8d -  */  0,
/* c8e -  */  0,
/* c8f -  */  0,
/* c90 - _0F_E9 */  0x2441,
/* c91 - _66_0F_E9 */  0x2442,
/* c92 -  */  0,
/* c93 -  */  0,
/* c94 -  */  0,
/* c95 - _V_66_0F_E9 */  0x40c2,
/* c96 -  */  0,
/* c97 -  */  0,
/* c98 -  */  0,
/* c99 -  */  0,
/* c9a -  */  0,
/* c9b -  */  0,
/* c9c - _0F_EA */  0x2443,
/* c9d - _66_0F_EA */  0x2444,
/* c9e -  */  0,
/* c9f -  */  0,
/* ca0 -  */  0,
/* ca1 - _V_66_0F_EA */  0x40c3,
/* ca2 -  */  0,
/* ca3 -  */  0,
/* ca4 -  */  0,
/* ca5 -  */  0,
/* ca6 -  */  0,
/* ca7 -  */  0,
/* ca8 - _0F_EB */  0x2445,
/* ca9 - _66_0F_EB */  0x2446,
/* caa -  */  0,
/* cab -  */  0,
/* cac -  */  0,
/* cad - _V_66_0F_EB */  0x40c4,
/* cae -  */  0,
/* caf -  */  0,
/* cb0 -  */  0,
/* cb1 -  */  0,
/* cb2 -  */  0,
/* cb3 -  */  0,
/* cb4 - _0F_EC */  0x2447,
/* cb5 - _66_0F_EC */  0x2448,
/* cb6 -  */  0,
/* cb7 -  */  0,
/* cb8 -  */  0,
/* cb9 - _V_66_0F_EC */  0x40c5,
/* cba -  */  0,
/* cbb -  */  0,
/* cbc -  */  0,
/* cbd -  */  0,
/* cbe -  */  0,
/* cbf -  */  0,
/* cc0 - _0F_ED */  0x2449,
/* cc1 - _66_0F_ED */  0x244a,
/* cc2 -  */  0,
/* cc3 -  */  0,
/* cc4 -  */  0,
/* cc5 - _V_66_0F_ED */  0x40c6,
/* cc6 -  */  0,
/* cc7 -  */  0,
/* cc8 -  */  0,
/* cc9 -  */  0,
/* cca -  */  0,
/* ccb -  */  0,
/* ccc - _0F_EE */  0x244b,
/* ccd - _66_0F_EE */  0x244c,
/* cce -  */  0,
/* ccf -  */  0,
/* cd0 -  */  0,
/* cd1 - _V_66_0F_EE */  0x40c7,
/* cd2 -  */  0,
/* cd3 -  */  0,
/* cd4 -  */  0,
/* cd5 -  */  0,
/* cd6 -  */  0,
/* cd7 -  */  0,
/* cd8 - _0F_EF */  0x244d,
/* cd9 - _66_0F_EF */  0x244e,
/* cda -  */  0,
/* cdb -  */  0,
/* cdc -  */  0,
/* cdd - _V_66_0F_EF */  0x40c8,
/* cde -  */  0,
/* cdf -  */  0,
/* ce0 -  */  0,
/* ce1 -  */  0,
/* ce2 -  */  0,
/* ce3 -  */  0,
/* ce4 -  */  0,
/* ce5 -  */  0,
/* ce6 -  */  0,
/* ce7 - _F2_0F_F0 */  0x244f,
/* ce8 -  */  0,
/* ce9 -  */  0,
/* cea -  */  0,
/* ceb -  */  0,
/* cec -  */  0,
/* ced -  */  0,
/* cee -  */  0,
/* cef - _NV_F2_0F_F0 */  0x40c9,
/* cf0 - _0F_F1 */  0x2450,
/* cf1 - _66_0F_F1 */  0x2451,
/* cf2 -  */  0,
/* cf3 -  */  0,
/* cf4 -  */  0,
/* cf5 - _V_66_0F_F1 */  0x40ca,
/* cf6 -  */  0,
/* cf7 -  */  0,
/* cf8 -  */  0,
/* cf9 -  */  0,
/* cfa -  */  0,
/* cfb -  */  0,
/* cfc - _0F_F2 */  0x2452,
/* cfd - _66_0F_F2 */  0x2453,
/* cfe -  */  0,
/* cff -  */  0,
/* d00 -  */  0,
/* d01 - _V_66_0F_F2 */  0x40cb,
/* d02 -  */  0,
/* d03 -  */  0,
/* d04 -  */  0,
/* d05 -  */  0,
/* d06 -  */  0,
/* d07 -  */  0,
/* d08 - _0F_F3 */  0x2454,
/* d09 - _66_0F_F3 */  0x2455,
/* d0a -  */  0,
/* d0b -  */  0,
/* d0c -  */  0,
/* d0d - _V_66_0F_F3 */  0x40cc,
/* d0e -  */  0,
/* d0f -  */  0,
/* d10 -  */  0,
/* d11 -  */  0,
/* d12 -  */  0,
/* d13 -  */  0,
/* d14 - _0F_F4 */  0x2456,
/* d15 - _66_0F_F4 */  0x2457,
/* d16 -  */  0,
/* d17 -  */  0,
/* d18 -  */  0,
/* d19 - _V_66_0F_F4 */  0x40cd,
/* d1a -  */  0,
/* d1b -  */  0,
/* d1c -  */  0,
/* d1d -  */  0,
/* d1e -  */  0,
/* d1f -  */  0,
/* d20 - _0F_F5 */  0x2458,
/* d21 - _66_0F_F5 */  0x2459,
/* d22 -  */  0,
/* d23 -  */  0,
/* d24 -  */  0,
/* d25 - _V_66_0F_F5 */  0x40ce,
/* d26 -  */  0,
/* d27 -  */  0,
/* d28 -  */  0,
/* d29 -  */  0,
/* d2a -  */  0,
/* d2b -  */  0,
/* d2c - _0F_F6 */  0x245a,
/* d2d - _66_0F_F6 */  0x245b,
/* d2e -  */  0,
/* d2f -  */  0,
/* d30 -  */  0,
/* d31 - _V_66_0F_F6 */  0x40cf,
/* d32 -  */  0,
/* d33 -  */  0,
/* d34 -  */  0,
/* d35 -  */  0,
/* d36 -  */  0,
/* d37 -  */  0,
/* d38 - _0F_F7 */  0x245c,
/* d39 - _66_0F_F7 */  0x245d,
/* d3a -  */  0,
/* d3b -  */  0,
/* d3c -  */  0,
/* d3d -  */  0,
/* d3e -  */  0,
/* d3f -  */  0,
/* d40 -  */  0,
/* d41 - _NV_66_0F_F7 */  0x40d0,
/* d42 -  */  0,
/* d43 -  */  0,
/* d44 - _0F_F8 */  0x245e,
/* d45 - _66_0F_F8 */  0x245f,
/* d46 -  */  0,
/* d47 -  */  0,
/* d48 -  */  0,
/* d49 - _V_66_0F_F8 */  0x40d1,
/* d4a -  */  0,
/* d4b -  */  0,
/* d4c -  */  0,
/* d4d -  */  0,
/* d4e -  */  0,
/* d4f -  */  0,
/* d50 - _0F_F9 */  0x2460,
/* d51 - _66_0F_F9 */  0x2461,
/* d52 -  */  0,
/* d53 -  */  0,
/* d54 -  */  0,
/* d55 - _V_66_0F_F9 */  0x40d2,
/* d56 -  */  0,
/* d57 -  */  0,
/* d58 -  */  0,
/* d59 -  */  0,
/* d5a -  */  0,
/* d5b -  */  0,
/* d5c - _0F_FA */  0x2462,
/* d5d - _66_0F_FA */  0x2463,
/* d5e -  */  0,
/* d5f -  */  0,
/* d60 -  */  0,
/* d61 - _V_66_0F_FA */  0x40d3,
/* d62 -  */  0,
/* d63 -  */  0,
/* d64 -  */  0,
/* d65 -  */  0,
/* d66 -  */  0,
/* d67 -  */  0,
/* d68 - _0F_FB */  0x2464,
/* d69 - _66_0F_FB */  0x2465,
/* d6a -  */  0,
/* d6b -  */  0,
/* d6c -  */  0,
/* d6d - _V_66_0F_FB */  0x40d4,
/* d6e -  */  0,
/* d6f -  */  0,
/* d70 -  */  0,
/* d71 -  */  0,
/* d72 -  */  0,
/* d73 -  */  0,
/* d74 - _0F_FC */  0x2466,
/* d75 - _66_0F_FC */  0x2467,
/* d76 -  */  0,
/* d77 -  */  0,
/* d78 -  */  0,
/* d79 - _V_66_0F_FC */  0x40d5,
/* d7a -  */  0,
/* d7b -  */  0,
/* d7c -  */  0,
/* d7d -  */  0,
/* d7e -  */  0,
/* d7f -  */  0,
/* d80 - _0F_FD */  0x2468,
/* d81 - _66_0F_FD */  0x2469,
/* d82 -  */  0,
/* d83 -  */  0,
/* d84 -  */  0,
/* d85 - _V_66_0F_FD */  0x40d6,
/* d86 -  */  0,
/* d87 -  */  0,
/* d88 -  */  0,
/* d89 -  */  0,
/* d8a -  */  0,
/* d8b -  */  0,
/* d8c - _0F_FE */  0x246a,
/* d8d - _66_0F_FE */  0x246b,
/* d8e -  */  0,
/* d8f -  */  0,
/* d90 -  */  0,
/* d91 - _V_66_0F_FE */  0x40d7,
/* d92 -  */  0,
/* d93 -  */  0,
/* d94 -  */  0,
/* d95 -  */  0,
/* d96 -  */  0,
/* d97 -  */  0,
/* d98 - _D9_06 */  0x246c,
/* d99 - _9B_D9_06 */  0x246d,
/* d9a -  */  0,
/* d9b -  */  0,
/* d9c -  */  0,
/* d9d -  */  0,
/* d9e -  */  0,
/* d9f -  */  0,
/* da0 -  */  0,
/* da1 -  */  0,
/* da2 -  */  0,
/* da3 -  */  0,
/* da4 - _D9_07 */  0x246e,
/* da5 - _9B_D9_07 */  0x246f,
/* da6 -  */  0,
/* da7 -  */  0,
/* da8 -  */  0,
/* da9 -  */  0,
/* daa -  */  0,
/* dab -  */  0,
/* dac -  */  0,
/* dad -  */  0,
/* dae -  */  0,
/* daf -  */  0,
/* db0 - _DB_E2 */  0x2470,
/* db1 - _9B_DB_E2 */  0x2471,
/* db2 -  */  0,
/* db3 -  */  0,
/* db4 -  */  0,
/* db5 -  */  0,
/* db6 -  */  0,
/* db7 -  */  0,
/* db8 -  */  0,
/* db9 -  */  0,
/* dba -  */  0,
/* dbb -  */  0,
/* dbc - _DB_E3 */  0x2472,
/* dbd - _9B_DB_E3 */  0x2473,
/* dbe -  */  0,
/* dbf -  */  0,
/* dc0 -  */  0,
/* dc1 -  */  0,
/* dc2 -  */  0,
/* dc3 -  */  0,
/* dc4 -  */  0,
/* dc5 -  */  0,
/* dc6 -  */  0,
/* dc7 -  */  0,
/* dc8 - _DD_06 */  0x2474,
/* dc9 - _9B_DD_06 */  0x2475,
/* dca -  */  0,
/* dcb -  */  0,
/* dcc -  */  0,
/* dcd -  */  0,
/* dce -  */  0,
/* dcf -  */  0,
/* dd0 -  */  0,
/* dd1 -  */  0,
/* dd2 -  */  0,
/* dd3 -  */  0,
/* dd4 - _DD_07 */  0x2476,
/* dd5 - _9B_DD_07 */  0x2477,
/* dd6 -  */  0,
/* dd7 -  */  0,
/* dd8 -  */  0,
/* dd9 -  */  0,
/* dda -  */  0,
/* ddb -  */  0,
/* ddc -  */  0,
/* ddd -  */  0,
/* dde -  */  0,
/* ddf -  */  0,
/* de0 - _DF_E0 */  0x2478,
/* de1 - _9B_DF_E0 */  0x2479,
/* de2 -  */  0,
/* de3 -  */  0,
/* de4 -  */  0,
/* de5 -  */  0,
/* de6 -  */  0,
/* de7 -  */  0,
/* de8 -  */  0,
/* de9 -  */  0,
/* dea -  */  0,
/* deb -  */  0,
/* dec - _0F_38_00 */  0x247a,
/* ded - _66_0F_38_00 */  0x247b,
/* dee -  */  0,
/* def -  */  0,
/* df0 -  */  0,
/* df1 - _V_66_0F_38_00 */  0x40d8,
/* df2 -  */  0,
/* df3 -  */  0,
/* df4 -  */  0,
/* df5 -  */  0,
/* df6 -  */  0,
/* df7 -  */  0,
/* df8 - _0F_38_01 */  0x247c,
/* df9 - _66_0F_38_01 */  0x247d,
/* dfa -  */  0,
/* dfb -  */  0,
/* dfc -  */  0,
/* dfd - _V_66_0F_38_01 */  0x40d9,
/* dfe -  */  0,
/* dff -  */  0,
/* e00 -  */  0,
/* e01 -  */  0,
/* e02 -  */  0,
/* e03 -  */  0,
/* e04 - _0F_38_02 */  0x247e,
/* e05 - _66_0F_38_02 */  0x247f,
/* e06 -  */  0,
/* e07 -  */  0,
/* e08 -  */  0,
/* e09 - _V_66_0F_38_02 */  0x40da,
/* e0a -  */  0,
/* e0b -  */  0,
/* e0c -  */  0,
/* e0d -  */  0,
/* e0e -  */  0,
/* e0f -  */  0,
/* e10 - _0F_38_03 */  0x2480,
/* e11 - _66_0F_38_03 */  0x2481,
/* e12 -  */  0,
/* e13 -  */  0,
/* e14 -  */  0,
/* e15 - _V_66_0F_38_03 */  0x40db,
/* e16 -  */  0,
/* e17 -  */  0,
/* e18 -  */  0,
/* e19 -  */  0,
/* e1a -  */  0,
/* e1b -  */  0,
/* e1c - _0F_38_04 */  0x2482,
/* e1d - _66_0F_38_04 */  0x2483,
/* e1e -  */  0,
/* e1f -  */  0,
/* e20 -  */  0,
/* e21 - _V_66_0F_38_04 */  0x40dc,
/* e22 -  */  0,
/* e23 -  */  0,
/* e24 -  */  0,
/* e25 -  */  0,
/* e26 -  */  0,
/* e27 -  */  0,
/* e28 - _0F_38_05 */  0x2484,
/* e29 - _66_0F_38_05 */  0x2485,
/* e2a -  */  0,
/* e2b -  */  0,
/* e2c -  */  0,
/* e2d - _V_66_0F_38_05 */  0x40dd,
/* e2e -  */  0,
/* e2f -  */  0,
/* e30 -  */  0,
/* e31 -  */  0,
/* e32 -  */  0,
/* e33 -  */  0,
/* e34 - _0F_38_06 */  0x2486,
/* e35 - _66_0F_38_06 */  0x2487,
/* e36 -  */  0,
/* e37 -  */  0,
/* e38 -  */  0,
/* e39 - _V_66_0F_38_06 */  0x40de,
/* e3a -  */  0,
/* e3b -  */  0,
/* e3c -  */  0,
/* e3d -  */  0,
/* e3e -  */  0,
/* e3f -  */  0,
/* e40 - _0F_38_07 */  0x2488,
/* e41 - _66_0F_38_07 */  0x2489,
/* e42 -  */  0,
/* e43 -  */  0,
/* e44 -  */  0,
/* e45 - _V_66_0F_38_07 */  0x40df,
/* e46 -  */  0,
/* e47 -  */  0,
/* e48 -  */  0,
/* e49 -  */  0,
/* e4a -  */  0,
/* e4b -  */  0,
/* e4c - _0F_38_08 */  0x248a,
/* e4d - _66_0F_38_08 */  0x248b,
/* e4e -  */  0,
/* e4f -  */  0,
/* e50 -  */  0,
/* e51 - _V_66_0F_38_08 */  0x40e0,
/* e52 -  */  0,
/* e53 -  */  0,
/* e54 -  */  0,
/* e55 -  */  0,
/* e56 -  */  0,
/* e57 -  */  0,
/* e58 - _0F_38_09 */  0x248c,
/* e59 - _66_0F_38_09 */  0x248d,
/* e5a -  */  0,
/* e5b -  */  0,
/* e5c -  */  0,
/* e5d - _V_66_0F_38_09 */  0x40e1,
/* e5e -  */  0,
/* e5f -  */  0,
/* e60 -  */  0,
/* e61 -  */  0,
/* e62 -  */  0,
/* e63 -  */  0,
/* e64 - _0F_38_0A */  0x248e,
/* e65 - _66_0F_38_0A */  0x248f,
/* e66 -  */  0,
/* e67 -  */  0,
/* e68 -  */  0,
/* e69 - _V_66_0F_38_0A */  0x40e2,
/* e6a -  */  0,
/* e6b -  */  0,
/* e6c -  */  0,
/* e6d -  */  0,
/* e6e -  */  0,
/* e6f -  */  0,
/* e70 - _0F_38_0B */  0x2490,
/* e71 - _66_0F_38_0B */  0x2491,
/* e72 -  */  0,
/* e73 -  */  0,
/* e74 -  */  0,
/* e75 - _V_66_0F_38_0B */  0x40e3,
/* e76 -  */  0,
/* e77 -  */  0,
/* e78 -  */  0,
/* e79 -  */  0,
/* e7a -  */  0,
/* e7b -  */  0,
/* e7c -  */  0,
/* e7d -  */  0,
/* e7e -  */  0,
/* e7f -  */  0,
/* e80 -  */  0,
/* e81 - _V_66_0F_38_0C */  0x40e4,
/* e82 -  */  0,
/* e83 -  */  0,
/* e84 -  */  0,
/* e85 -  */  0,
/* e86 -  */  0,
/* e87 -  */  0,
/* e88 -  */  0,
/* e89 -  */  0,
/* e8a -  */  0,
/* e8b -  */  0,
/* e8c -  */  0,
/* e8d - _V_66_0F_38_0D */  0x40e5,
/* e8e -  */  0,
/* e8f -  */  0,
/* e90 -  */  0,
/* e91 -  */  0,
/* e92 -  */  0,
/* e93 -  */  0,
/* e94 -  */  0,
/* e95 -  */  0,
/* e96 -  */  0,
/* e97 -  */  0,
/* e98 -  */  0,
/* e99 -  */  0,
/* e9a -  */  0,
/* e9b -  */  0,
/* e9c -  */  0,
/* e9d - _NV_66_0F_38_0E */  0x40e6,
/* e9e -  */  0,
/* e9f -  */  0,
/* ea0 -  */  0,
/* ea1 -  */  0,
/* ea2 -  */  0,
/* ea3 -  */  0,
/* ea4 -  */  0,
/* ea5 -  */  0,
/* ea6 -  */  0,
/* ea7 -  */  0,
/* ea8 -  */  0,
/* ea9 - _NV_66_0F_38_0F */  0x40e7,
/* eaa -  */  0,
/* eab -  */  0,
/* eac -  */  0,
/* ead - _66_0F_38_10 */  0x40e8,
/* eae -  */  0,
/* eaf -  */  0,
/* eb0 -  */  0,
/* eb1 -  */  0,
/* eb2 -  */  0,
/* eb3 -  */  0,
/* eb4 -  */  0,
/* eb5 -  */  0,
/* eb6 -  */  0,
/* eb7 -  */  0,
/* eb8 -  */  0,
/* eb9 - _66_0F_38_14 */  0x40e9,
/* eba -  */  0,
/* ebb -  */  0,
/* ebc -  */  0,
/* ebd -  */  0,
/* ebe -  */  0,
/* ebf -  */  0,
/* ec0 -  */  0,
/* ec1 -  */  0,
/* ec2 -  */  0,
/* ec3 -  */  0,
/* ec4 -  */  0,
/* ec5 - _66_0F_38_15 */  0x40ea,
/* ec6 -  */  0,
/* ec7 -  */  0,
/* ec8 -  */  0,
/* ec9 -  */  0,
/* eca -  */  0,
/* ecb -  */  0,
/* ecc -  */  0,
/* ecd -  */  0,
/* ece -  */  0,
/* ecf -  */  0,
/* ed0 -  */  0,
/* ed1 - _66_0F_38_17 */  0x2492,
/* ed2 -  */  0,
/* ed3 -  */  0,
/* ed4 -  */  0,
/* ed5 -  */  0,
/* ed6 -  */  0,
/* ed7 -  */  0,
/* ed8 -  */  0,
/* ed9 - _NV_66_0F_38_17 */  0x40eb,
/* eda -  */  0,
/* edb -  */  0,
/* edc -  */  0,
/* edd -  */  0,
/* ede -  */  0,
/* edf -  */  0,
/* ee0 -  */  0,
/* ee1 -  */  0,
/* ee2 -  */  0,
/* ee3 -  */  0,
/* ee4 -  */  0,
/* ee5 - _NV_66_0F_38_18 */  0x40ec,
/* ee6 -  */  0,
/* ee7 -  */  0,
/* ee8 -  */  0,
/* ee9 -  */  0,
/* eea -  */  0,
/* eeb -  */  0,
/* eec -  */  0,
/* eed -  */  0,
/* eee -  */  0,
/* eef -  */  0,
/* ef0 -  */  0,
/* ef1 - _NV_66_0F_38_19 */  0x40ed,
/* ef2 -  */  0,
/* ef3 -  */  0,
/* ef4 -  */  0,
/* ef5 -  */  0,
/* ef6 -  */  0,
/* ef7 -  */  0,
/* ef8 -  */  0,
/* ef9 -  */  0,
/* efa -  */  0,
/* efb -  */  0,
/* efc -  */  0,
/* efd - _NV_66_0F_38_1A */  0x40ee,
/* efe -  */  0,
/* eff -  */  0,
/* f00 - _0F_38_1C */  0x2493,
/* f01 - _66_0F_38_1C */  0x2494,
/* f02 -  */  0,
/* f03 -  */  0,
/* f04 -  */  0,
/* f05 -  */  0,
/* f06 -  */  0,
/* f07 -  */  0,
/* f08 -  */  0,
/* f09 - _NV_66_0F_38_1C */  0x40ef,
/* f0a -  */  0,
/* f0b -  */  0,
/* f0c - _0F_38_1D */  0x2495,
/* f0d - _66_0F_38_1D */  0x2496,
/* f0e -  */  0,
/* f0f -  */  0,
/* f10 -  */  0,
/* f11 -  */  0,
/* f12 -  */  0,
/* f13 -  */  0,
/* f14 -  */  0,
/* f15 - _NV_66_0F_38_1D */  0x40f0,
/* f16 -  */  0,
/* f17 -  */  0,
/* f18 - _0F_38_1E */  0x2497,
/* f19 - _66_0F_38_1E */  0x2498,
/* f1a -  */  0,
/* f1b -  */  0,
/* f1c -  */  0,
/* f1d -  */  0,
/* f1e -  */  0,
/* f1f -  */  0,
/* f20 -  */  0,
/* f21 - _NV_66_0F_38_1E */  0x40f1,
/* f22 -  */  0,
/* f23 -  */  0,
/* f24 -  */  0,
/* f25 - _66_0F_38_20 */  0x2499,
/* f26 -  */  0,
/* f27 -  */  0,
/* f28 -  */  0,
/* f29 -  */  0,
/* f2a -  */  0,
/* f2b -  */  0,
/* f2c -  */  0,
/* f2d - _NV_66_0F_38_20 */  0x40f2,
/* f2e -  */  0,
/* f2f -  */  0,
/* f30 -  */  0,
/* f31 - _66_0F_38_21 */  0x249a,
/* f32 -  */  0,
/* f33 -  */  0,
/* f34 -  */  0,
/* f35 -  */  0,
/* f36 -  */  0,
/* f37 -  */  0,
/* f38 -  */  0,
/* f39 - _NV_66_0F_38_21 */  0x40f3,
/* f3a -  */  0,
/* f3b -  */  0,
/* f3c -  */  0,
/* f3d - _66_0F_38_22 */  0x249b,
/* f3e -  */  0,
/* f3f -  */  0,
/* f40 -  */  0,
/* f41 -  */  0,
/* f42 -  */  0,
/* f43 -  */  0,
/* f44 -  */  0,
/* f45 - _NV_66_0F_38_22 */  0x40f4,
/* f46 -  */  0,
/* f47 -  */  0,
/* f48 -  */  0,
/* f49 - _66_0F_38_23 */  0x249c,
/* f4a -  */  0,
/* f4b -  */  0,
/* f4c -  */  0,
/* f4d -  */  0,
/* f4e -  */  0,
/* f4f -  */  0,
/* f50 -  */  0,
/* f51 - _NV_66_0F_38_23 */  0x40f5,
/* f52 -  */  0,
/* f53 -  */  0,
/* f54 -  */  0,
/* f55 - _66_0F_38_24 */  0x249d,
/* f56 -  */  0,
/* f57 -  */  0,
/* f58 -  */  0,
/* f59 -  */  0,
/* f5a -  */  0,
/* f5b -  */  0,
/* f5c -  */  0,
/* f5d - _NV_66_0F_38_24 */  0x40f6,
/* f5e -  */  0,
/* f5f -  */  0,
/* f60 -  */  0,
/* f61 - _66_0F_38_25 */  0x249e,
/* f62 -  */  0,
/* f63 -  */  0,
/* f64 -  */  0,
/* f65 -  */  0,
/* f66 -  */  0,
/* f67 -  */  0,
/* f68 -  */  0,
/* f69 - _NV_66_0F_38_25 */  0x40f7,
/* f6a -  */  0,
/* f6b -  */  0,
/* f6c -  */  0,
/* f6d - _66_0F_38_28 */  0x249f,
/* f6e -  */  0,
/* f6f -  */  0,
/* f70 -  */  0,
/* f71 - _V_66_0F_38_28 */  0x40f8,
/* f72 -  */  0,
/* f73 -  */  0,
/* f74 -  */  0,
/* f75 -  */  0,
/* f76 -  */  0,
/* f77 -  */  0,
/* f78 -  */  0,
/* f79 - _66_0F_38_29 */  0x24a0,
/* f7a -  */  0,
/* f7b -  */  0,
/* f7c -  */  0,
/* f7d - _V_66_0F_38_29 */  0x40f9,
/* f7e -  */  0,
/* f7f -  */  0,
/* f80 -  */  0,
/* f81 -  */  0,
/* f82 -  */  0,
/* f83 -  */  0,
/* f84 -  */  0,
/* f85 - _66_0F_38_2A */  0x24a1,
/* f86 -  */  0,
/* f87 -  */  0,
/* f88 -  */  0,
/* f89 -  */  0,
/* f8a -  */  0,
/* f8b -  */  0,
/* f8c -  */  0,
/* f8d - _NV_66_0F_38_2A */  0x40fa,
/* f8e -  */  0,
/* f8f -  */  0,
/* f90 -  */  0,
/* f91 - _66_0F_38_2B */  0x24a2,
/* f92 -  */  0,
/* f93 -  */  0,
/* f94 -  */  0,
/* f95 - _V_66_0F_38_2B */  0x40fb,
/* f96 -  */  0,
/* f97 -  */  0,
/* f98 -  */  0,
/* f99 -  */  0,
/* f9a -  */  0,
/* f9b -  */  0,
/* f9c -  */  0,
/* f9d -  */  0,
/* f9e -  */  0,
/* f9f -  */  0,
/* fa0 -  */  0,
/* fa1 - _V_66_0F_38_2C */  0x40fc,
/* fa2 -  */  0,
/* fa3 -  */  0,
/* fa4 -  */  0,
/* fa5 -  */  0,
/* fa6 -  */  0,
/* fa7 -  */  0,
/* fa8 -  */  0,
/* fa9 -  */  0,
/* faa -  */  0,
/* fab -  */  0,
/* fac -  */  0,
/* fad - _V_66_0F_38_2D */  0x40fd,
/* fae -  */  0,
/* faf -  */  0,
/* fb0 -  */  0,
/* fb1 -  */  0,
/* fb2 -  */  0,
/* fb3 -  */  0,
/* fb4 -  */  0,
/* fb5 -  */  0,
/* fb6 -  */  0,
/* fb7 -  */  0,
/* fb8 -  */  0,
/* fb9 - _V_66_0F_38_2E */  0x40fe,
/* fba -  */  0,
/* fbb -  */  0,
/* fbc -  */  0,
/* fbd -  */  0,
/* fbe -  */  0,
/* fbf -  */  0,
/* fc0 -  */  0,
/* fc1 -  */  0,
/* fc2 -  */  0,
/* fc3 -  */  0,
/* fc4 -  */  0,
/* fc5 - _V_66_0F_38_2F */  0x40ff,
/* fc6 -  */  0,
/* fc7 -  */  0,
/* fc8 -  */  0,
/* fc9 -  */  0,
/* fca -  */  0,
/* fcb -  */  0,
/* fcc -  */  0,
/* fcd - _66_0F_38_30 */  0x24a3,
/* fce -  */  0,
/* fcf -  */  0,
/* fd0 -  */  0,
/* fd1 -  */  0,
/* fd2 -  */  0,
/* fd3 -  */  0,
/* fd4 -  */  0,
/* fd5 - _NV_66_0F_38_30 */  0x4100,
/* fd6 -  */  0,
/* fd7 -  */  0,
/* fd8 -  */  0,
/* fd9 - _66_0F_38_31 */  0x24a4,
/* fda -  */  0,
/* fdb -  */  0,
/* fdc -  */  0,
/* fdd -  */  0,
/* fde -  */  0,
/* fdf -  */  0,
/* fe0 -  */  0,
/* fe1 - _NV_66_0F_38_31 */  0x4101,
/* fe2 -  */  0,
/* fe3 -  */  0,
/* fe4 -  */  0,
/* fe5 - _66_0F_38_32 */  0x24a5,
/* fe6 -  */  0,
/* fe7 -  */  0,
/* fe8 -  */  0,
/* fe9 -  */  0,
/* fea -  */  0,
/* feb -  */  0,
/* fec -  */  0,
/* fed - _NV_66_0F_38_32 */  0x4102,
/* fee -  */  0,
/* fef -  */  0,
/* ff0 -  */  0,
/* ff1 - _66_0F_38_33 */  0x24a6,
/* ff2 -  */  0,
/* ff3 -  */  0,
/* ff4 -  */  0,
/* ff5 -  */  0,
/* ff6 -  */  0,
/* ff7 -  */  0,
/* ff8 -  */  0,
/* ff9 - _NV_66_0F_38_33 */  0x4103,
/* ffa -  */  0,
/* ffb -  */  0,
/* ffc -  */  0,
/* ffd - _66_0F_38_34 */  0x24a7,
/* ffe -  */  0,
/* fff -  */  0,
/* 1000 -  */  0,
/* 1001 -  */  0,
/* 1002 -  */  0,
/* 1003 -  */  0,
/* 1004 -  */  0,
/* 1005 - _NV_66_0F_38_34 */  0x4104,
/* 1006 -  */  0,
/* 1007 -  */  0,
/* 1008 -  */  0,
/* 1009 - _66_0F_38_35 */  0x24a8,
/* 100a -  */  0,
/* 100b -  */  0,
/* 100c -  */  0,
/* 100d -  */  0,
/* 100e -  */  0,
/* 100f -  */  0,
/* 1010 -  */  0,
/* 1011 - _NV_66_0F_38_35 */  0x4105,
/* 1012 -  */  0,
/* 1013 -  */  0,
/* 1014 -  */  0,
/* 1015 - _66_0F_38_37 */  0x24a9,
/* 1016 -  */  0,
/* 1017 -  */  0,
/* 1018 -  */  0,
/* 1019 - _V_66_0F_38_37 */  0x4106,
/* 101a -  */  0,
/* 101b -  */  0,
/* 101c -  */  0,
/* 101d -  */  0,
/* 101e -  */  0,
/* 101f -  */  0,
/* 1020 -  */  0,
/* 1021 - _66_0F_38_38 */  0x24aa,
/* 1022 -  */  0,
/* 1023 -  */  0,
/* 1024 -  */  0,
/* 1025 - _V_66_0F_38_38 */  0x4107,
/* 1026 -  */  0,
/* 1027 -  */  0,
/* 1028 -  */  0,
/* 1029 -  */  0,
/* 102a -  */  0,
/* 102b -  */  0,
/* 102c -  */  0,
/* 102d - _66_0F_38_39 */  0x24ab,
/* 102e -  */  0,
/* 102f -  */  0,
/* 1030 -  */  0,
/* 1031 - _V_66_0F_38_39 */  0x4108,
/* 1032 -  */  0,
/* 1033 -  */  0,
/* 1034 -  */  0,
/* 1035 -  */  0,
/* 1036 -  */  0,
/* 1037 -  */  0,
/* 1038 -  */  0,
/* 1039 - _66_0F_38_3A */  0x24ac,
/* 103a -  */  0,
/* 103b -  */  0,
/* 103c -  */  0,
/* 103d - _V_66_0F_38_3A */  0x4109,
/* 103e -  */  0,
/* 103f -  */  0,
/* 1040 -  */  0,
/* 1041 -  */  0,
/* 1042 -  */  0,
/* 1043 -  */  0,
/* 1044 -  */  0,
/* 1045 - _66_0F_38_3B */  0x24ad,
/* 1046 -  */  0,
/* 1047 -  */  0,
/* 1048 -  */  0,
/* 1049 - _V_66_0F_38_3B */  0x410a,
/* 104a -  */  0,
/* 104b -  */  0,
/* 104c -  */  0,
/* 104d -  */  0,
/* 104e -  */  0,
/* 104f -  */  0,
/* 1050 -  */  0,
/* 1051 - _66_0F_38_3C */  0x24ae,
/* 1052 -  */  0,
/* 1053 -  */  0,
/* 1054 -  */  0,
/* 1055 - _V_66_0F_38_3C */  0x410b,
/* 1056 -  */  0,
/* 1057 -  */  0,
/* 1058 -  */  0,
/* 1059 -  */  0,
/* 105a -  */  0,
/* 105b -  */  0,
/* 105c -  */  0,
/* 105d - _66_0F_38_3D */  0x24af,
/* 105e -  */  0,
/* 105f -  */  0,
/* 1060 -  */  0,
/* 1061 - _V_66_0F_38_3D */  0x410c,
/* 1062 -  */  0,
/* 1063 -  */  0,
/* 1064 -  */  0,
/* 1065 -  */  0,
/* 1066 -  */  0,
/* 1067 -  */  0,
/* 1068 -  */  0,
/* 1069 - _66_0F_38_3E */  0x24b0,
/* 106a -  */  0,
/* 106b -  */  0,
/* 106c -  */  0,
/* 106d - _V_66_0F_38_3E */  0x410d,
/* 106e -  */  0,
/* 106f -  */  0,
/* 1070 -  */  0,
/* 1071 -  */  0,
/* 1072 -  */  0,
/* 1073 -  */  0,
/* 1074 -  */  0,
/* 1075 - _66_0F_38_3F */  0x24b1,
/* 1076 -  */  0,
/* 1077 -  */  0,
/* 1078 -  */  0,
/* 1079 - _V_66_0F_38_3F */  0x410e,
/* 107a -  */  0,
/* 107b -  */  0,
/* 107c -  */  0,
/* 107d -  */  0,
/* 107e -  */  0,
/* 107f -  */  0,
/* 1080 -  */  0,
/* 1081 - _66_0F_38_40 */  0x24b2,
/* 1082 -  */  0,
/* 1083 -  */  0,
/* 1084 -  */  0,
/* 1085 - _V_66_0F_38_40 */  0x410f,
/* 1086 -  */  0,
/* 1087 -  */  0,
/* 1088 -  */  0,
/* 1089 -  */  0,
/* 108a -  */  0,
/* 108b -  */  0,
/* 108c -  */  0,
/* 108d - _66_0F_38_41 */  0x24b3,
/* 108e -  */  0,
/* 108f -  */  0,
/* 1090 -  */  0,
/* 1091 -  */  0,
/* 1092 -  */  0,
/* 1093 -  */  0,
/* 1094 -  */  0,
/* 1095 - _NV_66_0F_38_41 */  0x4110,
/* 1096 -  */  0,
/* 1097 -  */  0,
/* 1098 -  */  0,
/* 1099 - _66_0F_38_80 */  0x24b4,
/* 109a -  */  0,
/* 109b -  */  0,
/* 109c -  */  0,
/* 109d -  */  0,
/* 109e -  */  0,
/* 109f -  */  0,
/* 10a0 -  */  0,
/* 10a1 -  */  0,
/* 10a2 -  */  0,
/* 10a3 -  */  0,
/* 10a4 -  */  0,
/* 10a5 - _66_0F_38_81 */  0x24b5,
/* 10a6 -  */  0,
/* 10a7 -  */  0,
/* 10a8 -  */  0,
/* 10a9 -  */  0,
/* 10aa -  */  0,
/* 10ab -  */  0,
/* 10ac -  */  0,
/* 10ad -  */  0,
/* 10ae -  */  0,
/* 10af -  */  0,
/* 10b0 -  */  0,
/* 10b1 -  */  0,
/* 10b2 -  */  0,
/* 10b3 -  */  0,
/* 10b4 -  */  0,
/* 10b5 - _V_66_0F_38_96 */  0x4111,
/* 10b6 -  */  0,
/* 10b7 -  */  0,
/* 10b8 -  */  0,
/* 10b9 -  */  0,
/* 10ba -  */  0,
/* 10bb -  */  0,
/* 10bc -  */  0,
/* 10bd -  */  0,
/* 10be -  */  0,
/* 10bf -  */  0,
/* 10c0 -  */  0,
/* 10c1 - _V_66_0F_38_97 */  0x4112,
/* 10c2 -  */  0,
/* 10c3 -  */  0,
/* 10c4 -  */  0,
/* 10c5 -  */  0,
/* 10c6 -  */  0,
/* 10c7 -  */  0,
/* 10c8 -  */  0,
/* 10c9 -  */  0,
/* 10ca -  */  0,
/* 10cb -  */  0,
/* 10cc -  */  0,
/* 10cd - _V_66_0F_38_98 */  0x4113,
/* 10ce -  */  0,
/* 10cf -  */  0,
/* 10d0 -  */  0,
/* 10d1 -  */  0,
/* 10d2 -  */  0,
/* 10d3 -  */  0,
/* 10d4 -  */  0,
/* 10d5 -  */  0,
/* 10d6 -  */  0,
/* 10d7 -  */  0,
/* 10d8 -  */  0,
/* 10d9 - _V_66_0F_38_99 */  0x4114,
/* 10da -  */  0,
/* 10db -  */  0,
/* 10dc -  */  0,
/* 10dd -  */  0,
/* 10de -  */  0,
/* 10df -  */  0,
/* 10e0 -  */  0,
/* 10e1 -  */  0,
/* 10e2 -  */  0,
/* 10e3 -  */  0,
/* 10e4 -  */  0,
/* 10e5 - _V_66_0F_38_9A */  0x4115,
/* 10e6 -  */  0,
/* 10e7 -  */  0,
/* 10e8 -  */  0,
/* 10e9 -  */  0,
/* 10ea -  */  0,
/* 10eb -  */  0,
/* 10ec -  */  0,
/* 10ed -  */  0,
/* 10ee -  */  0,
/* 10ef -  */  0,
/* 10f0 -  */  0,
/* 10f1 - _V_66_0F_38_9B */  0x4116,
/* 10f2 -  */  0,
/* 10f3 -  */  0,
/* 10f4 -  */  0,
/* 10f5 -  */  0,
/* 10f6 -  */  0,
/* 10f7 -  */  0,
/* 10f8 -  */  0,
/* 10f9 -  */  0,
/* 10fa -  */  0,
/* 10fb -  */  0,
/* 10fc -  */  0,
/* 10fd - _V_66_0F_38_9C */  0x4117,
/* 10fe -  */  0,
/* 10ff -  */  0,
/* 1100 -  */  0,
/* 1101 -  */  0,
/* 1102 -  */  0,
/* 1103 -  */  0,
/* 1104 -  */  0,
/* 1105 -  */  0,
/* 1106 -  */  0,
/* 1107 -  */  0,
/* 1108 -  */  0,
/* 1109 - _V_66_0F_38_9D */  0x4118,
/* 110a -  */  0,
/* 110b -  */  0,
/* 110c -  */  0,
/* 110d -  */  0,
/* 110e -  */  0,
/* 110f -  */  0,
/* 1110 -  */  0,
/* 1111 -  */  0,
/* 1112 -  */  0,
/* 1113 -  */  0,
/* 1114 -  */  0,
/* 1115 - _V_66_0F_38_9E */  0x4119,
/* 1116 -  */  0,
/* 1117 -  */  0,
/* 1118 -  */  0,
/* 1119 -  */  0,
/* 111a -  */  0,
/* 111b -  */  0,
/* 111c -  */  0,
/* 111d -  */  0,
/* 111e -  */  0,
/* 111f -  */  0,
/* 1120 -  */  0,
/* 1121 - _V_66_0F_38_9F */  0x411a,
/* 1122 -  */  0,
/* 1123 -  */  0,
/* 1124 -  */  0,
/* 1125 -  */  0,
/* 1126 -  */  0,
/* 1127 -  */  0,
/* 1128 -  */  0,
/* 1129 -  */  0,
/* 112a -  */  0,
/* 112b -  */  0,
/* 112c -  */  0,
/* 112d - _V_66_0F_38_A6 */  0x411b,
/* 112e -  */  0,
/* 112f -  */  0,
/* 1130 -  */  0,
/* 1131 -  */  0,
/* 1132 -  */  0,
/* 1133 -  */  0,
/* 1134 -  */  0,
/* 1135 -  */  0,
/* 1136 -  */  0,
/* 1137 -  */  0,
/* 1138 -  */  0,
/* 1139 - _V_66_0F_38_A7 */  0x411c,
/* 113a -  */  0,
/* 113b -  */  0,
/* 113c -  */  0,
/* 113d -  */  0,
/* 113e -  */  0,
/* 113f -  */  0,
/* 1140 -  */  0,
/* 1141 -  */  0,
/* 1142 -  */  0,
/* 1143 -  */  0,
/* 1144 -  */  0,
/* 1145 - _V_66_0F_38_A8 */  0x411d,
/* 1146 -  */  0,
/* 1147 -  */  0,
/* 1148 -  */  0,
/* 1149 -  */  0,
/* 114a -  */  0,
/* 114b -  */  0,
/* 114c -  */  0,
/* 114d -  */  0,
/* 114e -  */  0,
/* 114f -  */  0,
/* 1150 -  */  0,
/* 1151 - _V_66_0F_38_A9 */  0x411e,
/* 1152 -  */  0,
/* 1153 -  */  0,
/* 1154 -  */  0,
/* 1155 -  */  0,
/* 1156 -  */  0,
/* 1157 -  */  0,
/* 1158 -  */  0,
/* 1159 -  */  0,
/* 115a -  */  0,
/* 115b -  */  0,
/* 115c -  */  0,
/* 115d - _V_66_0F_38_AA */  0x411f,
/* 115e -  */  0,
/* 115f -  */  0,
/* 1160 -  */  0,
/* 1161 -  */  0,
/* 1162 -  */  0,
/* 1163 -  */  0,
/* 1164 -  */  0,
/* 1165 -  */  0,
/* 1166 -  */  0,
/* 1167 -  */  0,
/* 1168 -  */  0,
/* 1169 - _V_66_0F_38_AB */  0x4120,
/* 116a -  */  0,
/* 116b -  */  0,
/* 116c -  */  0,
/* 116d -  */  0,
/* 116e -  */  0,
/* 116f -  */  0,
/* 1170 -  */  0,
/* 1171 -  */  0,
/* 1172 -  */  0,
/* 1173 -  */  0,
/* 1174 -  */  0,
/* 1175 - _V_66_0F_38_AC */  0x4121,
/* 1176 -  */  0,
/* 1177 -  */  0,
/* 1178 -  */  0,
/* 1179 -  */  0,
/* 117a -  */  0,
/* 117b -  */  0,
/* 117c -  */  0,
/* 117d -  */  0,
/* 117e -  */  0,
/* 117f -  */  0,
/* 1180 -  */  0,
/* 1181 - _V_66_0F_38_AD */  0x4122,
/* 1182 -  */  0,
/* 1183 -  */  0,
/* 1184 -  */  0,
/* 1185 -  */  0,
/* 1186 -  */  0,
/* 1187 -  */  0,
/* 1188 -  */  0,
/* 1189 -  */  0,
/* 118a -  */  0,
/* 118b -  */  0,
/* 118c -  */  0,
/* 118d - _V_66_0F_38_AE */  0x4123,
/* 118e -  */  0,
/* 118f -  */  0,
/* 1190 -  */  0,
/* 1191 -  */  0,
/* 1192 -  */  0,
/* 1193 -  */  0,
/* 1194 -  */  0,
/* 1195 -  */  0,
/* 1196 -  */  0,
/* 1197 -  */  0,
/* 1198 -  */  0,
/* 1199 - _V_66_0F_38_AF */  0x4124,
/* 119a -  */  0,
/* 119b -  */  0,
/* 119c -  */  0,
/* 119d -  */  0,
/* 119e -  */  0,
/* 119f -  */  0,
/* 11a0 -  */  0,
/* 11a1 -  */  0,
/* 11a2 -  */  0,
/* 11a3 -  */  0,
/* 11a4 -  */  0,
/* 11a5 - _V_66_0F_38_B6 */  0x4125,
/* 11a6 -  */  0,
/* 11a7 -  */  0,
/* 11a8 -  */  0,
/* 11a9 -  */  0,
/* 11aa -  */  0,
/* 11ab -  */  0,
/* 11ac -  */  0,
/* 11ad -  */  0,
/* 11ae -  */  0,
/* 11af -  */  0,
/* 11b0 -  */  0,
/* 11b1 - _V_66_0F_38_B7 */  0x4126,
/* 11b2 -  */  0,
/* 11b3 -  */  0,
/* 11b4 -  */  0,
/* 11b5 -  */  0,
/* 11b6 -  */  0,
/* 11b7 -  */  0,
/* 11b8 -  */  0,
/* 11b9 -  */  0,
/* 11ba -  */  0,
/* 11bb -  */  0,
/* 11bc -  */  0,
/* 11bd - _V_66_0F_38_B8 */  0x4127,
/* 11be -  */  0,
/* 11bf -  */  0,
/* 11c0 -  */  0,
/* 11c1 -  */  0,
/* 11c2 -  */  0,
/* 11c3 -  */  0,
/* 11c4 -  */  0,
/* 11c5 -  */  0,
/* 11c6 -  */  0,
/* 11c7 -  */  0,
/* 11c8 -  */  0,
/* 11c9 - _V_66_0F_38_B9 */  0x4128,
/* 11ca -  */  0,
/* 11cb -  */  0,
/* 11cc -  */  0,
/* 11cd -  */  0,
/* 11ce -  */  0,
/* 11cf -  */  0,
/* 11d0 -  */  0,
/* 11d1 -  */  0,
/* 11d2 -  */  0,
/* 11d3 -  */  0,
/* 11d4 -  */  0,
/* 11d5 - _V_66_0F_38_BA */  0x4129,
/* 11d6 -  */  0,
/* 11d7 -  */  0,
/* 11d8 -  */  0,
/* 11d9 -  */  0,
/* 11da -  */  0,
/* 11db -  */  0,
/* 11dc -  */  0,
/* 11dd -  */  0,
/* 11de -  */  0,
/* 11df -  */  0,
/* 11e0 -  */  0,
/* 11e1 - _V_66_0F_38_BB */  0x412a,
/* 11e2 -  */  0,
/* 11e3 -  */  0,
/* 11e4 -  */  0,
/* 11e5 -  */  0,
/* 11e6 -  */  0,
/* 11e7 -  */  0,
/* 11e8 -  */  0,
/* 11e9 -  */  0,
/* 11ea -  */  0,
/* 11eb -  */  0,
/* 11ec -  */  0,
/* 11ed - _V_66_0F_38_BC */  0x412b,
/* 11ee -  */  0,
/* 11ef -  */  0,
/* 11f0 -  */  0,
/* 11f1 -  */  0,
/* 11f2 -  */  0,
/* 11f3 -  */  0,
/* 11f4 -  */  0,
/* 11f5 -  */  0,
/* 11f6 -  */  0,
/* 11f7 -  */  0,
/* 11f8 -  */  0,
/* 11f9 - _V_66_0F_38_BD */  0x412c,
/* 11fa -  */  0,
/* 11fb -  */  0,
/* 11fc -  */  0,
/* 11fd -  */  0,
/* 11fe -  */  0,
/* 11ff -  */  0,
/* 1200 -  */  0,
/* 1201 -  */  0,
/* 1202 -  */  0,
/* 1203 -  */  0,
/* 1204 -  */  0,
/* 1205 - _V_66_0F_38_BE */  0x412d,
/* 1206 -  */  0,
/* 1207 -  */  0,
/* 1208 -  */  0,
/* 1209 -  */  0,
/* 120a -  */  0,
/* 120b -  */  0,
/* 120c -  */  0,
/* 120d -  */  0,
/* 120e -  */  0,
/* 120f -  */  0,
/* 1210 -  */  0,
/* 1211 - _V_66_0F_38_BF */  0x412e,
/* 1212 -  */  0,
/* 1213 -  */  0,
/* 1214 -  */  0,
/* 1215 -  */  0,
/* 1216 -  */  0,
/* 1217 -  */  0,
/* 1218 -  */  0,
/* 1219 - _66_0F_38_DB */  0x24b6,
/* 121a -  */  0,
/* 121b -  */  0,
/* 121c -  */  0,
/* 121d -  */  0,
/* 121e -  */  0,
/* 121f -  */  0,
/* 1220 -  */  0,
/* 1221 - _NV_66_0F_38_DB */  0x412f,
/* 1222 -  */  0,
/* 1223 -  */  0,
/* 1224 -  */  0,
/* 1225 - _66_0F_38_DC */  0x24b7,
/* 1226 -  */  0,
/* 1227 -  */  0,
/* 1228 -  */  0,
/* 1229 - _V_66_0F_38_DC */  0x4130,
/* 122a -  */  0,
/* 122b -  */  0,
/* 122c -  */  0,
/* 122d -  */  0,
/* 122e -  */  0,
/* 122f -  */  0,
/* 1230 -  */  0,
/* 1231 - _66_0F_38_DD */  0x24b8,
/* 1232 -  */  0,
/* 1233 -  */  0,
/* 1234 -  */  0,
/* 1235 - _V_66_0F_38_DD */  0x4131,
/* 1236 -  */  0,
/* 1237 -  */  0,
/* 1238 -  */  0,
/* 1239 -  */  0,
/* 123a -  */  0,
/* 123b -  */  0,
/* 123c -  */  0,
/* 123d - _66_0F_38_DE */  0x24b9,
/* 123e -  */  0,
/* 123f -  */  0,
/* 1240 -  */  0,
/* 1241 - _V_66_0F_38_DE */  0x4132,
/* 1242 -  */  0,
/* 1243 -  */  0,
/* 1244 -  */  0,
/* 1245 -  */  0,
/* 1246 -  */  0,
/* 1247 -  */  0,
/* 1248 -  */  0,
/* 1249 - _66_0F_38_DF */  0x24ba,
/* 124a -  */  0,
/* 124b -  */  0,
/* 124c -  */  0,
/* 124d - _V_66_0F_38_DF */  0x4133,
/* 124e -  */  0,
/* 124f -  */  0,
/* 1250 -  */  0,
/* 1251 -  */  0,
/* 1252 -  */  0,
/* 1253 -  */  0,
/* 1254 - _0F_38_F0 */  0x24bb,
/* 1255 -  */  0,
/* 1256 -  */  0,
/* 1257 - _F2_0F_38_F0 */  0x24bc,
/* 1258 -  */  0,
/* 1259 -  */  0,
/* 125a -  */  0,
/* 125b -  */  0,
/* 125c -  */  0,
/* 125d -  */  0,
/* 125e -  */  0,
/* 125f -  */  0,
/* 1260 - _0F_38_F1 */  0x24bd,
/* 1261 -  */  0,
/* 1262 -  */  0,
/* 1263 - _F2_0F_38_F1 */  0x24be,
/* 1264 -  */  0,
/* 1265 -  */  0,
/* 1266 -  */  0,
/* 1267 -  */  0,
/* 1268 -  */  0,
/* 1269 -  */  0,
/* 126a -  */  0,
/* 126b -  */  0,
/* 126c -  */  0,
/* 126d -  */  0,
/* 126e -  */  0,
/* 126f -  */  0,
/* 1270 -  */  0,
/* 1271 -  */  0,
/* 1272 -  */  0,
/* 1273 -  */  0,
/* 1274 -  */  0,
/* 1275 - _NV_66_0F_3A_04 */  0x4134,
/* 1276 -  */  0,
/* 1277 -  */  0,
/* 1278 -  */  0,
/* 1279 -  */  0,
/* 127a -  */  0,
/* 127b -  */  0,
/* 127c -  */  0,
/* 127d -  */  0,
/* 127e -  */  0,
/* 127f -  */  0,
/* 1280 -  */  0,
/* 1281 - _NV_66_0F_3A_05 */  0x4135,
/* 1282 -  */  0,
/* 1283 -  */  0,
/* 1284 -  */  0,
/* 1285 -  */  0,
/* 1286 -  */  0,
/* 1287 -  */  0,
/* 1288 -  */  0,
/* 1289 - _V_66_0F_3A_06 */  0x4136,
/* 128a -  */  0,
/* 128b -  */  0,
/* 128c -  */  0,
/* 128d -  */  0,
/* 128e -  */  0,
/* 128f -  */  0,
/* 1290 -  */  0,
/* 1291 - _66_0F_3A_08 */  0x4137,
/* 1292 -  */  0,
/* 1293 -  */  0,
/* 1294 -  */  0,
/* 1295 -  */  0,
/* 1296 -  */  0,
/* 1297 -  */  0,
/* 1298 -  */  0,
/* 1299 - _NV_66_0F_3A_08 */  0x4138,
/* 129a -  */  0,
/* 129b -  */  0,
/* 129c -  */  0,
/* 129d - _66_0F_3A_09 */  0x4139,
/* 129e -  */  0,
/* 129f -  */  0,
/* 12a0 -  */  0,
/* 12a1 -  */  0,
/* 12a2 -  */  0,
/* 12a3 -  */  0,
/* 12a4 -  */  0,
/* 12a5 - _NV_66_0F_3A_09 */  0x413a,
/* 12a6 -  */  0,
/* 12a7 -  */  0,
/* 12a8 -  */  0,
/* 12a9 - _66_0F_3A_0A */  0x413b,
/* 12aa -  */  0,
/* 12ab -  */  0,
/* 12ac -  */  0,
/* 12ad - _V_66_0F_3A_0A */  0x413c,
/* 12ae -  */  0,
/* 12af -  */  0,
/* 12b0 -  */  0,
/* 12b1 -  */  0,
/* 12b2 -  */  0,
/* 12b3 -  */  0,
/* 12b4 -  */  0,
/* 12b5 - _66_0F_3A_0B */  0x413d,
/* 12b6 -  */  0,
/* 12b7 -  */  0,
/* 12b8 -  */  0,
/* 12b9 - _V_66_0F_3A_0B */  0x413e,
/* 12ba -  */  0,
/* 12bb -  */  0,
/* 12bc -  */  0,
/* 12bd -  */  0,
/* 12be -  */  0,
/* 12bf -  */  0,
/* 12c0 -  */  0,
/* 12c1 - _66_0F_3A_0C */  0x413f,
/* 12c2 -  */  0,
/* 12c3 -  */  0,
/* 12c4 -  */  0,
/* 12c5 - _V_66_0F_3A_0C */  0x4140,
/* 12c6 -  */  0,
/* 12c7 -  */  0,
/* 12c8 -  */  0,
/* 12c9 -  */  0,
/* 12ca -  */  0,
/* 12cb -  */  0,
/* 12cc -  */  0,
/* 12cd - _66_0F_3A_0D */  0x4141,
/* 12ce -  */  0,
/* 12cf -  */  0,
/* 12d0 -  */  0,
/* 12d1 - _V_66_0F_3A_0D */  0x4142,
/* 12d2 -  */  0,
/* 12d3 -  */  0,
/* 12d4 -  */  0,
/* 12d5 -  */  0,
/* 12d6 -  */  0,
/* 12d7 -  */  0,
/* 12d8 -  */  0,
/* 12d9 - _66_0F_3A_0E */  0x4143,
/* 12da -  */  0,
/* 12db -  */  0,
/* 12dc -  */  0,
/* 12dd - _V_66_0F_3A_0E */  0x4144,
/* 12de -  */  0,
/* 12df -  */  0,
/* 12e0 -  */  0,
/* 12e1 -  */  0,
/* 12e2 -  */  0,
/* 12e3 -  */  0,
/* 12e4 - _0F_3A_0F */  0x4145,
/* 12e5 - _66_0F_3A_0F */  0x4146,
/* 12e6 -  */  0,
/* 12e7 -  */  0,
/* 12e8 -  */  0,
/* 12e9 - _V_66_0F_3A_0F */  0x4147,
/* 12ea -  */  0,
/* 12eb -  */  0,
/* 12ec -  */  0,
/* 12ed -  */  0,
/* 12ee -  */  0,
/* 12ef -  */  0,
/* 12f0 -  */  0,
/* 12f1 - _66_0F_3A_14 */  0x4148,
/* 12f2 -  */  0,
/* 12f3 -  */  0,
/* 12f4 -  */  0,
/* 12f5 -  */  0,
/* 12f6 -  */  0,
/* 12f7 -  */  0,
/* 12f8 -  */  0,
/* 12f9 - _NV_66_0F_3A_14 */  0x4149,
/* 12fa -  */  0,
/* 12fb -  */  0,
/* 12fc -  */  0,
/* 12fd - _66_0F_3A_15 */  0x414a,
/* 12fe -  */  0,
/* 12ff -  */  0,
/* 1300 -  */  0,
/* 1301 -  */  0,
/* 1302 -  */  0,
/* 1303 -  */  0,
/* 1304 -  */  0,
/* 1305 - _NV_66_0F_3A_15 */  0x414b,
/* 1306 -  */  0,
/* 1307 -  */  0,
/* 1308 -  */  0,
/* 1309 - _66_0F_3A_16 */  0x414c,
/* 130a -  */  0,
/* 130b -  */  0,
/* 130c -  */  0,
/* 130d -  */  0,
/* 130e -  */  0,
/* 130f -  */  0,
/* 1310 -  */  0,
/* 1311 - _NV_66_0F_3A_16 */  0x414d,
/* 1312 -  */  0,
/* 1313 -  */  0,
/* 1314 -  */  0,
/* 1315 - _66_0F_3A_17 */  0x414e,
/* 1316 -  */  0,
/* 1317 -  */  0,
/* 1318 -  */  0,
/* 1319 -  */  0,
/* 131a -  */  0,
/* 131b -  */  0,
/* 131c -  */  0,
/* 131d - _NV_66_0F_3A_17 */  0x414f,
/* 131e -  */  0,
/* 131f -  */  0,
/* 1320 -  */  0,
/* 1321 -  */  0,
/* 1322 -  */  0,
/* 1323 -  */  0,
/* 1324 -  */  0,
/* 1325 - _V_66_0F_3A_18 */  0x4150,
/* 1326 -  */  0,
/* 1327 -  */  0,
/* 1328 -  */  0,
/* 1329 -  */  0,
/* 132a -  */  0,
/* 132b -  */  0,
/* 132c -  */  0,
/* 132d -  */  0,
/* 132e -  */  0,
/* 132f -  */  0,
/* 1330 -  */  0,
/* 1331 -  */  0,
/* 1332 -  */  0,
/* 1333 -  */  0,
/* 1334 -  */  0,
/* 1335 - _NV_66_0F_3A_19 */  0x4151,
/* 1336 -  */  0,
/* 1337 -  */  0,
/* 1338 -  */  0,
/* 1339 - _66_0F_3A_20 */  0x4152,
/* 133a -  */  0,
/* 133b -  */  0,
/* 133c -  */  0,
/* 133d - _V_66_0F_3A_20 */  0x4153,
/* 133e -  */  0,
/* 133f -  */  0,
/* 1340 -  */  0,
/* 1341 -  */  0,
/* 1342 -  */  0,
/* 1343 -  */  0,
/* 1344 -  */  0,
/* 1345 - _66_0F_3A_21 */  0x4154,
/* 1346 -  */  0,
/* 1347 -  */  0,
/* 1348 -  */  0,
/* 1349 - _V_66_0F_3A_21 */  0x4155,
/* 134a -  */  0,
/* 134b -  */  0,
/* 134c -  */  0,
/* 134d -  */  0,
/* 134e -  */  0,
/* 134f -  */  0,
/* 1350 -  */  0,
/* 1351 - _66_0F_3A_22 */  0x4156,
/* 1352 -  */  0,
/* 1353 -  */  0,
/* 1354 -  */  0,
/* 1355 - _V_66_0F_3A_22 */  0x4157,
/* 1356 -  */  0,
/* 1357 -  */  0,
/* 1358 -  */  0,
/* 1359 -  */  0,
/* 135a -  */  0,
/* 135b -  */  0,
/* 135c -  */  0,
/* 135d - _66_0F_3A_40 */  0x4158,
/* 135e -  */  0,
/* 135f -  */  0,
/* 1360 -  */  0,
/* 1361 - _V_66_0F_3A_40 */  0x4159,
/* 1362 -  */  0,
/* 1363 -  */  0,
/* 1364 -  */  0,
/* 1365 -  */  0,
/* 1366 -  */  0,
/* 1367 -  */  0,
/* 1368 -  */  0,
/* 1369 - _66_0F_3A_41 */  0x415a,
/* 136a -  */  0,
/* 136b -  */  0,
/* 136c -  */  0,
/* 136d - _V_66_0F_3A_41 */  0x415b,
/* 136e -  */  0,
/* 136f -  */  0,
/* 1370 -  */  0,
/* 1371 -  */  0,
/* 1372 -  */  0,
/* 1373 -  */  0,
/* 1374 -  */  0,
/* 1375 - _66_0F_3A_42 */  0x415c,
/* 1376 -  */  0,
/* 1377 -  */  0,
/* 1378 -  */  0,
/* 1379 - _V_66_0F_3A_42 */  0x415d,
/* 137a -  */  0,
/* 137b -  */  0,
/* 137c -  */  0,
/* 137d -  */  0,
/* 137e -  */  0,
/* 137f -  */  0,
/* 1380 -  */  0,
/* 1381 - _66_0F_3A_44 */  0x415e,
/* 1382 -  */  0,
/* 1383 -  */  0,
/* 1384 -  */  0,
/* 1385 - _V_66_0F_3A_44 */  0x415f,
/* 1386 -  */  0,
/* 1387 -  */  0,
/* 1388 -  */  0,
/* 1389 -  */  0,
/* 138a -  */  0,
/* 138b -  */  0,
/* 138c -  */  0,
/* 138d -  */  0,
/* 138e -  */  0,
/* 138f -  */  0,
/* 1390 -  */  0,
/* 1391 - _V_66_0F_3A_4A */  0x4160,
/* 1392 -  */  0,
/* 1393 -  */  0,
/* 1394 -  */  0,
/* 1395 -  */  0,
/* 1396 -  */  0,
/* 1397 -  */  0,
/* 1398 -  */  0,
/* 1399 -  */  0,
/* 139a -  */  0,
/* 139b -  */  0,
/* 139c -  */  0,
/* 139d - _V_66_0F_3A_4B */  0x4161,
/* 139e -  */  0,
/* 139f -  */  0,
/* 13a0 -  */  0,
/* 13a1 -  */  0,
/* 13a2 -  */  0,
/* 13a3 -  */  0,
/* 13a4 -  */  0,
/* 13a5 -  */  0,
/* 13a6 -  */  0,
/* 13a7 -  */  0,
/* 13a8 -  */  0,
/* 13a9 - _V_66_0F_3A_4C */  0x4162,
/* 13aa -  */  0,
/* 13ab -  */  0,
/* 13ac -  */  0,
/* 13ad -  */  0,
/* 13ae -  */  0,
/* 13af -  */  0,
/* 13b0 -  */  0,
/* 13b1 - _66_0F_3A_60 */  0x4163,
/* 13b2 -  */  0,
/* 13b3 -  */  0,
/* 13b4 -  */  0,
/* 13b5 -  */  0,
/* 13b6 -  */  0,
/* 13b7 -  */  0,
/* 13b8 -  */  0,
/* 13b9 - _NV_66_0F_3A_60 */  0x4164,
/* 13ba -  */  0,
/* 13bb -  */  0,
/* 13bc -  */  0,
/* 13bd - _66_0F_3A_61 */  0x4165,
/* 13be -  */  0,
/* 13bf -  */  0,
/* 13c0 -  */  0,
/* 13c1 -  */  0,
/* 13c2 -  */  0,
/* 13c3 -  */  0,
/* 13c4 -  */  0,
/* 13c5 - _NV_66_0F_3A_61 */  0x4166,
/* 13c6 -  */  0,
/* 13c7 -  */  0,
/* 13c8 -  */  0,
/* 13c9 - _66_0F_3A_62 */  0x4167,
/* 13ca -  */  0,
/* 13cb -  */  0,
/* 13cc -  */  0,
/* 13cd -  */  0,
/* 13ce -  */  0,
/* 13cf -  */  0,
/* 13d0 -  */  0,
/* 13d1 - _NV_66_0F_3A_62 */  0x4168,
/* 13d2 -  */  0,
/* 13d3 -  */  0,
/* 13d4 -  */  0,
/* 13d5 - _66_0F_3A_63 */  0x4169,
/* 13d6 -  */  0,
/* 13d7 -  */  0,
/* 13d8 -  */  0,
/* 13d9 -  */  0,
/* 13da -  */  0,
/* 13db -  */  0,
/* 13dc -  */  0,
/* 13dd - _NV_66_0F_3A_63 */  0x416a,
/* 13de -  */  0,
/* 13df -  */  0,
/* 13e0 -  */  0,
/* 13e1 - _66_0F_3A_DF */  0x416b,
/* 13e2 -  */  0,
/* 13e3 -  */  0,
/* 13e4 -  */  0,
/* 13e5 -  */  0,
/* 13e6 -  */  0,
/* 13e7 -  */  0,
/* 13e8 -  */  0,
/* 13e9 - _NV_66_0F_3A_DF */  0x416c,
/* 13ea -  */  0,
/* 13eb -  */  0,
/* 13ec - _0F_71_02 */  0x24bf,
/* 13ed - _66_0F_71_02 */  0x24c0,
/* 13ee -  */  0,
/* 13ef -  */  0,
/* 13f0 -  */  0,
/* 13f1 - _V_66_0F_71_02 */  0x416d,
/* 13f2 -  */  0,
/* 13f3 -  */  0,
/* 13f4 -  */  0,
/* 13f5 -  */  0,
/* 13f6 -  */  0,
/* 13f7 -  */  0,
/* 13f8 - _0F_71_04 */  0x24c1,
/* 13f9 - _66_0F_71_04 */  0x24c2,
/* 13fa -  */  0,
/* 13fb -  */  0,
/* 13fc -  */  0,
/* 13fd - _V_66_0F_71_04 */  0x416e,
/* 13fe -  */  0,
/* 13ff -  */  0,
/* 1400 -  */  0,
/* 1401 -  */  0,
/* 1402 -  */  0,
/* 1403 -  */  0,
/* 1404 - _0F_71_06 */  0x24c3,
/* 1405 - _66_0F_71_06 */  0x24c4,
/* 1406 -  */  0,
/* 1407 -  */  0,
/* 1408 -  */  0,
/* 1409 - _V_66_0F_71_06 */  0x416f,
/* 140a -  */  0,
/* 140b -  */  0,
/* 140c -  */  0,
/* 140d -  */  0,
/* 140e -  */  0,
/* 140f -  */  0,
/* 1410 - _0F_72_02 */  0x24c5,
/* 1411 - _66_0F_72_02 */  0x24c6,
/* 1412 -  */  0,
/* 1413 -  */  0,
/* 1414 -  */  0,
/* 1415 - _V_66_0F_72_02 */  0x4170,
/* 1416 -  */  0,
/* 1417 -  */  0,
/* 1418 -  */  0,
/* 1419 -  */  0,
/* 141a -  */  0,
/* 141b -  */  0,
/* 141c - _0F_72_04 */  0x24c7,
/* 141d - _66_0F_72_04 */  0x24c8,
/* 141e -  */  0,
/* 141f -  */  0,
/* 1420 -  */  0,
/* 1421 - _V_66_0F_72_04 */  0x4171,
/* 1422 -  */  0,
/* 1423 -  */  0,
/* 1424 -  */  0,
/* 1425 -  */  0,
/* 1426 -  */  0,
/* 1427 -  */  0,
/* 1428 - _0F_72_06 */  0x24c9,
/* 1429 - _66_0F_72_06 */  0x24ca,
/* 142a -  */  0,
/* 142b -  */  0,
/* 142c -  */  0,
/* 142d - _V_66_0F_72_06 */  0x4172,
/* 142e -  */  0,
/* 142f -  */  0,
/* 1430 -  */  0,
/* 1431 -  */  0,
/* 1432 -  */  0,
/* 1433 -  */  0,
/* 1434 - _0F_73_02 */  0x24cb,
/* 1435 - _66_0F_73_02 */  0x24cc,
/* 1436 -  */  0,
/* 1437 -  */  0,
/* 1438 -  */  0,
/* 1439 - _V_66_0F_73_02 */  0x4173,
/* 143a -  */  0,
/* 143b -  */  0,
/* 143c -  */  0,
/* 143d -  */  0,
/* 143e -  */  0,
/* 143f -  */  0,
/* 1440 -  */  0,
/* 1441 - _66_0F_73_03 */  0x24cd,
/* 1442 -  */  0,
/* 1443 -  */  0,
/* 1444 -  */  0,
/* 1445 - _V_66_0F_73_03 */  0x4174,
/* 1446 -  */  0,
/* 1447 -  */  0,
/* 1448 -  */  0,
/* 1449 -  */  0,
/* 144a -  */  0,
/* 144b -  */  0,
/* 144c - _0F_73_06 */  0x24ce,
/* 144d - _66_0F_73_06 */  0x24cf,
/* 144e -  */  0,
/* 144f -  */  0,
/* 1450 -  */  0,
/* 1451 - _V_66_0F_73_06 */  0x4175,
/* 1452 -  */  0,
/* 1453 -  */  0,
/* 1454 -  */  0,
/* 1455 -  */  0,
/* 1456 -  */  0,
/* 1457 -  */  0,
/* 1458 -  */  0,
/* 1459 - _66_0F_73_07 */  0x24d0,
/* 145a -  */  0,
/* 145b -  */  0,
/* 145c -  */  0,
/* 145d - _V_66_0F_73_07 */  0x4176,
/* 145e -  */  0,
/* 145f -  */  0,
/* 1460 -  */  0,
/* 1461 -  */  0,
/* 1462 -  */  0,
/* 1463 -  */  0,
/* 1464 - _0F_AE_02 */  0x24d1,
/* 1465 -  */  0,
/* 1466 -  */  0,
/* 1467 -  */  0,
/* 1468 -  */  0,
/* 1469 -  */  0,
/* 146a -  */  0,
/* 146b -  */  0,
/* 146c - _NV_0F_AE_02 */  0x4177,
/* 146d -  */  0,
/* 146e -  */  0,
/* 146f -  */  0,
/* 1470 - _0F_AE_03 */  0x24d2,
/* 1471 -  */  0,
/* 1472 -  */  0,
/* 1473 -  */  0,
/* 1474 -  */  0,
/* 1475 -  */  0,
/* 1476 -  */  0,
/* 1477 -  */  0,
/* 1478 - _NV_0F_AE_03 */  0x4178,
/* 1479 -  */  0,
/* 147a -  */  0,
/* 147b -  */  0,
/* 147c - _0F_C7_06 */  0x24d3,
/* 147d - _66_0F_C7_06 */  0x24d4,
/* 147e - _F3_0F_C7_06 */  0x24d5,
/* 147f -  */  0,
/* 1480 -  */  0,
/* 1481 -  */  0,
/* 1482 -  */  0,
/* 1483 -  */  0,
/* 1484 -  */  0,
/* 1485 -  */  0,
/* 1486 -  */  0,
/* 1487 -  */  0
};
