/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast;

import java.util.ArrayList;
import java.util.List;

import ast.statement.Statement;
import ast.type.Type;
import ast.variable.Variable;

public class PrgFunc extends Function {
  private String              name;
  private Statement           body;
  private ArrayList<Variable> param = new ArrayList<Variable>();
  private Type retType;

  public PrgFunc(Statement body, String name, Type retType) {
    super();
    this.body = body;
    this.name = name;
    this.retType = retType;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Statement getBody() {
    return body;
  }

  public void setBody(Statement body) {
    this.body = body;
  }

  @Override
  public Type getReturnType() {
    return retType;
  }

  public void setReturnType(Type retType) {
    this.retType = retType;
  }

  @Override
  public List<Variable> getParam() {
    return param;
  }

  @Override
  public String toString() {
    return retType + " " + name + "("+ param + ")";
  }

}
