/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.expression;

import java.util.List;

public class CallExpr extends Expression {
  private FunctionRef      function;
  private List<Expression> param;

  public CallExpr(FunctionRef function, List<Expression> param) {
    super();
    this.function = function;
    this.param = param;
  }

  public void setFunction(FunctionRef function) {
    this.function = function;
  }

  public FunctionRef getFunction() {
    return function;
  }

  public List<Expression> getParam() {
    return param;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append(function.toString());
    sb.append("(");
    for (int i = 0; i < param.size(); i++) {
      if (i > 0) {
        sb.append(", ");
      }
      sb.append(param.get(i));
    }
    sb.append(")");
    return sb.toString();
  }

}
