/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.expression;

public class IfExpr extends Expression {
  private Expression condition;
  private Expression left;
  private Expression right;

  public IfExpr(Expression condition, Expression left, Expression right) {
    super();
    this.condition = condition;
    this.left = left;
    this.right = right;
  }

  public Expression getCondition() {
    return condition;
  }

  public void setCondition(Expression expr) {
    condition = expr;
  }

  public Expression getLeft() {
    return left;
  }

  public Expression getRight() {
    return right;
  }

  public void setLeft(Expression left) {
    this.left = left;
  }

  public void setRight(Expression right) {
    this.right = right;
  }

  @Override
  public String toString() {
    return "if " + condition + "{" + left + "} else {" + right + "}";
  }

}
