/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.expression;

public class UnaryExpression extends Expression {
  private Expression expr;
  private UnaryOp    op;

  public UnaryExpression(Expression expr, UnaryOp op) {
    super();
    this.expr = expr;
    this.op = op;
  }

  public Expression getExpr() {
    return expr;
  }

  public UnaryOp getOp() {
    return op;
  }

  public void setExpr(Expression expr) {
    this.expr = expr;
  }

  @Override
  public String toString() {
    return "(" + op + " " + expr + ")";
  }
}
