/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import java.util.List;

import ast.Ast;
import ast.Function;
import ast.PrgFunc;
import ast.Program;
import ast.expression.Expression;
import ast.statement.Statement;

public class AstTraverser<P> {
  private AstStatementTraverser<P> stmt;

  public AstTraverser(AstStatementTraverser<P> stmt) {
    super();
    this.stmt = stmt;
  }

  public AstStatementTraverser<P> getStmt() {
    return stmt;
  }

  final public void visitList(List<PrgFunc> list, P param) {
    for (int i = 0; i < list.size(); i++) {
      PrgFunc func = list.get(i);
      func = (PrgFunc) visit(func, param);
      list.set(i, func);
    }
  }

  public Ast visit(Ast obj, P param) {
    if (obj == null) throw new RuntimeException("obj is null");
    else if (obj instanceof Statement) return stmt.visit((Statement) obj, param);
    else if (obj instanceof Expression) return stmt.visit((Expression) obj, param);
    else if (obj instanceof Function) return visitFunction((Function) obj, param);
    else if (obj instanceof Program) return visitProgram((Program) obj, param);
    else
      throw new RuntimeException("Unhandled class: " + obj.getClass());
  }

  protected Ast visitProgram(Program obj, P param) {
    visitList(obj.getFunction(), param);
    return obj;
  }

  protected Ast visitFunction(Function obj, P param) {
    if (obj instanceof PrgFunc) return visitPrgFunc((PrgFunc) obj, param);
    // else if (obj instanceof LibFunction) return visitLibFunction((LibFunction) obj, param);
    // else if (obj instanceof SysFunction) return visitSysFunction((SysFunction) obj, param);
    else
      throw new RuntimeException("Unhandled class: " + obj.getClass());
  }

  protected Ast visitPrgFunc(PrgFunc obj, P param) {
    for (int i = 0; i < obj.getParam().size(); i++) {
      obj.getParam().set(i, stmt.visit(obj.getParam().get(i), param));
    }
    obj.setBody(stmt.visit(obj.getBody(), param));
    return obj;
  }

}
