/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import java.util.ArrayList;
import java.util.List;

import ast.Ast;
import ast.expression.Expression;
import ast.variable.Variable;

public class AstVariableCollector extends AstTraverser<List<Variable>> {

  static public List<Variable> process(Ast ast) {
    List<Variable> res = new ArrayList<Variable>();
    AstVariableCollector collector = new AstVariableCollector();
    collector.visit(ast, res);
    return res;
  }

  public AstVariableCollector() {
    super(new AstStmtVariableCollector());
  }

}

class AstStmtVariableCollector extends AstStatementTraverser<List<Variable>> {
  private AstExprVariableCollector exprvisitor = new AstExprVariableCollector();

  @Override
  public Expression visit(Expression expr, List<Variable> param) {
    return exprvisitor.visit(expr, param);
  }

  @Override
  public Variable visit(Variable expr, List<Variable> param) {
    return exprvisitor.visit(expr, param);
  }

}

class AstExprVariableCollector extends AstExpressionTraverser<List<Variable>> {

  @Override
  public Variable visit(Variable obj, List<Variable> param) {
    assert (!param.contains(obj));
    param.add(obj);
    return obj;
  }

}
