/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import ast.expression.Expression;
import ast.variable.Variable;

public class NopAstStatementTraverser<P> extends AstStatementTraverser<P> {

  private AstExpressionTraverser<P> exptrav;

  public NopAstStatementTraverser(AstExpressionTraverser<P> exptrav) {
    super();
    this.exptrav = exptrav;
  }

  public final AstExpressionTraverser<P> getExpr() {
    return exptrav;
  }

  @Override
  public Expression visit(Expression expr, P param) {
    return exptrav.visit(expr, param);
  }

  @Override
  public Variable visit(Variable expr, P param) {
    return exptrav.visit(expr, param);
  }

}
