/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import ast.expression.Expression;
import ast.statement.AssignmentStmt;
import ast.statement.BlockStmt;
import ast.statement.CallStmt;
import ast.statement.CaseStmt;
import ast.statement.DoWhile;
import ast.statement.IfStmt;
import ast.statement.NullStmt;
import ast.statement.RetStmt;
import ast.statement.Statement;
import ast.statement.VarDef;
import ast.statement.WhileStmt;
import ast.variable.Variable;

// Tests if the control flow comes back (or otherwise all paths end in an return) 
public class ReturnChecker extends AstStatementTraverser<Void> {
  private boolean comeback = true;
  
  public static boolean comesBack( Statement stmt ){
    ReturnChecker   checker = new ReturnChecker();
    checker.visit(stmt, null);
    return checker.isComeback();
  }
  
  public final boolean isComeback() {
    return comeback;
  }

  // ---- infrastructure ----
  
  @Override
  public Expression visit(Expression expr, Void param) {
    throw new RuntimeException( "Not yet implemented" );
  }

  @Override
  public Variable visit(Variable expr, Void param) {
    throw new RuntimeException( "Not yet implemented" );
  }

  @Override
  public Statement visit(Statement obj, Void param) {
    if( comeback ){
      super.visit(obj, null);
    }
    return obj;
  }

  @Override
  protected Statement visitRetStmt(RetStmt obj, Void param) {
    comeback = false;
    return obj;
  }

  // ---- the interesting cases ----
  
  @Override
  protected Statement visitIfStmt(IfStmt obj, Void param) {
    assert( comeback );
    visit( obj.getThenBranch(), null );
    if( !comeback ){
      comeback = true;
      visit( obj.getElseBranch(), null );
    }
    return obj;
  }

  @Override
  protected Statement visitCaseStmt(CaseStmt obj, Void param) {
    assert( comeback );
    visit( obj.getOther(), null );
    for( Statement stmt : obj.getOption().values() ){
      if( !comeback ){
        comeback = true;
        visit( stmt, null );
      }
    }
    return obj;
  }

  @Override
  protected Statement visitBlockStmt(BlockStmt obj, Void param) {
    return super.visitBlockStmt(obj, null);
  }

  @Override
  protected Statement visitWhileStmt(WhileStmt obj, Void param) {
    return obj;
  }

  @Override
  protected Statement visitDoWhileStmt(DoWhile obj, Void param) {
    visit( obj.getBody(), null );
    return obj;
  }

  // ---- the boring cases ----
  
  @Override
  protected Statement visitNullStmt(NullStmt obj, Void param) {
    return obj;
  }

  @Override
  protected Statement visitVarDef(VarDef obj, Void param) {
    return obj;
  }

  @Override
  protected Statement visitCallStmt(CallStmt obj, Void param) {
    return obj;
  }

  @Override
  protected Statement visitAssignmentStmt(AssignmentStmt obj, Void param) {
    return obj;
  }
  
  

}
