/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import java.util.HashSet;
import java.util.Set;

import ast.expression.Expression;
import ast.variable.Variable;
import ast.variable.VariableRefLinked;
import ast.variable.VariableRefUnlinked;

public class VariableAccessCollector extends AstExpressionTraverser<Void> {
  private Set<String>   unlinked   = new HashSet<String>();
  private Set<Variable> defined    = new HashSet<Variable>();
  private Set<Variable> referenced = new HashSet<Variable>();

  public Set<String> getUnlinked() {
    return unlinked;
  }

  public Set<Variable> getDefined() {
    return defined;
  }

  public final Set<Variable> getReferenced() {
    return referenced;
  }

  @Override
  public Variable visit(Variable obj, Void param) {
    defined.add(obj);
    return obj;
  }

  @Override
  protected Expression visitVariableRefUnlinked(VariableRefUnlinked obj, Void param) {
    unlinked.add(obj.getName());
    return obj;
  }

  @Override
  protected Expression visitVariableRefLinked(VariableRefLinked obj, Void param) {
    referenced.add(obj.getReference());
    return obj;
  }

}
