/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import java.util.ArrayList;
import java.util.Collections;

import ast.PrgFunc;
import ast.Program;
import ast.statement.BlockStmt;
import ast.statement.VarDef;
import ast.type.Type;
import ast.variable.Variable;

public class VariableInserter {

  static public void process(Program prg) {
    for (PrgFunc func : prg.getFunction()) {
      process(func);
    }
  }

  static public void process(PrgFunc func) {
    VariableAccessCollector collector = new VariableAccessCollector();
    AstTraverser<Void> visitor = new AstTraverser<Void>(new NopAstStatementTraverser<Void>(collector));

    visitor.visit(func, null);
    ArrayList<String> variables = new ArrayList<String>( collector.getUnlinked() );
    Collections.sort(variables);
    for( Variable var : collector.getDefined() ){
      variables.remove(var.getName());
    }
    BlockStmt block = new BlockStmt();
    for (String name : variables) {
      block.addCode(new VarDef(new Variable(name,Type.Generic)));   //FIXME find type
    }
    block.addCode(func.getBody());
    func.setBody(block);
  }

}
