/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import java.util.HashMap;
import java.util.Map;

import ast.PrgFunc;
import ast.Program;
import ast.expression.Expression;
import ast.statement.RetStmt;
import ast.statement.Statement;
import ast.variable.Variable;
import ast.variable.VariableRefLinked;
import ast.variable.VariableRefUnlinked;

public class VariableLinker extends AstStatementTraverser<PrgFunc> {
  private ExprVariableLinker exptrav = new ExprVariableLinker();

  @Override
  public Expression visit(Expression expr, PrgFunc param) {
    return exptrav.visit(expr, param);
  }

  @Override
  public Variable visit(Variable expr, PrgFunc param) {
    return exptrav.visit(expr, param);
  }

  static public void process(Program prg) {
    for (PrgFunc func : prg.getFunction()) {
      process(func);
    }
  }

  static public void process(PrgFunc func) {
    AstTraverser<PrgFunc> visitor = new AstTraverser<PrgFunc>(new VariableLinker());
    visitor.visit(func, func);
  }

  @Override
  protected Statement visitRetStmt(RetStmt obj, PrgFunc param) {
    obj.setFunction(param);
    return super.visitRetStmt(obj, param);
  }

}

class ExprVariableLinker extends AstExpressionTraverser<PrgFunc> {

  private Map<String, Variable> symTable = new HashMap<String, Variable>();

  @Override
  public Variable visit(Variable obj, PrgFunc param) {
    assert (!symTable.containsKey(obj.getName()));
    symTable.put(obj.getName(), obj);
    return obj;
  }

  @Override
  protected Expression visitVariableRefUnlinked(VariableRefUnlinked obj, PrgFunc param) {
    Variable variable = symTable.get(obj.getName());
    assert (variable != null);
    return new VariableRefLinked(variable);
  }

  @Override
  protected Expression visitVariableRefLinked(VariableRefLinked obj, PrgFunc param) {
    assert (symTable.containsKey(obj.getName()));
    return obj;
  }

}

