/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.traverser;

import ast.Ast;
import ast.PrgFunc;
import ast.Program;
import ast.expression.Expression;
import ast.variable.Variable;

public class VariableNamer extends AstTraverser<Void> {
  public VariableNamer() {
    super(new StmtVariableNamer());
  }

  public static void process(Program prg) {
    VariableNamer traverser = new VariableNamer();
    traverser.visit(prg, null);
  }

  @Override
  protected Ast visitPrgFunc(PrgFunc obj, Void param) {
    ((StmtVariableNamer) getStmt()).setCounter(0);
    super.visitPrgFunc(obj, null);
    return obj;
  }

}

class StmtVariableNamer extends AstStatementTraverser<Void> {
  private final static String VAR_NAME = "var";
  private int                 counter  = 0;

  public final int getCounter() {
    return counter;
  }

  public final void setCounter(int counter) {
    this.counter = counter;
  }

  @Override
  public Expression visit(Expression expr, Void param) {
    return expr;
  }

  @Override
  public Variable visit(Variable expr, Void param) {
    if (expr.getName() == null) {
      expr.setName(VAR_NAME + counter);
      counter++;
    }
    return expr;
  }

}
