/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.variable;

import ast.expression.Expression;

public class ArrayAccess extends Expression {
  private Expression  index;
  private VariableRef base;

  public ArrayAccess(VariableRef base, Expression index) {
    assert (base != null);
    assert (index != null);
    this.base = base;
    this.index = index;
  }

  public Expression getIndex() {
    return index;
  }

  public void setIndex(Expression index) {
    assert (index != null);
    this.index = index;
  }

  public VariableRef getBase() {
    return base;
  }

  public void setBase(VariableRef base) {
    assert (base != null);
    this.base = base;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append(base);
    sb.append("[");
    sb.append(index);
    sb.append("]");
    return sb.toString();
  }

}
