/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package ast.variable;

import ast.Ast;
import ast.type.Type;

public class Variable implements Ast, Comparable<Variable> {
  private String name;
  private Type   type;
  private int    size = 1;

  public Variable(String name, Type type, int size) {
    this.name = name;
    this.type = type;
    this.size = size;
  }

  public Variable(String name, Type type) {
    this.name = name;
    this.type = type;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Type getType() {
    return type;
  }

  public void setType(Type type) {
    this.type = type;
  }

  public int getSize() {
    return size;
  }

  @Override
  public String toString() {
    String out = name;
    /*
     * out += ":" + type; if (size != 1) { out += "[" + size + "]"; }
     */
    return out;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((name == null) ? 0 : name.hashCode());
    result = prime * result + size;
    result = prime * result + ((type == null) ? 0 : type.ordinal());
    return result;
  }

  public int compareTo(Variable o) {
    if (this.type != o.type) {
      return this.type.compareTo(o.type);
    } else {
      return this.name.compareTo(o.name);
    }
  }

}
