/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg;


import java.io.File;
import java.util.ArrayList;
import java.util.List;

import knowledge.KnowledgeBase;
import ast.Program;
import ast.type.Type;
import cfg.function.FuncProtParam;
import cfg.function.LibFunction;
import cfg.function.PrgFunction;
import cfg.function.library.LibraryFunctions;
import cfg.function.system.SystemFunctions;
import elfreader.ElfReader;

public class Application {
  private File              file;
  private List<PrgFunction> funcs = null;
  private PrgFunction       main  = null;
  private LibraryFunctions  dynlib;
  private SystemFunctions   asmfunc;
  private long              mainAddr;
  private KnowledgeBase     kb;
  private ElfReader         elfReader;

  public Application(File filename, SystemFunctions asmfunc) {
    this.dynlib = createLinuxLibs();
    this.asmfunc = asmfunc;
    this.file = filename;
    kb = new KnowledgeBase(this, new Program("UserPrg"));
  }

  public void setFunctions(List<PrgFunction> functions, PrgFunction main) {
    assert (functions.contains(main));
    this.main = main;
    this.funcs = functions;
  }

  public List<PrgFunction> getFunctions() {
    return funcs;
  }

  public Program getPrg() {
    return kb.getPrg();
  }

  public PrgFunction getMain() {
    return main;
  }

  public LibraryFunctions getDynlib() {
    return dynlib;
  }

  public SystemFunctions getAsmfunc() {
    return asmfunc;
  }

  public final File getFile() {
    return file;
  }

  public final long getMainAddr() {
    return mainAddr;
  }

  public final void setMainAddr(long mainAddr) {
    this.mainAddr = mainAddr;
  }

  public final KnowledgeBase getKb() {
    return kb;
  }

  public final void setKb(KnowledgeBase kb) {
    this.kb = kb;
  }

  public final ElfReader getElfReader() {
    return elfReader;
  }

  public final void setElfReader(ElfReader elfReader) {
    this.elfReader = elfReader;
  }

  private static LibraryFunctions createLinuxLibs() {
    LibraryFunctions lib = new LibraryFunctions();
    addFunction(lib, "exit", ap("status", Type.Integer, ep()), false, Type.Void);
    addFunction(lib, "abort", ep(), false, Type.Void);
    addFunction(lib, "error", ap("status", Type.Integer, ap("errnum", Type.Integer, ap("format", Type.String, ep()))),
        true, Type.Void);
    addFunction(lib, "__cxa_atexit", ap("func", Type.Pointer, ap("p", Type.Pointer, ap("d", Type.Pointer, ep()))),
        true, Type.Integer);
    addFunction(lib, "perror", ap("s", Type.Integer, ep()), true, Type.Void);

    addFunction(lib, "__isoc99_fscanf", ap("stream", Type.Pointer, ap("format", Type.String, ep())), true, Type.Integer);
    addFunction(lib, "__isoc99_scanf", ap("format", Type.String, ep()), true, Type.Integer);
    addFunction(lib, "fwrite",
        ap("ptr", Type.Pointer, ap("size", Type.Integer, ap("nmemb", Type.Integer, ap("stream", Type.Pointer, ep())))),
        true, Type.Integer);
    addFunction(lib, "printf", ap("format", Type.String, ep()), true, Type.Integer);

    addFunction(lib, "fread",
        ap("ptr", Type.Pointer, ap("size", Type.Integer, ap("nmemb", Type.Integer, ap("stream", Type.Pointer, ep())))),
        true, Type.Integer);
    addFunction(lib, "puts", ap("s", Type.Pointer, ep()), true, Type.Integer);
    addFunction(lib, "putchar", ap("c", Type.Integer, ep()), true, Type.Integer);

    addFunction(lib, "malloc", ap("size", Type.Integer, ep()), true, Type.Pointer);
    addFunction(lib, "free", ap("ptr", Type.Pointer, ep()), true, Type.Void);

    /*
     * addFunction(lib, "fprintf", 2, true); addFunction(lib, "fopen", 2, true); addFunction(lib, "fputs", 2, true);
     * addFunction(lib, "fputs_unlocked", 2, true); addFunction(lib, "fclose", 1, true); addFunction(lib,
     * "putchar_unlocked", 1, true); addFunction(lib, "fileno", 1, true); addFunction(lib, "isatty", 1, true);
     * addFunction(lib, "close", 1, true); addFunction(lib, "lseek64", 4, true); addFunction(lib, "read", 3, true);
     * addFunction(lib, "__fxstat64", 2, true);
     */

    /*
     * addFunction(lib, "setlocale", 2, true); addFunction(lib, "bindtextdomain", 2, true); addFunction(lib,
     * "textdomain", 1, true);
     * 
     * addFunction(lib, "getopt_long", 3, true); addFunction(lib, "gettext", 1, true);
     * 
     * addFunction(lib, "sync", ep(), true);
     * 
     * addFunction(lib, "strrchr", 2, true); addFunction(lib, "strncmp", 3, true); addFunction(lib, "strlen", 1, true);
     * addFunction(lib, "strcmp", 2, true); addFunction(lib, "atoi", 1, true); addFunction(lib, "strchr", 2, true);
     * addFunction(lib, "strcpy", 2, true); addFunction(lib, "strspn", 2, true); addFunction(lib, "strcspn", 2, true);
     * 
     * addFunction(lib, "setvbuf", 2, true); addFunction(lib, "__errno_location", ep(), true); addFunction(lib,
     * "sigemptyset", 1, true); addFunction(lib, "sigaction", 3, true); addFunction(lib, "sigaddset", 2, true);
     * addFunction(lib, "sigismember", 2, true); addFunction(lib, "sigprocmask", 3, true); addFunction(lib, "getenv", 1,
     * true); addFunction(lib, "localtime", 1, true);
     * 
     * addFunction(lib, "memcmp", 3, true); addFunction(lib, "memcpy", 3, true); addFunction(lib, "free", 1, true);
     * addFunction(lib, "memmove", 3, true);
     */

    /*
     * addFunction(lib, "", , true); addFunction(lib, "", , true);
     */
    return lib;
  }

  static private ArrayList<FuncProtParam> ep() {
    return new ArrayList<FuncProtParam>();
  }

  static private ArrayList<FuncProtParam> ap(String name, Type type, ArrayList<FuncProtParam> list) {
    list.add(0, new FuncProtParam(name, type));
    return list;
  }

  static private void addFunction(LibraryFunctions lib, String name, ArrayList<FuncProtParam> param,
      boolean doesReturn, Type retType) {
    lib.addFunction(new LibFunction(name, param, doesReturn, retType));
  }
  }
