/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg;


import java.util.LinkedList;
import java.util.List;

import cfg.expression.BooleanExpr;

public class BooleanConstant implements BooleanExpr {
  private boolean value;

  public BooleanConstant(boolean value) {
    super();
    this.value = value;
  }

  public boolean getValue() {
    return value;
  }

  @Override
  public String toString() {
    return Boolean.toString(value);
  }

  public IrType getIrType() {
    return IrType.BooleanConstant;
  }

  public List<? extends IrElement> getChildren() {
    return new LinkedList<IrElement>();
  }
}
