/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg;


import java.util.LinkedList;
import java.util.List;

import cfg.expression.Expression;

public class IntConstant implements Expression {
  private long value;

  public IntConstant(long value) {
    super();
    this.value = value;
  }

  public long getValue() {
    return value;
  }

  @Override
  public String toString() {
    return Long.toString(value);
  }

  public IrType getIrType() {
    return IrType.IntConstant;
  }

  public List<? extends IrElement> getChildren() {
    return new LinkedList<IrElement>();
  }
}
