/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.basicblock;

import graph.SimpleEdge;

public class BbEdge extends SimpleEdge<BasicBlock> {
  final private int nr;

  public BbEdge(BasicBlock src, BasicBlock dst, int nr) {
    super(src, dst);
    this.nr = nr;
    src.addEdgeOut(this);
    dst.addEdgeIn(this);
  }

  @Override
  public String toString() {
    return getSrc() + " -> " + getDst() + " (" + contentString() + " )";
  }

  public int getNr() {
    return nr;
  }

  public String contentString() {
    return Integer.toString(nr);
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = super.hashCode();
    result = prime * result + nr;
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) return true;
    if (!super.equals(obj)) return false;
    if (getClass() != obj.getClass()) return false;
    BbEdge other = (BbEdge) obj;
    if (nr != other.nr) return false;
    return true;
  }

}
