/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.expression;


import java.util.ArrayList;
import java.util.List;

import cfg.IrElement;

abstract public class CallExpr implements Expression {
  private List<Expression> param = new ArrayList<Expression>();

  public List<Expression> getParam() {
    return param;
  }

  public void setParam(List<Expression> param) {
    this.param = param;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("(");
    for (int i = 0; i < param.size(); i++) {
      if (i > 0) {
        sb.append(", ");
      }
      sb.append(param.get(i));
    }
    sb.append(")");
    return sb.toString();
  }

  public boolean isAutoDeletable() {
    return false;
  }

  public List<? extends IrElement> getChildren() {
    ArrayList<IrElement> res = new ArrayList<IrElement>();
    res.addAll(param);
    return res;
  }
}
