/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.expression;


import java.util.HashMap;
import java.util.List;

import util.NumPrint;
import cfg.IrElement;
import cfg.IrType;
import cfg.function.Function;

public class CallExprPointer extends CallExpr {
  private HashMap<Long, Function> candidates = new HashMap<Long, Function>();
  private Expression              expr;

  public CallExprPointer(Expression expr) {
    super();
    this.expr = expr;
  }

  public Expression getExpr() {
    return expr;
  }

  public void setExpr(Expression expr) {
    this.expr = expr;
  }

  public HashMap<Long, Function> getCandidates() {
    return candidates;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("call ");
    sb.append(expr);
    sb.append(": ");
    for (Long bb : candidates.keySet()) {
      sb.append(NumPrint.toString(bb));
      sb.append("=");
      sb.append(candidates.get(bb));
      sb.append(" ");
    }
    return sb.toString() + super.toString();
  }

  public IrType getIrType() {
    return IrType.CallExprPointer;
  }

  @Override
  public List<? extends IrElement> getChildren() {
    @SuppressWarnings("unchecked")
    List<IrElement> res = (List<IrElement>) super.getChildren();
    res.add(0,expr);
    return res;
  }
}
