/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.expression;

import util.NumPrint;
import cfg.IrType;

public class CallExprUnlinked extends CallExpr {
  private long addr;

  public CallExprUnlinked(long addr) {
    super();
    this.addr = addr;
  }

  public long getAddr() {
    return addr;
  }

  @Override
  public String toString() {
    return "call '" + NumPrint.toString(getAddr()) + "'" + super.toString();
  }

  public IrType getIrType() {
    return IrType.CallExprUnlinked;
  }
}
