/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.expression;

public enum CompareOp {
	EQUAL, NOT_EQUAL,
	LOWER_EQUAL, GREATER_EQUAL, LOWER, GREATER;

	@Override
	public String toString() {
		switch(this){
		case EQUAL: return "==";
		case NOT_EQUAL: return "!=";
		case LOWER_EQUAL: return "<=";
		case GREATER_EQUAL: return ">=";
		case LOWER: return "<";
		case GREATER: return ">";
		default: throw new RuntimeException( "Not yet implemneted: " + this.ordinal() );
		}
	}
}
