/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.expression;

public enum IntegerOp {
	And, Or, Xor,
	Add, Sub, Mul, Div, 
	ShiftArithmeticRight, ShiftRight, ShiftArithmeticLeft, ShiftLeft;

	@Override
	public String toString() {
		switch(this){
		case And: return "and";
		case Or: return "or";
		case Xor: return "xor";
		case Add: return "+";
		case Sub: return "-";
		case Mul: return "*";
		case Div: return "/";
		case ShiftArithmeticRight: return "sar";
		case ShiftRight: return "shr";
		case ShiftArithmeticLeft: return "sal";
		case ShiftLeft: return "shl";
		default: throw new RuntimeException( "Not yet implemneted: " + this.ordinal() );
		}
	}
}

