/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.expression;


import java.util.LinkedList;
import java.util.List;

import cfg.IrElement;
import cfg.IrType;
import cfg.variable.VariableName;

public class VariableRefUnlinked implements Expression, VariableRef {
  private VariableName name;

  public VariableRefUnlinked(VariableName name) {
    super();
    this.name = name;
  }

  public VariableName getName() {
    return name;
  }

  @Override
  public String toString() {
    return "'" + name.toString() + "'";
  }

  public IrType getIrType() {
    return IrType.VariableRefUnlinked;
  }

  public List<? extends IrElement> getChildren() {
    return new LinkedList<IrElement>();
  }
}
