/*
 * Part of upcompiler. Copyright (c) 2012, Urs Fässler, Licensed under the GNU Genera Public License, v3
 * @author: urs@bitzgi.ch
 */

package cfg.function.argument;


import java.util.HashSet;
import java.util.Set;

import cfg.IntConstant;
import cfg.IrTraverser;
import cfg.expression.CallExprLinked;
import cfg.expression.CallExprPointer;
import cfg.expression.CallExprUnlinked;
import cfg.expression.Expression;
import cfg.expression.IntegerExpr;
import cfg.expression.IntegerOp;
import cfg.expression.VariableRefUnlinked;
import cfg.variable.VariablePtrDeref;

//TODO persretun.c llvm uses registers to pass arguments

public class ActualArgumentInserter extends IrTraverser<Void, Void> {
  private Set<Long>   argPtrOffset = new HashSet<Long>();
  
  static public Set<Long> process(Object obj) {
    ActualArgumentInserter inserter = new ActualArgumentInserter();
    inserter.visit(obj, null);
    return inserter.getArgPtrOffset();
  }
  
  public Set<Long> getArgPtrOffset() {
    return argPtrOffset;
  }

  @Override
  protected Void visitCallExprLinked(CallExprLinked obj, Void param) {
    // TODO this is for sure not general, but enough for the moment
    switch (obj.getFunc().getIrType()) {
      case FuncLibrary: //TODO for library functions, the argument number can be variable
      case FuncProgram: {
        obj.getParam().clear();
        for (int i = 0; i < obj.getFunc().getParam().size(); i++) {
          argPtrOffset.add((long) (i*4));
          Expression expr = new IntegerExpr(new VariableRefUnlinked(FuncVariables.locPtr), new IntConstant(i * 4),
              IntegerOp.Add);
          obj.getParam().add(new VariablePtrDeref(expr));
        }
        break;
      }
    }
    return null;
  }

  @Override
  protected Void visitCallExprUnlinked(CallExprUnlinked obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

  @Override
  protected Void visitCallExprPointer(CallExprPointer obj, Void param) {
    throw new RuntimeException("Not yet implemented");
  }

}
